/* options.c: options dialog boxes
   Copyright (c) 2001-2007 Philip Kendall, Marek Januszewski, Stuart Brady

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Author contact information:

   E-mail: philip-fuse@shadowmagic.org.uk

*/

/* This file is autogenerated from options.dat by options.pl.
   Do not edit unless you know what you're doing! */

#include <config.h>

#ifdef UI_WIN32		/* Use this file iff we're using WIN32 */

#include <libspectrum.h>

#include "display.h"
#include "fuse.h"
#include "options.h"
#include "periph.h"
#include "settings.h"
#include "win32internals.h"


static BOOL CALLBACK
menu_options_general_proc( HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
  char buffer[80];
  buffer[0] = '\0';		/* Shut gcc up */
  
  switch( msg )
  {
    case WM_INITDIALOG:
    {
      /* FIXME: save the handle returned by LoadIcon() in win32ui.c */
      SendMessage( hwndDlg, WM_SETICON, ICON_SMALL,
	(LPARAM)LoadIcon( fuse_hInstance, "win32_icon" ) );

      /* initialize the controls with current settings */

      /* FIXME split *_init and *_done functions out of *_proc function */
      /* FIXME This is asuming SendDlgItemMessage is not UNICODE */
      snprintf( buffer, 80, "%d", settings_current.emulation_speed );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_EMULATION_SPEED, WM_SETTEXT,
        0, (LPARAM) buffer );
      /* FIXME This is asuming SendDlgItemMessage is not UNICODE */
      snprintf( buffer, 80, "%d", settings_current.frame_rate );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_FRAME_RATE, WM_SETTEXT,
        0, (LPARAM) buffer );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_ISSUE2, BM_SETCHECK,
        settings_current.issue2 ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_TAPE_TRAPS, BM_SETCHECK,
        settings_current.tape_traps ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_FASTLOAD, BM_SETCHECK,
        settings_current.fastload ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_DETECT_LOADER, BM_SETCHECK,
        settings_current.detect_loader ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_ACCELERATE_LOADER, BM_SETCHECK,
        settings_current.accelerate_loader ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_AUTO_LOAD, BM_SETCHECK,
        settings_current.auto_load ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_SLT_TRAPS, BM_SETCHECK,
        settings_current.slt_traps ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_WRITABLE_ROMS, BM_SETCHECK,
        settings_current.writable_roms ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_AUTOSAVE_SETTINGS, BM_SETCHECK,
        settings_current.autosave_settings ? BST_CHECKED : BST_UNCHECKED, 0 );
      /* FIXME This is asuming SendDlgItemMessage is not UNICODE */
      snprintf( buffer, 80, "%d", settings_current.mdr_len );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_MDR_LEN, WM_SETTEXT,
        0, (LPARAM) buffer );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_MDR_RANDOM_LEN, BM_SETCHECK,
        settings_current.mdr_random_len ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_RS232_HANDSHAKE, BM_SETCHECK,
        settings_current.rs232_handshake ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_BW_TV, BM_SETCHECK,
        settings_current.bw_tv ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_PAL_TV2X, BM_SETCHECK,
        settings_current.pal_tv2x ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_CONFIRM_ACTIONS, BM_SETCHECK,
        settings_current.confirm_actions ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_STATUSBAR, BM_SETCHECK,
        settings_current.statusbar ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_JOY_PROMPT, BM_SETCHECK,
        settings_current.joy_prompt ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_LATE_TIMINGS, BM_SETCHECK,
        settings_current.late_timings ? BST_CHECKED : BST_UNCHECKED, 0 );

      return FALSE;
    }

    case WM_COMMAND:
      switch( LOWORD( wParam ) )
      {
	case IDOK:
	{
          /* Read the controls and apply the settings */
      /* FIXME This is asuming SendDlgItemMessage is not UNICODE */
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_EMULATION_SPEED, WM_GETTEXT,
        80, (LPARAM) buffer );
      settings_current.emulation_speed = atoi( buffer );  
      /* FIXME This is asuming SendDlgItemMessage is not UNICODE */
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_FRAME_RATE, WM_GETTEXT,
        80, (LPARAM) buffer );
      settings_current.frame_rate = atoi( buffer );  
          settings_current.issue2 =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_ISSUE2 );
          settings_current.tape_traps =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_TAPE_TRAPS );
          settings_current.fastload =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_FASTLOAD );
          settings_current.detect_loader =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_DETECT_LOADER );
          settings_current.accelerate_loader =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_ACCELERATE_LOADER );
          settings_current.auto_load =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_AUTO_LOAD );
          settings_current.slt_traps =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_SLT_TRAPS );
          settings_current.writable_roms =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_WRITABLE_ROMS );
          settings_current.autosave_settings =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_AUTOSAVE_SETTINGS );
      /* FIXME This is asuming SendDlgItemMessage is not UNICODE */
      SendDlgItemMessage( hwndDlg, IDC_OPT_GENERAL_MDR_LEN, WM_GETTEXT,
        80, (LPARAM) buffer );
      settings_current.mdr_len = atoi( buffer );  
          settings_current.mdr_random_len =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_MDR_RANDOM_LEN );
          settings_current.rs232_handshake =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_RS232_HANDSHAKE );
          settings_current.bw_tv =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_BW_TV );
          settings_current.pal_tv2x =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_PAL_TV2X );
          settings_current.confirm_actions =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_CONFIRM_ACTIONS );
          settings_current.statusbar =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_STATUSBAR );
          settings_current.joy_prompt =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_JOY_PROMPT );
          settings_current.late_timings =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_GENERAL_LATE_TIMINGS );
          win32statusbar_set_visibility( settings_current.statusbar );
          display_refresh_all();

	  EndDialog( hwndDlg, 0 );
	  return 0;
	}

	case IDCANCEL:
	  EndDialog( hwndDlg, 0 );
	  return 0;
      }
      break;

    case WM_CLOSE:
      EndDialog( hwndDlg, 0 );
      return 0;
  }
  return FALSE;
}

void
menu_options_general( int action )
{
  fuse_emulation_pause();

  DialogBox( fuse_hInstance, MAKEINTRESOURCE( IDD_OPT_GENERAL ),
             fuse_hWnd, (DLGPROC) menu_options_general_proc );

  fuse_emulation_unpause();
}


static BOOL CALLBACK
menu_options_peripherals_proc( HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
  char buffer[80];
  buffer[0] = '\0';		/* Shut gcc up */
  
  switch( msg )
  {
    case WM_INITDIALOG:
    {
      /* FIXME: save the handle returned by LoadIcon() in win32ui.c */
      SendMessage( hwndDlg, WM_SETICON, ICON_SMALL,
	(LPARAM)LoadIcon( fuse_hInstance, "win32_icon" ) );

      /* initialize the controls with current settings */

      /* FIXME split *_init and *_done functions out of *_proc function */
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_JOY_KEMPSTON, BM_SETCHECK,
        settings_current.joy_kempston ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_KEMPSTON_MOUSE, BM_SETCHECK,
        settings_current.kempston_mouse ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_INTERFACE1, BM_SETCHECK,
        settings_current.interface1 ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_INTERFACE2, BM_SETCHECK,
        settings_current.interface2 ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_PRINTER, BM_SETCHECK,
        settings_current.printer ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_SIMPLEIDE_ACTIVE, BM_SETCHECK,
        settings_current.simpleide_active ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_ZXATASP_ACTIVE, BM_SETCHECK,
        settings_current.zxatasp_active ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_ZXATASP_UPLOAD, BM_SETCHECK,
        settings_current.zxatasp_upload ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_ZXATASP_WP, BM_SETCHECK,
        settings_current.zxatasp_wp ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_ZXCF_ACTIVE, BM_SETCHECK,
        settings_current.zxcf_active ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_ZXCF_UPLOAD, BM_SETCHECK,
        settings_current.zxcf_upload ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_DIVIDE_ENABLED, BM_SETCHECK,
        settings_current.divide_enabled ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_DIVIDE_WP, BM_SETCHECK,
        settings_current.divide_wp ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_PLUSD, BM_SETCHECK,
        settings_current.plusd ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_PERIPHERALS_BETA128, BM_SETCHECK,
        settings_current.beta128 ? BST_CHECKED : BST_UNCHECKED, 0 );

      return FALSE;
    }

    case WM_COMMAND:
      switch( LOWORD( wParam ) )
      {
	case IDOK:
	{
          /* Read the controls and apply the settings */
          settings_current.joy_kempston =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_JOY_KEMPSTON );
          settings_current.kempston_mouse =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_KEMPSTON_MOUSE );
          settings_current.interface1 =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_INTERFACE1 );
          settings_current.interface2 =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_INTERFACE2 );
          settings_current.printer =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_PRINTER );
          settings_current.simpleide_active =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_SIMPLEIDE_ACTIVE );
          settings_current.zxatasp_active =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_ZXATASP_ACTIVE );
          settings_current.zxatasp_upload =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_ZXATASP_UPLOAD );
          settings_current.zxatasp_wp =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_ZXATASP_WP );
          settings_current.zxcf_active =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_ZXCF_ACTIVE );
          settings_current.zxcf_upload =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_ZXCF_UPLOAD );
          settings_current.divide_enabled =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_DIVIDE_ENABLED );
          settings_current.divide_wp =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_DIVIDE_WP );
          settings_current.plusd =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_PLUSD );
          settings_current.beta128 =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_PERIPHERALS_BETA128 );
          periph_update();

          win32statusbar_set_visibility( settings_current.statusbar );
          display_refresh_all();

	  EndDialog( hwndDlg, 0 );
	  return 0;
	}

	case IDCANCEL:
	  EndDialog( hwndDlg, 0 );
	  return 0;
      }
      break;

    case WM_CLOSE:
      EndDialog( hwndDlg, 0 );
      return 0;
  }
  return FALSE;
}

void
menu_options_peripherals( int action )
{
  fuse_emulation_pause();

  DialogBox( fuse_hInstance, MAKEINTRESOURCE( IDD_OPT_PERIPHERALS ),
             fuse_hWnd, (DLGPROC) menu_options_peripherals_proc );

  fuse_emulation_unpause();
}


static BOOL CALLBACK
menu_options_rzx_proc( HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
  char buffer[80];
  buffer[0] = '\0';		/* Shut gcc up */
  
  switch( msg )
  {
    case WM_INITDIALOG:
    {
      /* FIXME: save the handle returned by LoadIcon() in win32ui.c */
      SendMessage( hwndDlg, WM_SETICON, ICON_SMALL,
	(LPARAM)LoadIcon( fuse_hInstance, "win32_icon" ) );

      /* initialize the controls with current settings */

      /* FIXME split *_init and *_done functions out of *_proc function */
      SendDlgItemMessage( hwndDlg, IDC_OPT_RZX_RZX_AUTOSAVES, BM_SETCHECK,
        settings_current.rzx_autosaves ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_RZX_RZX_COMPRESSION, BM_SETCHECK,
        settings_current.rzx_compression ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_RZX_COMPETITION_MODE, BM_SETCHECK,
        settings_current.competition_mode ? BST_CHECKED : BST_UNCHECKED, 0 );
      /* FIXME This is asuming SendDlgItemMessage is not UNICODE */
      snprintf( buffer, 80, "%d", settings_current.competition_code );
      SendDlgItemMessage( hwndDlg, IDC_OPT_RZX_COMPETITION_CODE, WM_SETTEXT,
        0, (LPARAM) buffer );
      SendDlgItemMessage( hwndDlg, IDC_OPT_RZX_EMBED_SNAPSHOT, BM_SETCHECK,
        settings_current.embed_snapshot ? BST_CHECKED : BST_UNCHECKED, 0 );

      return FALSE;
    }

    case WM_COMMAND:
      switch( LOWORD( wParam ) )
      {
	case IDOK:
	{
          /* Read the controls and apply the settings */
          settings_current.rzx_autosaves =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_RZX_RZX_AUTOSAVES );
          settings_current.rzx_compression =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_RZX_RZX_COMPRESSION );
          settings_current.competition_mode =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_RZX_COMPETITION_MODE );
      /* FIXME This is asuming SendDlgItemMessage is not UNICODE */
      SendDlgItemMessage( hwndDlg, IDC_OPT_RZX_COMPETITION_CODE, WM_GETTEXT,
        80, (LPARAM) buffer );
      settings_current.competition_code = atoi( buffer );  
          settings_current.embed_snapshot =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_RZX_EMBED_SNAPSHOT );
          win32statusbar_set_visibility( settings_current.statusbar );
          display_refresh_all();

	  EndDialog( hwndDlg, 0 );
	  return 0;
	}

	case IDCANCEL:
	  EndDialog( hwndDlg, 0 );
	  return 0;
      }
      break;

    case WM_CLOSE:
      EndDialog( hwndDlg, 0 );
      return 0;
  }
  return FALSE;
}

void
menu_options_rzx( int action )
{
  fuse_emulation_pause();

  DialogBox( fuse_hInstance, MAKEINTRESOURCE( IDD_OPT_RZX ),
             fuse_hWnd, (DLGPROC) menu_options_rzx_proc );

  fuse_emulation_unpause();
}


static BOOL CALLBACK
menu_options_sound_proc( HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
  char buffer[80];
  buffer[0] = '\0';		/* Shut gcc up */
  
  switch( msg )
  {
    case WM_INITDIALOG:
    {
      /* FIXME: save the handle returned by LoadIcon() in win32ui.c */
      SendMessage( hwndDlg, WM_SETICON, ICON_SMALL,
	(LPARAM)LoadIcon( fuse_hInstance, "win32_icon" ) );

      /* initialize the controls with current settings */

      /* FIXME split *_init and *_done functions out of *_proc function */
      SendDlgItemMessage( hwndDlg, IDC_OPT_SOUND_SOUND, BM_SETCHECK,
        settings_current.sound ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_SOUND_SOUND_LOAD, BM_SETCHECK,
        settings_current.sound_load ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_SOUND_STEREO_AY, BM_SETCHECK,
        settings_current.stereo_ay ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_SOUND_STEREO_BEEPER, BM_SETCHECK,
        settings_current.stereo_beeper ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_SOUND_SOUND_FORCE_8BIT, BM_SETCHECK,
        settings_current.sound_force_8bit ? BST_CHECKED : BST_UNCHECKED, 0 );
      SendDlgItemMessage( hwndDlg, IDC_OPT_SOUND_SOUND_HIFI, BM_SETCHECK,
        settings_current.sound_hifi ? BST_CHECKED : BST_UNCHECKED, 0 );

      return FALSE;
    }

    case WM_COMMAND:
      switch( LOWORD( wParam ) )
      {
	case IDOK:
	{
          /* Read the controls and apply the settings */
          settings_current.sound =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_SOUND_SOUND );
          settings_current.sound_load =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_SOUND_SOUND_LOAD );
          settings_current.stereo_ay =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_SOUND_STEREO_AY );
          settings_current.stereo_beeper =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_SOUND_STEREO_BEEPER );
          settings_current.sound_force_8bit =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_SOUND_SOUND_FORCE_8BIT );
          settings_current.sound_hifi =
            IsDlgButtonChecked( hwndDlg, IDC_OPT_SOUND_SOUND_HIFI );
          win32statusbar_set_visibility( settings_current.statusbar );
          display_refresh_all();

	  EndDialog( hwndDlg, 0 );
	  return 0;
	}

	case IDCANCEL:
	  EndDialog( hwndDlg, 0 );
	  return 0;
      }
      break;

    case WM_CLOSE:
      EndDialog( hwndDlg, 0 );
      return 0;
  }
  return FALSE;
}

void
menu_options_sound( int action )
{
  fuse_emulation_pause();

  DialogBox( fuse_hInstance, MAKEINTRESOURCE( IDD_OPT_SOUND ),
             fuse_hWnd, (DLGPROC) menu_options_sound_proc );

  fuse_emulation_unpause();
}


#endif                 /* #ifdef UI_WIN32 */

