/* 
   ipmi-sensor-cmds-udm.c - IPMI UDM Sensor commands

   Copyright (C) 2003, 2004, 2005 FreeIPMI Core Team

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.  
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#if STDC_HEADERS
#include <string.h>
#endif /* STDC_HEADERS */
#include <errno.h>

#include "freeipmi/udm/ipmi-sensor-cmds-udm.h"
#include "freeipmi/ipmi-ipmb-interface.h"
#include "freeipmi/ipmi-netfn-spec.h"
#include "freeipmi/ipmi-sensor-cmds.h"
#include "freeipmi/udm/ipmi-sensor-cmds-udm.h"

#include "ipmi-udm-device.h"

#include "freeipmi-portability.h"
#include "udm-err-wrappers.h"
#include "udm-fiid-wrappers.h"

int8_t
ipmi_cmd_get_sensor_reading_threshold (ipmi_device_t dev, 
				       uint8_t sensor_number, 
				       fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE(obj_cmd_rs, tmpl_cmd_get_sensor_reading_threshold_rs);

  UDM_FIID_OBJ_CREATE(obj_cmd_rq, tmpl_cmd_get_sensor_reading_rq);
  
  UDM_ERR_CLEANUP (!(fill_cmd_get_sensor_reading (sensor_number,
						  obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
			    IPMI_BMC_IPMB_LUN_BMC, 
			    IPMI_NET_FN_SENSOR_EVENT_RQ, 
			    obj_cmd_rq, 
			    obj_cmd_rs);

  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY(obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_get_sensor_reading_discrete (ipmi_device_t dev, 
				      uint8_t sensor_number, 
				      fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;
  
  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (fiid_obj_valid(obj_cmd_rs));
  
  UDM_FIID_OBJ_TEMPLATE_COMPARE(obj_cmd_rs, tmpl_cmd_get_sensor_reading_discrete_rs);

  UDM_FIID_OBJ_CREATE(obj_cmd_rq, tmpl_cmd_get_sensor_reading_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_get_sensor_reading (sensor_number,
						  obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
			    IPMI_BMC_IPMB_LUN_BMC, 
			    IPMI_NET_FN_SENSOR_EVENT_RQ, 
			    obj_cmd_rq, 
			    obj_cmd_rs);

  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY(obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_get_sensor_thresholds (ipmi_device_t dev, 
				uint8_t sensor_number, 
				fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;
  
  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (fiid_obj_valid(obj_cmd_rs));
  
  UDM_FIID_OBJ_TEMPLATE_COMPARE(obj_cmd_rs, tmpl_cmd_get_sensor_thresholds_rs);

  UDM_FIID_OBJ_CREATE(obj_cmd_rq, tmpl_cmd_get_sensor_thresholds_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_get_sensor_thresholds (sensor_number,
						     obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
			    IPMI_BMC_IPMB_LUN_BMC, 
			    IPMI_NET_FN_SENSOR_EVENT_RQ, 
			    obj_cmd_rq, 
			    obj_cmd_rs);

  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY(obj_cmd_rq);
  return (rv);
}

