/* 
   Ipmi-chassis-cmds-udm.c - IPMI UDM Chassis Commands

   Copyright (C) 2003, 2004, 2005 FreeIPMI Core Team

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#ifdef STDC_HEADERS
#include <string.h>
#endif /* STDC_HEADERS */
#include <errno.h>


#include <freeipmi/udm/ipmi-chassis-cmds-udm.h>
#include <freeipmi/ipmi-chassis-cmds.h>
#include <freeipmi/ipmi-ipmb-interface.h>
#include <freeipmi/ipmi-netfn-spec.h>
#include <freeipmi/ipmi-cmd-spec.h>
#include <freeipmi/ipmi-chassis-boot-options-parameter-spec.h>
#include <freeipmi/ipmi-comp-code-spec.h>

#include "ipmi-udm-device.h"
#include "freeipmi-portability.h"
#include "udm-err-wrappers.h"
#include "udm-fiid-wrappers.h"

int8_t 
ipmi_cmd_get_chassis_capabilities (ipmi_device_t dev, 
				   fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE(obj_cmd_rs, tmpl_cmd_get_chassis_capabilities_rs);

  UDM_FIID_OBJ_CREATE(obj_cmd_rq, tmpl_cmd_get_chassis_capabilities_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_get_chassis_capabilities (obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
			    IPMI_BMC_IPMB_LUN_BMC, 
			    IPMI_NET_FN_CHASSIS_RQ, 
			    obj_cmd_rq, 
			    obj_cmd_rs);

  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY(obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_get_chassis_status (ipmi_device_t dev, 
                             fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE(obj_cmd_rs, tmpl_cmd_get_chassis_status_rs);

  UDM_FIID_OBJ_CREATE(obj_cmd_rq, tmpl_cmd_get_chassis_status_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_get_chassis_status (obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
			    IPMI_BMC_IPMB_LUN_BMC, 
			    IPMI_NET_FN_CHASSIS_RQ, 
			    obj_cmd_rq, 
			    obj_cmd_rs);

  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY(obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_chassis_control (ipmi_device_t dev,
                          uint8_t chassis_control,
                          fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (IPMI_CHASSIS_CONTROL_VALID (chassis_control)
                              && fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE (obj_cmd_rs, tmpl_cmd_chassis_control_rs);

  UDM_FIID_OBJ_CREATE (obj_cmd_rq, tmpl_cmd_chassis_control_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_chassis_control (chassis_control, obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
                            IPMI_BMC_IPMB_LUN_BMC, 
                            IPMI_NET_FN_CHASSIS_RQ, 
                            obj_cmd_rq, 
                            obj_cmd_rs);

  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY (obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_chassis_identify (ipmi_device_t dev,
                           uint8_t *identify_interval,
                           uint8_t *force_identify,
                           fiid_obj_t obj_cmd_rs)
{

  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS ((!force_identify
                               || IPMI_CHASSIS_FORCE_IDENTIFY_VALID (*force_identify))
                              && fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE (obj_cmd_rs, tmpl_cmd_chassis_identify_rs);

  UDM_FIID_OBJ_CREATE (obj_cmd_rq, tmpl_cmd_chassis_identify_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_chassis_identify (identify_interval, 
                                                force_identify, 
                                                obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
                            IPMI_BMC_IPMB_LUN_BMC, 
                            IPMI_NET_FN_CHASSIS_RQ, 
                            obj_cmd_rq, 
                            obj_cmd_rs);

  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY (obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_set_power_restore_policy (ipmi_device_t dev, 
                                   uint8_t power_restore_policy, 
                                   fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (IPMI_POWER_RESTORE_POLICY_VALID (power_restore_policy)
                              && fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE (obj_cmd_rs, tmpl_cmd_set_power_restore_policy_rs);

  UDM_FIID_OBJ_CREATE (obj_cmd_rq, tmpl_cmd_set_power_restore_policy_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_set_power_restore_policy (power_restore_policy, 
                                                        obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
                            IPMI_BMC_IPMB_LUN_BMC, 
                            IPMI_NET_FN_CHASSIS_RQ, 
                            obj_cmd_rq, 
                            obj_cmd_rs);

  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY (obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_set_power_cycle_interval (ipmi_device_t dev,
                                   uint8_t interval,
                                   fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE (obj_cmd_rs, tmpl_cmd_set_power_cycle_interval_rs);

  UDM_FIID_OBJ_CREATE (obj_cmd_rq, tmpl_cmd_set_power_cycle_interval_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_set_power_cycle_interval (interval, obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
                            IPMI_BMC_IPMB_LUN_BMC, 
                            IPMI_NET_FN_CHASSIS_RQ, 
                            obj_cmd_rq, 
                            obj_cmd_rs);
  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY (obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_get_system_restart_cause (ipmi_device_t dev,
                                   fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE (obj_cmd_rs, tmpl_cmd_get_system_restart_cause_rs);

  UDM_FIID_OBJ_CREATE (obj_cmd_rq, tmpl_cmd_get_system_restart_cause_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_get_system_restart_cause (obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
                            IPMI_BMC_IPMB_LUN_BMC, 
                            IPMI_NET_FN_CHASSIS_RQ, 
                            obj_cmd_rq, 
                            obj_cmd_rs);

  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY (obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_set_system_boot_options (ipmi_device_t dev,
                                  uint8_t param_selector,
                                  uint8_t *configuration_param_data,
                                  uint8_t data_len,
                                  fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE (obj_cmd_rs, tmpl_cmd_set_system_boot_options_rs);
  UDM_FIID_OBJ_CREATE (obj_cmd_rq, tmpl_cmd_set_system_boot_options_rq);

  UDM_ERR_CLEANUP (!fill_cmd_set_system_boot_options (param_selector,
                                                      configuration_param_data,
                                                      data_len,  
                                                      obj_cmd_rq) < 0);
  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
                            IPMI_BMC_IPMB_LUN_BMC, 
                            IPMI_NET_FN_CHASSIS_RQ, 
                            obj_cmd_rq, 
                            obj_cmd_rs);
  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY (obj_cmd_rq);
  return (rv);
}

int8_t
ipmi_cmd_set_system_boot_options_set_in_progress (ipmi_device_t dev, 
                                                  uint8_t value,
                                                  fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE (obj_cmd_rs, tmpl_cmd_set_system_boot_options_rs);

  UDM_FIID_OBJ_CREATE (obj_cmd_rq, tmpl_cmd_set_system_boot_options_set_in_progress_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_set_system_boot_options_set_in_progress (value, obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
                            IPMI_BMC_IPMB_LUN_BMC, 
                            IPMI_NET_FN_CHASSIS_RQ, 
                            obj_cmd_rq, 
                            obj_cmd_rs);
  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY (obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_set_system_boot_options_boot_info_acknowledge (ipmi_device_t dev,
                                                        uint8_t *bios_or_post_handled_boot_info,
                                                        uint8_t *os_loader_handled_boot_info,
                                                        uint8_t *os_or_service_partition_handled_boot_info,
                                                        uint8_t *sms_handled_boot_info,
                                                        uint8_t *oem_handled_boot_info,
                                                        fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS ((!bios_or_post_handled_boot_info 
                               || IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (*bios_or_post_handled_boot_info))
                              && (!os_loader_handled_boot_info 
                                  || IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (*os_loader_handled_boot_info))
                              && (!os_or_service_partition_handled_boot_info 
                                  || IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (*os_or_service_partition_handled_boot_info))
                              && (!sms_handled_boot_info 
                                  || IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (*sms_handled_boot_info))
                              && (!oem_handled_boot_info 
                                  || IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (*oem_handled_boot_info))
                              && fiid_obj_valid(obj_cmd_rs));


  UDM_FIID_OBJ_TEMPLATE_COMPARE (obj_cmd_rs, tmpl_cmd_set_system_boot_options_rs);

  UDM_FIID_OBJ_CREATE (obj_cmd_rq, tmpl_cmd_set_system_boot_options_boot_info_acknowledge_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_set_system_boot_options_boot_info_acknowledge (bios_or_post_handled_boot_info,
                                                                             os_loader_handled_boot_info, 
                                                                             os_or_service_partition_handled_boot_info, 
                                                                             sms_handled_boot_info,
                                                                             oem_handled_boot_info,
                                                                             obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
                            IPMI_BMC_IPMB_LUN_BMC, 
                            IPMI_NET_FN_CHASSIS_RQ, 
                            obj_cmd_rq, 
                            obj_cmd_rs);
  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY (obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_set_system_boot_options_boot_flags (ipmi_device_t dev,
                                             uint8_t bios_boot_type,
                                             uint8_t boot_flags_persistent,
                                             uint8_t boot_flags_valid,
                                             uint8_t lock_out_reset_button,
                                             uint8_t screen_blank,
                                             uint8_t boot_device_selector,
                                             uint8_t lock_keyboard,
                                             uint8_t clear_cmos,
                                             uint8_t console_redirection,
                                             uint8_t lock_out_sleep_button,
                                             uint8_t user_password_bypass,
                                             uint8_t force_progress_event_traps,
                                             uint8_t firmware_bios_verbosity,
                                             uint8_t lock_out_via_power_button,
                                             uint8_t bios_mux_control_override,
                                             uint8_t bios_shared_mode_override,
                                             fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (boot_flags_valid)
                              && IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (boot_flags_persistent)
                              && IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (clear_cmos)
                              && IPMI_CHASSIS_BOOT_OPTIONS_BOOT_FLAG_BIOS_BOOT_TYPE_VALID (bios_boot_type)
                              && IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (lock_keyboard)
                              && IPMI_CHASSIS_BOOT_OPTIONS_BOOT_FLAG_BOOT_DEVICE_VALID (boot_device_selector)
                              && IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (screen_blank)
                              && IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (lock_out_reset_button)
                              && IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (lock_out_via_power_button)
                              && IPMI_CHASSIS_BOOT_OPTIONS_BOOT_FLAG_FIRMWARE_BIOS_VERBOSITY_VALID (firmware_bios_verbosity)
                              && IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (force_progress_event_traps)
                              && IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (user_password_bypass)
                              && IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (lock_out_sleep_button)
                              && IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (console_redirection)
                              && IPMI_CHASSIS_BOOT_OPTIONS_ENABLE_VALID (bios_shared_mode_override)
                              && IPMI_CHASSIS_BOOT_OPTIONS_BOOT_FLAGS_BIOS_MUX_CONTROL_OVERRIDE_VALID (bios_mux_control_override)
                              && fiid_obj_valid(obj_cmd_rs));
                              
  UDM_FIID_OBJ_TEMPLATE_COMPARE (obj_cmd_rs, tmpl_cmd_set_system_boot_options_rs);

  UDM_FIID_OBJ_CREATE (obj_cmd_rq, tmpl_cmd_set_system_boot_options_boot_flags_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_set_system_boot_options_boot_flags (bios_boot_type,
                                                                  boot_flags_persistent,
                                                                  boot_flags_valid,
                                                                  lock_out_reset_button,
                                                                  screen_blank,
                                                                  boot_device_selector,
                                                                  lock_keyboard,
                                                                  clear_cmos,
                                                                  console_redirection,
                                                                  lock_out_sleep_button,
                                                                  user_password_bypass,
                                                                  force_progress_event_traps,
                                                                  firmware_bios_verbosity,
                                                                  lock_out_via_power_button,
                                                                  bios_mux_control_override,
                                                                  bios_shared_mode_override,
                                                                  obj_cmd_rq) < 0));
  
  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
                            IPMI_BMC_IPMB_LUN_BMC, 
                            IPMI_NET_FN_CHASSIS_RQ, 
                            obj_cmd_rq, 
                            obj_cmd_rs);
  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY (obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_get_system_boot_options (ipmi_device_t dev,
                                  uint8_t param_selector,
                                  uint8_t set_selector,
                                  uint8_t block_selector,
                                  fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE (obj_cmd_rs, tmpl_cmd_get_system_boot_options_rs);

  UDM_FIID_OBJ_CREATE (obj_cmd_rq, tmpl_cmd_get_system_boot_options_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_get_system_boot_options (param_selector, 
                                                       set_selector, 
                                                       block_selector, 
                                                       obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
                            IPMI_BMC_IPMB_LUN_BMC, 
                            IPMI_NET_FN_CHASSIS_RQ, 
                            obj_cmd_rq, 
                            obj_cmd_rs);
  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY (obj_cmd_rq);
  return (rv);
}

int8_t 
ipmi_cmd_get_system_boot_options_boot_flags (ipmi_device_t dev,
                                             uint8_t set_selector,
                                             uint8_t block_selector,
                                             fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE (obj_cmd_rs, tmpl_cmd_get_system_boot_options_boot_flags_rs);

  UDM_FIID_OBJ_CREATE (obj_cmd_rq, tmpl_cmd_get_system_boot_options_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_get_system_boot_options (IPMI_CHASSIS_BOOT_OPTIONS_PARAMETER_BOOT_FLAGS, 
                                                       set_selector, 
                                                       block_selector, 
                                                       obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
                            IPMI_BMC_IPMB_LUN_BMC, 
                            IPMI_NET_FN_CHASSIS_RQ, 
                            obj_cmd_rq, 
                            obj_cmd_rs);
  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY (obj_cmd_rq);
  return (rv);
}

int8_t
ipmi_cmd_get_power_on_hours_counter (ipmi_device_t dev,
                                     fiid_obj_t obj_cmd_rs)
{
  fiid_obj_t obj_cmd_rq = NULL;
  int8_t rv = -1;

  UDM_ERR_DEV_CHECK (dev && dev->magic == IPMI_UDM_DEVICE_MAGIC);

  UDM_ERR_INVALID_PARAMETERS (fiid_obj_valid(obj_cmd_rs));

  UDM_FIID_OBJ_TEMPLATE_COMPARE (obj_cmd_rs, tmpl_cmd_get_power_on_hours_counter_rs);

  UDM_FIID_OBJ_CREATE (obj_cmd_rq, tmpl_cmd_get_power_on_hours_counter_rq);

  UDM_ERR_CLEANUP (!(fill_cmd_get_power_on_hours_counter (obj_cmd_rq) < 0));

  UDM_ERR_IPMI_CMD_CLEANUP (dev, 
                            IPMI_BMC_IPMB_LUN_BMC, 
                            IPMI_NET_FN_CHASSIS_RQ, 
                            obj_cmd_rq, 
                            obj_cmd_rs);

  rv = 0;
 cleanup:
  UDM_FIID_OBJ_DESTROY (obj_cmd_rq);
  return (rv);
}
