#
# Copyright (c) 2003 FreeIPMI Core Team
#

%define name freeipmi
%define version 0.4.6
%if %{?_with_debug:1}%{!?_with_debug:0}
%define release 1.debug%{?dist}
%else
%define release 1%{?dist}
%endif

Name: %{name}
Version: %{version}
Release: %{release}
License: GPL
Group: Development/System
URL: http://www.gnu.org/software/freeipmi/
Source: ftp://ftp.zresearch.com/pub/freeipmi/0.4.6/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: libgcrypt-devel
Summary: FreeIPMI
%description
The FreeIPMI project provides "Remote-Console" (out-of-band) and
"System Management Software" (in-band) based on Intelligent
Platform Management Interface specification.

%package devel
Summary: Development package for FreeIPMI
Group: Development/System
Requires: freeipmi = %{version}-%{release}
%description devel
Development package for FreeIPMI.  This package includes the FreeIPMI
header files and static libraries.

%package bmc-watchdog
Summary: FreeIPMI BMC watchdog
Group: Applications/System
Requires: freeipmi = %{version}-%{release}
Requires: chkconfig
Requires: logrotate
%description bmc-watchdog
Provides a watchdog daemon for OS monitoring and recovery.

%package ipmimonitoring
Summary: Ipmimonitoring library
Group: Development/System
Requires: freeipmi = %{version}-%{release}
%description ipmimonitoring
Provides library for IPMI host monitoring.

%package ipmidetectd
Summary: Development/System
Group: Applications/System
Requires: freeipmi = %{version}-%{release}
Requires: chkconfig
%description ipmidetectd
IPMI node detection daemon.

%if %{?_with_debug:1}%{!?_with_debug:0}
  %define _enable_debug --enable-debug --enable-trace --enable-syslog
%endif

%prep
%setup -q

%build
%configure --program-prefix=%{?_program_prefix:%{_program_prefix}} \
           %{?_enable_debug}
CFLAGS="$RPM_OPT_FLAGS" make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
DESTDIR="$RPM_BUILD_ROOT" make install
# fix coherance problems with associated script filenames
mkdir -p $RPM_BUILD_ROOT/%{_initrddir}/
# if check needed for SLES systems
if [[ "%{_sysconfdir}/init.d" != "%{_initrddir}" ]]
then
mv $RPM_BUILD_ROOT/%{_sysconfdir}/init.d/freeipmi-bmc-watchdog $RPM_BUILD_ROOT/%{_initrddir}/freeipmi-bmc-watchdog
mv $RPM_BUILD_ROOT/%{_sysconfdir}/init.d/freeipmi-ipmidetectd $RPM_BUILD_ROOT/%{_initrddir}/freeipmi-ipmidetectd
fi
rm -f %{buildroot}%{_infodir}/dir
# kludge to get around rpmlint complaining about 0 length semephore file
echo freeipmi > %{buildroot}%{_localstatedir}/lib/freeipmi/ipckey

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ -x /sbin/install-info ]; then
   #/sbin/install-info %{_infodir}/freeipmi.info.gz %{_infodir}/dir
   /sbin/install-info %{_infodir}/freeipmi-faq.info.gz %{_infodir}/dir
fi
ldconfig

%preun
if [ $1 = 0 ]; then
   if [ -x /sbin/install-info ]; then
      #/sbin/install-info --delete %{_infodir}/freeipmi.info.gz %{_infodir}/dir
      /sbin/install-info --delete %{_infodir}/freeipmi-faq.info.gz %{_infodir}/dir
   fi
fi

%postun -p /sbin/ldconfig

%post bmc-watchdog
if [ "$1" = 1 ]; then
   if [ -x %{_initrddir}/freeipmi-bmc-watchdog ]; then
      /sbin/chkconfig --add freeipmi-bmc-watchdog
      /sbin/chkconfig freeipmi-bmc-watchdog off
   fi
fi
if [ $1 -ge 1 ]; then
   if [ -x %{_initrddir}/freeipmi-bmc-watchdog ]; then
      if %{_initrddir}/freeipmi-bmc-watchdog status | grep -q running; then
         %{_initrddir}/freeipmi-bmc-watchdog restart
      else
         %{_initrddir}/freeipmi-bmc-watchdog condrestart
      fi
   fi
fi

%preun bmc-watchdog
#
# Stop bmc-watchdog if it is running 
#
if [ "$1" = 0 ]; then
    if [ -x %{_initrddir}/freeipmi-bmc-watchdog ]; then
       if %{_initrddir}/freeipmi-bmc-watchdog status | grep -q running; then
          %{_initrddir}/freeipmi-bmc-watchdog stop
       fi
       /sbin/chkconfig --del freeipmi-bmc-watchdog
    fi
fi

%post ipmidetectd
if [ "$1" = 1 ]; then
   if [ -x %{_initrddir}/freeipmi-ipmidetectd ]; then
      /sbin/chkconfig --add freeipmi-ipmidetectd
      /sbin/chkconfig freeipmi-ipmidetectd off
   fi
fi
if [ $1 -ge 1 ]; then
   if [ -x %{_initrddir}/freeipmi-ipmidetectd ]; then
      if %{_initrddir}/freeipmi-ipmidetectd status | grep -q running; then
         %{_initrddir}/freeipmi-ipmidetectd restart
      else
         %{_initrddir}/freeipmi-ipmidetectd condrestart
      fi
   fi
fi

%preun ipmidetectd
#
# Stop ipmidetectd if it is running 
#
if [ "$1" = 0 ]; then
    if [ -x %{_initrddir}/freeipmi-ipmidetectd ]; then
       if %{_initrddir}/freeipmi-ipmidetectd status | grep -q running; then
          %{_initrddir}/freeipmi-ipmidetectd stop
       fi
       /sbin/chkconfig --del freeipmi-ipmidetectd
    fi
fi

%files
%defattr(-,root,root)
%doc %{_datadir}/doc/%{name}/AUTHORS
%doc %{_datadir}/doc/%{name}/COPYING
%doc %{_datadir}/doc/%{name}/ChangeLog
%doc %{_datadir}/doc/%{name}/ChangeLog.0
%doc %{_datadir}/doc/%{name}/INSTALL
%doc %{_datadir}/doc/%{name}/NEWS
%doc %{_datadir}/doc/%{name}/README
%doc %{_datadir}/doc/%{name}/TODO
%doc %{_infodir}/*
%doc %{_datadir}/doc/%{name}/COPYING.ipmiping
%doc %{_datadir}/doc/%{name}/DISCLAIMER.ipmiping
%doc %{_datadir}/doc/%{name}/COPYING.ipmipower
%doc %{_datadir}/doc/%{name}/DISCLAIMER.ipmipower
%doc %{_datadir}/doc/%{name}/COPYING.rmcpping
%doc %{_datadir}/doc/%{name}/DISCLAIMER.rmcpping
%doc %{_datadir}/doc/%{name}/COPYING.ipmiconsole
%doc %{_datadir}/doc/%{name}/DISCLAIMER.ipmiconsole
%doc %{_datadir}/doc/%{name}/COPYING.pstdout
%doc %{_datadir}/doc/%{name}/DISCLAIMER.pstdout
%doc %{_datadir}/doc/%{name}/COPYING.ipmidetect
%doc %{_datadir}/doc/%{name}/DISCLAIMER.ipmidetect
%doc %{_datadir}/doc/%{name}/COPYING.ipmi-fru
%doc %{_datadir}/doc/%{name}/DISCLAIMER.ipmi-fru
%doc %{_datadir}/doc/%{name}/COPYING.ZRESEARCH
%doc %{_datadir}/doc/%{name}/freeipmi-coding.txt
%doc %{_datadir}/doc/%{name}/freeipmi-hostrange.txt
%doc %{_datadir}/doc/%{name}/freeipmi-libraries.txt
%{_libdir}/libipmiconsole*so*
%{_libdir}/libfreeipmi*so*
%{_libdir}/libipmidetect*so*
%{_localstatedir}/lib/*
%{_sbindir}/bmc-autoconfig
%{_sbindir}/bmc-config
%{_sbindir}/bmc-info
%{_sbindir}/ipmi-fru
%{_sbindir}/ipmi-locate
%{_sbindir}/pef-config
%{_sbindir}/ipmi-raw
%{_sbindir}/ipmi-sel
%{_sbindir}/ipmi-sensors
%{_sbindir}/ipmiping
%{_sbindir}/ipmipower
%{_sbindir}/rmcpping
%{_sbindir}/ipmiconsole
%{_sbindir}/ipmi-chassis
%{_sbindir}/ipmidetect
%{_mandir}/man8/bmc-autoconfig.8*
%{_mandir}/man8/bmc-config.8*
%{_mandir}/man5/bmc-config.conf.5*
%{_mandir}/man8/bmc-info.8*
%{_mandir}/man8/ipmi-fru.8*
%{_mandir}/man8/ipmi-locate.8*
%{_mandir}/man8/pef-config.8*
%{_mandir}/man8/ipmi-raw.8*
%{_mandir}/man8/ipmi-sel.8*
%{_mandir}/man8/ipmi-sensors.8*
%{_mandir}/man8/ipmiping.8*
%{_mandir}/man8/ipmipower.8*
%{_mandir}/man5/ipmipower.conf.5*
%{_mandir}/man8/rmcpping.8*
%{_mandir}/man8/ipmiconsole.8*
%{_mandir}/man5/ipmiconsole.conf.5*
%{_mandir}/man8/ipmi-chassis.8*
%{_mandir}/man3/libipmidetect.3*
%{_mandir}/man8/ipmidetect.8*
%{_mandir}/man5/ipmidetect.conf.5*

%files devel
%defattr(-,root,root)
%{_libdir}/libipmiconsole.a
%{_libdir}/libfreeipmi.a
%{_libdir}/libipmiconsole.la
%{_libdir}/libfreeipmi.la
%{_libdir}/libipmidetect.a
%{_libdir}/libipmidetect.la
%dir %{_includedir}/freeipmi
%dir %{_includedir}/freeipmi/udm
%{_includedir}/ipmiconsole.h
%{_includedir}/ipmidetect.h
%{_includedir}/freeipmi/*.h
%{_includedir}/freeipmi/udm/*.h
%{_mandir}/man3/*

%files bmc-watchdog
%defattr(-,root,root)
%doc %{_datadir}/doc/%{name}/COPYING.bmc-watchdog
%doc %{_datadir}/doc/%{name}/DISCLAIMER.bmc-watchdog
%{_initrddir}/freeipmi-bmc-watchdog
%config(noreplace) %{_sysconfdir}/sysconfig/freeipmi-bmc-watchdog
%config(noreplace) %{_sysconfdir}/logrotate.d/freeipmi-bmc-watchdog
%{_sbindir}/bmc-watchdog
%{_mandir}/man8/bmc-watchdog.8*
%dir %{_localstatedir}/log/freeipmi

%files ipmimonitoring
%defattr(-,root,root)
%doc %{_datadir}/doc/%{name}/COPYING.ipmimonitoring
%doc %{_datadir}/doc/%{name}/DISCLAIMER.ipmimonitoring
%config(noreplace) %{_sysconfdir}/ipmi_monitoring_sensors.conf
%{_includedir}/ipmi_monitoring.h
%{_libdir}/libipmimonitoring*
%{_sbindir}/ipmimonitoring
%{_mandir}/man8/ipmimonitoring.8*
%dir %{_localstatedir}/cache/ipmimonitoringsdrcache

%files ipmidetectd
%defattr(-,root,root)
%{_initrddir}/freeipmi-ipmidetectd
%{_sbindir}/ipmidetectd
%{_mandir}/man5/ipmidetectd.conf.5*
%{_mandir}/man8/ipmidetectd.8*

%changelog
* Wed Aug 01 2007 Troy Telford <ttelford@lnxi.com> 0.4.0
- Some package cleanup so it builds on SLES
* Wed Jun 13 2007 Phil Knirsch <pknirsch@redhat.com> 0.4.beta0-1
- Some package cleanup and split of configuration and initscript
* Fri Feb 28 2007 Albert Chu <chu11@llnl.gov> 0.4.beta0-1
- Add ipmidetectd subpackage.
* Fri Feb 16 2007 Albert Chu <chu11@llnl.gov> 0.4.beta0-1
- Add ipmimonitoring subpackage.
* Sun Jul 30 2006 Albert Chu <chu11@llnl.gov> 0.3.beta0-1
- Re-architect for 0.3.X
* Mon May 15 2006 Albert Chu <chu11@llnl.gov> 0.3.beta0-1
- Fixed up spec file to pass rpmlint
