#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "iolib.h"
const char *progname = "svok";
const char *proghelp =
	"Usage: svok [OPTIONS] servicedir\n"
	"Check that supervise is running for a service.\n\n";
#include "freedt.h"

int main(int argc, char **argv) {
	int fd;

	get_default_args(argc, argv);
	if ((argc - optind) != 1)
		help();

	if (chdir(argv[optind]) < 0)
		die2(argv[optind], "unable to chdir to service dir");

	fd = open("supervise/control", O_WRONLY | O_NONBLOCK);
	if (fd < 0) {
		if (errno == ENXIO || errno == ENOENT)
			return 100;
		die2(argv[optind], "unable to open control pipe");
	}

	return 0;
}

