#include <pwd.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include "iolib.h"
const char *progname = "envuidgid";
const char *proghelp =
	"Usage: envuidgid [OPTIONS] account command ...\n"
	"Run a command with $UID and $GID set for an account.\n\n";
#include "freedt.h"

int main(int argc, char **argv) {
	struct passwd *p;
	buffer b = BUFFER;

	get_default_args(argc, argv);
	if ((argc - optind) < 2)
		help();

	p = getpwnam(argv[optind]);
	if (!p)
		die2(argv[optind], "no such account");
	bformat(&b, "@i", p->pw_uid);
	if (fdt_setenv("UID", bstr(&b)) < 0)
		die("unable to set UID");
	bfree(&b);
	bformat(&b, "@i", p->pw_gid);
	if (fdt_setenv("GID", bstr(&b)) < 0)
		die("unable to set GID");
	bfree(&b);

	++optind;
	execvp(argv[optind], &argv[optind]);
	die2(argv[optind], "unable to exec");

	return 0; /* NOTREACHED */
}

