#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "iolib.h"
const char *progname = "anonidentd";
const char *proghelp =
	"Usage: anonidentd [OPTIONS]\n"
	"A simple anonymous identd server.\n\n"
	"-n        Return a HIDDEN-USER response\n"
	"-c ID     Return a USERID:UNIX ID response\n";
#include "freedt.h"

char *response = NULL;

int main(int argc, char **argv) {
	int my_pid = getpid();
	char *remoteip, *remoteport;
	buffer overflow = BUFFER;

	while (1) {
		int c = getopt(argc, argv, "V?nc:");
		if (c == -1)
			break;
		switch (c) {
		case 'n':
			response = NULL;
			break;
		case 'c':
			response = strdup(optarg);
			break;
		case 'V':
			version();
		default:
			help();
		}
	}

	if (argc != optind)
		help();

	setuidgidroot();

	remoteip = getenv("TCPREMOTEIP");
	if (remoteip == NULL)
		die("no TCPREMOTEIP set");
	remoteport = getenv("TCPREMOTEPORT");
	if (remoteport == NULL)
		die("no TCPREMOTEPORT set");

	format(fd_err, "@i: connect from @c port @c\n",
		my_pid, remoteip, remoteport);	

	while (1) {
		int pos;
		int c;
		const char *s;
		int my_port, their_port;
		buffer request = BUFFER, reply = BUFFER;

		c = readlineb(fd_in, &request, 1000, &overflow);
		if (c == 0)
			break;
		if (c < 0) {
			format(fd_err, "@i: read from client failed\n", my_pid);
			goto out;
		}

		pos = bindex(&request, ',');
		if (pos == -1) {
			format(fd_err, "@i: request without comma\n", my_pid);
			goto out;
		}

		s = bstr(&request);
		my_port = atoi(s);
		their_port = atoi(s + pos + 1);

		if (my_port < 1 || my_port > 65535
			|| their_port < 1 || their_port > 65535) {
			format(fd_err, "@i: port out of range in request\n",
				my_pid);
			goto out;
		}

		format(fd_err, "@i: request @i,@i\n",
			my_pid, my_port, their_port);

		bformat(&reply, " @i , @i : ", my_port, their_port);
		if (response == NULL) {
			bformat(&reply, "ERROR : HIDDEN-USER\r\n");
		} else {
			bformat(&reply, "USERID : UNIX : @c\r\n", response);
		}

		if (writeba(fd_out, &reply) < 0) {
			format(fd_err, "@i: write to client failed\n", my_pid);
			goto out;
		}

		bfree(&request);
		bfree(&reply);
	}

	out:
	format(fd_err, "@i: closed\n", my_pid);

	return 0;
}

