===========================================================================
 Freecivs Stilvgledning
===========================================================================

Om man vill koda Freeciv och f sina patchar antagna s hjlper det
att flja ngra enkla stilregler. Ja, ngra av dessa r en aning
petiga, men krig utkmpas ver de fnigaste saker...

- Freeciv r skrivet i C (frutom BEOS-klienten). Detta innebr att
  C++-drag som "//"-kommentarer och variabeldeklarationer som inte r
  i brjan av block r frbjudna.

- Anvnd K&R-indragsstil med indrag 2 (vid tveksamhet, anvnd
  "indent -kr -i2 -l77"). Men man ska inte ndra stilen p kodstycken
  som man inte ndrar p annat stt eller skapar. Hr r de viktigaste
  egenskaperna:
    - den strsta tilltna radlngden r 77 tecken
    - blanksteg infogas fre och efter operatorer ("int i, j, k;" i
      stllet fr "int i,j,k;" och "if (foo <= bar) c = a + b;" i
      stllet fr "if(foo<=bar) c=a+b;")
    - funktionsklammern skall st i den frsta kolonnen:
        int foo()
        {
          return 0;
        }
      i stllet fr
        int foo() {
          return 0;
        }
    - tabavstndet skall vara 8

- En tom rad ska sttas mellan 2 tskilda kodstycken.

================================
 Kommentarer
================================

- Varje funktion ska ha ett kommentarhuvud. Det ska vara ovanfr
  funktionens implementering, inte prototypen:

/*************************************************************************
 funktionsbeskrivningen ska vara hr
 all anvndbar information ssom vad som anropar funktionen med mera
 skapa _inte_ en ny funktion utan ngon form av kommentar
*************************************************************************/

int the_function_starts_here(int value) 
{
  ...
}

- Enradskommentarer: Kommentaren ska vara rtt indragen och st
  ovanfr koden som kommenteas:

  int x;

  /* Detta r en enradskommentar */
  x = 3;

- Flerradskommentarer: Stjrnor ska st framfr kommentarraden:

  /* Detta r en
   * flerradskommentar 
   * bla bla bla */

- Kommentarer i deklarationer. Om man behver kommentera en
  variabeldeklaration s ska det gras s hr:

  struct foo {
    int bar;                    /* bar anvnds fr ....
                                 * att ..... ska */
    int blah;                   /* blah anvnds fr .... */
  };

- Kommentarer i villkorssatser: Om man behver en kommentar fr att
  visa programfldet s ska den st nedanfr if eller else:

  if(is_barbarian(pplayer)) {
    x++;
  } else {
    /* Om inte barbar ... */
    x--;
  }

- Kommentarer till versttare str fre strngen som r mrkt med
  N_(), _() eller Q_() och har frstavelsen "TRANS:". Dessa
  kommentarer kopieras till versttningsfilerna. De ska anvndas
  nrhelst man tycker att versttarna kan behva lite mer
  information:

    /* TRANS: verstt inte "commandname". */
    printf(_("commandname <arg> [-o <optarg>]"));

================================
 Deklarera variabler
================================

- Variabler kan tilldelas ett vrde vid initialiseringen:

int foo(struct unit *punit)
{
  int x = punit->x;
  int foo = x;
  char *blah;

  ...
}

- Efter variabeldeklarationerna ska det vara en tom rad fre resten av
  funktionskroppen.

- Sammanfoga deklarationer: Variabler behver inte dekrareras p var
  sin rad. De ska dock endast sammanfogas om de har liknande
  anvndning.

int foo(struct city *pcity)
{
  int i, j, k;
  int total, cost;
  int build = pcity->shield_stock;
}

================================
 Klamrar
================================

- Ytterligare klamrar p upprepningar: Lgg mrke till att
  *_iterate_end; ska st p samma rad som slutklammern:

  unit_list_iterate(pcity->units_supported, punit) {
    kill(punit);
  } unit_list_iterate_end;

- I switchsatser skall klamrar bara sttas dr de behvs, till exempel
  fr att skydda variabler.

- Klammrar skall anvndas efter villkorssatser:

  if (x == 3) {
    return;
  }

 och 

  if (x == 3) {
    return 1;
  } else {
    return 0;
  }

 inte

  if (x == 3)
    return 1;  /* DLIGT! */

================================
 Annat
================================

- Om ett tomt block behvs s ska man stta en frklarnde kommentar i
  det:

  while(*i++) {
    /* nothing */
  }

- Ordna inkluderingsfiler konsekvent: Alla systeminkluderingsfiler ska
  st frst, inom <> och i bokstavsordning. Sedan ska alla
  freecivinkluderingsfiler st inom "" och ordnade efter katalog
  (common, server, ...) och sedan i bokstavsordning. Det ska vara en
  tom rad mellan styckena. Detta hjlper till att undvika dubbla
  inkluderingar.

- Om man anvnder systemberoende funktioner s ska man inte lgga till
  #ifdef __CRAY__ eller liknande. Man ska i stllet skriva ett prov
  fr funktionen i bde configure.in och configure.ac och anvnda ett
  meningsfullt makronamn i kllkoden.

- Globala funktioner ska alltid ha prototyper i lmpliga
  inkluderingsfiler. Lokala funktioner ska alltid deklareras som
  statiska. Fr att upptcka detta och ngra andra problem skall man
  anvnda fljande varningsargument fr gcc; "-Wall -Wpointer-arith
  -Wcast-align -Wmissing-prototypes -Wmissing-declarations
  -Wstrict-prototypes -Wnested-externs".

- Om man skickar patchar s ska man anvnda "diff -u" (eller "diff -r
  -u" eller "cvs diff -u"). Se
  <http://www.freeciv.org/contribute.html> fr ytterligare
  upplysningar. Man ska ven ge patcharna beskrivande namn (till
  exempel "fix-foo-0.diff", men inte "freeciv.diff").

- Nr man kr "diff" fr en patch s ska man se till att utesluta
  ondiga filer genom att anvnda kommandoradsargumentet "-X" fr
  programmet "diff":

    % diff -ruN -Xdiff_ignore freeciv_c freeciv > /tmp/fix-foo-0.diff

  En freslagen "diff_ignore"-fil fljer med Freeciv.

===========================================================================
