/********************************************************************** 
 Freeciv - Copyright (C) 1996 - A Kjeldberg, L Gregersen, P Unold
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
***********************************************************************/
#ifndef FC__AIUNIT_H
#define FC__AIUNIT_H

#include "unittype.h"
#include "combat.h"

/*
 * To prevent integer overflows the product "power * hp * firepower"
 * is divided by POWER_DIVIDER.
 *
 * The constant may be changed since it isn't externally visible used.
 */
#define POWER_DIVIDER 	(POWER_FACTOR * 3)

struct player;
struct city;
struct unit;
struct ai_choice;

extern Unit_Type_id simple_ai_types[U_LAST];

void ai_manage_units(struct player *pplayer); 
int could_unit_move_to_tile(struct unit *punit, int src_x, int src_y,
			    int dest_x, int dest_y);
int look_for_charge(struct player *pplayer, struct unit *punit,
                    struct unit **aunit, struct city **acity);

bool ai_manage_explorer(struct unit *punit);

int find_something_to_kill(struct player *pplayer, struct unit *punit, 
                            int *x, int *y);
int find_beachhead(struct unit *punit, int dest_x, int dest_y, int *x, int *y);

int build_cost_balanced(Unit_Type_id type);
int base_unit_belligerence_primitive(Unit_Type_id type, bool veteran,
				     int moves_left, int hp);
int unit_belligerence_basic(struct unit *punit);
int unit_belligerence(struct unit *punit);
int unit_vulnerability_basic(struct unit *punit, struct unit *pdef);
int unit_vulnerability_virtual(struct unit *punit);
int unit_vulnerability_virtual2(Unit_Type_id att_type, Unit_Type_id def_type,
				int x, int y, bool fortified, bool veteran,
				bool use_alternative_hp, int alternative_hp);
int unit_vulnerability(struct unit *punit, struct unit *pdef);
int kill_desire(int benefit, int attack, int loss, int vuln, int attack_count);
int military_amortize(int value, int delay, int build_cost);

bool is_on_unit_upgrade_path(Unit_Type_id test, Unit_Type_id base);

Unit_Type_id ai_wants_role_unit(struct player *pplayer, struct city *pcity,
                                int role, int want);
void ai_choose_role_unit(struct player *pplayer, struct city *pcity,
			 struct ai_choice *choice, int role, int want);
void update_simple_ai_types(void);

#define simple_ai_unit_type_iterate(m_i)                                      \
{                                                                             \
  int m_c;                                                                    \
  for (m_c = 0;; m_c++) {                                                     \
    Unit_Type_id m_i = simple_ai_types[m_c];                                  \
    if (m_i == U_LAST) {                                                      \
      break;                                                                  \
    }

#define simple_ai_unit_type_iterate_end                                       \
 }                                                                            \
}

#endif  /* FC__AIUNIT_H */
