/********************************************************************************
*                                                                               *
*                     T h e   A d i e   T e x t   E d i t o r                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998,2003 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: Adie.cpp,v 1.92 2003/09/12 00:55:07 fox Exp $                            *
********************************************************************************/
#include "fx.h"
#include "fxkeys.h"
#include "FXRex.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <signal.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <ctype.h>
#include "HelpWindow.h"
#include "Preferences.h"
#include "Commands.h"
#include "Hilite.h"
#include "TextWindow.h"
#include "Adie.h"
#include "icons.h"

/*
  Notes:
  - One single collection of icons.
  - Manage list of open windows.
*/


/*******************************************************************************/

// Map
FXDEFMAP(Adie) AdieMap[]={
  FXMAPFUNC(SEL_SIGNAL,Adie::ID_CLOSEALL,Adie::onCmdCloseAll),
  FXMAPFUNC(SEL_COMMAND,Adie::ID_CLOSEALL,Adie::onCmdCloseAll),
  };


// Object implementation
FXIMPLEMENT(Adie,FXApp,AdieMap,ARRAYNUMBER(AdieMap))


// Make some windows
Adie::Adie(const FXString& name):FXApp(name,FXString::null){

  // Make some icons; these are shared between all text windows
  bigicon=new FXGIFIcon(this,big_gif);
  smallicon=new FXGIFIcon(this,small_gif);
  newicon=new FXGIFIcon(this,new_gif,0,IMAGE_ALPHAGUESS);
  reloadicon=new FXGIFIcon(this,reload_gif);
  openicon=new FXGIFIcon(this,open_gif);
  saveicon=new FXGIFIcon(this,save_gif);
  saveasicon=new FXGIFIcon(this,saveas_gif,0,IMAGE_ALPHAGUESS);
  printicon=new FXGIFIcon(this,print_gif);
  cuticon=new FXGIFIcon(this,cut_gif);
  copyicon=new FXGIFIcon(this,copy_gif);
  pasteicon=new FXGIFIcon(this,paste_gif);
  deleteicon=new FXGIFIcon(this,delete_gif);
  undoicon=new FXGIFIcon(this,undo_gif);
  redoicon=new FXGIFIcon(this,redo_gif);
  fontsicon=new FXGIFIcon(this,fonts_gif);
  helpicon=new FXGIFIcon(this,help_gif);
  quiticon=new FXGIFIcon(this,quit_gif);
  shiftlefticon=new FXGIFIcon(this,shiftleft_gif);
  shiftrighticon=new FXGIFIcon(this,shiftright_gif);

  searchicon=new FXGIFIcon(this,search_gif,0,IMAGE_ALPHAGUESS);
  searchnexticon=new FXGIFIcon(this,searchnext_gif,0,IMAGE_ALPHAGUESS);
  searchprevicon=new FXGIFIcon(this,searchprev_gif,0,IMAGE_ALPHAGUESS);
  bookseticon=new FXGIFIcon(this,bookset_gif);
  booknexticon=new FXGIFIcon(this,booknext_gif);
  bookprevicon=new FXGIFIcon(this,bookprev_gif);
  bookdelicon=new FXGIFIcon(this,bookdel_gif);

  // If interrupt happens, quit gracefully; we may want to
  // save edit buffer contents w/o asking if display gets
  // disconnected or if hangup signal is received.
  addSignal(SIGINT,this,ID_CLOSEALL);
#ifndef WIN32
  addSignal(SIGQUIT,this,ID_CLOSEALL);
  addSignal(SIGHUP,this,ID_CLOSEALL);
  addSignal(SIGPIPE,this,ID_CLOSEALL);
#endif

  // File associations
  associations=new FXFileDict(this);
  nstyles=0;
  }


// Initialize application
void Adie::init(int& argc,char** argv,FXbool connect){

  // After init, the registry has been loaded
  FXApp::init(argc,argv,connect);

  // Read common registry settings
  readStyles();

  // Now we know the icon search path
  associations->setIconPath(reg().readStringEntry("SETTINGS","iconpath",FXIconDict::defaultIconPath));
  }


// Exit application
void Adie::exit(FXint code){

  // Write common registry setting
  writeStyles();

  // Writes registry, and quits
  FXApp::exit(code);
  }


// Delete style
void Adie::deleteStyle(FXint index){
  register FXint i;
  FXASSERT(index<nstyles);
  for(i=index+1; i<nstyles; i++){
    stylename[i-1]=stylename[i];
    stylecolor[i-1]=stylecolor[i];
    }
  nstyles--;
  for(i=0; i<windowlist.no(); i++) windowlist[i]->redraw();
  }


// Append style
void Adie::appendStyle(const FXString& name,const FXHiliteStyle& style){
  register FXint i;
  FXASSERT(nstyles<MAXSTYLES);
  stylename[nstyles]=name;
  stylecolor[nstyles]=style;
  nstyles++;
  for(i=0; i<windowlist.no(); i++) windowlist[i]->redraw();
  }


// Change style colors
void Adie::setStyleColors(FXint index,const FXHiliteStyle& style){
  register FXint i;
  stylecolor[index]=style;
  for(i=0; i<windowlist.no(); i++) windowlist[i]->redraw();
  }


// Read styles
void Adie::readStyles(){
  FXchar nfg[100],nbg[100],sfg[100],sbg[100],hfg[100],hbg[100],abg[100],index[10],name[200];
  FXint  sty,i;
  nstyles=0;
  for(i=0; i<MAXSTYLES; i++){
    sprintf(index,"%d",i+1);
    if(reg().readFormatEntry("STYLES",index,"%[^,],%[^,],%[^,],%[^,],%[^,],%[^,],%[^,],%[^,],%d",name,nfg,nbg,sfg,sbg,hfg,hbg,abg,&sty)!=9) break;
    FXTRACE((1,"name=\"%s\" nfg=%s nbg=%s sfg=%s sbg=%s hfg=%s hbg=%s abg=%s sty=%d\n",name,nfg,nbg,sfg,sbg,hfg,hbg,abg,sty));
    stylename[i]=name;
    stylecolor[i].normalForeColor=fxcolorfromname(nfg);
    stylecolor[i].normalBackColor=fxcolorfromname(nbg);
    stylecolor[i].selectForeColor=fxcolorfromname(sfg);
    stylecolor[i].selectBackColor=fxcolorfromname(sbg);
    stylecolor[i].hiliteForeColor=fxcolorfromname(hfg);
    stylecolor[i].hiliteBackColor=fxcolorfromname(hbg);
    stylecolor[i].activeBackColor=fxcolorfromname(abg);
    stylecolor[i].style=sty;
    nstyles++;
    }
  }


// Write styles
void Adie::writeStyles(){
  FXchar nfg[100],nbg[100],sfg[100],sbg[100],hfg[100],hbg[100],abg[100],name[10];
  FXint  i;
  reg().deleteSection("STYLES");
  for(i=0; i<nstyles; i++){
    fxnamefromcolor(nfg,stylecolor[i].normalForeColor);
    fxnamefromcolor(nbg,stylecolor[i].normalBackColor);
    fxnamefromcolor(sfg,stylecolor[i].selectForeColor);
    fxnamefromcolor(sbg,stylecolor[i].selectBackColor);
    fxnamefromcolor(hfg,stylecolor[i].hiliteForeColor);
    fxnamefromcolor(hbg,stylecolor[i].hiliteBackColor);
    fxnamefromcolor(abg,stylecolor[i].activeBackColor);
    sprintf(name,"%d",i+1);
    reg().writeFormatEntry("STYLES",name,"%s,%s,%s,%s,%s,%s,%s,%s,%d",stylename[i].text(),nfg,nbg,sfg,sbg,hfg,hbg,abg,stylecolor[i].style);
    }
  }


// Close all windows
long Adie::onCmdCloseAll(FXObject*,FXSelector,void*){
  while(0<windowlist.no() && windowlist[0]->close(TRUE));
  return 1;
  }


// Clean up the mess
Adie::~Adie(){
  FXASSERT(windowlist.no()==0);
  delete associations;
  delete bigicon;
  delete smallicon;
  delete newicon;
  delete reloadicon;
  delete openicon;
  delete saveicon;
  delete saveasicon;
  delete printicon;
  delete cuticon;
  delete copyicon;
  delete pasteicon;
  delete deleteicon;
  delete undoicon;
  delete redoicon;
  delete fontsicon;
  delete helpicon;
  delete quiticon;
  delete shiftlefticon;
  delete shiftrighticon;
  delete searchicon;
  delete searchnexticon;
  delete searchprevicon;
  delete bookseticon;
  delete booknexticon;
  delete bookprevicon;
  delete bookdelicon;
  }

