//
// File: <wsa_error.c>
//
// Written by: David M. Stanhope [voip@fobbit.com]
//

#include "vblast.h"

int
Socket_Errno(void)
{
    return WSAGetLastError();
}


#define EENTRY(x) case x: s = #x; break;


char *
Socket_Error_String(int wsa_error)
{
    static char buf[128]; char *s;

    switch(wsa_error)
    {
        EENTRY(WSAEINTR                  )
        EENTRY(WSAEBADF                  )
        EENTRY(WSAEACCES                 )
        EENTRY(WSAEFAULT                 )
        EENTRY(WSAEINVAL                 )
        EENTRY(WSAEMFILE                 )
        EENTRY(WSAEWOULDBLOCK            )
        EENTRY(WSAEINPROGRESS            )
        EENTRY(WSAEALREADY               )
        EENTRY(WSAENOTSOCK               )
        EENTRY(WSAEDESTADDRREQ           )
        EENTRY(WSAEMSGSIZE               )
        EENTRY(WSAEPROTOTYPE             )
        EENTRY(WSAENOPROTOOPT            )
        EENTRY(WSAEPROTONOSUPPORT        )
        EENTRY(WSAESOCKTNOSUPPORT        )
        EENTRY(WSAEOPNOTSUPP             )
        EENTRY(WSAEPFNOSUPPORT           )
        EENTRY(WSAEAFNOSUPPORT           )
        EENTRY(WSAEADDRINUSE             )
        EENTRY(WSAEADDRNOTAVAIL          )
        EENTRY(WSAENETDOWN               )
        EENTRY(WSAENETUNREACH            )
        EENTRY(WSAENETRESET              )
        EENTRY(WSAECONNABORTED           )
        EENTRY(WSAECONNRESET             )
        EENTRY(WSAENOBUFS                )
        EENTRY(WSAEISCONN                )
        EENTRY(WSAENOTCONN               )
        EENTRY(WSAESHUTDOWN              )
        EENTRY(WSAETOOMANYREFS           )
        EENTRY(WSAETIMEDOUT              )
        EENTRY(WSAECONNREFUSED           )
        EENTRY(WSAELOOP                  )
        EENTRY(WSAENAMETOOLONG           )
        EENTRY(WSAEHOSTDOWN              )
        EENTRY(WSAEHOSTUNREACH           )
        EENTRY(WSAENOTEMPTY              )
        EENTRY(WSAEPROCLIM               )
        EENTRY(WSAEUSERS                 )
        EENTRY(WSAEDQUOT                 )
        EENTRY(WSAESTALE                 )
        EENTRY(WSAEREMOTE                )
        EENTRY(WSASYSNOTREADY            )
        EENTRY(WSAVERNOTSUPPORTED        )
        EENTRY(WSANOTINITIALISED         )
        EENTRY(WSAEDISCON                )
        EENTRY(WSAENOMORE                )
        EENTRY(WSAECANCELLED             )
        EENTRY(WSAEINVALIDPROCTABLE      )
        EENTRY(WSAEINVALIDPROVIDER       )
        EENTRY(WSAEPROVIDERFAILEDINIT    )
        EENTRY(WSASYSCALLFAILURE         )
        EENTRY(WSASERVICE_NOT_FOUND      )
        EENTRY(WSATYPE_NOT_FOUND         )
        EENTRY(WSA_E_NO_MORE             )
        EENTRY(WSA_E_CANCELLED           )
        EENTRY(WSAEREFUSED               )
        EENTRY(WSAHOST_NOT_FOUND         )
        EENTRY(WSATRY_AGAIN              )
        EENTRY(WSANO_RECOVERY            )
        EENTRY(WSANO_DATA                )
        EENTRY(WSA_QOS_RECEIVERS         )
        EENTRY(WSA_QOS_SENDERS           )
        EENTRY(WSA_QOS_NO_SENDERS        )
        EENTRY(WSA_QOS_NO_RECEIVERS      )
        EENTRY(WSA_QOS_REQUEST_CONFIRMED )
        EENTRY(WSA_QOS_ADMISSION_FAILURE )
        EENTRY(WSA_QOS_POLICY_FAILURE    )
        EENTRY(WSA_QOS_BAD_STYLE         )
        EENTRY(WSA_QOS_BAD_OBJECT        )
        EENTRY(WSA_QOS_TRAFFIC_CTRL_ERROR)
        EENTRY(WSA_QOS_GENERIC_ERROR     )
#ifdef WSA_QOS_ESERVICETYPE
        EENTRY(WSA_QOS_ESERVICETYPE      )
        EENTRY(WSA_QOS_EFLOWSPEC         )
        EENTRY(WSA_QOS_EPROVSPECBUF      )
        EENTRY(WSA_QOS_EFILTERSTYLE      )
        EENTRY(WSA_QOS_EFILTERTYPE       )
        EENTRY(WSA_QOS_EFILTERCOUNT      )
        EENTRY(WSA_QOS_EOBJLENGTH        )
        EENTRY(WSA_QOS_EFLOWCOUNT        )
        EENTRY(WSA_QOS_EUNKOWNPSOBJ      )
        EENTRY(WSA_QOS_EPOLICYOBJ        )
        EENTRY(WSA_QOS_EFLOWDESC         )
        EENTRY(WSA_QOS_EPSFLOWSPEC       )
        EENTRY(WSA_QOS_EPSFILTERSPEC     )
        EENTRY(WSA_QOS_ESDMODEOBJ        )
        EENTRY(WSA_QOS_ESHAPERATEOBJ     )
        EENTRY(WSA_QOS_RESERVED_PETYPE   )
#endif
        default: s = "UNKNOWN"; break;
    }


    sprintf(buf, "%d:%s", wsa_error, s);
    return buf;
}

char *
Socket_Error(void)
{
    return Socket_Error_String(WSAGetLastError());
}

int
Socket_Would_Block(int wsa_error)
{

    if(wsa_error == WSAEWOULDBLOCK)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

//
// The End!
//
