//
// File: <util.c>
//
// Written by: David M. Stanhope [voip@fobbit.com]
//

#include "vblast.h"

// ---------------------------------------------------------------------------

char *
Show_Error_String(int err)
{
    static char buf[128];
    sprintf(buf, "%d:%s", err, strerror(err));
    return buf;
}

char *
Show_Error(void)
{
    return Show_Error_String(errno);
}

// ---------------------------------------------------------------------------

int
hex_char(int c)
{
    c &= 0x0f;
    if(c < 10) return  c       + '0';
          else return (c - 10) + 'a';
}

// ---------------------------------------------------------------------------
// dump data at given address with given length in hex and ascii
// ---------------------------------------------------------------------------

#define DW 16

void
dump(char *msg, u_char *sp, int len)
{
    int i, n, c, offset;
    char *dp, *cp, dbuf[(DW * 3) + 1], cbuf[DW + 1];

    if(debug_level && (len > 0))
    {
        offset = 0;
        MSG(("%s(%02d)\n", msg, len))
        while(len > 0)
        {
            dp = dbuf; cp = cbuf;

            if(len > DW) { n = DW; } else { n = len; }

            for(i = 0; i < DW; i++)
            {
                if(i < n)
                {
                     c    = *sp++;
                    *dp++ = hex_char(c >> 4);
                    *dp++ = hex_char(c     );
                    *cp++ = ((c >= ' ') && (c <= '~')) ?  c : '.';
                }
                else
                {
                    *dp++ = 'x';
                    *dp++ = 'x';
                    *cp++ = 'x';
                }
                *dp++ = ' ';
            }

            *dp++ = '\0'; *cp++ = '\0';

            MSG(("%08lx: %s %s\n", offset, dbuf, cbuf))

            offset += DW; len -= DW;
        }
    }
}

// ---------------------------------------------------------------------------

char *
new_string(char *s)
{
    char *ns;
    if((ns = (char *) malloc(strlen(s) + 1)) == NULL)
    {
        ERR(("Out of Memory for (%s)\n", s))
        exit(-1);
    }
    strcpy(ns, s);
    return ns;
}

// ---------------------------------------------------------------------------

void
skip_whitespace(char **cp)
{
    char *s = *cp;
    while((*s == ' ') || (*s == '\t')) { s++; }
    *cp = s;
}

// ---------------------------------------------------------------------------

char *
get_token(char **cp, char *bp)
{
    int c; char *src, *dst;
    skip_whitespace(cp);
    src = *cp; dst = bp;
    if(*src == '"')
    {
        src++; // skip past quote
        while((c = *src++) != '"')
        {
            if((c == '\r') || (c == '\n') || (c == '\0')) return NULL;
            *dst++ = c;
        }
    }
    else
    {
        while((c = *src++) != '\0')
        {
            if((c == '\r') || (c == '\n') ||
               (c == '\t') || (c == ' ')) break;
            *dst++ = c;
        }
    }
    *dst = '\0'; *cp = src;
    return bp;
}


// ---------------------------------------------------------------------------

int
get_hex(int c)
{
    if((c >= '0') && (c <= '9')) return (c - '0')     ;
    if((c >= 'a') && (c <= 'f')) return (c - 'a') + 10;
    if((c >= 'A') && (c <= 'F')) return (c - 'A') + 10;

    ERR(("Invalid character in serial number (0x%02x)\n", c))

    exit(-1);

    NEED_RETURN(0)
}

int
get_hex2(char *cp)
{
    return (get_hex(cp[0]) << 4) | get_hex(cp[1]);
}

int
get_hex4(char *cp)
{
    return (get_hex2(cp) << 8) | get_hex2(cp + 2);
}

int
get_hex8(char *cp)
{
    return (get_hex4(cp) << 16) | get_hex4(cp + 4);
}

// ---------------------------------------------------------------------------

//
// The End!
//
