//
// File: <usb_devfs.c>
//
// Written by: David M. Stanhope [voip@fobbit.com]
//

#include "vblast.h"

#ifdef USE_DEVFS

#ifdef OLD_WAY

#include <signal.h>
#include <sys/ioctl.h>

static int
bg_reader(char *name, int fd, int len, pid_t *p_pid)
{
    unsigned char buf[20];
    int got, r, fds[2], pid;

    if(pipe(fds) != 0)
    {
        ERR(("%s: pipe() error(%s)\n", name, Show_Error()))
        exit(-1);
    }

    if((pid = fork()) < 0)
    {
        ERR(("%s: fork() error(%s)\n", name, Show_Error()))
        exit(-1);
    }

    if(pid != 0) // in parent
    {
        close(fds[1]);
        *p_pid = pid;
        return fds[0];
    }

    // in child

    close(fds[0]);

    set_title("%s", name);

    while(1)
    {
        if((got = read(fd, buf, len)) < 0)
        {
            ERR(("%s: read() error(%s)\n", name, Show_Error()))
            exit(-1);
        }
        else if(got == 0)
        {
            ERR(("%s: read() returned 0\n", name))
            exit(-1);
        }
        else // got > 0
        {
            dump(name, buf, got);
            if((r = write(fds[1], buf, got)) != got)
            {
                if(r < 0)
                {
                    ERR(("%s: write(%d) error(%s)\n", name, got, Show_Error()))
                }
                else
                {
                    ERR(("%s: write(%d) error, ret(%d)\n", name, got, r))
                }
                close(fds[1]);
                exit(-1);
            }
        }
    }
}

static pid_t spid; // pid of status reader
static pid_t vpid; // pid of voice  reader

static void
kill_readers(void)
{
    kill(spid, SIGTERM);
    kill(vpid, SIGTERM);
}

static void
set_signals(void (*handler)(int))
{
    signal(SIGHUP , handler);
    signal(SIGINT , handler);
    signal(SIGQUIT, handler);
    signal(SIGABRT, handler);
    signal(SIGFPE , handler);
    signal(SIGSEGV, handler);
    signal(SIGPIPE, handler);
    signal(SIGALRM, handler);
    signal(SIGTERM, handler);
    signal(SIGCHLD, handler);
    signal(SIGBUS , handler);
}

static void
catch_signals(int n)
{
    set_signals(SIG_IGN); // don't want to hear about child's exit

    MSG(("Signal (%d) Caught, Exiting\n", n))

    exit(1); // should call 'kill_readers()' since registers with 'atexit()'
}

#endif // OLD_WAY

// ---------------------------------------------------------------------------

VBLAST *
vblast_device_open(int device_index)
{
    static VBLAST vb;

    unsigned char c_name[32];
    unsigned char v_name[32];

    sprintf(c_name, "/dev/usb/vbc%d", device_index);
    sprintf(v_name, "/dev/usb/vbv%d", device_index);

    if((vb.fd_command   = open(c_name, 2)) < 0)
    {
        ERR(("open(%s) error(%s)\n", c_name, Show_Error()))
        exit(-1);
    }
    MSG(("Opened (%s)\n", c_name))

    if((vb.fd_voice_out = open(v_name, 2)) < 0)
    {
        ERR(("open(%s) error(%s)\n", v_name, Show_Error()))
        exit(-1);
    }
    MSG(("Opened (%s)\n", v_name))

    // -----------------------------------------------------------------------

#ifdef OLD_WAY

    vb.fd_status    = bg_reader(c_name, vb.fd_command,    1, &spid);
    vb.fd_voice_inp = bg_reader(v_name, vb.fd_voice_out, 20, &vpid);

    // -----------------------------------------------------------------------

    atexit(kill_readers); // shutdown children on normal exit

    // catch a bunch of signals to insure background reads shutdown at exit
    set_signals(catch_signals);

#endif // OLD_WAY

    // -----------------------------------------------------------------------

    return &vb;
}

void
vblast_device_close(VBLAST *v)
{
    MSG(("vblast_close-start\n"))
    close(v->fd_status   ); v->fd_status    = -1;
    close(v->fd_voice_inp); v->fd_voice_inp = -1;
    MSG(("vblast_close-done\n"))
}

#endif // USE_DEVFS

//
// The End!
//
