#
# Makefile for vb.exe
#

!IF "$(OS)" == "Windows_NT"
NULL=
!ELSE 
NULL=nul
!ENDIF 

LOCDIR=.
OUTDIR=.\Setup
INTDIR=.\Setup
# Begin Custom Macros
OutDir=.\Setup
# End Custom Macros

ALL : "$(OUTDIR)\setup.exe"

CLEAN :
	-@erase "$(INTDIR)\setup.obj"
	-@erase "$(INTDIR)\util.obj"
	-@erase "$(INTDIR)\vb.c"
	-@erase "$(INTDIR)\vb.obj"
	-@erase "$(LOCDIR)\dialtone.c"
	-@erase "$(INTDIR)\dialtone.obj"
	-@erase "$(LOCDIR)\ringback.c"
	-@erase "$(INTDIR)\ringback.obj"
	-@erase "$(LOCDIR)\busy.c"
	-@erase "$(INTDIR)\busy.obj"
	-@erase "$(LOCDIR)\vb_usb1.c"
	-@erase "$(INTDIR)\vb_usb1.obj"
	-@erase "$(LOCDIR)\vb_usb2.c"
	-@erase "$(INTDIR)\vb_usb2.obj"
	-@erase "$(LOCDIR)\vb_ini.c"
	-@erase "$(INTDIR)\vb_ini.obj"
	-@erase "$(LOCDIR)\cvt.obj"
	-@erase "$(LOCDIR)\cvt.exe"
	-@erase "$(INTDIR)\Script2.res"
	-@erase "$(INTDIR)\vc60.idb"
	-@erase "$(OUTDIR)\setup.exe"
	-@erase "$(LOCDIR)\setup.log"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP=cl.exe
CPP_PROJ=/nologo /Ic:\NTDDK\inc\win_me /MT /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" /D "WIN32_LEAN_AND_MEAN" /D "_MT" /D "IS_VBWIN" /Fp"$(INTDIR)\setup.pch" /YX /Fo"$(INTDIR)\\" /Fd"$(INTDIR)\\" /FD /c 

.c{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $< 
<<

MTL=midl.exe
MTL_PROJ=/nologo /D "NDEBUG" /mktyplib203 /win32 
RSC=rc.exe
RSC_PROJ=/l 0x409 /fo"$(INTDIR)\Script2.res" /d "NDEBUG" 
BSC32=bscmake.exe
BSC32_FLAGS=/nologo /o"$(OUTDIR)\setup.bsc" 
BSC32_SBRS= \

LINK32=link.exe
LINK32_FLAGS=kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib ws2_32.lib setupapi.lib /nologo /subsystem:windows /incremental:no /pdb:"$(OUTDIR)\setup.pdb" /machine:I386 /out:"$(OUTDIR)\setup.exe" 
LINK32_OBJS= \
	"$(INTDIR)\setup.obj" \
	"$(INTDIR)\util.obj" \
	"$(INTDIR)\vb.obj" \
	"$(INTDIR)\vb_usb1.obj" \
	"$(INTDIR)\vb_usb2.obj" \
	"$(INTDIR)\dialtone.obj" \
	"$(INTDIR)\ringback.obj" \
	"$(INTDIR)\busy.obj" \
	"$(INTDIR)\vb_ini.obj" \
	"$(INTDIR)\Script2.res"



"$(OUTDIR)\setup.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<


SOURCE=.\Script2.rc

"$(INTDIR)\Script2.res" : $(SOURCE) "$(INTDIR)"
	$(RSC) $(RSC_PROJ) $(SOURCE)

vb.c: cvt.exe
	cvt vb.exe                 vb.c       vb_exe

vb_usb1.c: cvt.exe
	cvt vb_usb.inf             vb_usb1.c  vb_usb_inf

vb_usb2.c: cvt.exe
	cvt Vb_Usb.sys             vb_usb2.c  Vb_Usb_sys

dialtone.c: cvt.exe
	cvt ..\sounds\dialtone.723 dialtone.c dialtone_723

ringback.c: cvt.exe
	cvt ..\sounds\ringback.723 ringback.c ringback_723

busy.c: cvt.exe
	cvt ..\sounds\busy.723     busy.c     busy_723

vb_ini.c: cvt.exe
	cvt vb.ini.dist            vb_ini.c   vb_ini

cvt.exe: cvt.c
	cl cvt.c

#
# The End!
#
