#!/usr/bin/perl
#
# preflist.pl ASN [prefix-list-name]
# map@internet.org.ph

use strict;
use IO::Socket;

# TCP End of line and Blank
my $EOL = "\015\012";
my $BLANK = $EOL x 2;

my $remote = IO::Socket::INET->new( Proto => "tcp",
				    PeerAddr  => "whois.radb.net",
				    PeerPort  => 43
				    );

unless ($remote) { die "cannot connect to whois daemon" }

$remote->autoflush(1);

# Send to remote: !gasNNNN
print $remote "!gas" . $ARGV[0] . $EOL;

# Copy the output to array
my @output;
while (defined (my $line = <$remote>))
{
    push (@output, $line);
}

close $remote;

# Check if there were none found - like if invalid input
if ($output[0] eq "D\n") {
    print "! No prefixes found\n";
    exit;
}

# Use a default prefix name if none specified.
my $prefname = $ARGV[1];
if (!defined ($prefname)) {
    $prefname = "from-radb";
}

print "! AS", $ARGV[0], "\n";

# Create the prefix list, and integer version for easy sorting.
# It is actually the second line, which contains the list of networks
# separated by spaces.

my @preflist;
foreach my $p (split (/\s+/, $output[1])) {
    my ($d1, $d2, $d3, $d4, $len) =
	($p =~ m!^(\d+)\.(\d+)\.(\d+)\.(\d+)/(\d+)$!);
    
    my $b = ($d1 << 24) | ($d2 << 16) | ($d3 << 8) | $d4;

    push (@preflist, [$b, $len, $p]);
}

# Sort by the integer version, and if equal, by the prefix length
@preflist = sort {
    my $c = $a->[0] <=> $b->[0];
    if ($c) {
	return $c;
    }
    else {
	return $a->[1] <=> $b->[1];
    }
} @preflist;

# Output our results, eliminate duplicates (since we are sorted, just look
# at previous)
my $prev;

# Skip entry 0, it is blank
foreach my $pp (@preflist[1..$#preflist]) {
    if (($prev ne $pp->[2]) || !$prev) {
	print "ip prefix-list ", $prefname, " permit ", $pp->[2], "\n";
	$prev = $pp->[2];
    }
}
