#!/usr/bin/perl
#
# perl script to look at all interfaces and list their indexes
#
# william.s.yu@ieee.org
#

use strict;
use Net::SNMP::Interfaces;

my @router;
$router[1]="202.61.95.243";
$router[2]="202.61.95.254";
$router[3]="203.176.28.19";
$router[0]="203.176.75.254";

my %interfaces;
$interfaces{"202.61.95.243"}[0] = "Serial4/2.1";
$interfaces{"202.61.95.254"}[0] = "Serial1/2";
$interfaces{"202.61.95.254"}[1] = "Serial2/0.1";
$interfaces{"203.176.28.19"}[0] = "Serial2/0";
$interfaces{"203.176.28.19"}[1] = "Serial2/1";
$interfaces{"203.176.75.254"}[0] = "Serial0/2";

my %community;
$community{"202.61.95.243"} = "idotnet";
$community{"202.61.95.254"} = "idotnet";
$community{"203.176.28.19"} = "idotnet";
$community{"203.176.75.254"} = "idotnet";

my %intstring;

foreach my $element (@router) {
my $router_ints = Net::SNMP::Interfaces->new(Hostname => $element,
                      Community => $community{$element} );
  $intstring{$element} = '';
  for my $i (0 .. $#{ $interfaces{$element} } ) {
    my $element2 = $interfaces{$element}[$i];
    my $router_int = $router_ints->interface($element2);
    if ($i != 0){
       $intstring{$element} .= ',';
    }
    $intstring{$element} .= $router_int->index;
    delete $interfaces{$element}[$i];
  }
  print "> " . $intstring{$element} . "\n";
}
