#!/usr/bin/perl
#
# perl script to look at all interfaces and list their indexes
#
# william.s.yu@ieee.org
#

use strict;
use Getopt::Std;

# configuration data that must be defined
my $flowbindir = "/usr/local/netflow/bin";
my $descfile = "/data/clients/client6.conf";
my $flowdir = "/data";
my @router;
$router[1]="202.61.95.243";
$router[2]="202.61.95.254";
$router[3]="203.176.28.19";
$router[0]="203.176.75.254";

my %opts = ();
getopts('i:c:d:h:s', \%opts);
die "Usage: flow-usage.pl [-c client] [-i ipaddress/prefix] -d [YYYY-MM-DD] -h [HH] [-s]"
    unless exists($opts{d}) && exists($opts{h});

my $flowstring = "ft-v05.$opts{d}.$opts{h}";
my $cmdstring = "$flowbindir/flow-cat ";
foreach my $element (@router) {
  $cmdstring .= "$flowdir/$element/$flowstring* ";
}

if ($opts{i} ne '') {
  $cmdstring .= "| $flowbindir/flow-cidr -i $opts{i}"; 
} else {
  $cmdstring .= "| $flowbindir/flow-cidr -f $descfile -D $opts{c}";
}

if ($opts{s}==1) {
  $cmdstring .= "| $flowbindir/flow-stat -f15";
} else {
  $cmdstring .= "| $flowbindir/flow-print -f3";
}

system("$cmdstring\n");

