/*
 * Copyright (c) 2001 Mark Fullmer and The Ohio State University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      $Id: support.h,v 1.13 2001/07/17 05:51:05 maf Exp $
 */

#ifndef SUPPORT_H
#define SUPPORT_H


#if HAVE_CONFIG_H
 #include <config.h>
#endif

#include <time.h>

#include "bytes.h"

struct ftpeeri {
  u_int32 loc_ip;        /* local ip address */
  u_int32 rem_ip;        /* remote ip address */
  u_int16 dst_port;      /* destination port */
  u_int8  ttl;           /* ttl */
};

void print_3float(float f);
void print_3float2(float f);
int load_lookup(char *s, int size, char *list);
u_long scan_ip(char *s);
int sort_64uint64(u_int64 *a, u_int *index, u_int elem);
int64 scan_size(char *val);

int unlink_pidfile(int pid, char *file, u_int16 port);
int write_pidfile(int pid, char *file, u_int16 port);

struct ftpeeri scan_peeri(char *input);

#ifdef POSIX_SIGNALS
#define signal mysignal
void *mysignal(int signo, void *func);
#endif /* POSIX_SIGNALS */

int get_gmtoff(time_t t);

u_int32 ipv4_len2mask(u_int8 len);

int bigsockbuf(int fd, int dir, int size);

#endif /* SUPPORT_H */
