/*
 * Copyright (c) 2001 Mark Fullmer and The Ohio State University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      $Id: fmt.h,v 1.9 2001/07/17 05:51:05 maf Exp $
 */

#ifndef FMT_H
#define FMT_H

#if HAVE_CONFIG_H
 #include <config.h>
#endif

#include "bytes.h"
#include "ftlib.h"

#define FMT_UINT64  21      /* 18446744073709551615 + \0 */
#define FMT_UINT32  11      /* 4294967295 + \0 */
#define FMT_UINT16  6       /* 65535 + \0 */
#define FMT_UINT8   4       /* 256 + \0 */
#define FMT_IPV4  16        /* 111.111.111.111 + \0 */
#define FMT_IPV4_PREFIX 19  /* 111.111.111.111/32 + \0 */

#define FMT_PAD_LEFT    0
#define FMT_PAD_RIGHT   1
#define FMT_JUST_LEFT   2
#define FMT_JUST_RIGHT  FMT_PAD_LEFT

unsigned int fmt_uint8(register char *s, register u_int8 u, int format);
unsigned int fmt_uint16(register char *s, register u_int16 u, int format);
unsigned int fmt_uint32(register char *s, register u_int32 u, int format);
unsigned int fmt_uint64(register char *s, register u_int64 u, int format);
unsigned int fmt_ipv4(register char *s, register u_int32 u, int format);
unsigned int fmt_ipv4prefix(register char *s, register u_int32 u,
  u_char mask, int format);

unsigned int fmt_uint16s(struct ftsym *ftsym, int max, char *s, u_int16 u,
  int format);


unsigned int fmt_ipv4();

/* MACHINE DEPENDANT */
#define fmt_uint fmt_uint32

#endif /* FMT_H */
