#include "bytes.h"
#include "sym.h"
#include "fmt.h"

/*
/* retrieve symbol s
/* return 1 for yes, 0 for no
/* if it exists, val is its value
*/
sym_getname(table, s, val)
struct sym_table *table;
char *s;
u_int16 *val;
{

  u_int x;

  for (x = 0; table && (table[x].val || table[x].name); ++x) {
    if (!strcmp(s, table[x].name)) {
      *val = table[x].val;
      return 1;
    }
  }

  return 0;

} /* sym_getname */

/*
/* reverse lookup of value val 
/* to symbol. 
/* return 1 of value matched a symbol
/* 0 if not.
*/
sym_getval(table, s, val)
struct sym_table *table;
char **s;
u_int16 val;
{
  u_int x;

  for (x = 0; table && (table[x].val || table[x].name); ++x) {
    if (table[x].val == val) {
      *s = table[x].name;
      return 1;
    }
  }

  return 0;

} /* sym_getval */

/*
/* lookup the value val, and return a printable string.
/* if val is not in the table, then return it as the string
*/
char *sym_pr_uint16(table, val, fmt, opt)
struct sym_table *table;
u_int16 val;
int fmt, opt;
{
  static char s2[SYM_MAXLEN];
  int ret;
  char *s1;

  if (opt & OPT_NAMES) 
    ret = sym_getval(table, &s1, val);
  else
    goto skip1;

  /* if the symbol was found, return it as (sym) */
  if (ret) {
    ret = strlen(s1);
/*    s2[0] = '('; s2[ret+1] = ')'; s2[ret+2] = 0; 
    bcopy(s1, s2+1, ret); */
    bcopy(s1, s2, ret);
    s2[ret] = 0;
  } else /* return it as just the number */
skip1:
    fmt_uint32(s2, (u_int32)val, fmt);
    
  return s2;
} /* sym_pr_uint16 */

struct sym_table sym_ipprot[] = {

  "eigrp",  88, /* XXX ??? */
  "gre",    47,
  "icmp",   1,
  "igmp",   2,
  "igrp",   88,
  "ip",   0,  /* special case */
  "ipinip", 94,
  "nos",    0,  /* XXX ??? */
  "ospf",   89,
  "tcp",    6,
  "udp",    17,
  (char*)0L,  0,
};

struct sym_table sym_tcp[] = {

  "bgp",    179,
  "chargen",  19,
  "cmd",    514,
  "daytime",  13,
  "discard",  9,
  "domain", 53,
  "echo",   7,
  "exec",   512,
  "finger", 79,
  "ftp",    21,
  "ftp-data", 20,
  "gopher", 70,
  "hostname", 101,
  "ident",  113,
  "irc",    194,
  "klogin", 543,
  "kshell", 544,
  "login",  513,
  "lpd",    515,
  "nntp",   119,
  "pop2",   109,
  "pop3",   110,
  "smtp",   25,
  "sunrpc", 111,
  "syslog", 514,
  "tacacs", 49,
  "talk",   517,
  "telnet", 23,
  "time",   37,
  "uucp",   540,
  "whois",  43,
  "www",    80,
  (char*)0L,  0,
};

struct sym_table sym_igmp[] = {

  "dvmrp",    0,
  "host-query", 0,
  "host-report",  0,
  "log",      0,
  "pim",      0,
  "trace",    0,
  (char*)0L,    0,
};

struct sym_table sym_icmp[] = {

  "administratively-prohibited",  0,
  "alternate-address",      0,
  "conversion-error",       0,
  "dod-host-prohibited",      0,
  "dod-net-prohibited",     0,
  "echo",             0,
  "echo-reply",         0,
  "general-parameter-problem",  0,
  "host-isolated",        0,
  "host-precedence-unreachable",  0,
  "host-redirect",        0,
  "host-tos-redirect",      0,
  "host-tos-unreachable",     0,
  "host-unknown",         0,
  "host-unreachable",       0,
  "information-reply",      0,
  "information-request",      0,
  "log",              0,
  "mask-reply",         0,
  "mask-request",         0,
  "mobile-redirect",        0,
  "net-redirect",         0,
  "net-tos-redirect",       0,
  "net-tos-unreachable",      0,
  "net-unreachable",        0,
  "network-unknown",        0,
  "no-room-for-option",     0,
  "option-missing",       0,
  "packet-too-big",       0,
  "parameter-problem",      0,
  "port-unreachable",       0,
  "precedence-unreachable",   0,
  "protocol-unreachable",     0,
  "reassembly-timeout",     0,
  "redirect",           0,
  "router-advertisement",     0,
  "router-solicitation",      0,
  "source-quench",        0,
  "source-route-failed",      0,
  "time-exceeded",        0,
  "timestamp-reply",        0,
  "timestamp-request",      0,
  "traceroute",         0,
  "ttl-exceeded",         0,
  "unreachable",          0,
  (char*)0L,            0,
};

