#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <fcntl.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include <signal.h>
#include "bytes.h"
#include "flow.h"

/* max stack size for sorting */
#define SORT_STACK  65536*2

/*
/* function: load_lookup
/*
/*  loads a list of , seperated numbers into an array
/*  ! will invert the list
/*  - can be used as a range operator
/*
/*  example
/*   1,5-10   == 1,5,6,7,8,9,10
/*   !1       == all numbers in the range except for 1
*/
int load_lookup(s, size, list)
char *s;
int size;
char *list;
{
  char *p;
  int j, k;
  unsigned i, i2;

  p = s;

  while ((*p == ' ') || (*p == '\t')) ++p;
  if (*p == '!') {
    for (k = 0; k < size; ++k)
      list[k] = 1;
    k = 0;
    ++p;
  } else {
    for (k = 0; k < size; ++k)
      list[k] = 0;
    k = 1;
  }

  while (*p) {

    sscanf(p, "%u", (unsigned*)&i);
    if (i > size) return -1;
    list[i] = k;

    /* skip to , or - */
    while (*p && (*p != ',') && (*p != '-')) ++p;

    if (*p == '-') {

      ++p;
      sscanf(p, "%u", (unsigned*)&i2);
      if (i2 > size) return -1;
      for (j = i; j <= i2; ++j) list[j] = k;

      /* skip to , or - */
      while (*p && (*p != ',') && (*p != '-')) ++p;
    }

    /* skip past , and - */
    while (*p && ((*p == ',') || (*p == '-'))) ++p;

  } /* *p */

  return 0;

} /* load_lookup */


/*
/* function: scan_ip
/*
/*  IP address in string S is converted to a u_long
/*  (borrowed from tcpdump)
/*
*/
u_long scan_ip(s)
char *s;
{
  u_long addr = 0;
  u_int n;

  while (1) {

    /* n is the nibble */
    n = 0;

    /* nibble's are . bounded */
    while (*s && (*s != '.') && (*s != ' ') && (*s != '\t'))
      n = n * 10 + *s++ - '0';

    /* shift in the nibble */
    addr <<=8;
    addr |= n & 0xff;

    /* return on end of string */
    if ((!*s) || (*s == ' ') || (*s == '\t'))
      return addr;

    /* skip the . */
    ++s;
  } /* forever */
} /* scan_ip */


/*
/* function: print_3float
/*
/*  format a floating point # to stdout w. 1 trailing space
/*
*/
void print_3float(f)
float f;
{

  char s[10], *c;
  sprintf(s, "%-3.3f", f);
  c = s + 1;
  printf("%s ", c);

} /* print_3float */

/*
/* function: print_3float2
/*
/*  format a floating point # to stdout w. 2 trailing spaces
/*
*/
void print_3float2(f)
float f;
{

  char s[10], *c;
  sprintf(s, "%-3.3f", f);
  c = s + 1;
  printf("%s  ", c);

} /* print_3float */

/*
/*  function sort_64uint64
/*
/*  a   an array of up to 65536 u_int64's
/*  index an array of up to 65536 indexes
/*  elem  # of elements in a and index
/*
/*  uses quicker sort to arrange the index by comparing
/*  the values the index points to in a.
/*
*/
int sort_64uint64(a, index, elem)
u_int *index, elem;
u_int64 *a;
{
  long i, l, r, j;
  u_int stack[SORT_STACK];
  u_int sp;
  u_int t;
  u_int64 v;

  l = 0;
  r = elem - 1;
  sp = SORT_STACK;

  for (;;) {

    while (r > l) {

      /* partition */
      v = a[index[r]];
      i = l-1;
      j = r;

      for (;;) {
        while (a[index[++i]] < v);
        while (a[index[--j]] > v);
        if (i >= j) break;
        t = index[i]; index[i] = index[j]; index[j] = t;
      }

      t = index[i]; index[i] = index[r]; index[r] = t;

      if (i-l > r-i) {
        stack[--sp] = l;
        stack[--sp] = i-1;
        l = i+1;
      } else {
        stack[--sp] = i+1;
        stack[--sp] = r;
        r = i-1;
      }
    } /* while */

    if (sp == SORT_STACK)
      break;

    if (!sp) {
      fprintf(stderr, "sort_64uint64(): stack overflow\n");
      exit (1);
    }

    r = stack[sp++];
    l = stack[sp++];

  } /* for */

  return 0;

} /* sort_64uint64 */


/* adapted from dd */

int64 scan_size(val)
char *val;
{
  u_int64 num, t;
  char *expr;

  if ((num = strtoul(val, &expr, 0)) == ULONG_MAX)
    goto erange;

  switch(*expr) {

    case 0:
      break;

    case 'b':
      t = num;
      num *= 512;
      if (t > num)
        goto erange;
      break;
    case 'G':
      t = num;
      num *= 1024;
      num *= 1024;
      num *= 1024;
      if (t > num)
        goto erange;
      break;
    case 'K':
      t = num;
      num *= 1024;
      if (t > num)
        goto erange;
      break;
    case 'M':
      t = num;
      num *= 1024;
      num *= 1024;
      if (t > num)
        goto erange;
      break;
    default:
      goto erange;
  }

  return num;

erange: 

  return (int64)-1;

} /* scan_size */

#ifdef POSIX_SIGNALS

/*********************************************************************/
/* Function: mysignal()
/*  POSIX style signals.
/*
/*  signal() has different semantics over different versions of unix.
/*  this emulates signal() with sigaction() to behave like BSD.
/*
/* From Stevens Advanced Programming in the UNIX environment */
/*
/*********************************************************************/
void *mysignal(signo, func)
  int signo;
  void *func;

{
  struct sigaction act, oact;
  
  act.sa_handler = (void*)func;
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;

  if (signo == SIGALRM) {
#ifdef  SA_INTERRUPT
  act.sa_flags |= SA_INTERRUPT; /* SunOS */
#endif
  } else {
#ifdef SA_RESTART
  act.sa_flags |= SA_RESTART; /* SVR4, 4.3+BSD */
#endif
  }

  if (sigaction(signo, &act, &oact) < 0)
    return SIG_ERR;

  return oact.sa_handler;
} /* signal */

#endif /* POSIX_SIGNALS */

