#include <sys/types.h>
#include "bytes.h"

int hash_ip_sinit();
int hash_ip_sdump();

#define HASH_IP_S_STAT 

struct hash_ip_s_addr {

  u_short seg;    /* segment pointer */
  u_short off;    /* offset */
#ifdef HASH_IP_S_STAT
  u_long  hits;
#endif /* HASH_IP_S_STAT */
};

struct hash_ip_s_rec {

  u_int32 addr;       /* ip address */
  int32 index;        /* index into the name table */

  struct hash_ip_s_addr next; /* next record */
};


struct hash_ip_s_table {
  struct hash_ip_s_addr head;   /* head pointer to free records */
  struct hash_ip_s_addr *table; /* lookup table */
  char **data;                  /* hash data */
  u_short lastoff;              /* last offset before need new allocation */
};

  
/* add a record to the table, or update the current record */
int hash_ip_s_update();

/* free storage */
int hash_ip_s_free();

/* lookup next key */
int hash_ip_s_next();

/* display histogram if hash table */
int hash_ip_s_hist();

