#include <sys/types.h>
#include "bytes.h"

int hash_ip2_init();
int hash_ip2_dump();

#define HASH_IP2_STAT 

struct hash_ip2_addr {

  u_short seg;    /* segment pointer */
  u_short off;    /* offset */
#ifdef HASH_IP2_STAT
  u_long  hits;
#endif /* HASH_IP2_STAT */
};

struct hash_ip2_rec {

  u_int32 src_addr;     /* ip source address */
  u_int32 dst_addr;     /* ip source address */
  u_int64 nflows;       /* # of flows */
  u_int64 noctets;      /* # of octets */
  u_int64 npackets;     /* # of packets */
  u_int64 etime;        /* elapsed time */

  struct hash_ip2_addr next;  /* next record */
};


struct hash_ip2_table {
  struct hash_ip2_addr  head;   /* head pointer to free records */
  struct hash_ip2_addr  *table; /* lookup table */
  char **data;                  /* hash data */
  u_short lastoff;              /* last offset before need new allocation */
};

  
/* add a record to the table, or update the current record */
int hash_ip2_update();

/* free storage */
int hash_ip2_free();

/* lookup next key */
int hash_ip2_next();

/* display histogram if hash table */
int hash_ip2_hist();

