#include "fmt.h"

unsigned int fmt_uint16(s, u, format)
register char *s;
register u_int16 u;
int format;
{

  register int len = 0;
  char *s1;
  int i;

  if (!s)
    return 0;

  s1 = s;

  s += FMT_UINT16 - 1;
  do {

    ++len;
    *--s = '0' + (u % 10);
    u /= 10;

  } while(u); 

  if ((format == FMT_PAD_RIGHT) || (format == FMT_JUST_LEFT)) {
    bcopy(s, s1, len);
    if (format == FMT_PAD_RIGHT)
      for (; len < (FMT_UINT16 - 1); ++len)
        s1[len] = ' ';
    s1[len] = 0;
    return len;
  }
} /* fmt_uint16 */

unsigned int fmt_uint32(s, u, format)
register char *s;
register u_int32 u;
int format;
{

  register int len = 0;
  char *s1;
  int i;

  if (!s)
    return 0;

  s1 = s;

  s += FMT_UINT32 - 1;
  do {

    ++len;
    *--s = '0' + (u % 10);
    u /= 10;

  } while(u); 

  if ((format == FMT_PAD_RIGHT) || (format == FMT_JUST_LEFT)) {
    bcopy(s, s1, len);
    if (format == FMT_PAD_RIGHT)
      for (; len < (FMT_UINT32 - 1); ++len)
        s1[len] = ' ';
    s1[len] = 0;
    return len;
  }

  if (format == FMT_PAD_LEFT) {
    for (i = 0; i < ((FMT_UINT32 - 1) - len); ++i)
      s1[i] = ' ';
    s1[(FMT_UINT32 - 1)] = 0;
    return (FMT_UINT32 - 1);
  }

  return 0;

} /* fmt_uint32 */

unsigned int fmt_uint64(s, u, format)
register char *s;
register u_int64 u;
int format;
{

  register int len = 0;
  char *s1;
  int i;

  if (!s)
    return 0;

  s1 = s;

  s += FMT_UINT64 - 1;

  do {

    ++len;
    *--s = '0' + (u % 10);
    u /= 10;

  } while(u); 

  if ((format == FMT_PAD_RIGHT) || (format == FMT_JUST_LEFT)) {
    bcopy(s, s1, len);
    if (format == FMT_PAD_RIGHT)
      for (; len < (FMT_UINT64 - 1); ++len)
        s1[len] = ' ';
    s1[len] = 0;
    return len;
  }

  if (format == FMT_PAD_LEFT) {
    for (i = 0; i < ((FMT_UINT64 - 1) - len); ++i)
      s1[i] = ' ';
    s1[(FMT_UINT64 - 1)] = 0;
    return (FMT_UINT64 - 1);
  }

  return 0;

} /* fmt_uint64 */

unsigned int fmt_ipv4(s, u, format)
register char *s;
register u_int32 u;
int format;
{

  register int len = 0;
  char *s1;
  int i, j;
  u_int8 e[4];
  char c[4][4];

  if (!s)
    return 0;

  j = 0;

  e[0] = (u & 0xFF000000)>>24;
  e[1] = (u & 0x00FF0000)>>16;
  e[2] = (u & 0x0000FF00)>>8;
  e[3] = (u & 0x000000FF);

  for (i = 0; i < 4; ++i) {
    s1 = &c[i][3];
    len = 0;
    do {
      ++len;
      *--s1 = '0' + (e[i] % 10);
      e[i] /= 10;
    } while(e[i]); 

    bcopy(s1, s+j, len);
    j += len;
    *(s+j) = '.';
    ++j;
  }

  --j;
  s[j] = 0;

  if (format == FMT_JUST_LEFT)
    return j;

  if (format == FMT_PAD_RIGHT) {
    for (; j < (FMT_IPV4-1); ++j)
      s[j] = ' ';
    s[j] = 0;
    return (FMT_IPV4-1);
  }

  if (format == FMT_JUST_RIGHT) {
    bcopy(s, s+(FMT_IPV4-1)-j, j);
    for (i = 0; i < (FMT_IPV4-1)-j; ++i)
      s[i] = ' ';
    s[FMT_IPV4-1] = 0;
    return (FMT_IPV4-1);
  }

  return j;

} /* fmt_ipv4 */

