#include <stdio.h>
#include <stdlib.h>
#include <zlib.h>
#include "bytes.h"
#include "flow.h"

/*
/* output 1000 flows for testing
*/

main(argc, argv)
int argc;
char **argv;
{

  struct flow_header fh;
  struct flow_data fdata;
  struct flow_stream fs;
  int i, x, out_byte_order, z_level;
  extern char *optarg;
  extern int errno;

  bzero(&fh, sizeof fh);
  bzero(&fs, sizeof fs);
  bzero(&fdata, sizeof fdata);
  z_level = 0;
  fh.d_version = FF_D_VERSION_UNKNOWN;

#if BYTE_ORDER == BIG_ENDIAN
  out_byte_order = BIG_ENDIAN;
#endif /* BYTE_ORDER == BIG_ENDIAN */
#if BYTE_ORDER == LITTLE_ENDIAN
  out_byte_order = LITTLE_ENDIAN;
#endif /* BYTE_ORDER == LITTLE_ENDIAN */

#if BYTE_ORDER == LITTLE_ENDIAN
  fh.byte_order = FF_LITTLE_ENDIAN;
#endif /* BYTE_ORDER == LITTLE_ENDIAN */

#if BYTE_ORDER == BIG_ENDIAN
  fh.byte_order = FF_BIG_ENDIAN;
#endif /* BYTE_ORDER == BIG_ENDIAN */

   while ((i = getopt(argc, argv, "b:V:z:")) != -1)

    switch(i) {

    case 'b': /* output byte order */
      if (!strcasecmp(optarg, "little"))
        out_byte_order = LITTLE_ENDIAN;
      else if (!strcasecmp(optarg, "big"))
        out_byte_order = BIG_ENDIAN;
      else {
        fprintf(stderr, "expecting \"big\" or \"little\" at -b\n");
        exit (1);
      }
      break;

    case 'V': /* output flow version */
      fh.d_version = atoi(optarg);
      break;

    case 'z': /* compress level */
      z_level = atoi(optarg);
      if ((z_level < 0) || (z_level > 9)) {
        fprintf(stderr, "Compression level must be between 0 and 9\n");
        exit (1);
      }
      break;

    default:
      usage();
      exit (1);

    } /* switch */

  /* set compression level in output stream */
  if (z_level != Z_NO_COMPRESSION) {
    fs.flags = FS_FLAG_COMPRESS;
    fs.z_level = z_level;
    fh.flags = FF_FLAG_COMPRESS;
  } else
    fs.flags = 0;

  fh.magic1 = FF_MAGIC1;
  fh.magic2 = FF_MAGIC2;

  fh.s_version = FSTREAM_VERSION;

#if BYTE_ORDER == BIG_ENDIAN
  if (out_byte_order == LITTLE_ENDIAN)
    swap_flow_header(&fh);
#endif /* BYTE_ORDER == LITTLE_ENDIAN */

#if BYTE_ORDER == LITTLE_ENDIAN
  if (out_byte_order == BIG_ENDIAN)
    swap_flow_header(&fh);
#endif /* BYTE_ORDER == LITTLE_ENDIAN */


  if ((writen(1, &fh, sizeof fh)) == -1) {
    fprintf(stderr, "writen(): %s\n", strerror(errno));
    exit (1);
  }

  fs.fd = 1;

  for (x = 0; x < 1000; ++x) {

    fdata.unix_secs = x;

    fdata.srcaddr = 0x0a000000 + x;
    fdata.dstaddr = 0x0a010200 + x;

    fdata.src_as = x;
    fdata.dst_as = x + 2000;

#if BYTE_ORDER == BIG_ENDIAN
    if (out_byte_order == LITTLE_ENDIAN)
      swap_flow_data(&fdata);
#endif /* BYTE_ORDER == LITTLE_ENDIAN */

#if BYTE_ORDER == LITTLE_ENDIAN
    if (out_byte_order == BIG_ENDIAN)
      swap_flow_header(&fh);
#endif /* BYTE_ORDER == LITTLE_ENDIAN */

    if (flow_write(&fdata, &fs) == -1) {
      fprintf(stderr, "flow_write(): failed\n");
      exit (1);
    }
  }

  if (flow_flush(&fs) == -1) {
    fprintf(stderr, "flow_flush(): failed.\n");
    exit (1);
  }

  flow_write_end(&fs);

} /* main */


usage() {}  
