#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/uio.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <sys/time.h>
#include "flow.h"
#include "support.h"

int debug;

void usage();

struct peer {
  int fd;
  struct sockaddr_in addr;
  int port;
};

int main(argc, argv)
int argc;
char **argv;
{
  extern char *optarg;
  extern int errno, optind;
  fd_set rfd;
  struct sockaddr_in fsocaddr;
  int fsockfd;
  struct timeval timout;
  int fport, i, len, n, p;
  int npeers, tx_delay;
  struct peer *peers;
  char tmp_buf[256];
  char rcv_buf[FLOW_RECV_BUFSIZE];
  char *c;
  u_long ip;

  fport = FLOWPORT;
  debug = 0;
  tx_delay = 0;

  while ((i = getopt(argc, argv, "d:p:x:")) != -1)
    switch (i) {

    case 'd': /* debug */
      debug = atoi(optarg);
      break;

    case 'p': /* flow Port */
      fport = atoi(optarg);
      break;

    case 'x': /* transmit delay */
      tx_delay = atoi(optarg);
      break;

    default:
      usage();
      exit (1);
      break;

    } /* switch */

  /* allocate argc - optind peer entries */
  npeers = argc - optind;

  if (!(peers = (struct peer*)malloc(npeers * sizeof (struct peer)))) {
    fprintf(stderr, "malloc(): failed.\n");
    exit (1);
  }

  /* zero out malloc'd memory */
  bzero(peers, npeers*sizeof(struct peer));

  /* fill in peer entries */
  for (i = optind, n = 0; i < argc; ++i, ++n) {

    if (strlen(argv[i]) > 255) {
      fprintf(stderr, "ouch!\n");
      exit (1);
    }

    strcpy(tmp_buf, argv[i]);

    /* skip to end or port seperator */
    for (c = tmp_buf; (*c != '/') && (*c); ++c);

    /* extract the port part */
    if (*c == '/') {
      *c = 0;
      ++c;
      peers[n].addr.sin_port = atoi(c);
    } else 
      peers[n].addr.sin_port = FLOWPORT;

    /* extract the ip address part */
    peers[n].addr.sin_addr.s_addr = scan_ip(tmp_buf);

    peers[n].addr.sin_family = AF_INET;

    if ((peers[n].fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
      fprintf(stderr, "socket(): %s\n", strerror(errno));
      exit (1);
    }
  }

  /* setup to receive flows */
  bzero(&fsocaddr, sizeof(fsocaddr));
  fsocaddr.sin_family = AF_INET;
  fsocaddr.sin_addr.s_addr = htonl(INADDR_ANY);
  fsocaddr.sin_port = htons(fport);

  if ((fsockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
    fprintf(stderr, "socket(): %s\n", strerror(errno));
    exit(1);
  }

  if (bind(fsockfd, (struct sockaddr*)&fsocaddr, sizeof(fsocaddr)) < 0) {
    fprintf(stderr, "bind(): %s\n", strerror(errno));
    exit (1);
  }

  len = sizeof(fsocaddr);

  while (1) {

    FD_ZERO (&rfd);
    FD_SET (fsockfd, &rfd);
    timout.tv_usec = 0;
    timout.tv_sec = 1;

    if (select (fsockfd+1, &rfd, (fd_set *)0, (fd_set *)0, &timout) < 0)  {
      fprintf(stderr, "select(): %s\n", strerror(errno));
      exit (1);
    }

    if (FD_ISSET(fsockfd, &rfd)) {

      if ((n = recvfrom(fsockfd, &rcv_buf, sizeof rcv_buf, 0,
        (struct sockaddr*) &fsocaddr, &len)) == -1) {
        fprintf(stderr, "recvfrom(): %s\n", strerror(errno));
        exit (1);
      }

      for (i = 0; i < npeers; ++i) {

        sendto(peers[i].fd, &rcv_buf, n, 0, (struct sockaddr*)&peers[i].addr,
          sizeof (struct sockaddr_in));

        if (tx_delay)
          usleep((unsigned)tx_delay);

      }

    } /* if FD_ISSET */

  } /* while 1 */
} /* main */

void usage() {

  fprintf(stderr, "flow fanout:\n\n");
  fprintf(stderr, " -d #  set debug level.\n");
  fprintf(stderr, " -p #  UDP port to accept flows on.\n");
  fprintf(stderr, " -x #  transmit delay in microseconds.\n");
  fprintf(stderr, " A.B.C.D/port  A.B.C.D/port ...\n");
  fprintf(stderr, "\n\n");

} /* usage */

