#include <sys/time.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <fcntl.h>
#include "sym.h"
#include "flow.h"
#include "pcap.h"

int debug;
int ip_net_only;

int flow_export0();

struct jump flow_export[] = {{flow_export0},};

void usage();

#define FLOW_EXPORT_FORMATS 1 /* # of types of output + 1 */

int main(argc, argv)
int argc;
char **argv;
{

  int i, format, ret;
  extern char *optarg;
  extern struct jump flow_export[];
  struct flow_stream fs;
  struct flow_profile fp;
  int options;
  u_int64 total_flows;

  options = 0;

  /* profile */
  if (profile_start (&fp) == -1) {
    fprintf(stderr, "profile_start(): failed\n");
    exit (1);
  }

  format = 0;
  bzero (&fs, sizeof fs);

  while ((i = getopt(argc, argv, "h?d:f:l")) != -1)
    switch (i) {

    case 'd': /* debug */
      debug = atoi(optarg);
      break;

    case 'f': /* format */
      format = atoi(optarg);
      break;

    case 'h': /* help */
    case '?':
      usage();
      exit (0);
      break;

    case 'l': /* turn off buffered output */
      options |= OPT_NOBUF;
      break;

    default:
      usage();
      exit (1);
      break;

    } /* switch */

  if (format >= FLOW_EXPORT_FORMATS) {
    fprintf(stderr, "no such format, %d\n", format);
    exit (1);
  }

  /* read from stdin */
  fs.fd = 0;

  if (flow_read_header(&fs) == -1) {
    fprintf(stderr, "flow_read_header(): failed.\n");
    exit (1);
  }

  ret = flow_export[format].where(&fs, &total_flows, options);

  fp.nflows = total_flows;

  if ((!ret) && (debug > 0))
    if (profile_end(argv[0], &fp) == -1) {
      fprintf(stderr, "profile_end(): failed\n");
      exit (1);
    }

  return ret;

} /* main */

void usage() {

  fprintf(stderr, "flow-export:\n\n");
  fprintf(stderr, " -d # set debug level.\n");
  fprintf(stderr, " -f # format\n");
  fprintf(stderr, "    0 pcap (tcpdump)\n");
  fprintf(stderr, " -l no buffered output\n");
  fprintf(stderr, "\n\n");

} /* usage */

/*
/* function flow_export0
/*
/* export flows in pcap format
*/
flow_export0(fs, total_flows, options)
struct flow_stream *fs;
u_int64 *total_flows;
int options;
{

  struct flow_data *fdata;
  u_int64 nflows;
  struct pcap_file_header pfh;
  struct pcap_packet_header pph;
  struct pcap_data1 pd1;
  struct pcap_data2 pd2;
  struct pcap_data3 pd3;
  struct pcap_data4 pd4;
  int n, vec_len, good;
  struct timeval now;
  struct timezone tz;
  long thiszone;
  struct iovec vec[4];

  if (gettimeofday(&now, &tz) < 0) {
    fprintf(stderr, "gettimeofday() failed\n");
    return -1;
  }

  bzero(&pfh, sizeof pfh);
  bzero(&pph, sizeof pph);
  bzero(&pd1, sizeof pd1);
  bzero(&pd2, sizeof pd2);
  bzero(&pd3, sizeof pd3);
  bzero(&pd4, sizeof pd4);

  thiszone = tz.tz_minuteswest * -60;

  if (localtime((time_t *)&now.tv_sec)->tm_isdst)
    thiszone += 3600;

  pfh.magic = TCPDUMP_MAGIC;  
  pfh.version_major = TCPDUMP_VERSION_MAJOR;
  pfh.version_minor = TCPDUMP_VERSION_MINOR;
  pfh.thiszone = thiszone;
  pfh.sigfigs = 6;
  pfh.snaplen = 58; /* XXX TODO */
  pfh.linktype = 1;
  

  if (writen(1, &pfh, sizeof pfh) != sizeof pfh) {
    fprintf(stderr, "pcap header write failed\n");
    return -1;
  }

  pph.len = 58;
  pph.caplen = 58;

  pd1.eth_dst[0] = pd1.eth_dst[1] = pd1.eth_dst[2] = pd1.eth_dst[3] =
     pd1.eth_dst[4] = pd1.eth_dst[5] = 0;

  pd1.eth_src[0] = pd1.eth_src[1] = pd1.eth_src[2] = pd1.eth_src[3] =
     pd1.eth_src[4] = pd1.eth_dst[5] = 0;

  pd1.eth_prot = 0x0008;

  pd2.version = 0x45;

  vec[0].iov_base = (char*)&pph;
  vec[0].iov_len = sizeof pph;

  vec[1].iov_base = (char*)&pd1;
  vec[1].iov_len = sizeof pd1;

  vec[2].iov_base = (char*)&pd2;
  vec[2].iov_len = sizeof pd2;

  vec_len = 4;

  while ((fdata = flow_read(fs))) {

    ++nflows;

    pd2.tos = fdata->tos;
    pd2.prot = fdata->prot;
    pd2.srcaddr = fdata->srcaddr;
    pd2.dstaddr = fdata->dstaddr;

    SWAPINT32(pd2.srcaddr);
    SWAPINT32(pd2.dstaddr);

    good = 1;

    switch (pd2.prot) {

    case 6:

      pd3.srcport = fdata->srcport;
      pd3.dstport = fdata->dstport;

      vec[3].iov_base = (char*)&pd3;
      vec[3].iov_len = sizeof pd3;

      SWAPINT16(pd3.srcport);
      SWAPINT16(pd3.dstport);

      break;


    case 17:

      pd4.srcport = fdata->srcport;
      pd4.dstport = fdata->dstport;

      vec[3].iov_base = (char*)&pd4;
      vec[3].iov_len = sizeof pd4;

      SWAPINT16(pd4.srcport);
      SWAPINT16(pd4.dstport);

      break;

    default:
/*      fprintf(stderr, "can't encode protocol %d\n", pd2.prot); */
      good = 0;
      break;

    } /* switch */

    if (good)
      if (writev(1, vec, vec_len) < 0 ) {
        fprintf(stderr, "pcap datagram write failed\n");
        return -1;
      }

  } /* while */

  *total_flows = nflows;
  
} /* flow_export0 */


