#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <fcntl.h>
#include <string.h>
#include <dirent.h>
#include <sys/stat.h>
#include <limits.h>
#include "bytes.h"
#include "queue.h"
#include "flow.h"


file_scandir(fa, dir)
struct file_ager *fa;
char *dir;
{
  DIR *dirp;
  struct dirent *dirent;
  struct flow_header fh;
  int fd, n, ret, done;
  struct stat sb;
  struct file_entry *n1, *n2;
  extern int errno;
  extern int debug;

  ret = -1;

  TAILQ_INIT(&fa->head);

  if (chdir (dir) == -1) {
    report(LOG_ERR, "chdir(%s): %s", dir, strerror(errno));
    return -1;
  }

  if (!(dirp = opendir("."))) {
    report(LOG_ERR, "opendir() .");
    return -1;
  }

  for (dirent = readdir(dirp); dirent; dirent = readdir(dirp)) {

    /* skip . and .. */
    if (dirent->d_name[0] == '.')
      if (!dirent->d_name[1])
        continue;
      if (dirent->d_name[1] == '.')
        if (!dirent->d_name[2])
          continue;

    /* skip anything that doesn't begin with "cf" */
    if (strncmp(dirent->d_name, "cf", 2)) {
      report(LOG_INFO, "ignoring: %s", dirent->d_name);
      continue;
    }

    /* make sure the file is actually a flow file */
    if ((fd = open (dirent->d_name,  O_RDONLY, 0)) == -1) {
      report(LOG_INFO, "open(%s): %s", dirent->d_name, strerror(errno));
      continue;
    }

    if ((n = read(fd, &fh, sizeof fh)) == -1) {
      report(LOG_INFO, "read(%s): %s", dirent->d_name, strerror(errno));
      close (fd);
      continue;
    }

    if (fstat(fd, &sb) == -1) {
      report(LOG_INFO, "stat(%s): %s", dirent->d_name, strerror(errno));
      close (fd);
      continue;
    }

    close (fd);

    if (n != sizeof fh) {
      report(LOG_INFO, "bad header: %s", dirent->d_name);
      continue;
    }

    if ((fh.magic1 != FF_MAGIC1) || (fh.magic2 != FF_MAGIC2)) {
      report(LOG_INFO, "bad magic: %s", dirent->d_name);
      continue;
    }

    /* can only store proper length files below */
    if (strlen(dirent->d_name) > FLOWFILELEN) {
      report(LOG_INFO, "bad filename: %s", dirent->d_name);
      continue;
    }

    /* insert the entry in the list sorted by start time of flow file */
    done = 0;
    TAILQ_FOREACH(n1, &fa->head, chain) {

      if (n1->start > fh.start) {

        if (!(n2 = malloc(sizeof (struct file_entry)))) {
          report(LOG_ERR, "malloc(): failed");
          goto errout;
        }

        n2->size = sb.st_size;
        n2->start = fh.start; 
        strcpy((char*)&n2->name, (char*)dirent->d_name);

        TAILQ_INSERT_BEFORE(n1, n2, chain);
        done = 1;
        break;
      }

    } /* TAILQ_FOREACH */

    if (!done) {
      if (!(n2 = malloc(sizeof (struct file_entry)))) {
        report(LOG_ERR, "malloc(): failed");
        goto errout;
      }
      n2->size = sb.st_size;
      n2->start = fh.start; 
      strcpy((char*)&n2->name, (char*)dirent->d_name);
      TAILQ_INSERT_TAIL(&fa->head, n2, chain);
    }

    fa->num_bytes += sb.st_size;
    fa->num_files ++;

  }  /* for dirent */

  ret = 0;

errout:
  closedir(dirp);

  if (debug)
    report(LOG_INFO, "file_scandir(): loaded %lu files", fa->num_files);

  return ret;

} /* file_scandir */

file_add_tail(fa, fname, size, start)
struct file_ager *fa;
char *fname;
off_t size;
u_int32 start;
{

  struct file_entry *n1;

  if (!(n1 = malloc(sizeof (struct file_entry)))) {
    report(LOG_ERR, "malloc(): failed");
    return -1;
  }
  n1->size = size;
  n1->start = start;
  strcpy((char*)&n1->name, fname);
  TAILQ_INSERT_TAIL(&fa->head, n1, chain);
  fa->num_files ++;
  fa->num_bytes += size;

  return 0;

}

file_expire (fa, doit, curbytes)
struct file_ager *fa;
int doit, curbytes;
{

  off_t size;
  u_int32 start;
  u_int i;
  struct file_entry *n1;
  u_int64 bytes;
  extern int errno, debug;

  /*
  /* if max_files is set, remove files starting at the head of the list until
  /* max_files <= num_files.  update num_files, num_bytes
  */

  i = 0;
  bytes = 0;

  if (fa->max_files && (fa->num_files > fa->max_files)) {
    TAILQ_FOREACH(n1, &fa->head, chain) {
      report(LOG_INFO, "remove/1 %s", n1->name);
      bytes += n1->size;
      ++i;
      if (doit) {
        TAILQ_REMOVE(&fa->head, n1, chain);
        free(n1);
        if (unlink(n1->name) == -1) 
          report(LOG_ERR, "unlink(%s): %s", n1->name, strerror(errno));
      } /* doit */
      if ((fa->num_files - i) <= fa->max_files)
        break;
    } /* TAILQ_FOREACH */
    if (doit) {
      fa->num_files -= i;
      fa->num_bytes -= bytes;
    } /* doit */
  } /* if */

  if (debug)
    report(LOG_INFO, "remove/1 %u files", i);

  i = 0;
  bytes = 0;
  /*
  /* if max_bytes is set, remove files starting at the head of the list until
  /* max_bytes <= num_bytes
  */
  if (fa->max_bytes && (fa->num_bytes+curbytes > fa->max_bytes)) {
    TAILQ_FOREACH(n1, &fa->head, chain) {
      report(LOG_INFO, "remove/2 %s", n1->name);
      bytes += n1->size;
      ++i;
      if (doit) {
        TAILQ_REMOVE(&fa->head, n1, chain);
        free(n1);
        if (unlink(n1->name) == -1) 
          report(LOG_ERR, "unlink(%s): %s", n1->name, strerror(errno));
      } /* doit */
      if ((fa->num_bytes+curbytes - bytes) <= fa->max_bytes)
        break;
    } /* TAILQ_FOREACH */
    if (doit) {
      fa->num_files -= i;
      fa->num_bytes -= bytes;
    } /* doit */
  } /* if */

  if (debug)
    report(LOG_INFO, "remove/2 %u files", i);

  return 0;

} /* file_expire */

file_dump(fa)
struct file_ager *fa;
{
  struct file_entry *n1;

  TAILQ_FOREACH(n1, &fa->head, chain) {

    report(LOG_INFO, "name=%s  size=%ld  time=%lu", n1->name, (long)n1->size,
      (unsigned long)n1->start);

  } /* TAILQ_FOREACH */

  return 0;

} /* file_dump */

