#include "../fltk/Fl_StatusPanel.h"
#include <stdio.h>


FL_API Fl_StatusPanel::Fl_StatusPanel(int nx, int ny, int nw, int nh, const char *lbl)
	: Fl_Group(nx, ny, nw, nh, lbl)
{
	int bdx, bdy, bdh, bdw;
	box(FL_ENGRAVED_BOX);
	
#if (FL_MAJOR_VERSION > 1)
	bdx = box()->dx();
	bdy = box()->dy();
	bdw = box()->dw();
	bdh = box()->dh();
	int ttop = bdy;
	nx = bdx;
#else
	bdx = Fl::box_dx(box());
	bdy = Fl::box_dy(box());
	bdw = Fl::box_dw(box());
	bdh = Fl::box_dh(box());
	int ttop = ny + bdy;
	nx += bdx;
#endif
	int theight = (nh - bdh);
	nw -= bdx;
	
	StatusMsg = new Fl_Tile(nx, ttop, nw - (3*33), theight, "");
	StatusMsg->box(FL_DOWN_BOX);
#if (FL_MAJOR_VERSION > 1)
	StatusMsg->label_size(12);
	StatusMsg->clear_flag(FL_ALIGN_MASK);
	StatusMsg->set_flag(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	int smbdx = StatusMsg->box()->dx();
	int smbdy = StatusMsg->box()->dy();
	int smbdh = StatusMsg->box()->dh();
#else
	StatusMsg->labelsize(12);
	StatusMsg->align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	int smbdx = Fl::box_dx(StatusMsg->box());
	int smbdy = Fl::box_dy(StatusMsg->box());
	int smbdh = Fl::box_dh(StatusMsg->box());
#endif

	this->resizable(StatusMsg);
	
	StatusMsg->end();

	INSlight = new Fl_Tile((nx+nw) - (3*33), ttop, 33, theight, "INS");
	INSlight->box(FL_DOWN_BOX);
#if (FL_MAJOR_VERSION > 1)
	INSlight->label_size(12);
	INSlight->clear_flag(FL_ALIGN_MASK);
	INSlight->set_flag(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
#else
	INSlight->labelsize(12);
	INSlight->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
#endif
	INSlight->end();

	CAPlight = new Fl_Tile((nx+nw) - (2*33), ttop, 33, theight, "");	// caps lock
	CAPlight->box(FL_DOWN_BOX);
#if (FL_MAJOR_VERSION > 1)
	CAPlight->label_size(12);
	CAPlight->clear_flag(FL_ALIGN_MASK);
	CAPlight->set_flag(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
#else
	CAPlight->labelsize(12);
	CAPlight->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
#endif
	CAPlight->end();

	NUMlight = new Fl_Tile((nx+nw) - 33, ttop, 33, theight, "");	// num lock
	NUMlight->box(FL_DOWN_BOX);
#if (FL_MAJOR_VERSION > 1)
	NUMlight->label_size(12);
	NUMlight->clear_flag(FL_ALIGN_MASK);
	NUMlight->set_flag(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
#else
	NUMlight->labelsize(12);
	NUMlight->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
#endif
	NUMlight->end();

#if (FL_MAJOR_VERSION > 1)
	PBar = new Fl_ProgressBox(StatusMsg->x() + smbdx, StatusMsg->y() + smbdy, StatusMsg->w() / 2, StatusMsg->h() - smbdh, "");
	PBar->label_size(10);
#else
	PBar = new Fl_ProgressBox(StatusMsg->x() + smbdx, StatusMsg->y() + smbdy, StatusMsg->w() / 2, StatusMsg->h() - smbdh, "");
	PBar->labelsize(10);
#endif
	PBar->hide();
	
	this->end();
}

FL_API Fl_StatusPanel::~Fl_StatusPanel()
{
	hide();
	// FLTK group will automatically delete its children...
	//return;
	if ( NUMlight )
	{
		this->remove(NUMlight);
		delete NUMlight;
	}
	if ( CAPlight )
	{
		this->remove(CAPlight);
		delete CAPlight;
	}
	if ( INSlight )
	{
		this->remove(INSlight);
		delete INSlight;
	}
	if ( StatusMsg )
	{
		this->remove(StatusMsg);
		if(PBar)
		{
			StatusMsg->remove(PBar);
			delete PBar;
		}
		delete StatusMsg;
	}
}

// This won't update right away on turning *off* the cap/num lock, at least
// on Linux, because the event for the keypress has the state still set,
// so you don't get the state cleared until the *next* event.
FL_API int Fl_StatusPanel::updatestatus(int event)
{
	// update the keyboard status lights
	int changed = 1;
	int key = 0;
	int state = Fl::event_state();
	int capon = (CAPlight->label()[0] == 'C');
	int numon = (NUMlight->label()[0] == 'N');
		
#if (FL_MAJOR_VERSION > 1) || (FL_MINOR_VERSION > 1)
	if(event == FL_KEYUP)
#endif
	{
		key = Fl::event_key();
		if(key == FL_Insert)
		{
			INSlight->label((INSlight->label()[0] == 'I') ? "" : "INS");
			redraw();
		}
	}
	if(capon && !(state & FL_CAPS_LOCK))
	{
		cap(0);
		redraw();
	}
	else if(!capon && (state & FL_CAPS_LOCK))
	{
		cap(1);
		redraw();
	}
	if(numon  && !(state & FL_NUM_LOCK))
	{
		num(0);
		redraw();
	}
	else if(!numon && (state & FL_NUM_LOCK))
	{
		num(1);
		redraw();
	}
	return(changed);
}


FL_API int Fl_StatusPanel::handle(int event)
{
	updatestatus(event);
	return (Fl_Widget::handle(event));
}

