#ifndef FL_FANCY_MULTI_EDITOR_H
#define FL_FANCY_MULTI_EDITOR_H 1

#include <FL/Fl_MultiEditor.H>
#include <FL/Fl_StatusPanel.H>

struct  fleditor_FindOptions
{
	wString SearchFor;
	wString ReplaceWith;
	bool MatchCase;
	bool MatchWord;
	bool SearchCursor;	// only one or the other of these two will be true.
	bool SearchDoc;
	bool PreserveCase;
	bool PromptReplace;
};

class Fl_FancyMultiEditor : public Fl_MultiEditor
{
protected:
	Fl_StatusPanel *lights;
	fleditor_FindOptions findopts;
	char PositionString[30];
protected:
	virtual FL_API Fl_Window *MakeFindDialog();
	virtual FL_API Fl_Window *MakeReplaceDialog();
public:
	FL_API Fl_FancyMultiEditor(int x, int y, int w, int h, const char *cap="") ;
	virtual FL_API ~Fl_FancyMultiEditor();
	FL_API void Session(fledit_SessionInfo *sinf);
	FL_API int handle(int event);
	FL_API bool Find();
	FL_API bool Replace();
	FL_API bool FindNext();
	FL_API void ShowPanel(bool show);
	// everything below this is inline.
	bool ShowPanel() 	{ return (bool)lights->visible(); };
	// why is this necessary?  Can't seem to call it from the base class!
	long Session()		{ return Fl_MultiEditor::Session(); };
};

#endif //FL_FANCY_EDITOR_H
