/*
 * Copyright (c) 2003, 2007-8 Matteo Frigo
 * Copyright (c) 2003, 2007-8 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Feb  9 19:56:12 EST 2009 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2c -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -twiddle-log3 -precompute-twiddles -n 20 -dif -name hc2cb2_20 -include hc2cb.h */

/*
 * This function contains 276 FP additions, 198 FP multiplications,
 * (or, 136 additions, 58 multiplications, 140 fused multiply/add),
 * 160 stack variables, 4 constants, and 80 memory accesses
 */
#include "hc2cb.h"

static void hc2cb2_20(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP618033988, +0.618033988749894848204586834365638117720309180);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     INT m;
     for (m = mb, W = W + ((mb - 1) * 8); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 8, MAKE_VOLATILE_STRIDE(rs)) {
	  E T1S, T1O, T1s, TI, T24, T1Y, T2g, T2k, TS, TR, T1I, T26, T1o, T20, T1F;
	  E T25, TT, T1Z;
	  {
	       E TD, TH, TE, T1L, T1N, T1X, TG, T1V, T2Y, T2b, T29, T2s, T36, T3e, T31;
	       E T2o, T3b, T5b, T2c, T2U, T4y, T4u, T2f, T5g, T47, T5p, T4b, T5l;
	       {
		    E T1r, TF, T2T, T1M, T1R, T2X, T2r, T4x;
		    TD = W[0];
		    TH = W[3];
		    TE = W[2];
		    T1L = W[6];
		    T1N = W[7];
		    T1r = TD * TH;
		    TF = TD * TE;
		    T2T = TE * T1L;
		    T1M = TD * T1L;
		    T1R = TD * T1N;
		    T2X = TE * T1N;
		    T1X = W[5];
		    TG = W[1];
		    T1V = W[4];
		    T2Y = FNMS(TH, T1L, T2X);
		    T2r = TD * T1X;
		    {
			 E T23, T2n, T1W, T2a;
			 T23 = TE * T1X;
			 T1S = FNMS(TG, T1L, T1R);
			 T1O = FMA(TG, T1N, T1M);
			 T2b = FMA(TG, TE, T1r);
			 T1s = FNMS(TG, TE, T1r);
			 T29 = FNMS(TG, TH, TF);
			 TI = FMA(TG, TH, TF);
			 T2n = TD * T1V;
			 T1W = TE * T1V;
			 T2s = FMA(TG, T1V, T2r);
			 T36 = FNMS(TG, T1V, T2r);
			 T3e = FMA(TH, T1V, T23);
			 T24 = FNMS(TH, T1V, T23);
			 T2a = T29 * T1V;
			 T31 = FMA(TG, T1X, T2n);
			 T2o = FNMS(TG, T1X, T2n);
			 T3b = FNMS(TH, T1X, T1W);
			 T1Y = FMA(TH, T1X, T1W);
			 T5b = FNMS(T2b, T1X, T2a);
			 T2c = FMA(T2b, T1X, T2a);
			 T2U = FMA(TH, T1N, T2T);
		    }
		    T4x = T29 * T1N;
		    {
			 E T4t, T2d, T2j, T2e;
			 T4t = T29 * T1L;
			 T2e = T29 * T1X;
			 T4y = FNMS(T2b, T1L, T4x);
			 T4u = FMA(T2b, T1N, T4t);
			 T2f = FNMS(T2b, T1V, T2e);
			 T5g = FMA(T2b, T1V, T2e);
			 T2d = T2c * T1L;
			 T2j = T2c * T1N;
			 T47 = TI * T1V;
			 T2g = FMA(T2f, T1N, T2d);
			 T2k = FNMS(T2f, T1L, T2j);
			 T5p = TI * T1N;
			 T4b = TI * T1X;
			 T5l = TI * T1L;
		    }
	       }
	       {
		    E T4f, T48, T4c, T4k, T5m, T5q, T3V, T4V, TJ, T7, T3j, T4B, T2H, T1z, T3q;
		    E T43, T1n, T52, T42, T3x, T53, T2D, T18, T2A, T1H, T4R, T4X, T4W, T4O, T1G;
		    E T2O, T3I, T2P, T3P, T2K, T2M, T1C, T1E, TC, T2w, T40, T3Y, T4K, T4I, TQ;
		    {
			 E T3h, T3, T1w, T3T, T1v, T3U, T6, T1x;
			 {
			      E T1t, T1u, T1, T2, T4, T5;
			      T1 = Rp[0];
			      T2 = Rm[WS(rs, 9)];
			      T1t = Ip[0];
			      T4f = FNMS(T1s, T1X, T47);
			      T48 = FMA(T1s, T1X, T47);
			      T4c = FNMS(T1s, T1V, T4b);
			      T4k = FMA(T1s, T1V, T4b);
			      T5m = FMA(T1s, T1N, T5l);
			      T5q = FNMS(T1s, T1L, T5p);
			      T3h = T1 - T2;
			      T3 = T1 + T2;
			      T1u = Im[WS(rs, 9)];
			      T4 = Rp[WS(rs, 5)];
			      T5 = Rm[WS(rs, 4)];
			      T1w = Ip[WS(rs, 5)];
			      T3T = T1t + T1u;
			      T1v = T1t - T1u;
			      T3U = T4 - T5;
			      T6 = T4 + T5;
			      T1x = Im[WS(rs, 4)];
			 }
			 {
			      E T3L, T4M, TK, Te, T3m, T4C, T2y, T1f, T3H, T4Q, TO, TA, T3w, T4G, T2C;
			      E T17, T3O, T4N, TL, Tl, T3p, T4D, T2z, T1m, T3r, Tp, TX, T3C, TW, T3D;
			      E Ts, TY;
			      {
				   E T3u, Tw, T14, T3G, T13, T3F, Tz, T15;
				   {
					E T3k, Ta, T1c, T3J, T1b, T3K, Td, T1d;
					{
					     E T19, T1a, Tb, Tc;
					     {
						  E T8, T3i, T1y, T9;
						  T8 = Rp[WS(rs, 4)];
						  T3V = T3T - T3U;
						  T4V = T3U + T3T;
						  TJ = T3 - T6;
						  T7 = T3 + T6;
						  T3i = T1w + T1x;
						  T1y = T1w - T1x;
						  T9 = Rm[WS(rs, 5)];
						  T19 = Ip[WS(rs, 4)];
						  T3j = T3h + T3i;
						  T4B = T3h - T3i;
						  T2H = T1v + T1y;
						  T1z = T1v - T1y;
						  T3k = T8 - T9;
						  Ta = T8 + T9;
						  T1a = Im[WS(rs, 5)];
					     }
					     Tb = Rp[WS(rs, 9)];
					     Tc = Rm[0];
					     T1c = Ip[WS(rs, 9)];
					     T3J = T19 + T1a;
					     T1b = T19 - T1a;
					     T3K = Tb - Tc;
					     Td = Tb + Tc;
					     T1d = Im[0];
					}
					{
					     E T11, T12, Tx, Ty;
					     {
						  E Tu, T3l, T1e, Tv;
						  Tu = Rm[WS(rs, 7)];
						  T3L = T3J - T3K;
						  T4M = T3K + T3J;
						  TK = Ta - Td;
						  Te = Ta + Td;
						  T3l = T1c + T1d;
						  T1e = T1c - T1d;
						  Tv = Rp[WS(rs, 2)];
						  T11 = Ip[WS(rs, 2)];
						  T3m = T3k + T3l;
						  T4C = T3k - T3l;
						  T2y = T1b + T1e;
						  T1f = T1b - T1e;
						  T3u = Tu - Tv;
						  Tw = Tu + Tv;
						  T12 = Im[WS(rs, 7)];
					     }
					     Tx = Rm[WS(rs, 2)];
					     Ty = Rp[WS(rs, 7)];
					     T14 = Ip[WS(rs, 7)];
					     T3G = T11 + T12;
					     T13 = T11 - T12;
					     T3F = Tx - Ty;
					     Tz = Tx + Ty;
					     T15 = Im[WS(rs, 2)];
					}
				   }
				   {
					E T3n, Th, T1j, T3N, T1i, T3M, Tk, T1k;
					{
					     E T1g, T1h, Ti, Tj;
					     {
						  E Tf, T3v, T16, Tg;
						  Tf = Rm[WS(rs, 3)];
						  T3H = T3F + T3G;
						  T4Q = T3F - T3G;
						  TO = Tw - Tz;
						  TA = Tw + Tz;
						  T3v = T14 + T15;
						  T16 = T14 - T15;
						  Tg = Rp[WS(rs, 6)];
						  T1g = Ip[WS(rs, 6)];
						  T3w = T3u - T3v;
						  T4G = T3u + T3v;
						  T2C = T13 + T16;
						  T17 = T13 - T16;
						  T3n = Tf - Tg;
						  Th = Tf + Tg;
						  T1h = Im[WS(rs, 3)];
					     }
					     Ti = Rp[WS(rs, 1)];
					     Tj = Rm[WS(rs, 8)];
					     T1j = Ip[WS(rs, 1)];
					     T3N = T1g + T1h;
					     T1i = T1g - T1h;
					     T3M = Ti - Tj;
					     Tk = Ti + Tj;
					     T1k = Im[WS(rs, 8)];
					}
					{
					     E TU, TV, Tq, Tr;
					     {
						  E Tn, T3o, T1l, To;
						  Tn = Rp[WS(rs, 8)];
						  T3O = T3M + T3N;
						  T4N = T3M - T3N;
						  TL = Th - Tk;
						  Tl = Th + Tk;
						  T3o = T1j + T1k;
						  T1l = T1j - T1k;
						  To = Rm[WS(rs, 1)];
						  TU = Ip[WS(rs, 8)];
						  T3p = T3n + T3o;
						  T4D = T3n - T3o;
						  T2z = T1i + T1l;
						  T1m = T1i - T1l;
						  T3r = Tn - To;
						  Tp = Tn + To;
						  TV = Im[WS(rs, 1)];
					     }
					     Tq = Rm[WS(rs, 6)];
					     Tr = Rp[WS(rs, 3)];
					     TX = Ip[WS(rs, 3)];
					     T3C = TU + TV;
					     TW = TU - TV;
					     T3D = Tq - Tr;
					     Ts = Tq + Tr;
					     TY = Im[WS(rs, 6)];
					}
				   }
			      }
			      {
				   E T3E, Tt, T1A, T4E, T4H, T2J, T1B, T2I, TM, TP;
				   {
					E T4P, TN, T3s, TZ;
					T3q = T3m + T3p;
					T43 = T3m - T3p;
					T3E = T3C - T3D;
					T4P = T3D + T3C;
					TN = Tp - Ts;
					Tt = Tp + Ts;
					T3s = TX + TY;
					TZ = TX - TY;
					T1n = T1f - T1m;
					T1A = T1f + T1m;
					T4E = T4C + T4D;
					T52 = T4C - T4D;
					{
					     E T3t, T4F, T2B, T10;
					     T3t = T3r - T3s;
					     T4F = T3r + T3s;
					     T2B = TW + TZ;
					     T10 = TW - TZ;
					     T42 = T3t - T3w;
					     T3x = T3t + T3w;
					     T4H = T4F + T4G;
					     T53 = T4F - T4G;
					     T2D = T2B - T2C;
					     T2J = T2B + T2C;
					     T1B = T10 + T17;
					     T18 = T10 - T17;
					     T2A = T2y - T2z;
					     T2I = T2y + T2z;
					     TM = TK + TL;
					     T1H = TK - TL;
					}
					T4R = T4P - T4Q;
					T4X = T4P + T4Q;
					T4W = T4M + T4N;
					T4O = T4M - T4N;
					T1G = TN - TO;
					TP = TN + TO;
				   }
				   {
					E Tm, T3X, TB, T3W;
					Tm = Te + Tl;
					T2O = Te - Tl;
					T3I = T3E + T3H;
					T3X = T3E - T3H;
					TB = Tt + TA;
					T2P = Tt - TA;
					T3P = T3L + T3O;
					T3W = T3L - T3O;
					T2K = T2I + T2J;
					T2M = T2I - T2J;
					T1C = T1A + T1B;
					T1E = T1A - T1B;
					TC = Tm + TB;
					T2w = Tm - TB;
					T40 = T3W - T3X;
					T3Y = T3W + T3X;
					T4K = T4E - T4H;
					T4I = T4E + T4H;
					TS = TM - TP;
					TQ = TM + TP;
				   }
			      }
			 }
		    }
		    {
			 E T3A, T3y, T50, T1D, T2t, T2p, T4J, T5t, T5v, T4Z, T4Y;
			 Rp[0] = T7 + TC;
			 T3A = T3q - T3x;
			 T3y = T3q + T3x;
			 T50 = T4W - T4X;
			 T4Y = T4W + T4X;
			 Rm[0] = T2H + T2K;
			 T1D = FNMS(KP250000000, T1C, T1z);
			 T2t = T1z + T1C;
			 T2p = TJ + TQ;
			 TR = FNMS(KP250000000, TQ, TJ);
			 T4J = FNMS(KP250000000, T4I, T4B);
			 T5t = T4B + T4I;
			 T5v = T4V + T4Y;
			 T4Z = FNMS(KP250000000, T4Y, T4V);
			 {
			      E T4m, T44, T4i, T4p, T49, T3R, T4j, T4a, T3S, T4l, T41, T4q;
			      {
				   E T3z, T4v, T4w, T3Z, T4z;
				   T3z = FNMS(KP250000000, T3y, T3j);
				   T4v = T3j + T3y;
				   {
					E T2u, T2q, T5u, T5w;
					T2u = T2s * T2p;
					T2q = T2o * T2p;
					T5u = T2c * T5t;
					T5w = T2c * T5v;
					Rm[WS(rs, 5)] = FMA(T2o, T2t, T2u);
					Rp[WS(rs, 5)] = FNMS(T2s, T2t, T2q);
					Ip[WS(rs, 2)] = FNMS(T2f, T5v, T5u);
					Im[WS(rs, 2)] = FMA(T2f, T5t, T5w);
					T4w = T4u * T4v;
				   }
				   T3Z = FNMS(KP250000000, T3Y, T3V);
				   T4z = T3V + T3Y;
				   {
					E T3Q, T4h, T4A, T4g, T3B;
					T3Q = FNMS(KP618033988, T3P, T3I);
					T4h = FMA(KP618033988, T3I, T3P);
					Ip[WS(rs, 7)] = FNMS(T4y, T4z, T4w);
					T4A = T4u * T4z;
					T4m = FMA(KP618033988, T42, T43);
					T44 = FNMS(KP618033988, T43, T42);
					T4g = FMA(KP559016994, T3A, T3z);
					T3B = FNMS(KP559016994, T3A, T3z);
					Im[WS(rs, 7)] = FMA(T4y, T4v, T4A);
					T4i = FNMS(KP951056516, T4h, T4g);
					T4p = FMA(KP951056516, T4h, T4g);
					T49 = FMA(KP951056516, T3Q, T3B);
					T3R = FNMS(KP951056516, T3Q, T3B);
				   }
				   T4j = T4f * T4i;
				   T4a = T48 * T49;
				   T3S = TE * T3R;
				   T4l = FMA(KP559016994, T40, T3Z);
				   T41 = FNMS(KP559016994, T40, T3Z);
				   T4q = T1L * T4p;
			      }
			      {
				   E T5d, T4S, T54, T5i, T4L, T5c;
				   T5d = FNMS(KP618033988, T4O, T4R);
				   T4S = FMA(KP618033988, T4R, T4O);
				   {
					E T4n, T4r, T4d, T45;
					T4n = FMA(KP951056516, T4m, T4l);
					T4r = FNMS(KP951056516, T4m, T4l);
					T4d = FNMS(KP951056516, T44, T41);
					T45 = FMA(KP951056516, T44, T41);
					{
					     E T4o, T4s, T4e, T46;
					     T4o = T4f * T4n;
					     Ip[WS(rs, 5)] = FNMS(T4k, T4n, T4j);
					     T4s = T1L * T4r;
					     Ip[WS(rs, 9)] = FNMS(T1N, T4r, T4q);
					     T4e = T48 * T4d;
					     Ip[WS(rs, 3)] = FNMS(T4c, T4d, T4a);
					     T46 = TE * T45;
					     Ip[WS(rs, 1)] = FNMS(TH, T45, T3S);
					     Im[WS(rs, 5)] = FMA(T4k, T4i, T4o);
					     Im[WS(rs, 9)] = FMA(T1N, T4p, T4s);
					     Im[WS(rs, 3)] = FMA(T4c, T49, T4e);
					     Im[WS(rs, 1)] = FMA(TH, T3R, T46);
					}
				   }
				   T54 = FMA(KP618033988, T53, T52);
				   T5i = FNMS(KP618033988, T52, T53);
				   T4L = FMA(KP559016994, T4K, T4J);
				   T5c = FNMS(KP559016994, T4K, T4J);
				   {
					E T38, T2Q, T33, T2E, T2v, T37, T2N, T5h, T51, T2L, T2x, T32;
					T38 = FNMS(KP618033988, T2O, T2P);
					T2Q = FMA(KP618033988, T2P, T2O);
					T5h = FNMS(KP559016994, T50, T4Z);
					T51 = FMA(KP559016994, T50, T4Z);
					{
					     E T5e, T5n, T57, T4T;
					     T5e = FNMS(KP951056516, T5d, T5c);
					     T5n = FMA(KP951056516, T5d, T5c);
					     T57 = FMA(KP951056516, T4S, T4L);
					     T4T = FNMS(KP951056516, T4S, T4L);
					     {
						  E T5j, T5r, T59, T55;
						  T5j = FMA(KP951056516, T5i, T5h);
						  T5r = FNMS(KP951056516, T5i, T5h);
						  T59 = FNMS(KP951056516, T54, T51);
						  T55 = FMA(KP951056516, T54, T51);
						  {
						       E T5f, T5o, T58, T4U;
						       T5f = T5b * T5e;
						       T5o = T5m * T5n;
						       T58 = T1V * T57;
						       T4U = TD * T4T;
						       {
							    E T5k, T5s, T5a, T56;
							    T5k = T5b * T5j;
							    T5s = T5m * T5r;
							    T5a = T1V * T59;
							    T56 = TD * T55;
							    Ip[WS(rs, 6)] = FNMS(T5g, T5j, T5f);
							    Ip[WS(rs, 8)] = FNMS(T5q, T5r, T5o);
							    Ip[WS(rs, 4)] = FNMS(T1X, T59, T58);
							    Ip[0] = FNMS(TG, T55, T4U);
							    Im[WS(rs, 6)] = FMA(T5g, T5e, T5k);
							    Im[WS(rs, 8)] = FMA(T5q, T5n, T5s);
							    Im[WS(rs, 4)] = FMA(T1X, T57, T5a);
							    Im[0] = FMA(TG, T4T, T56);
						       }
						  }
					     }
					}
					T2L = FNMS(KP250000000, T2K, T2H);
					T33 = FNMS(KP618033988, T2A, T2D);
					T2E = FMA(KP618033988, T2D, T2A);
					T2v = FNMS(KP250000000, TC, T7);
					T37 = FNMS(KP559016994, T2M, T2L);
					T2N = FMA(KP559016994, T2M, T2L);
					T1I = FNMS(KP618033988, T1H, T1G);
					T26 = FMA(KP618033988, T1G, T1H);
					T2x = FMA(KP559016994, T2w, T2v);
					T32 = FNMS(KP559016994, T2w, T2v);
					{
					     E T3f, T39, T2R, T2Z;
					     T3f = FNMS(KP951056516, T38, T37);
					     T39 = FMA(KP951056516, T38, T37);
					     T2R = FNMS(KP951056516, T2Q, T2N);
					     T2Z = FMA(KP951056516, T2Q, T2N);
					     {
						  E T3c, T34, T2F, T2V;
						  T3c = FMA(KP951056516, T33, T32);
						  T34 = FNMS(KP951056516, T33, T32);
						  T2F = FMA(KP951056516, T2E, T2x);
						  T2V = FNMS(KP951056516, T2E, T2x);
						  {
						       E T3a, T35, T3g, T3d;
						       T3a = T36 * T34;
						       T35 = T31 * T34;
						       T3g = T3e * T3c;
						       T3d = T3b * T3c;
						       {
							    E T30, T2W, T2S, T2G;
							    T30 = T2Y * T2V;
							    T2W = T2U * T2V;
							    T2S = T2b * T2F;
							    T2G = T29 * T2F;
							    Rm[WS(rs, 4)] = FMA(T31, T39, T3a);
							    Rp[WS(rs, 4)] = FNMS(T36, T39, T35);
							    Rm[WS(rs, 6)] = FMA(T3b, T3f, T3g);
							    Rp[WS(rs, 6)] = FNMS(T3e, T3f, T3d);
							    Rm[WS(rs, 8)] = FMA(T2U, T2Z, T30);
							    Rp[WS(rs, 8)] = FNMS(T2Y, T2Z, T2W);
							    Rm[WS(rs, 2)] = FMA(T29, T2R, T2S);
							    Rp[WS(rs, 2)] = FNMS(T2b, T2R, T2G);
						       }
						  }
					     }
					}
					T1o = FNMS(KP618033988, T1n, T18);
					T20 = FMA(KP618033988, T18, T1n);
					T1F = FNMS(KP559016994, T1E, T1D);
					T25 = FMA(KP559016994, T1E, T1D);
				   }
			      }
			 }
		    }
	       }
	  }
	  TT = FNMS(KP559016994, TS, TR);
	  T1Z = FMA(KP559016994, TS, TR);
	  {
	       E T2l, T27, T1J, T1T;
	       T2l = FNMS(KP951056516, T26, T25);
	       T27 = FMA(KP951056516, T26, T25);
	       T1J = FNMS(KP951056516, T1I, T1F);
	       T1T = FMA(KP951056516, T1I, T1F);
	       {
		    E T2h, T21, T1p, T1P;
		    T2h = FMA(KP951056516, T20, T1Z);
		    T21 = FNMS(KP951056516, T20, T1Z);
		    T1p = FMA(KP951056516, T1o, TT);
		    T1P = FNMS(KP951056516, T1o, TT);
		    {
			 E T28, T22, T2m, T2i;
			 T28 = T24 * T21;
			 T22 = T1Y * T21;
			 T2m = T2k * T2h;
			 T2i = T2g * T2h;
			 {
			      E T1U, T1Q, T1K, T1q;
			      T1U = T1S * T1P;
			      T1Q = T1O * T1P;
			      T1K = T1s * T1p;
			      T1q = TI * T1p;
			      Rm[WS(rs, 3)] = FMA(T1Y, T27, T28);
			      Rp[WS(rs, 3)] = FNMS(T24, T27, T22);
			      Rm[WS(rs, 7)] = FMA(T2g, T2l, T2m);
			      Rp[WS(rs, 7)] = FNMS(T2k, T2l, T2i);
			      Rm[WS(rs, 9)] = FMA(T1O, T1T, T1U);
			      Rp[WS(rs, 9)] = FNMS(T1S, T1T, T1Q);
			      Rm[WS(rs, 1)] = FMA(TI, T1J, T1K);
			      Rp[WS(rs, 1)] = FNMS(T1s, T1J, T1q);
			 }
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 1, 1},
     {TW_CEXP, 1, 3},
     {TW_CEXP, 1, 9},
     {TW_CEXP, 1, 19},
     {TW_NEXT, 1, 0}
};

static const hc2c_desc desc = { 20, "hc2cb2_20", twinstr, &GENUS, {136, 58, 140, 0} };

void X(codelet_hc2cb2_20) (planner *p) {
     X(khc2c_register) (p, hc2cb2_20, &desc, HC2C_VIA_RDFT);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2c -compact -variables 4 -pipeline-latency 4 -sign 1 -twiddle-log3 -precompute-twiddles -n 20 -dif -name hc2cb2_20 -include hc2cb.h */

/*
 * This function contains 276 FP additions, 164 FP multiplications,
 * (or, 204 additions, 92 multiplications, 72 fused multiply/add),
 * 137 stack variables, 4 constants, and 80 memory accesses
 */
#include "hc2cb.h"

static void hc2cb2_20(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     INT m;
     for (m = mb, W = W + ((mb - 1) * 8); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 8, MAKE_VOLATILE_STRIDE(rs)) {
	  E TD, TG, TE, TH, TJ, T1t, T27, T25, T1T, T1R, T1V, T2j, T2Z, T21, T2X;
	  E T2T, T2n, T2P, T3V, T41, T3R, T3X, T29, T2c, T4H, T4L, T1L, T1M, T1N, T2d;
	  E T4R, T1P, T4P, T49, T2N, T2f, T47, T2L;
	  {
	       E T1U, T2l, T1Z, T2i, T1S, T2m, T20, T2h;
	       {
		    E TF, T1s, TI, T1r;
		    TD = W[0];
		    TG = W[1];
		    TE = W[2];
		    TH = W[3];
		    TF = TD * TE;
		    T1s = TG * TE;
		    TI = TG * TH;
		    T1r = TD * TH;
		    TJ = TF + TI;
		    T1t = T1r - T1s;
		    T27 = T1r + T1s;
		    T25 = TF - TI;
		    T1T = W[5];
		    T1U = TH * T1T;
		    T2l = TD * T1T;
		    T1Z = TE * T1T;
		    T2i = TG * T1T;
		    T1R = W[4];
		    T1S = TE * T1R;
		    T2m = TG * T1R;
		    T20 = TH * T1R;
		    T2h = TD * T1R;
	       }
	       T1V = T1S + T1U;
	       T2j = T2h - T2i;
	       T2Z = T1Z + T20;
	       T21 = T1Z - T20;
	       T2X = T1S - T1U;
	       T2T = T2l - T2m;
	       T2n = T2l + T2m;
	       T2P = T2h + T2i;
	       {
		    E T3T, T3U, T3P, T3Q;
		    T3T = TJ * T1T;
		    T3U = T1t * T1R;
		    T3V = T3T - T3U;
		    T41 = T3T + T3U;
		    T3P = TJ * T1R;
		    T3Q = T1t * T1T;
		    T3R = T3P + T3Q;
		    T3X = T3P - T3Q;
		    {
			 E T26, T28, T2a, T2b;
			 T26 = T25 * T1R;
			 T28 = T27 * T1T;
			 T29 = T26 + T28;
			 T2a = T25 * T1T;
			 T2b = T27 * T1R;
			 T2c = T2a - T2b;
			 T4H = T26 - T28;
			 T4L = T2a + T2b;
			 T1L = W[6];
			 T1M = W[7];
			 T1N = FMA(TD, T1L, TG * T1M);
			 T2d = FMA(T29, T1L, T2c * T1M);
			 T4R = FNMS(T1t, T1L, TJ * T1M);
			 T1P = FNMS(TG, T1L, TD * T1M);
			 T4P = FMA(TJ, T1L, T1t * T1M);
			 T49 = FNMS(T27, T1L, T25 * T1M);
			 T2N = FNMS(TH, T1L, TE * T1M);
			 T2f = FNMS(T2c, T1L, T29 * T1M);
			 T47 = FMA(T25, T1L, T27 * T1M);
			 T2L = FMA(TE, T1L, TH * T1M);
		    }
	       }
	  }
	  {
	       E T7, T4i, T4x, TK, T1D, T3i, T3E, T2D, T19, T3L, T3M, T1o, T2x, T4C, T4B;
	       E T2u, T1v, T4r, T4o, T1u, T2H, T37, T2I, T3e, T3p, T3w, T3x, Tm, TB, TC;
	       E T4u, T4v, T4y, T2A, T2B, T2E, T1E, T1F, T1G, T4d, T4g, T4j, T3F, T3G, T3H;
	       E TN, TQ, TR, T48, T4a;
	       {
		    E T3, T3g, T1z, T3C, T6, T3D, T1C, T3h;
		    {
			 E T1, T2, T1x, T1y;
			 T1 = Rp[0];
			 T2 = Rm[WS(rs, 9)];
			 T3 = T1 + T2;
			 T3g = T1 - T2;
			 T1x = Ip[0];
			 T1y = Im[WS(rs, 9)];
			 T1z = T1x - T1y;
			 T3C = T1x + T1y;
		    }
		    {
			 E T4, T5, T1A, T1B;
			 T4 = Rp[WS(rs, 5)];
			 T5 = Rm[WS(rs, 4)];
			 T6 = T4 + T5;
			 T3D = T4 - T5;
			 T1A = Ip[WS(rs, 5)];
			 T1B = Im[WS(rs, 4)];
			 T1C = T1A - T1B;
			 T3h = T1A + T1B;
		    }
		    T7 = T3 + T6;
		    T4i = T3g - T3h;
		    T4x = T3D + T3C;
		    TK = T3 - T6;
		    T1D = T1z - T1C;
		    T3i = T3g + T3h;
		    T3E = T3C - T3D;
		    T2D = T1z + T1C;
	       }
	       {
		    E Te, T4b, T4m, TL, T11, T33, T3l, T2s, TA, T4f, T4q, TP, T1n, T3d, T3v;
		    E T2w, Tl, T4c, T4n, TM, T18, T36, T3o, T2t, Tt, T4e, T4p, TO, T1g, T3a;
		    E T3s, T2v;
		    {
			 E Ta, T3j, TX, T31, Td, T32, T10, T3k;
			 {
			      E T8, T9, TV, TW;
			      T8 = Rp[WS(rs, 4)];
			      T9 = Rm[WS(rs, 5)];
			      Ta = T8 + T9;
			      T3j = T8 - T9;
			      TV = Ip[WS(rs, 4)];
			      TW = Im[WS(rs, 5)];
			      TX = TV - TW;
			      T31 = TV + TW;
			 }
			 {
			      E Tb, Tc, TY, TZ;
			      Tb = Rp[WS(rs, 9)];
			      Tc = Rm[0];
			      Td = Tb + Tc;
			      T32 = Tb - Tc;
			      TY = Ip[WS(rs, 9)];
			      TZ = Im[0];
			      T10 = TY - TZ;
			      T3k = TY + TZ;
			 }
			 Te = Ta + Td;
			 T4b = T3j - T3k;
			 T4m = T32 + T31;
			 TL = Ta - Td;
			 T11 = TX - T10;
			 T33 = T31 - T32;
			 T3l = T3j + T3k;
			 T2s = TX + T10;
		    }
		    {
			 E Tw, T3t, T1j, T3c, Tz, T3b, T1m, T3u;
			 {
			      E Tu, Tv, T1h, T1i;
			      Tu = Rm[WS(rs, 7)];
			      Tv = Rp[WS(rs, 2)];
			      Tw = Tu + Tv;
			      T3t = Tu - Tv;
			      T1h = Ip[WS(rs, 2)];
			      T1i = Im[WS(rs, 7)];
			      T1j = T1h - T1i;
			      T3c = T1h + T1i;
			 }
			 {
			      E Tx, Ty, T1k, T1l;
			      Tx = Rm[WS(rs, 2)];
			      Ty = Rp[WS(rs, 7)];
			      Tz = Tx + Ty;
			      T3b = Tx - Ty;
			      T1k = Ip[WS(rs, 7)];
			      T1l = Im[WS(rs, 2)];
			      T1m = T1k - T1l;
			      T3u = T1k + T1l;
			 }
			 TA = Tw + Tz;
			 T4f = T3t + T3u;
			 T4q = T3b - T3c;
			 TP = Tw - Tz;
			 T1n = T1j - T1m;
			 T3d = T3b + T3c;
			 T3v = T3t - T3u;
			 T2w = T1j + T1m;
		    }
		    {
			 E Th, T3m, T14, T35, Tk, T34, T17, T3n;
			 {
			      E Tf, Tg, T12, T13;
			      Tf = Rm[WS(rs, 3)];
			      Tg = Rp[WS(rs, 6)];
			      Th = Tf + Tg;
			      T3m = Tf - Tg;
			      T12 = Ip[WS(rs, 6)];
			      T13 = Im[WS(rs, 3)];
			      T14 = T12 - T13;
			      T35 = T12 + T13;
			 }
			 {
			      E Ti, Tj, T15, T16;
			      Ti = Rp[WS(rs, 1)];
			      Tj = Rm[WS(rs, 8)];
			      Tk = Ti + Tj;
			      T34 = Ti - Tj;
			      T15 = Ip[WS(rs, 1)];
			      T16 = Im[WS(rs, 8)];
			      T17 = T15 - T16;
			      T3n = T15 + T16;
			 }
			 Tl = Th + Tk;
			 T4c = T3m - T3n;
			 T4n = T34 - T35;
			 TM = Th - Tk;
			 T18 = T14 - T17;
			 T36 = T34 + T35;
			 T3o = T3m + T3n;
			 T2t = T14 + T17;
		    }
		    {
			 E Tp, T3q, T1c, T38, Ts, T39, T1f, T3r;
			 {
			      E Tn, To, T1a, T1b;
			      Tn = Rp[WS(rs, 8)];
			      To = Rm[WS(rs, 1)];
			      Tp = Tn + To;
			      T3q = Tn - To;
			      T1a = Ip[WS(rs, 8)];
			      T1b = Im[WS(rs, 1)];
			      T1c = T1a - T1b;
			      T38 = T1a + T1b;
			 }
			 {
			      E Tq, Tr, T1d, T1e;
			      Tq = Rm[WS(rs, 6)];
			      Tr = Rp[WS(rs, 3)];
			      Ts = Tq + Tr;
			      T39 = Tq - Tr;
			      T1d = Ip[WS(rs, 3)];
			      T1e = Im[WS(rs, 6)];
			      T1f = T1d - T1e;
			      T3r = T1d + T1e;
			 }
			 Tt = Tp + Ts;
			 T4e = T3q + T3r;
			 T4p = T39 + T38;
			 TO = Tp - Ts;
			 T1g = T1c - T1f;
			 T3a = T38 - T39;
			 T3s = T3q - T3r;
			 T2v = T1c + T1f;
		    }
		    T19 = T11 - T18;
		    T3L = T3l - T3o;
		    T3M = T3s - T3v;
		    T1o = T1g - T1n;
		    T2x = T2v - T2w;
		    T4C = T4e - T4f;
		    T4B = T4b - T4c;
		    T2u = T2s - T2t;
		    T1v = TO - TP;
		    T4r = T4p - T4q;
		    T4o = T4m - T4n;
		    T1u = TL - TM;
		    T2H = Te - Tl;
		    T37 = T33 + T36;
		    T2I = Tt - TA;
		    T3e = T3a + T3d;
		    T3p = T3l + T3o;
		    T3w = T3s + T3v;
		    T3x = T3p + T3w;
		    Tm = Te + Tl;
		    TB = Tt + TA;
		    TC = Tm + TB;
		    T4u = T4m + T4n;
		    T4v = T4p + T4q;
		    T4y = T4u + T4v;
		    T2A = T2s + T2t;
		    T2B = T2v + T2w;
		    T2E = T2A + T2B;
		    T1E = T11 + T18;
		    T1F = T1g + T1n;
		    T1G = T1E + T1F;
		    T4d = T4b + T4c;
		    T4g = T4e + T4f;
		    T4j = T4d + T4g;
		    T3F = T33 - T36;
		    T3G = T3a - T3d;
		    T3H = T3F + T3G;
		    TN = TL + TM;
		    TQ = TO + TP;
		    TR = TN + TQ;
	       }
	       Rp[0] = T7 + TC;
	       Rm[0] = T2D + T2E;
	       {
		    E T2k, T2o, T4T, T4U;
		    T2k = TK + TR;
		    T2o = T1D + T1G;
		    Rp[WS(rs, 5)] = FNMS(T2n, T2o, T2j * T2k);
		    Rm[WS(rs, 5)] = FMA(T2n, T2k, T2j * T2o);
		    T4T = T4i + T4j;
		    T4U = T4x + T4y;
		    Ip[WS(rs, 2)] = FNMS(T2c, T4U, T29 * T4T);
		    Im[WS(rs, 2)] = FMA(T29, T4U, T2c * T4T);
	       }
	       T48 = T3i + T3x;
	       T4a = T3E + T3H;
	       Ip[WS(rs, 7)] = FNMS(T49, T4a, T47 * T48);
	       Im[WS(rs, 7)] = FMA(T47, T4a, T49 * T48);
	       {
		    E T2y, T2J, T2V, T2R, T2G, T2U, T2r, T2Q;
		    T2y = FMA(KP951056516, T2u, KP587785252 * T2x);
		    T2J = FMA(KP951056516, T2H, KP587785252 * T2I);
		    T2V = FNMS(KP951056516, T2I, KP587785252 * T2H);
		    T2R = FNMS(KP951056516, T2x, KP587785252 * T2u);
		    {
			 E T2C, T2F, T2p, T2q;
			 T2C = KP559016994 * (T2A - T2B);
			 T2F = FNMS(KP250000000, T2E, T2D);
			 T2G = T2C + T2F;
			 T2U = T2F - T2C;
			 T2p = KP559016994 * (Tm - TB);
			 T2q = FNMS(KP250000000, TC, T7);
			 T2r = T2p + T2q;
			 T2Q = T2q - T2p;
		    }
		    {
			 E T2z, T2K, T2Y, T30;
			 T2z = T2r + T2y;
			 T2K = T2G - T2J;
			 Rp[WS(rs, 2)] = FNMS(T27, T2K, T25 * T2z);
			 Rm[WS(rs, 2)] = FMA(T27, T2z, T25 * T2K);
			 T2Y = T2Q - T2R;
			 T30 = T2V + T2U;
			 Rp[WS(rs, 6)] = FNMS(T2Z, T30, T2X * T2Y);
			 Rm[WS(rs, 6)] = FMA(T2Z, T2Y, T2X * T30);
		    }
		    {
			 E T2M, T2O, T2S, T2W;
			 T2M = T2r - T2y;
			 T2O = T2J + T2G;
			 Rp[WS(rs, 8)] = FNMS(T2N, T2O, T2L * T2M);
			 Rm[WS(rs, 8)] = FMA(T2N, T2M, T2L * T2O);
			 T2S = T2Q + T2R;
			 T2W = T2U - T2V;
			 Rp[WS(rs, 4)] = FNMS(T2T, T2W, T2P * T2S);
			 Rm[WS(rs, 4)] = FMA(T2T, T2S, T2P * T2W);
		    }
	       }
	       {
		    E T4s, T4D, T4N, T4I, T4A, T4M, T4l, T4J;
		    T4s = FMA(KP951056516, T4o, KP587785252 * T4r);
		    T4D = FMA(KP951056516, T4B, KP587785252 * T4C);
		    T4N = FNMS(KP951056516, T4C, KP587785252 * T4B);
		    T4I = FNMS(KP951056516, T4r, KP587785252 * T4o);
		    {
			 E T4w, T4z, T4h, T4k;
			 T4w = KP559016994 * (T4u - T4v);
			 T4z = FNMS(KP250000000, T4y, T4x);
			 T4A = T4w + T4z;
			 T4M = T4z - T4w;
			 T4h = KP559016994 * (T4d - T4g);
			 T4k = FNMS(KP250000000, T4j, T4i);
			 T4l = T4h + T4k;
			 T4J = T4k - T4h;
		    }
		    {
			 E T4t, T4E, T4Q, T4S;
			 T4t = T4l - T4s;
			 T4E = T4A + T4D;
			 Ip[0] = FNMS(TG, T4E, TD * T4t);
			 Im[0] = FMA(TD, T4E, TG * T4t);
			 T4Q = T4J - T4I;
			 T4S = T4M + T4N;
			 Ip[WS(rs, 8)] = FNMS(T4R, T4S, T4P * T4Q);
			 Im[WS(rs, 8)] = FMA(T4P, T4S, T4R * T4Q);
		    }
		    {
			 E T4F, T4G, T4K, T4O;
			 T4F = T4s + T4l;
			 T4G = T4A - T4D;
			 Ip[WS(rs, 4)] = FNMS(T1T, T4G, T1R * T4F);
			 Im[WS(rs, 4)] = FMA(T1R, T4G, T1T * T4F);
			 T4K = T4I + T4J;
			 T4O = T4M - T4N;
			 Ip[WS(rs, 6)] = FNMS(T4L, T4O, T4H * T4K);
			 Im[WS(rs, 6)] = FMA(T4H, T4O, T4L * T4K);
		    }
	       }
	       {
		    E T1p, T1w, T22, T1X, T1J, T23, TU, T1W;
		    T1p = FNMS(KP951056516, T1o, KP587785252 * T19);
		    T1w = FNMS(KP951056516, T1v, KP587785252 * T1u);
		    T22 = FMA(KP951056516, T1u, KP587785252 * T1v);
		    T1X = FMA(KP951056516, T19, KP587785252 * T1o);
		    {
			 E T1H, T1I, TS, TT;
			 T1H = FNMS(KP250000000, T1G, T1D);
			 T1I = KP559016994 * (T1E - T1F);
			 T1J = T1H - T1I;
			 T23 = T1I + T1H;
			 TS = FNMS(KP250000000, TR, TK);
			 TT = KP559016994 * (TN - TQ);
			 TU = TS - TT;
			 T1W = TT + TS;
		    }
		    {
			 E T1q, T1K, T2e, T2g;
			 T1q = TU - T1p;
			 T1K = T1w + T1J;
			 Rp[WS(rs, 1)] = FNMS(T1t, T1K, TJ * T1q);
			 Rm[WS(rs, 1)] = FMA(T1t, T1q, TJ * T1K);
			 T2e = T1W + T1X;
			 T2g = T23 - T22;
			 Rp[WS(rs, 7)] = FNMS(T2f, T2g, T2d * T2e);
			 Rm[WS(rs, 7)] = FMA(T2f, T2e, T2d * T2g);
		    }
		    {
			 E T1O, T1Q, T1Y, T24;
			 T1O = TU + T1p;
			 T1Q = T1J - T1w;
			 Rp[WS(rs, 9)] = FNMS(T1P, T1Q, T1N * T1O);
			 Rm[WS(rs, 9)] = FMA(T1P, T1O, T1N * T1Q);
			 T1Y = T1W - T1X;
			 T24 = T22 + T23;
			 Rp[WS(rs, 3)] = FNMS(T21, T24, T1V * T1Y);
			 Rm[WS(rs, 3)] = FMA(T21, T1Y, T1V * T24);
		    }
	       }
	       {
		    E T3f, T3N, T43, T3Z, T3K, T42, T3A, T3Y;
		    T3f = FNMS(KP951056516, T3e, KP587785252 * T37);
		    T3N = FNMS(KP951056516, T3M, KP587785252 * T3L);
		    T43 = FMA(KP951056516, T3L, KP587785252 * T3M);
		    T3Z = FMA(KP951056516, T37, KP587785252 * T3e);
		    {
			 E T3I, T3J, T3y, T3z;
			 T3I = FNMS(KP250000000, T3H, T3E);
			 T3J = KP559016994 * (T3F - T3G);
			 T3K = T3I - T3J;
			 T42 = T3J + T3I;
			 T3y = FNMS(KP250000000, T3x, T3i);
			 T3z = KP559016994 * (T3p - T3w);
			 T3A = T3y - T3z;
			 T3Y = T3z + T3y;
		    }
		    {
			 E T3B, T3O, T45, T46;
			 T3B = T3f + T3A;
			 T3O = T3K - T3N;
			 Ip[WS(rs, 1)] = FNMS(TH, T3O, TE * T3B);
			 Im[WS(rs, 1)] = FMA(TE, T3O, TH * T3B);
			 T45 = T3Z + T3Y;
			 T46 = T42 - T43;
			 Ip[WS(rs, 9)] = FNMS(T1M, T46, T1L * T45);
			 Im[WS(rs, 9)] = FMA(T1L, T46, T1M * T45);
		    }
		    {
			 E T3S, T3W, T40, T44;
			 T3S = T3A - T3f;
			 T3W = T3K + T3N;
			 Ip[WS(rs, 3)] = FNMS(T3V, T3W, T3R * T3S);
			 Im[WS(rs, 3)] = FMA(T3R, T3W, T3V * T3S);
			 T40 = T3Y - T3Z;
			 T44 = T42 + T43;
			 Ip[WS(rs, 5)] = FNMS(T41, T44, T3X * T40);
			 Im[WS(rs, 5)] = FMA(T3X, T44, T41 * T40);
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 1, 1},
     {TW_CEXP, 1, 3},
     {TW_CEXP, 1, 9},
     {TW_CEXP, 1, 19},
     {TW_NEXT, 1, 0}
};

static const hc2c_desc desc = { 20, "hc2cb2_20", twinstr, &GENUS, {204, 92, 72, 0} };

void X(codelet_hc2cb2_20) (planner *p) {
     X(khc2c_register) (p, hc2cb2_20, &desc, HC2C_VIA_RDFT);
}
#endif				/* HAVE_FMA */
