/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Oct  4 10:30:50 EDT 2008 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_r2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -n 6 -name r2hc_6 -include r2hc.h */

/*
 * This function contains 14 FP additions, 4 FP multiplications,
 * (or, 12 additions, 2 multiplications, 2 fused multiply/add),
 * 13 stack variables, and 12 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_r2hc.ml,v 1.18 2006-02-12 23:34:12 athena Exp $
 */

#include "r2hc.h"

static void r2hc_6(const R *I, R *ro, R *io, stride is, stride ros, stride ios, INT v, INT ivs, INT ovs)
{
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     INT i;
     for (i = v; i > 0; i = i - 1, I = I + ivs, ro = ro + ovs, io = io + ovs, MAKE_VOLATILE_STRIDE(is), MAKE_VOLATILE_STRIDE(ros), MAKE_VOLATILE_STRIDE(ios)) {
	  E T4, Td, T3, Tc, T9, T5;
	  {
	       E T1, T2, T7, T8;
	       T1 = I[0];
	       T2 = I[WS(is, 3)];
	       T7 = I[WS(is, 4)];
	       T8 = I[WS(is, 1)];
	       T4 = I[WS(is, 2)];
	       Td = T1 + T2;
	       T3 = T1 - T2;
	       Tc = T7 + T8;
	       T9 = T7 - T8;
	       T5 = I[WS(is, 5)];
	  }
	  {
	       E T6, Tb, Te, Ta;
	       T6 = T4 - T5;
	       Tb = T4 + T5;
	       Te = Tb + Tc;
	       io[WS(ios, 2)] = KP866025403 * (Tb - Tc);
	       Ta = T6 + T9;
	       io[WS(ios, 1)] = KP866025403 * (T9 - T6);
	       ro[0] = Td + Te;
	       ro[WS(ros, 2)] = FNMS(KP500000000, Te, Td);
	       ro[WS(ros, 3)] = T3 + Ta;
	       ro[WS(ros, 1)] = FNMS(KP500000000, Ta, T3);
	  }
     }
}

static const kr2hc_desc desc = { 6, "r2hc_6", {12, 2, 2, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_r2hc_6) (planner *p) {
     X(kr2hc_register) (p, r2hc_6, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_r2hc -compact -variables 4 -pipeline-latency 4 -n 6 -name r2hc_6 -include r2hc.h */

/*
 * This function contains 14 FP additions, 4 FP multiplications,
 * (or, 12 additions, 2 multiplications, 2 fused multiply/add),
 * 17 stack variables, and 12 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_r2hc.ml,v 1.18 2006-02-12 23:34:12 athena Exp $
 */

#include "r2hc.h"

static void r2hc_6(const R *I, R *ro, R *io, stride is, stride ros, stride ios, INT v, INT ivs, INT ovs)
{
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     INT i;
     for (i = v; i > 0; i = i - 1, I = I + ivs, ro = ro + ovs, io = io + ovs, MAKE_VOLATILE_STRIDE(is), MAKE_VOLATILE_STRIDE(ros), MAKE_VOLATILE_STRIDE(ios)) {
	  E T3, Td, T9, Tc, T6, Tb, T1, T2, Ta, Te;
	  T1 = I[0];
	  T2 = I[WS(is, 3)];
	  T3 = T1 - T2;
	  Td = T1 + T2;
	  {
	       E T7, T8, T4, T5;
	       T7 = I[WS(is, 4)];
	       T8 = I[WS(is, 1)];
	       T9 = T7 - T8;
	       Tc = T7 + T8;
	       T4 = I[WS(is, 2)];
	       T5 = I[WS(is, 5)];
	       T6 = T4 - T5;
	       Tb = T4 + T5;
	  }
	  io[WS(ios, 1)] = KP866025403 * (T9 - T6);
	  Ta = T6 + T9;
	  ro[WS(ros, 1)] = FNMS(KP500000000, Ta, T3);
	  ro[WS(ros, 3)] = T3 + Ta;
	  io[WS(ios, 2)] = KP866025403 * (Tb - Tc);
	  Te = Tb + Tc;
	  ro[WS(ros, 2)] = FNMS(KP500000000, Te, Td);
	  ro[0] = Td + Te;
     }
}

static const kr2hc_desc desc = { 6, "r2hc_6", {12, 2, 2, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_r2hc_6) (planner *p) {
     X(kr2hc_register) (p, r2hc_6, &desc);
}

#endif				/* HAVE_FMA */
