/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Oct  4 10:30:59 EDT 2008 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 16 -dit -name hf2_16 -include hf.h */

/*
 * This function contains 196 FP additions, 134 FP multiplications,
 * (or, 104 additions, 42 multiplications, 92 fused multiply/add),
 * 105 stack variables, and 64 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hf.h"

static const R *hf2_16(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 8, MAKE_VOLATILE_STRIDE(ios)) {
	  E T3S, T3R;
	  {
	       E T2, Tf, TM, TO, T3, Tg, TN, TS, T4, Tp, T6, T5, Th;
	       T2 = W[0];
	       Tf = W[2];
	       TM = W[6];
	       TO = W[7];
	       T3 = W[4];
	       Tg = T2 * Tf;
	       TN = T2 * TM;
	       TS = T2 * TO;
	       T4 = T2 * T3;
	       Tp = Tf * T3;
	       T6 = W[5];
	       T5 = W[1];
	       Th = W[3];
	       {
		    E Te, T1U, T3A, T3L, T2B, T3h, T2D, T1G, T3w, T1Z, T3M, Tx, T2I, T3i, T1R;
		    E T2w, T25, T37, TL, T26, T3d, T2t, T2m, T1s, T2d, T38, T12, T28, T18, T2k;
		    E T2i, T1c;
		    {
			 E TF, TP, TT, TW, Tz, TZ, TI, TC, T1m, T1f, T1p, T1j, T1L, T1O, T1H;
			 E T1P, T2G, T2E, T1M, T1K;
			 {
			      E Tq, Ti, Tu, Tm, T1D, T1E, T1x, T1B, T2y, T2A;
			      {
				   E T1, T7, Tb, T3z, T8, T1z, T9, Tc;
				   {
					E T1i, T1e, T1C, T1y, Tt, Ta, Tl;
					T1 = rio[0];
					Tt = Tf * T6;
					Ta = T2 * T6;
					T7 = FMA(T5, T6, T4);
					TF = FNMS(T5, T6, T4);
					TP = FMA(T5, TO, TN);
					TT = FNMS(T5, TM, TS);
					Tq = FNMS(Th, T6, Tp);
					TW = FMA(Th, T6, Tp);
					Tz = FMA(T5, Th, Tg);
					Ti = FNMS(T5, Th, Tg);
					Tl = T2 * Th;
					Tu = FMA(Th, T3, Tt);
					TZ = FNMS(Th, T3, Tt);
					TI = FMA(T5, T3, Ta);
					Tb = FNMS(T5, T3, Ta);
					T1i = Ti * T6;
					T1e = Ti * T3;
					T1C = Tz * T6;
					T1y = Tz * T3;
					Tm = FMA(T5, Tf, Tl);
					TC = FNMS(T5, Tf, Tl);
					T3z = iio[-WS(ios, 15)];
					T8 = rio[WS(ios, 8)];
					T1m = FNMS(Tm, T6, T1e);
					T1f = FMA(Tm, T6, T1e);
					T1p = FMA(Tm, T3, T1i);
					T1j = FNMS(Tm, T3, T1i);
					T1L = FNMS(TC, T6, T1y);
					T1z = FMA(TC, T6, T1y);
					T1O = FMA(TC, T3, T1C);
					T1D = FNMS(TC, T3, T1C);
					T9 = T7 * T8;
					Tc = iio[-WS(ios, 7)];
				   }
				   {
					E T1u, T1w, T1v, T2z, T3y, T2x, T1A, Td, T3x;
					T1u = rio[WS(ios, 15)];
					T1E = iio[-WS(ios, 8)];
					T1w = iio[0];
					Td = FMA(Tb, Tc, T9);
					T3x = T7 * Tc;
					T1v = TM * T1u;
					T2z = T1z * T1E;
					Te = T1 + Td;
					T1U = T1 - Td;
					T3y = FNMS(Tb, T8, T3x);
					T2x = TM * T1w;
					T1A = rio[WS(ios, 7)];
					T1x = FMA(TO, T1w, T1v);
					T3A = T3y + T3z;
					T3L = T3z - T3y;
					T1B = T1z * T1A;
					T2y = FNMS(TO, T1u, T2x);
					T2A = FNMS(T1D, T1A, T2z);
				   }
			      }
			      {
				   E Tj, Tv, Tk, T1X, Tn, Tr, T1F, T1I, T1J;
				   Tj = rio[WS(ios, 4)];
				   T1F = FMA(T1D, T1E, T1B);
				   Tv = iio[-WS(ios, 3)];
				   T2B = T2y - T2A;
				   T3h = T2y + T2A;
				   Tk = Ti * Tj;
				   T2D = T1x - T1F;
				   T1G = T1x + T1F;
				   T1X = Tq * Tv;
				   Tn = iio[-WS(ios, 11)];
				   Tr = rio[WS(ios, 12)];
				   {
					E To, T1Y, Ts, T1W, T1V, Tw;
					T1H = rio[WS(ios, 3)];
					T1P = iio[-WS(ios, 4)];
					To = FMA(Tm, Tn, Tk);
					T1V = Ti * Tn;
					T1Y = FNMS(Tu, Tr, T1X);
					Ts = Tq * Tr;
					T1I = Tf * T1H;
					T1W = FNMS(Tm, Tj, T1V);
					T2G = T1L * T1P;
					Tw = FMA(Tu, Tv, Ts);
					T1J = iio[-WS(ios, 12)];
					T3w = T1W + T1Y;
					T1Z = T1W - T1Y;
					T3M = To - Tw;
					Tx = To + Tw;
					T2E = Tf * T1J;
					T1M = rio[WS(ios, 11)];
				   }
				   T1K = FMA(Th, T1J, T1I);
			      }
			 }
			 {
			      E T1g, T1q, T1h, T2r, T1k, T1n;
			      {
				   E TE, T24, T22, TK;
				   {
					E TA, TB, TJ, T23, TD, TG, T21, TH;
					{
					     E T1Q, T2F, T2H, T1N;
					     TA = rio[WS(ios, 2)];
					     T2F = FNMS(Th, T1H, T2E);
					     T2H = FNMS(T1O, T1M, T2G);
					     T1N = T1L * T1M;
					     TB = Tz * TA;
					     TJ = iio[-WS(ios, 5)];
					     T2I = T2F - T2H;
					     T3i = T2F + T2H;
					     T1Q = FMA(T1O, T1P, T1N);
					     T23 = TF * TJ;
					     TD = iio[-WS(ios, 13)];
					     TG = rio[WS(ios, 10)];
					     T1R = T1K + T1Q;
					     T2w = T1Q - T1K;
					     T21 = Tz * TD;
					     TH = TF * TG;
					}
					TE = FMA(TC, TD, TB);
					T24 = FNMS(TI, TG, T23);
					T22 = FNMS(TC, TA, T21);
					TK = FMA(TI, TJ, TH);
				   }
				   T1g = rio[WS(ios, 5)];
				   T1q = iio[-WS(ios, 2)];
				   T25 = T22 - T24;
				   T37 = T22 + T24;
				   TL = TE + TK;
				   T26 = TE - TK;
				   T1h = T1f * T1g;
				   T2r = T1m * T1q;
				   T1k = iio[-WS(ios, 10)];
				   T1n = rio[WS(ios, 13)];
			      }
			      {
				   E TQ, T10, T2b, T29, TX, TV, TR, TU;
				   {
					E T1l, T2s, T1o, T2q, T2p, T1r;
					TQ = rio[WS(ios, 14)];
					T10 = iio[-WS(ios, 9)];
					T1l = FMA(T1j, T1k, T1h);
					T2p = T1f * T1k;
					T2s = FNMS(T1p, T1n, T2r);
					T1o = T1m * T1n;
					TR = TP * TQ;
					T2q = FNMS(T1j, T1g, T2p);
					T2b = TW * T10;
					T1r = FMA(T1p, T1q, T1o);
					TU = iio[-WS(ios, 1)];
					T3d = T2q + T2s;
					T2t = T2q - T2s;
					T2m = T1l - T1r;
					T1s = T1l + T1r;
					T29 = TP * TU;
					TX = rio[WS(ios, 6)];
				   }
				   TV = FMA(TT, TU, TR);
				   {
					E T15, T16, T1b, T2j, T17, T19, T2h, T1a;
					{
					     E T11, T2a, T2c, TY;
					     T15 = rio[WS(ios, 1)];
					     T2a = FNMS(TT, TQ, T29);
					     T2c = FNMS(TZ, TX, T2b);
					     TY = TW * TX;
					     T16 = T2 * T15;
					     T1b = iio[-WS(ios, 6)];
					     T2d = T2a - T2c;
					     T38 = T2a + T2c;
					     T11 = FMA(TZ, T10, TY);
					     T2j = T3 * T1b;
					     T17 = iio[-WS(ios, 14)];
					     T19 = rio[WS(ios, 9)];
					     T12 = TV + T11;
					     T28 = TV - T11;
					     T2h = T2 * T17;
					     T1a = T3 * T19;
					}
					T18 = FMA(T5, T17, T16);
					T2k = FNMS(T6, T19, T2j);
					T2i = FNMS(T5, T15, T2h);
					T1c = FMA(T6, T1b, T1a);
				   }
			      }
			 }
		    }
		    {
			 E T36, T3F, T2l, T2o, T3q, T14, T39, T3G, T3b, T3g, T3e, T3r, T3E, T3C, T3D;
			 E T1T, T3s, T3j;
			 {
			      E T3c, T1d, T3v, T3B, Ty, T13, T1t, T1S;
			      T36 = Te - Tx;
			      Ty = Te + Tx;
			      T13 = TL + T12;
			      T3F = T12 - TL;
			      T2l = T2i - T2k;
			      T3c = T2i + T2k;
			      T1d = T18 + T1c;
			      T2o = T18 - T1c;
			      T3q = Ty - T13;
			      T14 = Ty + T13;
			      T39 = T37 - T38;
			      T3v = T37 + T38;
			      T3B = T3w + T3A;
			      T3G = T3A - T3w;
			      T3b = T1d - T1s;
			      T1t = T1d + T1s;
			      T1S = T1G + T1R;
			      T3g = T1G - T1R;
			      T3e = T3c - T3d;
			      T3r = T3c + T3d;
			      T3E = T3B - T3v;
			      T3C = T3v + T3B;
			      T3D = T1S - T1t;
			      T1T = T1t + T1S;
			      T3s = T3h + T3i;
			      T3j = T3h - T3i;
			 }
			 {
			      E T3m, T3a, T3J, T3H, T3n, T3f, T3u, T3t;
			      iio[-WS(ios, 4)] = T3D + T3E;
			      rio[WS(ios, 12)] = T3D - T3E;
			      rio[0] = T14 + T1T;
			      iio[-WS(ios, 8)] = T14 - T1T;
			      T3u = T3r + T3s;
			      T3t = T3r - T3s;
			      iio[0] = T3u + T3C;
			      rio[WS(ios, 8)] = T3u - T3C;
			      rio[WS(ios, 4)] = T3q + T3t;
			      iio[-WS(ios, 12)] = T3q - T3t;
			      T3m = T36 - T39;
			      T3a = T36 + T39;
			      T3J = T3G - T3F;
			      T3H = T3F + T3G;
			      T3n = T3e - T3b;
			      T3f = T3b + T3e;
			      {
				   E T2Q, T20, T3N, T3T, T2J, T2C, T3O, T2f, T34, T30, T2W, T2V, T3U, T2T, T2N;
				   E T2v;
				   {
					E T2R, T27, T2e, T2S, T3o, T3k;
					T2Q = T1U + T1Z;
					T20 = T1U - T1Z;
					T3N = T3L - T3M;
					T3T = T3M + T3L;
					T3o = T3g + T3j;
					T3k = T3g - T3j;
					T2R = T26 + T25;
					T27 = T25 - T26;
					{
					     E T3p, T3I, T3K, T3l;
					     T3p = T3n - T3o;
					     T3I = T3n + T3o;
					     T3K = T3k - T3f;
					     T3l = T3f + T3k;
					     rio[WS(ios, 6)] = FMA(KP707106781, T3p, T3m);
					     iio[-WS(ios, 14)] = FNMS(KP707106781, T3p, T3m);
					     iio[-WS(ios, 2)] = FMA(KP707106781, T3I, T3H);
					     rio[WS(ios, 10)] = FMS(KP707106781, T3I, T3H);
					     iio[-WS(ios, 6)] = FMA(KP707106781, T3K, T3J);
					     rio[WS(ios, 14)] = FMS(KP707106781, T3K, T3J);
					     rio[WS(ios, 2)] = FMA(KP707106781, T3l, T3a);
					     iio[-WS(ios, 10)] = FNMS(KP707106781, T3l, T3a);
					     T2e = T28 + T2d;
					     T2S = T28 - T2d;
					}
					{
					     E T2Y, T2Z, T2n, T2u;
					     T2J = T2D - T2I;
					     T2Y = T2D + T2I;
					     T2Z = T2B + T2w;
					     T2C = T2w - T2B;
					     T3O = T27 + T2e;
					     T2f = T27 - T2e;
					     T34 = FMA(KP414213562, T2Y, T2Z);
					     T30 = FNMS(KP414213562, T2Z, T2Y);
					     T2W = T2l - T2m;
					     T2n = T2l + T2m;
					     T2u = T2o - T2t;
					     T2V = T2o + T2t;
					     T3U = T2S - T2R;
					     T2T = T2R + T2S;
					     T2N = FNMS(KP414213562, T2n, T2u);
					     T2v = FMA(KP414213562, T2u, T2n);
					}
				   }
				   {
					E T33, T2X, T3X, T3Y;
					{
					     E T2M, T2g, T2O, T2K, T3V, T3W, T2P, T2L;
					     T2M = FNMS(KP707106781, T2f, T20);
					     T2g = FMA(KP707106781, T2f, T20);
					     T33 = FNMS(KP414213562, T2V, T2W);
					     T2X = FMA(KP414213562, T2W, T2V);
					     T2O = FNMS(KP414213562, T2C, T2J);
					     T2K = FMA(KP414213562, T2J, T2C);
					     T3V = FMA(KP707106781, T3U, T3T);
					     T3X = FNMS(KP707106781, T3U, T3T);
					     T3W = T2O - T2N;
					     T2P = T2N + T2O;
					     T3Y = T2K - T2v;
					     T2L = T2v + T2K;
					     iio[-WS(ios, 3)] = FMA(KP923879532, T3W, T3V);
					     rio[WS(ios, 11)] = FMS(KP923879532, T3W, T3V);
					     rio[WS(ios, 3)] = FMA(KP923879532, T2L, T2g);
					     iio[-WS(ios, 11)] = FNMS(KP923879532, T2L, T2g);
					     iio[-WS(ios, 15)] = FMA(KP923879532, T2P, T2M);
					     rio[WS(ios, 7)] = FNMS(KP923879532, T2P, T2M);
					}
					{
					     E T32, T3P, T3Q, T35, T2U, T31;
					     T32 = FNMS(KP707106781, T2T, T2Q);
					     T2U = FMA(KP707106781, T2T, T2Q);
					     T31 = T2X + T30;
					     T3S = T30 - T2X;
					     T3R = FNMS(KP707106781, T3O, T3N);
					     T3P = FMA(KP707106781, T3O, T3N);
					     iio[-WS(ios, 7)] = FMA(KP923879532, T3Y, T3X);
					     rio[WS(ios, 15)] = FMS(KP923879532, T3Y, T3X);
					     rio[WS(ios, 1)] = FMA(KP923879532, T31, T2U);
					     iio[-WS(ios, 9)] = FNMS(KP923879532, T31, T2U);
					     T3Q = T33 + T34;
					     T35 = T33 - T34;
					     iio[-WS(ios, 1)] = FMA(KP923879532, T3Q, T3P);
					     rio[WS(ios, 9)] = FMS(KP923879532, T3Q, T3P);
					     rio[WS(ios, 5)] = FMA(KP923879532, T35, T32);
					     iio[-WS(ios, 13)] = FNMS(KP923879532, T35, T32);
					}
				   }
			      }
			 }
		    }
	       }
	  }
	  iio[-WS(ios, 5)] = FMA(KP923879532, T3S, T3R);
	  rio[WS(ios, 13)] = FMS(KP923879532, T3S, T3R);
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_CEXP, 0, 9},
     {TW_CEXP, 0, 15},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 16, "hf2_16", twinstr, &GENUS, {104, 42, 92, 0}, 0, 0, 0 };

void X(codelet_hf2_16) (planner *p) {
     X(khc2hc_register) (p, hf2_16, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 16 -dit -name hf2_16 -include hf.h */

/*
 * This function contains 196 FP additions, 108 FP multiplications,
 * (or, 156 additions, 68 multiplications, 40 fused multiply/add),
 * 82 stack variables, and 64 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hf.h"

static const R *hf2_16(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 8, MAKE_VOLATILE_STRIDE(ios)) {
	  E T2, T5, Tg, Ti, Tk, To, TE, TC, T6, T3, T8, TW, TJ, Tt, TU;
	  E Tc, Tx, TH, TN, TO, TP, TR, T1f, T1k, T1b, T1i, T1y, T1H, T1u, T1F;
	  {
	       E T7, Tv, Ta, Ts, T4, Tw, Tb, Tr;
	       {
		    E Th, Tn, Tj, Tm;
		    T2 = W[0];
		    T5 = W[1];
		    Tg = W[2];
		    Ti = W[3];
		    Th = T2 * Tg;
		    Tn = T5 * Tg;
		    Tj = T5 * Ti;
		    Tm = T2 * Ti;
		    Tk = Th - Tj;
		    To = Tm + Tn;
		    TE = Tm - Tn;
		    TC = Th + Tj;
		    T6 = W[5];
		    T7 = T5 * T6;
		    Tv = Tg * T6;
		    Ta = T2 * T6;
		    Ts = Ti * T6;
		    T3 = W[4];
		    T4 = T2 * T3;
		    Tw = Ti * T3;
		    Tb = T5 * T3;
		    Tr = Tg * T3;
	       }
	       T8 = T4 + T7;
	       TW = Tv - Tw;
	       TJ = Ta + Tb;
	       Tt = Tr - Ts;
	       TU = Tr + Ts;
	       Tc = Ta - Tb;
	       Tx = Tv + Tw;
	       TH = T4 - T7;
	       TN = W[6];
	       TO = W[7];
	       TP = FMA(T2, TN, T5 * TO);
	       TR = FNMS(T5, TN, T2 * TO);
	       {
		    E T1d, T1e, T19, T1a;
		    T1d = Tk * T6;
		    T1e = To * T3;
		    T1f = T1d - T1e;
		    T1k = T1d + T1e;
		    T19 = Tk * T3;
		    T1a = To * T6;
		    T1b = T19 + T1a;
		    T1i = T19 - T1a;
	       }
	       {
		    E T1w, T1x, T1s, T1t;
		    T1w = TC * T6;
		    T1x = TE * T3;
		    T1y = T1w - T1x;
		    T1H = T1w + T1x;
		    T1s = TC * T3;
		    T1t = TE * T6;
		    T1u = T1s + T1t;
		    T1F = T1s - T1t;
	       }
	  }
	  {
	       E Tf, T3r, T1N, T3e, TA, T3s, T1Q, T3b, TM, T2M, T1W, T2w, TZ, T2N, T21;
	       E T2x, T18, T1n, T2Q, T2R, T2S, T2T, T28, T2A, T2d, T2B, T1B, T1K, T2V, T2W;
	       E T2X, T2Y, T2j, T2D, T2o, T2E;
	       {
		    E T1, T3d, Te, T3c, T9, Td;
		    T1 = rio[0];
		    T3d = iio[-WS(ios, 15)];
		    T9 = rio[WS(ios, 8)];
		    Td = iio[-WS(ios, 7)];
		    Te = FMA(T8, T9, Tc * Td);
		    T3c = FNMS(Tc, T9, T8 * Td);
		    Tf = T1 + Te;
		    T3r = T3d - T3c;
		    T1N = T1 - Te;
		    T3e = T3c + T3d;
	       }
	       {
		    E Tq, T1O, Tz, T1P;
		    {
			 E Tl, Tp, Tu, Ty;
			 Tl = rio[WS(ios, 4)];
			 Tp = iio[-WS(ios, 11)];
			 Tq = FMA(Tk, Tl, To * Tp);
			 T1O = FNMS(To, Tl, Tk * Tp);
			 Tu = rio[WS(ios, 12)];
			 Ty = iio[-WS(ios, 3)];
			 Tz = FMA(Tt, Tu, Tx * Ty);
			 T1P = FNMS(Tx, Tu, Tt * Ty);
		    }
		    TA = Tq + Tz;
		    T3s = Tq - Tz;
		    T1Q = T1O - T1P;
		    T3b = T1O + T1P;
	       }
	       {
		    E TG, T1S, TL, T1T, T1U, T1V;
		    {
			 E TD, TF, TI, TK;
			 TD = rio[WS(ios, 2)];
			 TF = iio[-WS(ios, 13)];
			 TG = FMA(TC, TD, TE * TF);
			 T1S = FNMS(TE, TD, TC * TF);
			 TI = rio[WS(ios, 10)];
			 TK = iio[-WS(ios, 5)];
			 TL = FMA(TH, TI, TJ * TK);
			 T1T = FNMS(TJ, TI, TH * TK);
		    }
		    TM = TG + TL;
		    T2M = T1S + T1T;
		    T1U = T1S - T1T;
		    T1V = TG - TL;
		    T1W = T1U - T1V;
		    T2w = T1V + T1U;
	       }
	       {
		    E TT, T1Y, TY, T1Z, T1X, T20;
		    {
			 E TQ, TS, TV, TX;
			 TQ = rio[WS(ios, 14)];
			 TS = iio[-WS(ios, 1)];
			 TT = FMA(TP, TQ, TR * TS);
			 T1Y = FNMS(TR, TQ, TP * TS);
			 TV = rio[WS(ios, 6)];
			 TX = iio[-WS(ios, 9)];
			 TY = FMA(TU, TV, TW * TX);
			 T1Z = FNMS(TW, TV, TU * TX);
		    }
		    TZ = TT + TY;
		    T2N = T1Y + T1Z;
		    T1X = TT - TY;
		    T20 = T1Y - T1Z;
		    T21 = T1X + T20;
		    T2x = T1X - T20;
	       }
	       {
		    E T14, T24, T1m, T2b, T17, T25, T1h, T2a;
		    {
			 E T12, T13, T1j, T1l;
			 T12 = rio[WS(ios, 1)];
			 T13 = iio[-WS(ios, 14)];
			 T14 = FMA(T2, T12, T5 * T13);
			 T24 = FNMS(T5, T12, T2 * T13);
			 T1j = rio[WS(ios, 13)];
			 T1l = iio[-WS(ios, 2)];
			 T1m = FMA(T1i, T1j, T1k * T1l);
			 T2b = FNMS(T1k, T1j, T1i * T1l);
		    }
		    {
			 E T15, T16, T1c, T1g;
			 T15 = rio[WS(ios, 9)];
			 T16 = iio[-WS(ios, 6)];
			 T17 = FMA(T3, T15, T6 * T16);
			 T25 = FNMS(T6, T15, T3 * T16);
			 T1c = rio[WS(ios, 5)];
			 T1g = iio[-WS(ios, 10)];
			 T1h = FMA(T1b, T1c, T1f * T1g);
			 T2a = FNMS(T1f, T1c, T1b * T1g);
		    }
		    T18 = T14 + T17;
		    T1n = T1h + T1m;
		    T2Q = T18 - T1n;
		    T2R = T24 + T25;
		    T2S = T2a + T2b;
		    T2T = T2R - T2S;
		    {
			 E T26, T27, T29, T2c;
			 T26 = T24 - T25;
			 T27 = T1h - T1m;
			 T28 = T26 + T27;
			 T2A = T26 - T27;
			 T29 = T14 - T17;
			 T2c = T2a - T2b;
			 T2d = T29 - T2c;
			 T2B = T29 + T2c;
		    }
	       }
	       {
		    E T1r, T2k, T1J, T2h, T1A, T2l, T1E, T2g;
		    {
			 E T1p, T1q, T1G, T1I;
			 T1p = rio[WS(ios, 15)];
			 T1q = iio[0];
			 T1r = FMA(TN, T1p, TO * T1q);
			 T2k = FNMS(TO, T1p, TN * T1q);
			 T1G = rio[WS(ios, 11)];
			 T1I = iio[-WS(ios, 4)];
			 T1J = FMA(T1F, T1G, T1H * T1I);
			 T2h = FNMS(T1H, T1G, T1F * T1I);
		    }
		    {
			 E T1v, T1z, T1C, T1D;
			 T1v = rio[WS(ios, 7)];
			 T1z = iio[-WS(ios, 8)];
			 T1A = FMA(T1u, T1v, T1y * T1z);
			 T2l = FNMS(T1y, T1v, T1u * T1z);
			 T1C = rio[WS(ios, 3)];
			 T1D = iio[-WS(ios, 12)];
			 T1E = FMA(Tg, T1C, Ti * T1D);
			 T2g = FNMS(Ti, T1C, Tg * T1D);
		    }
		    T1B = T1r + T1A;
		    T1K = T1E + T1J;
		    T2V = T1B - T1K;
		    T2W = T2k + T2l;
		    T2X = T2g + T2h;
		    T2Y = T2W - T2X;
		    {
			 E T2f, T2i, T2m, T2n;
			 T2f = T1r - T1A;
			 T2i = T2g - T2h;
			 T2j = T2f - T2i;
			 T2D = T2f + T2i;
			 T2m = T2k - T2l;
			 T2n = T1E - T1J;
			 T2o = T2m + T2n;
			 T2E = T2m - T2n;
		    }
	       }
	       {
		    E T23, T2r, T3A, T3C, T2q, T3B, T2u, T3x;
		    {
			 E T1R, T22, T3y, T3z;
			 T1R = T1N - T1Q;
			 T22 = KP707106781 * (T1W - T21);
			 T23 = T1R + T22;
			 T2r = T1R - T22;
			 T3y = KP707106781 * (T2x - T2w);
			 T3z = T3s + T3r;
			 T3A = T3y + T3z;
			 T3C = T3z - T3y;
		    }
		    {
			 E T2e, T2p, T2s, T2t;
			 T2e = FMA(KP923879532, T28, KP382683432 * T2d);
			 T2p = FNMS(KP923879532, T2o, KP382683432 * T2j);
			 T2q = T2e + T2p;
			 T3B = T2p - T2e;
			 T2s = FNMS(KP923879532, T2d, KP382683432 * T28);
			 T2t = FMA(KP382683432, T2o, KP923879532 * T2j);
			 T2u = T2s - T2t;
			 T3x = T2s + T2t;
		    }
		    iio[-WS(ios, 11)] = T23 - T2q;
		    rio[WS(ios, 11)] = T3x - T3A;
		    rio[WS(ios, 3)] = T23 + T2q;
		    iio[-WS(ios, 3)] = T3x + T3A;
		    iio[-WS(ios, 15)] = T2r - T2u;
		    rio[WS(ios, 15)] = T3B - T3C;
		    rio[WS(ios, 7)] = T2r + T2u;
		    iio[-WS(ios, 7)] = T3B + T3C;
	       }
	       {
		    E T2P, T31, T3m, T3o, T30, T3n, T34, T3j;
		    {
			 E T2L, T2O, T3k, T3l;
			 T2L = Tf - TA;
			 T2O = T2M - T2N;
			 T2P = T2L + T2O;
			 T31 = T2L - T2O;
			 T3k = TZ - TM;
			 T3l = T3e - T3b;
			 T3m = T3k + T3l;
			 T3o = T3l - T3k;
		    }
		    {
			 E T2U, T2Z, T32, T33;
			 T2U = T2Q + T2T;
			 T2Z = T2V - T2Y;
			 T30 = KP707106781 * (T2U + T2Z);
			 T3n = KP707106781 * (T2Z - T2U);
			 T32 = T2T - T2Q;
			 T33 = T2V + T2Y;
			 T34 = KP707106781 * (T32 - T33);
			 T3j = KP707106781 * (T32 + T33);
		    }
		    iio[-WS(ios, 10)] = T2P - T30;
		    rio[WS(ios, 10)] = T3j - T3m;
		    rio[WS(ios, 2)] = T2P + T30;
		    iio[-WS(ios, 2)] = T3j + T3m;
		    iio[-WS(ios, 14)] = T31 - T34;
		    rio[WS(ios, 14)] = T3n - T3o;
		    rio[WS(ios, 6)] = T31 + T34;
		    iio[-WS(ios, 6)] = T3n + T3o;
	       }
	       {
		    E T2z, T2H, T3u, T3w, T2G, T3v, T2K, T3p;
		    {
			 E T2v, T2y, T3q, T3t;
			 T2v = T1N + T1Q;
			 T2y = KP707106781 * (T2w + T2x);
			 T2z = T2v + T2y;
			 T2H = T2v - T2y;
			 T3q = KP707106781 * (T1W + T21);
			 T3t = T3r - T3s;
			 T3u = T3q + T3t;
			 T3w = T3t - T3q;
		    }
		    {
			 E T2C, T2F, T2I, T2J;
			 T2C = FMA(KP382683432, T2A, KP923879532 * T2B);
			 T2F = FNMS(KP382683432, T2E, KP923879532 * T2D);
			 T2G = T2C + T2F;
			 T3v = T2F - T2C;
			 T2I = FNMS(KP382683432, T2B, KP923879532 * T2A);
			 T2J = FMA(KP923879532, T2E, KP382683432 * T2D);
			 T2K = T2I - T2J;
			 T3p = T2I + T2J;
		    }
		    iio[-WS(ios, 9)] = T2z - T2G;
		    rio[WS(ios, 9)] = T3p - T3u;
		    rio[WS(ios, 1)] = T2z + T2G;
		    iio[-WS(ios, 1)] = T3p + T3u;
		    iio[-WS(ios, 13)] = T2H - T2K;
		    rio[WS(ios, 13)] = T3v - T3w;
		    rio[WS(ios, 5)] = T2H + T2K;
		    iio[-WS(ios, 5)] = T3v + T3w;
	       }
	       {
		    E T11, T35, T3g, T3i, T1M, T3h, T38, T39;
		    {
			 E TB, T10, T3a, T3f;
			 TB = Tf + TA;
			 T10 = TM + TZ;
			 T11 = TB + T10;
			 T35 = TB - T10;
			 T3a = T2M + T2N;
			 T3f = T3b + T3e;
			 T3g = T3a + T3f;
			 T3i = T3f - T3a;
		    }
		    {
			 E T1o, T1L, T36, T37;
			 T1o = T18 + T1n;
			 T1L = T1B + T1K;
			 T1M = T1o + T1L;
			 T3h = T1L - T1o;
			 T36 = T2R + T2S;
			 T37 = T2W + T2X;
			 T38 = T36 - T37;
			 T39 = T36 + T37;
		    }
		    iio[-WS(ios, 8)] = T11 - T1M;
		    rio[WS(ios, 8)] = T39 - T3g;
		    rio[0] = T11 + T1M;
		    iio[0] = T39 + T3g;
		    iio[-WS(ios, 12)] = T35 - T38;
		    rio[WS(ios, 12)] = T3h - T3i;
		    rio[WS(ios, 4)] = T35 + T38;
		    iio[-WS(ios, 4)] = T3h + T3i;
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_CEXP, 0, 9},
     {TW_CEXP, 0, 15},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 16, "hf2_16", twinstr, &GENUS, {156, 68, 40, 0}, 0, 0, 0 };

void X(codelet_hf2_16) (planner *p) {
     X(khc2hc_register) (p, hf2_16, &desc);
}
#endif				/* HAVE_FMA */
