/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Oct  4 10:35:36 EDT 2008 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 64 -dif -name hb_64 -include hb.h */

/*
 * This function contains 1038 FP additions, 644 FP multiplications,
 * (or, 520 additions, 126 multiplications, 518 fused multiply/add),
 * 234 stack variables, and 256 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hb.h"

static const R *hb_64(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 126, MAKE_VOLATILE_STRIDE(ios)) {
	  E Tgv, Tgs, Tgr;
	  {
	       E T8v, Ta9, Tv, T9O, Tj7, TgN, TjA, ThQ, Tj6, ThN, T6y, T2v, T64, T2c, T6x;
	       E T4L, TeV, Tbv, Tfn, Tbg, Tjz, TgG, T65, T4O, T96, T7S, Ta8, T8y, Tfo, TdE;
	       E TeU, TdB, T10, Ta7, T9R, TaN, T2P, T4Q, T8A, T7X, T4R, T38, T8B, T82, T6A;
	       E T69, T6B, T6c, TeZ, Tfq, TdG, TbP, Tjb, TjC, ThS, TgV, Tf2, Tfr, TdH, Tc8;
	       E Tje, TjD, ThT, Th2, T9T, T1w, T9a, T8e, TaF, T9W, T99, T89, T6k, T7a, T5p;
	       E T3D, T6h, T79, T5q, T3Q, Tf7, Tg0, Teg, TcB, Tfa, TfZ, Tef, TcM, Tjj, Tkc;
	       E Tis, Thf, Tjm, Tkb, Tir, Thm, T21, T9Y, T9d, T8p, TaG, Ta1, T9c, T8k, T6r;
	       E T7d, T5s, T4k, T6o, T7c, T5t, T4x, Tfe, Tg3, Tej, Tde, Thq, Tjr, Tfh, Tg2;
	       E Tei, Tdp, ThC, ThD, Tjo, ThB, Tjp, Thx;
	       {
		    E Tc3, TgW, TgZ, TgX, Tc0, Tf1, Tc6, Th0, TdA, Tdx;
		    {
			 E Tdw, T4G, Tb7, T4J, Tb6, Tdv, T24, T7, T27, T2a, Tbe, Tdy, Tbb, Tdz, Te;
			 E T4D, Tbt, TgK, T2m, Tt, Tbq, TgL, T7Q, T2t, Tj, Tbh, Ti, Tbl, T2g, Tk;
			 E T2h, T2i;
			 {
			      E T1, T2, T4, T5;
			      {
				   E T4E, T4F, T4H, T4I;
				   T4E = iio[0];
				   T4F = rio[WS(ios, 32)];
				   T4H = iio[-WS(ios, 16)];
				   T4I = rio[WS(ios, 48)];
				   T1 = rio[0];
				   Tdw = T4E + T4F;
				   T4G = T4E - T4F;
				   Tb7 = T4H + T4I;
				   T4J = T4H - T4I;
				   T2 = iio[-WS(ios, 32)];
				   T4 = rio[WS(ios, 16)];
				   T5 = iio[-WS(ios, 48)];
			      }
			      {
				   E Ta, Tba, Tb9, Td;
				   {
					E Tbc, T28, Tbd, T29, Tb, Tc, T8, T9;
					{
					     E T25, T3, T6, T26;
					     T25 = iio[-WS(ios, 8)];
					     Tb6 = T1 - T2;
					     T3 = T1 + T2;
					     Tdv = T4 - T5;
					     T6 = T4 + T5;
					     T26 = rio[WS(ios, 40)];
					     T8 = rio[WS(ios, 8)];
					     T9 = iio[-WS(ios, 40)];
					     T24 = T3 - T6;
					     T7 = T3 + T6;
					     Tbc = T25 + T26;
					     T27 = T25 - T26;
					}
					T28 = iio[-WS(ios, 24)];
					Tbd = T8 - T9;
					Ta = T8 + T9;
					T29 = rio[WS(ios, 56)];
					Tb = iio[-WS(ios, 56)];
					Tc = rio[WS(ios, 24)];
					Tba = T29 + T28;
					T2a = T28 - T29;
					Tbe = Tbc - Tbd;
					Tdy = Tbd + Tbc;
					Tb9 = Tb - Tc;
					Td = Tb + Tc;
				   }
				   Tbb = Tb9 - Tba;
				   Tdz = Tb9 + Tba;
				   Te = Ta + Td;
				   T4D = Td - Ta;
				   {
					E Tq, Tbo, Tp, Tbs, T2p, Tr, T2q, T2r;
					{
					     E Tn, To, T2n, T2o;
					     Tn = iio[-WS(ios, 60)];
					     To = rio[WS(ios, 28)];
					     T2n = iio[-WS(ios, 28)];
					     T2o = rio[WS(ios, 60)];
					     Tq = rio[WS(ios, 12)];
					     Tbo = Tn - To;
					     Tp = Tn + To;
					     Tbs = T2o + T2n;
					     T2p = T2n - T2o;
					     Tr = iio[-WS(ios, 44)];
					     T2q = iio[-WS(ios, 12)];
					     T2r = rio[WS(ios, 44)];
					}
					{
					     E Tg, Th, T2e, T2f;
					     Tg = rio[WS(ios, 4)];
					     {
						  E Tbr, Ts, Tbp, T2s;
						  Tbr = Tq - Tr;
						  Ts = Tq + Tr;
						  Tbp = T2q + T2r;
						  T2s = T2q - T2r;
						  Tbt = Tbr - Tbs;
						  TgK = Tbr + Tbs;
						  T2m = Tp - Ts;
						  Tt = Tp + Ts;
						  Tbq = Tbo - Tbp;
						  TgL = Tbo + Tbp;
						  T7Q = T2p + T2s;
						  T2t = T2p - T2s;
						  Th = iio[-WS(ios, 36)];
					     }
					     T2e = iio[-WS(ios, 4)];
					     T2f = rio[WS(ios, 36)];
					     Tj = rio[WS(ios, 20)];
					     Tbh = Tg - Th;
					     Ti = Tg + Th;
					     Tbl = T2e + T2f;
					     T2g = T2e - T2f;
					     Tk = iio[-WS(ios, 52)];
					     T2h = iio[-WS(ios, 20)];
					     T2i = rio[WS(ios, 52)];
					}
				   }
			      }
			 }
			 {
			      E T7O, Tbm, Tbj, T7R, Tb8, T4M, T2l, T2u, T4N, T2b, T8x;
			      {
				   E T2d, T2k, ThO, TgJ, TgM, ThP, ThL, ThM;
				   {
					E Tf, TgH, TgI, Tu, T7P;
					T7O = T7 - Te;
					Tf = T7 + Te;
					{
					     E Tbk, Tl, Tbi, T2j, Tm;
					     Tbk = Tj - Tk;
					     Tl = Tj + Tk;
					     Tbi = T2h + T2i;
					     T2j = T2h - T2i;
					     Tbm = Tbk + Tbl;
					     TgH = Tbl - Tbk;
					     T2d = Ti - Tl;
					     Tm = Ti + Tl;
					     Tbj = Tbh - Tbi;
					     TgI = Tbh + Tbi;
					     T7P = T2g + T2j;
					     T2k = T2g - T2j;
					     T8v = Tt - Tm;
					     Tu = Tm + Tt;
					}
					Ta9 = T7P + T7Q;
					T7R = T7P - T7Q;
					ThO = FMA(KP414213562, TgH, TgI);
					TgJ = FNMS(KP414213562, TgI, TgH);
					TgM = FNMS(KP414213562, TgL, TgK);
					ThP = FMA(KP414213562, TgK, TgL);
					Tv = Tf + Tu;
					T9O = Tf - Tu;
				   }
				   Tj7 = TgJ + TgM;
				   TgN = TgJ - TgM;
				   Tb8 = Tb6 - Tb7;
				   ThL = Tb6 + Tb7;
				   ThM = Tdy + Tdz;
				   TdA = Tdy - Tdz;
				   T4M = T2k - T2d;
				   T2l = T2d + T2k;
				   TjA = ThO - ThP;
				   ThQ = ThO + ThP;
				   Tj6 = FNMS(KP707106781, ThM, ThL);
				   ThN = FMA(KP707106781, ThM, ThL);
				   T2u = T2m - T2t;
				   T4N = T2m + T2t;
				   T2b = T27 - T2a;
				   T8x = T27 + T2a;
			      }
			      {
				   E T8w, TdC, TdD, Tbf, TgF, TgE, T4K, Tbn, Tbu;
				   T6y = T2l - T2u;
				   T2v = T2l + T2u;
				   T64 = T24 - T2b;
				   T2c = T24 + T2b;
				   T4K = T4G - T4J;
				   T8w = T4G + T4J;
				   TdC = FMA(KP414213562, Tbj, Tbm);
				   Tbn = FNMS(KP414213562, Tbm, Tbj);
				   Tbu = FMA(KP414213562, Tbt, Tbq);
				   TdD = FNMS(KP414213562, Tbq, Tbt);
				   T6x = T4K - T4D;
				   T4L = T4D + T4K;
				   TeV = Tbu - Tbn;
				   Tbv = Tbn + Tbu;
				   Tbf = Tbb - Tbe;
				   TgF = Tbe + Tbb;
				   Tdx = Tdv + Tdw;
				   TgE = Tdw - Tdv;
				   Tfn = FNMS(KP707106781, Tbf, Tb8);
				   Tbg = FMA(KP707106781, Tbf, Tb8);
				   Tjz = FNMS(KP707106781, TgF, TgE);
				   TgG = FMA(KP707106781, TgF, TgE);
				   T65 = T4N - T4M;
				   T4O = T4M + T4N;
				   T96 = T7O - T7R;
				   T7S = T7O + T7R;
				   Ta8 = T8x + T8w;
				   T8y = T8w - T8x;
				   Tfo = TdC - TdD;
				   TdE = TdC + TdD;
			      }
			 }
		    }
		    {
			 E TbK, TgP, T2x, TC, Tbz, TgS, T7U, T2N, TbV, Tc4, TY, T2Z, Tc5, TbY, T2X;
			 E T80, TbF, TbL, TJ, T2G, TbM, TbC, T2E, T7V, TbQ, TN, T33, Tc2, T32, Tc1;
			 E TQ, T34;
			 {
			      E T2T, TbW, T2W, TbX;
			      {
				   E Tbx, Ty, T2K, TbJ, T2J, TbI, TB, T2L;
				   {
					E T2H, T2I, Tw, Tx, Tz, TA;
					Tw = rio[WS(ios, 2)];
					Tx = iio[-WS(ios, 34)];
					T2H = iio[-WS(ios, 2)];
					TeU = FNMS(KP707106781, TdA, Tdx);
					TdB = FMA(KP707106781, TdA, Tdx);
					Tbx = Tw - Tx;
					Ty = Tw + Tx;
					T2I = rio[WS(ios, 34)];
					Tz = rio[WS(ios, 18)];
					TA = iio[-WS(ios, 50)];
					T2K = iio[-WS(ios, 18)];
					TbJ = T2H + T2I;
					T2J = T2H - T2I;
					TbI = Tz - TA;
					TB = Tz + TA;
					T2L = rio[WS(ios, 50)];
				   }
				   {
					E TbT, TU, T2U, TbU, TX, T2V;
					{
					     E T2R, T2S, TV, TW;
					     {
						  E TS, Tby, T2M, TT;
						  TS = rio[WS(ios, 6)];
						  TbK = TbI + TbJ;
						  TgP = TbJ - TbI;
						  T2x = Ty - TB;
						  TC = Ty + TB;
						  Tby = T2K + T2L;
						  T2M = T2K - T2L;
						  TT = iio[-WS(ios, 38)];
						  T2R = iio[-WS(ios, 6)];
						  Tbz = Tbx - Tby;
						  TgS = Tbx + Tby;
						  T7U = T2J + T2M;
						  T2N = T2J - T2M;
						  TbT = TS - TT;
						  TU = TS + TT;
						  T2S = rio[WS(ios, 38)];
					     }
					     TV = iio[-WS(ios, 54)];
					     TW = rio[WS(ios, 22)];
					     T2U = iio[-WS(ios, 22)];
					     TbU = T2R + T2S;
					     T2T = T2R - T2S;
					     TbW = TV - TW;
					     TX = TV + TW;
					     T2V = rio[WS(ios, 54)];
					}
					TbV = TbT - TbU;
					Tc4 = TbT + TbU;
					TY = TU + TX;
					T2Z = TX - TU;
					T2W = T2U - T2V;
					TbX = T2V + T2U;
				   }
			      }
			      {
				   E T2A, TbA, T2D, TbB;
				   {
					E TbE, TF, T2B, TbD, TI, T2C;
					{
					     E T2y, T2z, TD, TE, TG, TH;
					     TD = rio[WS(ios, 10)];
					     TE = iio[-WS(ios, 42)];
					     Tc5 = TbW + TbX;
					     TbY = TbW - TbX;
					     T2X = T2T - T2W;
					     T80 = T2T + T2W;
					     TbE = TD - TE;
					     TF = TD + TE;
					     T2y = iio[-WS(ios, 10)];
					     T2z = rio[WS(ios, 42)];
					     TG = iio[-WS(ios, 58)];
					     TH = rio[WS(ios, 26)];
					     T2B = iio[-WS(ios, 26)];
					     TbD = T2y + T2z;
					     T2A = T2y - T2z;
					     TbA = TG - TH;
					     TI = TG + TH;
					     T2C = rio[WS(ios, 58)];
					}
					TbF = TbD - TbE;
					TbL = TbE + TbD;
					TJ = TF + TI;
					T2G = TI - TF;
					T2D = T2B - T2C;
					TbB = T2C + T2B;
				   }
				   {
					E T30, T31, TL, TM, TO, TP;
					TL = iio[-WS(ios, 62)];
					TM = rio[WS(ios, 30)];
					TbM = TbA + TbB;
					TbC = TbA - TbB;
					T2E = T2A - T2D;
					T7V = T2A + T2D;
					TbQ = TL - TM;
					TN = TL + TM;
					T30 = iio[-WS(ios, 30)];
					T31 = rio[WS(ios, 62)];
					TO = rio[WS(ios, 14)];
					TP = iio[-WS(ios, 46)];
					T33 = iio[-WS(ios, 14)];
					Tc2 = T31 + T30;
					T32 = T30 - T31;
					Tc1 = TO - TP;
					TQ = TO + TP;
					T34 = rio[WS(ios, 46)];
				   }
			      }
			 }
			 {
			      E T7Y, TbS, T67, T81, T68, T6a, T2Y, T37, T6b;
			      {
				   E T7T, T2Q, T9P, T7W, T36, T2F, T9Q, T2O;
				   {
					E TK, TR, TbR, T35, T7Z, TZ;
					T7T = TC - TJ;
					TK = TC + TJ;
					Tc3 = Tc1 - Tc2;
					TgW = Tc1 + Tc2;
					T2Q = TN - TQ;
					TR = TN + TQ;
					TbR = T33 + T34;
					T35 = T33 - T34;
					T9P = T7V + T7U;
					T7W = T7U - T7V;
					T7Y = TR - TY;
					TZ = TR + TY;
					TbS = TbQ - TbR;
					TgZ = TbQ + TbR;
					T7Z = T32 + T35;
					T36 = T32 - T35;
					T10 = TK + TZ;
					Ta7 = TZ - TK;
					T67 = T2x - T2E;
					T2F = T2x + T2E;
					T9Q = T80 + T7Z;
					T81 = T7Z - T80;
					T68 = T2N - T2G;
					T2O = T2G + T2N;
				   }
				   T9R = T9P - T9Q;
				   TaN = T9P + T9Q;
				   T2P = FMA(KP414213562, T2O, T2F);
				   T4Q = FNMS(KP414213562, T2F, T2O);
				   T8A = T7W - T7T;
				   T7X = T7T + T7W;
				   T6a = T2Q - T2X;
				   T2Y = T2Q + T2X;
				   T37 = T2Z + T36;
				   T6b = T36 - T2Z;
			      }
			      {
				   E TgQ, TbH, TeY, TbN, TgT, TbG, TbZ, TeX, TbO;
				   T4R = FMA(KP414213562, T2Y, T37);
				   T38 = FNMS(KP414213562, T37, T2Y);
				   T8B = T7Y + T81;
				   T82 = T7Y - T81;
				   TgQ = TbF + TbC;
				   TbG = TbC - TbF;
				   T6A = FMA(KP414213562, T67, T68);
				   T69 = FNMS(KP414213562, T68, T67);
				   T6B = FNMS(KP414213562, T6a, T6b);
				   T6c = FMA(KP414213562, T6b, T6a);
				   TbH = FMA(KP707106781, TbG, Tbz);
				   TeY = FNMS(KP707106781, TbG, Tbz);
				   TbN = TbL - TbM;
				   TgT = TbL + TbM;
				   TgX = TbV - TbY;
				   TbZ = TbV + TbY;
				   TeX = FNMS(KP707106781, TbN, TbK);
				   TbO = FMA(KP707106781, TbN, TbK);
				   {
					E Tja, TgR, Tj9, TgU;
					Tja = FNMS(KP707106781, TgQ, TgP);
					TgR = FMA(KP707106781, TgQ, TgP);
					Tj9 = FNMS(KP707106781, TgT, TgS);
					TgU = FMA(KP707106781, TgT, TgS);
					TeZ = FNMS(KP668178637, TeY, TeX);
					Tfq = FMA(KP668178637, TeX, TeY);
					TdG = FMA(KP198912367, TbH, TbO);
					TbP = FNMS(KP198912367, TbO, TbH);
					Tjb = FNMS(KP668178637, Tja, Tj9);
					TjC = FMA(KP668178637, Tj9, Tja);
					ThS = FMA(KP198912367, TgR, TgU);
					TgV = FNMS(KP198912367, TgU, TgR);
					Tc0 = FMA(KP707106781, TbZ, TbS);
					Tf1 = FNMS(KP707106781, TbZ, TbS);
				   }
				   Tc6 = Tc4 - Tc5;
				   Th0 = Tc4 + Tc5;
			      }
			 }
		    }
		    {
			 E Th7, Tjk, Thj, Thk, Tjh, Thi, Tji, The;
			 {
			      E TcE, Th5, T3b, T18, Tcd, Thg, T8b, T3L, Tcy, Thb, T3t, T1u, Tcv, Thc, T87;
			      E T3A, Tcj, TcF, T1f, T3E, TcG, Tcg, T8c, T3i, T1k, Tcm, T1j, Tcq, T3n, T1l;
			      E T3o, T3p;
			      {
				   E T1r, Tct, T1q, Tcx, T3w, T1s, T3x, T3y;
				   {
					E T15, Tcb, T14, TcD, T3H, T16, T3I, T3J;
					{
					     E T12, T13, T3F, T3G, Tf0, Tc7;
					     T12 = rio[WS(ios, 1)];
					     Tf0 = FNMS(KP707106781, Tc6, Tc3);
					     Tc7 = FMA(KP707106781, Tc6, Tc3);
					     {
						  E Tjd, TgY, Tjc, Th1;
						  Tjd = FNMS(KP707106781, TgX, TgW);
						  TgY = FMA(KP707106781, TgX, TgW);
						  Tjc = FNMS(KP707106781, Th0, TgZ);
						  Th1 = FMA(KP707106781, Th0, TgZ);
						  Tf2 = FMA(KP668178637, Tf1, Tf0);
						  Tfr = FNMS(KP668178637, Tf0, Tf1);
						  TdH = FNMS(KP198912367, Tc0, Tc7);
						  Tc8 = FMA(KP198912367, Tc7, Tc0);
						  Tje = FNMS(KP668178637, Tjd, Tjc);
						  TjD = FMA(KP668178637, Tjc, Tjd);
						  ThT = FMA(KP198912367, TgY, Th1);
						  Th2 = FNMS(KP198912367, Th1, TgY);
						  T13 = iio[-WS(ios, 33)];
					     }
					     T3F = iio[-WS(ios, 1)];
					     T3G = rio[WS(ios, 33)];
					     T15 = rio[WS(ios, 17)];
					     Tcb = T12 - T13;
					     T14 = T12 + T13;
					     TcD = T3F + T3G;
					     T3H = T3F - T3G;
					     T16 = iio[-WS(ios, 49)];
					     T3I = iio[-WS(ios, 17)];
					     T3J = rio[WS(ios, 49)];
					}
					{
					     E T1o, T1p, T3u, T3v;
					     T1o = iio[-WS(ios, 61)];
					     {
						  E TcC, T17, Tcc, T3K;
						  TcC = T15 - T16;
						  T17 = T15 + T16;
						  Tcc = T3I + T3J;
						  T3K = T3I - T3J;
						  TcE = TcC + TcD;
						  Th5 = TcD - TcC;
						  T3b = T14 - T17;
						  T18 = T14 + T17;
						  Tcd = Tcb - Tcc;
						  Thg = Tcb + Tcc;
						  T8b = T3H + T3K;
						  T3L = T3H - T3K;
						  T1p = rio[WS(ios, 29)];
					     }
					     T3u = iio[-WS(ios, 29)];
					     T3v = rio[WS(ios, 61)];
					     T1r = rio[WS(ios, 13)];
					     Tct = T1o - T1p;
					     T1q = T1o + T1p;
					     Tcx = T3v + T3u;
					     T3w = T3u - T3v;
					     T1s = iio[-WS(ios, 45)];
					     T3x = iio[-WS(ios, 13)];
					     T3y = rio[WS(ios, 45)];
					}
				   }
				   {
					E T1c, Tci, T1b, Tch, T3e, T1d, T3f, T3g;
					{
					     E T19, T1a, T3c, T3d;
					     T19 = rio[WS(ios, 9)];
					     {
						  E Tcw, T1t, Tcu, T3z;
						  Tcw = T1r - T1s;
						  T1t = T1r + T1s;
						  Tcu = T3x + T3y;
						  T3z = T3x - T3y;
						  Tcy = Tcw - Tcx;
						  Thb = Tcw + Tcx;
						  T3t = T1q - T1t;
						  T1u = T1q + T1t;
						  Tcv = Tct - Tcu;
						  Thc = Tct + Tcu;
						  T87 = T3w + T3z;
						  T3A = T3w - T3z;
						  T1a = iio[-WS(ios, 41)];
					     }
					     T3c = iio[-WS(ios, 9)];
					     T3d = rio[WS(ios, 41)];
					     T1c = iio[-WS(ios, 57)];
					     Tci = T19 - T1a;
					     T1b = T19 + T1a;
					     Tch = T3c + T3d;
					     T3e = T3c - T3d;
					     T1d = rio[WS(ios, 25)];
					     T3f = iio[-WS(ios, 25)];
					     T3g = rio[WS(ios, 57)];
					}
					{
					     E Tce, T1e, Tcf, T3h;
					     Tcj = Tch - Tci;
					     TcF = Tci + Tch;
					     Tce = T1c - T1d;
					     T1e = T1c + T1d;
					     Tcf = T3g + T3f;
					     T3h = T3f - T3g;
					     T1f = T1b + T1e;
					     T3E = T1e - T1b;
					     TcG = Tce + Tcf;
					     Tcg = Tce - Tcf;
					     T8c = T3e + T3h;
					     T3i = T3e - T3h;
					}
				   }
				   {
					E T1h, T1i, T3l, T3m;
					T1h = rio[WS(ios, 5)];
					T1i = iio[-WS(ios, 37)];
					T3l = iio[-WS(ios, 5)];
					T3m = rio[WS(ios, 37)];
					T1k = rio[WS(ios, 21)];
					Tcm = T1h - T1i;
					T1j = T1h + T1i;
					Tcq = T3l + T3m;
					T3n = T3l - T3m;
					T1l = iio[-WS(ios, 53)];
					T3o = iio[-WS(ios, 21)];
					T3p = rio[WS(ios, 53)];
				   }
			      }
			      {
				   E T85, Tcr, Th8, T3k, Tco, Th9, T3r, T9U, T9V, T88;
				   {
					E T1g, T86, T1v, T8a, T8d;
					T85 = T18 - T1f;
					T1g = T18 + T1f;
					{
					     E Tcp, T1m, Tcn, T3q, T1n;
					     Tcp = T1k - T1l;
					     T1m = T1k + T1l;
					     Tcn = T3o + T3p;
					     T3q = T3o - T3p;
					     Tcr = Tcp + Tcq;
					     Th8 = Tcq - Tcp;
					     T3k = T1j - T1m;
					     T1n = T1j + T1m;
					     Tco = Tcm - Tcn;
					     Th9 = Tcm + Tcn;
					     T86 = T3n + T3q;
					     T3r = T3n - T3q;
					     T1v = T1n + T1u;
					     T8a = T1u - T1n;
					}
					T8d = T8b - T8c;
					T9U = T8c + T8b;
					T9T = T1g - T1v;
					T1w = T1g + T1v;
					T9a = T8d - T8a;
					T8e = T8a + T8d;
					T9V = T86 + T87;
					T88 = T86 - T87;
				   }
				   {
					E T6f, T3j, T6i, T3M, T3N, T3O, T6j, T3C, T3s, T3B;
					T6f = T3b - T3i;
					T3j = T3b + T3i;
					TaF = T9V + T9U;
					T9W = T9U - T9V;
					T99 = T85 - T88;
					T89 = T85 + T88;
					T6i = T3L - T3E;
					T3M = T3E + T3L;
					T3N = T3r - T3k;
					T3s = T3k + T3r;
					T3B = T3t - T3A;
					T3O = T3t + T3A;
					T6j = T3s - T3B;
					T3C = T3s + T3B;
					{
					     E Th6, Tcl, Tf8, Thh, TcJ, TcK, Tf5, TcI, Tf6, TcA;
					     {
						  E TcH, T6g, T3P, Tck, Tcs, Tcz;
						  Th6 = Tcj + Tcg;
						  Tck = Tcg - Tcj;
						  T6k = FMA(KP707106781, T6j, T6i);
						  T7a = FNMS(KP707106781, T6j, T6i);
						  T5p = FNMS(KP707106781, T3C, T3j);
						  T3D = FMA(KP707106781, T3C, T3j);
						  T6g = T3O - T3N;
						  T3P = T3N + T3O;
						  Tcl = FMA(KP707106781, Tck, Tcd);
						  Tf8 = FNMS(KP707106781, Tck, Tcd);
						  T6h = FMA(KP707106781, T6g, T6f);
						  T79 = FNMS(KP707106781, T6g, T6f);
						  T5q = FNMS(KP707106781, T3P, T3M);
						  T3Q = FMA(KP707106781, T3P, T3M);
						  TcH = TcF - TcG;
						  Thh = TcF + TcG;
						  TcJ = FMA(KP414213562, Tco, Tcr);
						  Tcs = FNMS(KP414213562, Tcr, Tco);
						  Tcz = FMA(KP414213562, Tcy, Tcv);
						  TcK = FNMS(KP414213562, Tcv, Tcy);
						  Tf5 = FNMS(KP707106781, TcH, TcE);
						  TcI = FMA(KP707106781, TcH, TcE);
						  Tf6 = Tcz - Tcs;
						  TcA = Tcs + Tcz;
					     }
					     {
						  E Tf9, TcL, Tha, Thd;
						  Tf7 = FMA(KP923879532, Tf6, Tf5);
						  Tg0 = FNMS(KP923879532, Tf6, Tf5);
						  Teg = FNMS(KP923879532, TcA, Tcl);
						  TcB = FMA(KP923879532, TcA, Tcl);
						  Tf9 = TcJ - TcK;
						  TcL = TcJ + TcK;
						  Th7 = FMA(KP707106781, Th6, Th5);
						  Tjk = FNMS(KP707106781, Th6, Th5);
						  Tfa = FMA(KP923879532, Tf9, Tf8);
						  TfZ = FNMS(KP923879532, Tf9, Tf8);
						  Tef = FNMS(KP923879532, TcL, TcI);
						  TcM = FMA(KP923879532, TcL, TcI);
						  Thj = FMA(KP414213562, Th8, Th9);
						  Tha = FNMS(KP414213562, Th9, Th8);
						  Thd = FNMS(KP414213562, Thc, Thb);
						  Thk = FMA(KP414213562, Thb, Thc);
						  Tjh = FNMS(KP707106781, Thh, Thg);
						  Thi = FMA(KP707106781, Thh, Thg);
						  Tji = Tha + Thd;
						  The = Tha - Thd;
					     }
					}
				   }
			      }
			 }
			 {
			      E Tdh, Tho, T3S, T1D, TcQ, Thz, T8m, T4s, Tdb, Thu, T4a, T1Z, Td8, Thv, T8i;
			      E T4h, TcT, Tdi, T1K, T4l, Tdj, TcW, T3Z, T8n, TcZ, T1O, T45, Td3, T44, Td2;
			      E T1R, T46;
			      {
				   E Td6, T1V, T4e, Tda, T4d, Td9, T1Y, T4f;
				   {
					E TcO, T1z, T4p, Tdg, T4o, Tdf, T1C, T4q;
					{
					     E T4m, T4n, T1A, T1B;
					     {
						  E T1x, Tjl, Thl, T1y;
						  T1x = iio[-WS(ios, 63)];
						  Tjj = FNMS(KP923879532, Tji, Tjh);
						  Tkc = FMA(KP923879532, Tji, Tjh);
						  Tis = FNMS(KP923879532, The, Th7);
						  Thf = FMA(KP923879532, The, Th7);
						  Tjl = Thj - Thk;
						  Thl = Thj + Thk;
						  T1y = rio[WS(ios, 31)];
						  T4m = iio[-WS(ios, 31)];
						  Tjm = FMA(KP923879532, Tjl, Tjk);
						  Tkb = FNMS(KP923879532, Tjl, Tjk);
						  Tir = FNMS(KP923879532, Thl, Thi);
						  Thm = FMA(KP923879532, Thl, Thi);
						  TcO = T1x - T1y;
						  T1z = T1x + T1y;
						  T4n = rio[WS(ios, 63)];
					     }
					     T1A = rio[WS(ios, 15)];
					     T1B = iio[-WS(ios, 47)];
					     T4p = iio[-WS(ios, 15)];
					     Tdg = T4n + T4m;
					     T4o = T4m - T4n;
					     Tdf = T1A - T1B;
					     T1C = T1A + T1B;
					     T4q = rio[WS(ios, 47)];
					}
					{
					     E T4b, T4c, T1W, T1X;
					     {
						  E T1T, TcP, T4r, T1U;
						  T1T = iio[-WS(ios, 59)];
						  Tdh = Tdf - Tdg;
						  Tho = Tdf + Tdg;
						  T3S = T1z - T1C;
						  T1D = T1z + T1C;
						  TcP = T4p + T4q;
						  T4r = T4p - T4q;
						  T1U = rio[WS(ios, 27)];
						  T4b = iio[-WS(ios, 27)];
						  TcQ = TcO - TcP;
						  Thz = TcO + TcP;
						  T8m = T4o + T4r;
						  T4s = T4o - T4r;
						  Td6 = T1T - T1U;
						  T1V = T1T + T1U;
						  T4c = rio[WS(ios, 59)];
					     }
					     T1W = rio[WS(ios, 11)];
					     T1X = iio[-WS(ios, 43)];
					     T4e = iio[-WS(ios, 11)];
					     Tda = T4c + T4b;
					     T4d = T4b - T4c;
					     Td9 = T1W - T1X;
					     T1Y = T1W + T1X;
					     T4f = rio[WS(ios, 43)];
					}
				   }
				   {
					E T3V, TcU, T3Y, TcV;
					{
					     E TcR, T1G, T3W, TcS, T1J, T3X;
					     {
						  E T3T, T3U, T1H, T1I;
						  {
						       E T1E, Td7, T4g, T1F;
						       T1E = rio[WS(ios, 7)];
						       Tdb = Td9 - Tda;
						       Thu = Td9 + Tda;
						       T4a = T1V - T1Y;
						       T1Z = T1V + T1Y;
						       Td7 = T4e + T4f;
						       T4g = T4e - T4f;
						       T1F = iio[-WS(ios, 39)];
						       T3T = iio[-WS(ios, 7)];
						       Td8 = Td6 - Td7;
						       Thv = Td6 + Td7;
						       T8i = T4d + T4g;
						       T4h = T4d - T4g;
						       TcR = T1E - T1F;
						       T1G = T1E + T1F;
						       T3U = rio[WS(ios, 39)];
						  }
						  T1H = iio[-WS(ios, 55)];
						  T1I = rio[WS(ios, 23)];
						  T3W = iio[-WS(ios, 23)];
						  TcS = T3T + T3U;
						  T3V = T3T - T3U;
						  TcU = T1H - T1I;
						  T1J = T1H + T1I;
						  T3X = rio[WS(ios, 55)];
					     }
					     TcT = TcR - TcS;
					     Tdi = TcR + TcS;
					     T1K = T1G + T1J;
					     T4l = T1J - T1G;
					     T3Y = T3W - T3X;
					     TcV = T3X + T3W;
					}
					{
					     E T42, T43, T1M, T1N, T1P, T1Q;
					     T1M = rio[WS(ios, 3)];
					     T1N = iio[-WS(ios, 35)];
					     Tdj = TcU + TcV;
					     TcW = TcU - TcV;
					     T3Z = T3V - T3Y;
					     T8n = T3V + T3Y;
					     TcZ = T1M - T1N;
					     T1O = T1M + T1N;
					     T42 = iio[-WS(ios, 3)];
					     T43 = rio[WS(ios, 35)];
					     T1P = rio[WS(ios, 19)];
					     T1Q = iio[-WS(ios, 51)];
					     T45 = iio[-WS(ios, 19)];
					     Td3 = T42 + T43;
					     T44 = T42 - T43;
					     Td2 = T1P - T1Q;
					     T1R = T1P + T1Q;
					     T46 = rio[WS(ios, 51)];
					}
				   }
			      }
			      {
				   E T8g, Td4, Thr, T41, T9Z, Ths, Td1, T48, Ta0, T8j, T8h;
				   {
					E T1L, T1S, Td0, T47, T8o, T20, T8l;
					T8g = T1D - T1K;
					T1L = T1D + T1K;
					Td4 = Td2 + Td3;
					Thr = Td2 - Td3;
					T41 = T1O - T1R;
					T1S = T1O + T1R;
					Td0 = T45 + T46;
					T47 = T45 - T46;
					T8o = T8m - T8n;
					T9Z = T8n + T8m;
					T20 = T1S + T1Z;
					T8l = T1Z - T1S;
					Ths = TcZ + Td0;
					Td1 = TcZ - Td0;
					T48 = T44 - T47;
					T8h = T44 + T47;
					T21 = T1L + T20;
					T9Y = T1L - T20;
					T9d = T8o - T8l;
					T8p = T8l + T8o;
				   }
				   Ta0 = T8h + T8i;
				   T8j = T8h - T8i;
				   {
					E T6m, T40, T6p, T4t, T4u, T4v, T6q, T4j, T49, T4i;
					T6m = T3S - T3Z;
					T40 = T3S + T3Z;
					TaG = Ta0 + T9Z;
					Ta1 = T9Z - Ta0;
					T9c = T8g - T8j;
					T8k = T8g + T8j;
					T6p = T4s - T4l;
					T4t = T4l + T4s;
					T4u = T48 - T41;
					T49 = T41 + T48;
					T4i = T4a - T4h;
					T4v = T4a + T4h;
					T6q = T49 - T4i;
					T4j = T49 + T4i;
					{
					     E Thp, TcY, Tff, ThA, Tdm, Tdn, Tfc, Tdl, Tfd, Tdd;
					     {
						  E Tdk, T6n, T4w, TcX, Td5, Tdc;
						  Thp = TcT - TcW;
						  TcX = TcT + TcW;
						  T6r = FMA(KP707106781, T6q, T6p);
						  T7d = FNMS(KP707106781, T6q, T6p);
						  T5s = FNMS(KP707106781, T4j, T40);
						  T4k = FMA(KP707106781, T4j, T40);
						  T6n = T4v - T4u;
						  T4w = T4u + T4v;
						  TcY = FMA(KP707106781, TcX, TcQ);
						  Tff = FNMS(KP707106781, TcX, TcQ);
						  T6o = FMA(KP707106781, T6n, T6m);
						  T7c = FNMS(KP707106781, T6n, T6m);
						  T5t = FNMS(KP707106781, T4w, T4t);
						  T4x = FMA(KP707106781, T4w, T4t);
						  Tdk = Tdi - Tdj;
						  ThA = Tdi + Tdj;
						  Tdm = FMA(KP414213562, Td1, Td4);
						  Td5 = FNMS(KP414213562, Td4, Td1);
						  Tdc = FMA(KP414213562, Tdb, Td8);
						  Tdn = FNMS(KP414213562, Td8, Tdb);
						  Tfc = FNMS(KP707106781, Tdk, Tdh);
						  Tdl = FMA(KP707106781, Tdk, Tdh);
						  Tfd = Tdc - Td5;
						  Tdd = Td5 + Tdc;
					     }
					     {
						  E Tfg, Tdo, Tht, Thw;
						  Tfe = FMA(KP923879532, Tfd, Tfc);
						  Tg3 = FNMS(KP923879532, Tfd, Tfc);
						  Tej = FNMS(KP923879532, Tdd, TcY);
						  Tde = FMA(KP923879532, Tdd, TcY);
						  Tfg = Tdm - Tdn;
						  Tdo = Tdm + Tdn;
						  Thq = FMA(KP707106781, Thp, Tho);
						  Tjr = FNMS(KP707106781, Thp, Tho);
						  Tfh = FMA(KP923879532, Tfg, Tff);
						  Tg2 = FNMS(KP923879532, Tfg, Tff);
						  Tei = FNMS(KP923879532, Tdo, Tdl);
						  Tdp = FMA(KP923879532, Tdo, Tdl);
						  ThC = FNMS(KP414213562, Thr, Ths);
						  Tht = FMA(KP414213562, Ths, Thr);
						  Thw = FNMS(KP414213562, Thv, Thu);
						  ThD = FMA(KP414213562, Thu, Thv);
						  Tjo = FNMS(KP707106781, ThA, Thz);
						  ThB = FMA(KP707106781, ThA, Thz);
						  Tjp = Tht - Thw;
						  Thx = Tht + Thw;
					     }
					}
				   }
			      }
			 }
		    }
	       }
	       {
		    E TiX, TiU, TiT, TeL, TeI, TeH;
		    {
			 E Tjq, Tkf, Tiv, Thy, Tjt, Tke, Tiu, ThF, T9F, T9C, T9x, T9G, T9B;
			 {
			      E Tav, Tas, Tan, Taw, Tar;
			      {
				   E Taa, TaY, Tb3, Tb0, TaX, Tb4;
				   {
					E T22, TaL, Tb2, T11, TaM, TaS, TaI, TaO, Tb1;
					{
					     E Tjs, ThE, TaH, TaE;
					     T22 = T1w + T21;
					     TaL = T21 - T1w;
					     Tjq = FMA(KP923879532, Tjp, Tjo);
					     Tkf = FNMS(KP923879532, Tjp, Tjo);
					     Tiv = FNMS(KP923879532, Thx, Thq);
					     Thy = FMA(KP923879532, Thx, Thq);
					     Tjs = ThD - ThC;
					     ThE = ThC + ThD;
					     Tb2 = TaF + TaG;
					     TaH = TaF - TaG;
					     TaE = Tv - T10;
					     T11 = Tv + T10;
					     Tjt = FMA(KP923879532, Tjs, Tjr);
					     Tke = FNMS(KP923879532, Tjs, Tjr);
					     Tiu = FNMS(KP923879532, ThE, ThB);
					     ThF = FMA(KP923879532, ThE, ThB);
					     Taa = Ta8 - Ta9;
					     TaM = Ta9 + Ta8;
					     TaY = T11 - T22;
					     TaS = TaE - TaH;
					     TaI = TaE + TaH;
					}
					rio[0] = T11 + T22;
					TaO = TaM - TaN;
					Tb1 = TaN + TaM;
					{
					     E TaK, TaD, TaP, TaV, TaQ, TaJ;
					     TaK = W[95];
					     TaD = W[94];
					     iio[-WS(ios, 63)] = Tb2 + Tb1;
					     TaP = TaL + TaO;
					     TaV = TaO - TaL;
					     TaQ = TaK * TaI;
					     TaJ = TaD * TaI;
					     {
						  E TaU, TaR, TaW, TaT;
						  TaU = W[31];
						  iio[-WS(ios, 15)] = FMA(TaD, TaP, TaQ);
						  rio[WS(ios, 48)] = FNMS(TaK, TaP, TaJ);
						  TaR = W[30];
						  TaW = TaU * TaS;
						  Tb3 = Tb1 - Tb2;
						  Tb0 = W[63];
						  TaT = TaR * TaS;
						  iio[-WS(ios, 47)] = FMA(TaR, TaV, TaW);
						  TaX = W[62];
						  Tb4 = Tb0 * TaY;
						  rio[WS(ios, 16)] = FNMS(TaU, TaV, TaT);
					     }
					}
				   }
				   {
					E Tao, T9S, T9X, Tab, Tat, Ta2, Tap, Tae, TaZ, Tac, Tad;
					TaZ = TaX * TaY;
					iio[-WS(ios, 31)] = FMA(TaX, Tb3, Tb4);
					Tao = T9O - T9R;
					T9S = T9O + T9R;
					rio[WS(ios, 32)] = FNMS(Tb0, Tb3, TaZ);
					Tac = T9W - T9T;
					T9X = T9T + T9W;
					Tab = Ta7 + Taa;
					Tat = Taa - Ta7;
					Ta2 = T9Y - Ta1;
					Tad = T9Y + Ta1;
					Tap = Tad - Tac;
					Tae = Tac + Tad;
					{
					     E Tal, Taq, Tai, TaB, TaA, Taz;
					     {
						  E Ta6, Tau, Taf, Tay, Ta4, T9N, Ta3;
						  Ta6 = W[111];
						  Tau = T9X - Ta2;
						  Ta3 = T9X + Ta2;
						  Taf = FMA(KP707106781, Tae, Tab);
						  Tal = FNMS(KP707106781, Tae, Tab);
						  Tay = FNMS(KP707106781, Tap, Tao);
						  Taq = FMA(KP707106781, Tap, Tao);
						  Ta4 = FMA(KP707106781, Ta3, T9S);
						  Tai = FNMS(KP707106781, Ta3, T9S);
						  T9N = W[110];
						  {
						       E Tax, TaC, Tag, Ta5;
						       TaB = FNMS(KP707106781, Tau, Tat);
						       Tav = FMA(KP707106781, Tau, Tat);
						       TaA = W[79];
						       Tag = Ta6 * Ta4;
						       Ta5 = T9N * Ta4;
						       Tax = W[78];
						       TaC = TaA * Tay;
						       iio[-WS(ios, 7)] = FMA(T9N, Taf, Tag);
						       rio[WS(ios, 56)] = FNMS(Ta6, Taf, Ta5);
						       Taz = Tax * Tay;
						       iio[-WS(ios, 23)] = FMA(Tax, TaB, TaC);
						  }
					     }
					     {
						  E Tak, Tah, Tam, Taj;
						  Tak = W[47];
						  rio[WS(ios, 40)] = FNMS(TaA, TaB, Taz);
						  Tah = W[46];
						  Tam = Tak * Tai;
						  Tas = W[15];
						  Taj = Tah * Tai;
						  Tan = W[14];
						  iio[-WS(ios, 39)] = FMA(Tah, Tal, Tam);
						  Taw = Tas * Taq;
						  rio[WS(ios, 24)] = FNMS(Tak, Tal, Taj);
						  Tar = Tan * Taq;
					     }
					}
				   }
			      }
			      {
				   E T9j, T97, T9k, T8X, T8U, T8P, T8Y, T8T;
				   {
					E T8E, T8f, T8D, T8V, T84, T8Q, T8q, T8F, T8z, T8C, T83;
					T9j = T8y - T8v;
					T8z = T8v + T8y;
					iio[-WS(ios, 55)] = FMA(Tan, Tav, Taw);
					T97 = T8B - T8A;
					T8C = T8A + T8B;
					rio[WS(ios, 8)] = FNMS(Tas, Tav, Tar);
					T9k = T7X - T82;
					T83 = T7X + T82;
					T8E = FNMS(KP414213562, T89, T8e);
					T8f = FMA(KP414213562, T8e, T89);
					T8D = FMA(KP707106781, T8C, T8z);
					T8V = FNMS(KP707106781, T8C, T8z);
					T84 = FMA(KP707106781, T83, T7S);
					T8Q = FNMS(KP707106781, T83, T7S);
					T8q = FNMS(KP414213562, T8p, T8k);
					T8F = FMA(KP414213562, T8k, T8p);
					{
					     E T8N, T8S, T8K, T93, T92, T91;
					     {
						  E T8u, T8W, T8H, T90, T8s, T7N, T8R, T8G, T8r;
						  T8u = W[119];
						  T8R = T8F - T8E;
						  T8G = T8E + T8F;
						  T8r = T8f + T8q;
						  T8W = T8f - T8q;
						  T8N = FNMS(KP923879532, T8G, T8D);
						  T8H = FMA(KP923879532, T8G, T8D);
						  T8S = FMA(KP923879532, T8R, T8Q);
						  T90 = FNMS(KP923879532, T8R, T8Q);
						  T8K = FNMS(KP923879532, T8r, T84);
						  T8s = FMA(KP923879532, T8r, T84);
						  T7N = W[118];
						  {
						       E T8Z, T94, T8I, T8t;
						       T8X = FMA(KP923879532, T8W, T8V);
						       T93 = FNMS(KP923879532, T8W, T8V);
						       T92 = W[87];
						       T8I = T8u * T8s;
						       T8t = T7N * T8s;
						       T8Z = W[86];
						       T94 = T92 * T90;
						       iio[-WS(ios, 3)] = FMA(T7N, T8H, T8I);
						       rio[WS(ios, 60)] = FNMS(T8u, T8H, T8t);
						       T91 = T8Z * T90;
						       iio[-WS(ios, 19)] = FMA(T8Z, T93, T94);
						  }
					     }
					     {
						  E T8M, T8J, T8O, T8L;
						  T8M = W[55];
						  rio[WS(ios, 44)] = FNMS(T92, T93, T91);
						  T8J = W[54];
						  T8O = T8M * T8K;
						  T8U = W[23];
						  T8L = T8J * T8K;
						  T8P = W[22];
						  iio[-WS(ios, 35)] = FMA(T8J, T8N, T8O);
						  T8Y = T8U * T8S;
						  rio[WS(ios, 28)] = FNMS(T8M, T8N, T8L);
						  T8T = T8P * T8S;
					     }
					}
				   }
				   {
					E T9b, T9m, T9D, T9l, T9y, T98, T9n, T9e;
					iio[-WS(ios, 51)] = FMA(T8P, T8X, T8Y);
					rio[WS(ios, 12)] = FNMS(T8U, T8X, T8T);
					T9b = FNMS(KP414213562, T9a, T99);
					T9m = FMA(KP414213562, T99, T9a);
					T9D = FNMS(KP707106781, T9k, T9j);
					T9l = FMA(KP707106781, T9k, T9j);
					T9y = FNMS(KP707106781, T97, T96);
					T98 = FMA(KP707106781, T97, T96);
					T9n = FNMS(KP414213562, T9c, T9d);
					T9e = FMA(KP414213562, T9d, T9c);
					{
					     E T9v, T9A, T9s, T9L, T9K, T9J;
					     {
						  E T9i, T9E, T9p, T9I, T9g, T95, T9o, T9z, T9f;
						  T9i = W[7];
						  T9o = T9m + T9n;
						  T9z = T9m - T9n;
						  T9E = T9e - T9b;
						  T9f = T9b + T9e;
						  T9p = FMA(KP923879532, T9o, T9l);
						  T9v = FNMS(KP923879532, T9o, T9l);
						  T9I = FNMS(KP923879532, T9z, T9y);
						  T9A = FMA(KP923879532, T9z, T9y);
						  T9g = FMA(KP923879532, T9f, T98);
						  T9s = FNMS(KP923879532, T9f, T98);
						  T95 = W[6];
						  {
						       E T9H, T9M, T9q, T9h;
						       T9L = FNMS(KP923879532, T9E, T9D);
						       T9F = FMA(KP923879532, T9E, T9D);
						       T9K = W[39];
						       T9q = T9i * T9g;
						       T9h = T95 * T9g;
						       T9H = W[38];
						       T9M = T9K * T9I;
						       iio[-WS(ios, 59)] = FMA(T95, T9p, T9q);
						       rio[WS(ios, 4)] = FNMS(T9i, T9p, T9h);
						       T9J = T9H * T9I;
						       iio[-WS(ios, 43)] = FMA(T9H, T9L, T9M);
						  }
					     }
					     {
						  E T9u, T9r, T9w, T9t;
						  T9u = W[71];
						  rio[WS(ios, 20)] = FNMS(T9K, T9L, T9J);
						  T9r = W[70];
						  T9w = T9u * T9s;
						  T9C = W[103];
						  T9t = T9r * T9s;
						  T9x = W[102];
						  iio[-WS(ios, 27)] = FMA(T9r, T9v, T9w);
						  T9G = T9C * T9A;
						  rio[WS(ios, 36)] = FNMS(T9u, T9v, T9t);
						  T9B = T9x * T9A;
					     }
					}
				   }
			      }
			 }
			 {
			      E TjB, Tjf, Tj8, TjE, TiB, Tip, Tio, TiC, Tif, Tic, Tib, TkH, TkE, TkD, TjZ;
			      E TjW, TjV;
			      {
				   E TkK, Tkx, Tki, TkC, TkN, Tku, Tkr;
				   {
					E Tkd, Tkg, Tka, TkF, TkG, Tkq, Tkl, Tkm;
					{
					     E Tko, Tkp, Tk8, Tk9;
					     TjB = FMA(KP923879532, TjA, Tjz);
					     Tk8 = FNMS(KP923879532, TjA, Tjz);
					     iio[-WS(ios, 11)] = FMA(T9x, T9F, T9G);
					     Tjf = Tjb + Tje;
					     Tk9 = Tje - Tjb;
					     rio[WS(ios, 52)] = FNMS(T9C, T9F, T9B);
					     Tkd = FNMS(KP534511135, Tkc, Tkb);
					     Tko = FMA(KP534511135, Tkb, Tkc);
					     Tkp = FMA(KP534511135, Tke, Tkf);
					     Tkg = FNMS(KP534511135, Tkf, Tke);
					     Tka = FMA(KP831469612, Tk9, Tk8);
					     TkF = FNMS(KP831469612, Tk9, Tk8);
					     TkG = Tko - Tkp;
					     Tkq = Tko + Tkp;
					     Tj8 = FNMS(KP923879532, Tj7, Tj6);
					     Tkl = FMA(KP923879532, Tj7, Tj6);
					     Tkm = TjC + TjD;
					     TjE = TjC - TjD;
					}
					{
					     E TkB, Tkh, TkA, Tkn;
					     TkH = FMA(KP881921264, TkG, TkF);
					     TkK = FNMS(KP881921264, TkG, TkF);
					     TkB = Tkd + Tkg;
					     Tkh = Tkd - Tkg;
					     TkA = FNMS(KP831469612, Tkm, Tkl);
					     Tkn = FMA(KP831469612, Tkm, Tkl);
					     Tkx = FNMS(KP881921264, Tkh, Tka);
					     Tki = FMA(KP881921264, Tkh, Tka);
					     TkC = FNMS(KP881921264, TkB, TkA);
					     TkN = FMA(KP881921264, TkB, TkA);
					     Tku = FNMS(KP881921264, Tkq, Tkn);
					     Tkr = FMA(KP881921264, Tkq, Tkn);
					}
				   }
				   {
					E TkM, TkL, Tk7, Tkk, Tkt, Tkw;
					Tk7 = W[116];
					Tkk = W[117];
					{
					     E TkJ, Tks, Tkj, TkO;
					     TkJ = W[84];
					     TkM = W[85];
					     Tks = Tk7 * Tkr;
					     Tkj = Tk7 * Tki;
					     TkO = TkJ * TkN;
					     TkL = TkJ * TkK;
					     rio[WS(ios, 59)] = FNMS(Tkk, Tki, Tks);
					     iio[-WS(ios, 4)] = FMA(Tkk, Tkr, Tkj);
					     rio[WS(ios, 43)] = FNMS(TkM, TkK, TkO);
					}
					iio[-WS(ios, 20)] = FMA(TkM, TkN, TkL);
					Tkt = W[52];
					Tkw = W[53];
					{
					     E Tkz, Tky, Tkv, TkI;
					     Tkz = W[20];
					     TkE = W[21];
					     Tky = Tkt * Tkx;
					     Tkv = Tkt * Tku;
					     TkI = Tkz * TkH;
					     TkD = Tkz * TkC;
					     iio[-WS(ios, 36)] = FMA(Tkw, Tku, Tky);
					     rio[WS(ios, 27)] = FNMS(Tkw, Tkx, Tkv);
					     iio[-WS(ios, 52)] = FMA(TkE, TkC, TkI);
					}
				   }
			      }
			      rio[WS(ios, 11)] = FNMS(TkE, TkH, TkD);
			      {
				   E Tii, Ti5, ThI, Tia, Til, Ti2, ThZ;
				   {
					E Thn, ThG, Tid, Th4, Tie, ThY, ThR, ThU;
					{
					     E TgO, Th3, ThW, ThX;
					     TiB = FNMS(KP923879532, TgN, TgG);
					     TgO = FMA(KP923879532, TgN, TgG);
					     Th3 = TgV - Th2;
					     Tip = TgV + Th2;
					     Thn = FNMS(KP098491403, Thm, Thf);
					     ThW = FMA(KP098491403, Thf, Thm);
					     ThX = FMA(KP098491403, Thy, ThF);
					     ThG = FNMS(KP098491403, ThF, Thy);
					     Tid = FNMS(KP980785280, Th3, TgO);
					     Th4 = FMA(KP980785280, Th3, TgO);
					     Tie = ThW - ThX;
					     ThY = ThW + ThX;
					     Tio = FNMS(KP923879532, ThQ, ThN);
					     ThR = FMA(KP923879532, ThQ, ThN);
					     ThU = ThS + ThT;
					     TiC = ThS - ThT;
					}
					{
					     E Ti9, ThH, Ti8, ThV;
					     Tif = FMA(KP995184726, Tie, Tid);
					     Tii = FNMS(KP995184726, Tie, Tid);
					     Ti9 = Thn + ThG;
					     ThH = Thn - ThG;
					     Ti8 = FNMS(KP980785280, ThU, ThR);
					     ThV = FMA(KP980785280, ThU, ThR);
					     Ti5 = FNMS(KP995184726, ThH, Th4);
					     ThI = FMA(KP995184726, ThH, Th4);
					     Tia = FNMS(KP995184726, Ti9, Ti8);
					     Til = FMA(KP995184726, Ti9, Ti8);
					     Ti2 = FNMS(KP995184726, ThY, ThV);
					     ThZ = FMA(KP995184726, ThY, ThV);
					}
				   }
				   {
					E Tik, Tij, TgD, ThK, Ti1, Ti4;
					TgD = W[124];
					ThK = W[125];
					{
					     E Tih, Ti0, ThJ, Tim;
					     Tih = W[92];
					     Tik = W[93];
					     Ti0 = TgD * ThZ;
					     ThJ = TgD * ThI;
					     Tim = Tih * Til;
					     Tij = Tih * Tii;
					     rio[WS(ios, 63)] = FNMS(ThK, ThI, Ti0);
					     iio[0] = FMA(ThK, ThZ, ThJ);
					     rio[WS(ios, 47)] = FNMS(Tik, Tii, Tim);
					}
					iio[-WS(ios, 16)] = FMA(Tik, Til, Tij);
					Ti1 = W[60];
					Ti4 = W[61];
					{
					     E Ti7, Ti6, Ti3, Tig;
					     Ti7 = W[28];
					     Tic = W[29];
					     Ti6 = Ti1 * Ti5;
					     Ti3 = Ti1 * Ti2;
					     Tig = Ti7 * Tif;
					     Tib = Ti7 * Tia;
					     iio[-WS(ios, 32)] = FMA(Ti4, Ti2, Ti6);
					     rio[WS(ios, 31)] = FNMS(Ti4, Ti5, Ti3);
					     iio[-WS(ios, 48)] = FMA(Tic, Tia, Tig);
					}
				   }
			      }
			      rio[WS(ios, 15)] = FNMS(Tic, Tif, Tib);
			      {
				   E Tk2, TjP, Tjw, TjU, Tk5, TjM, TjJ;
				   {
					E Tjn, Tju, TjX, Tjg, TjY, TjI, TjG, TjH;
					Tjn = FNMS(KP303346683, Tjm, Tjj);
					TjG = FMA(KP303346683, Tjj, Tjm);
					TjH = FMA(KP303346683, Tjq, Tjt);
					Tju = FNMS(KP303346683, Tjt, Tjq);
					TjX = FNMS(KP831469612, Tjf, Tj8);
					Tjg = FMA(KP831469612, Tjf, Tj8);
					TjY = TjG + TjH;
					TjI = TjG - TjH;
					{
					     E TjT, Tjv, TjS, TjF;
					     TjZ = FMA(KP956940335, TjY, TjX);
					     Tk2 = FNMS(KP956940335, TjY, TjX);
					     TjT = Tju - Tjn;
					     Tjv = Tjn + Tju;
					     TjS = FNMS(KP831469612, TjE, TjB);
					     TjF = FMA(KP831469612, TjE, TjB);
					     TjP = FNMS(KP956940335, Tjv, Tjg);
					     Tjw = FMA(KP956940335, Tjv, Tjg);
					     TjU = FMA(KP956940335, TjT, TjS);
					     Tk5 = FNMS(KP956940335, TjT, TjS);
					     TjM = FNMS(KP956940335, TjI, TjF);
					     TjJ = FMA(KP956940335, TjI, TjF);
					}
				   }
				   {
					E Tk4, Tk3, Tj5, Tjy, TjL, TjO;
					Tj5 = W[4];
					Tjy = W[5];
					{
					     E Tk1, TjK, Tjx, Tk6;
					     Tk1 = W[36];
					     Tk4 = W[37];
					     TjK = Tj5 * TjJ;
					     Tjx = Tj5 * Tjw;
					     Tk6 = Tk1 * Tk5;
					     Tk3 = Tk1 * Tk2;
					     iio[-WS(ios, 60)] = FMA(Tjy, Tjw, TjK);
					     rio[WS(ios, 3)] = FNMS(Tjy, TjJ, Tjx);
					     iio[-WS(ios, 44)] = FMA(Tk4, Tk2, Tk6);
					}
					rio[WS(ios, 19)] = FNMS(Tk4, Tk5, Tk3);
					TjL = W[68];
					TjO = W[69];
					{
					     E TjR, TjQ, TjN, Tk0;
					     TjR = W[100];
					     TjW = W[101];
					     TjQ = TjL * TjP;
					     TjN = TjL * TjM;
					     Tk0 = TjR * TjZ;
					     TjV = TjR * TjU;
					     rio[WS(ios, 35)] = FNMS(TjO, TjM, TjQ);
					     iio[-WS(ios, 28)] = FMA(TjO, TjP, TjN);
					     rio[WS(ios, 51)] = FNMS(TjW, TjU, Tk0);
					}
				   }
			      }
			      iio[-WS(ios, 12)] = FMA(TjW, TjZ, TjV);
			      {
				   E Tj0, TiN, Tiy, TiS, Tj3, TiK, TiH;
				   {
					E Tit, Tiw, TiV, Tiq, TiW, TiG, TiE, TiF;
					Tit = FNMS(KP820678790, Tis, Tir);
					TiE = FMA(KP820678790, Tir, Tis);
					TiF = FMA(KP820678790, Tiu, Tiv);
					Tiw = FNMS(KP820678790, Tiv, Tiu);
					TiV = FMA(KP980785280, Tip, Tio);
					Tiq = FNMS(KP980785280, Tip, Tio);
					TiW = TiE + TiF;
					TiG = TiE - TiF;
					{
					     E TiR, Tix, TiQ, TiD;
					     TiX = FMA(KP773010453, TiW, TiV);
					     Tj0 = FNMS(KP773010453, TiW, TiV);
					     TiR = Tiw - Tit;
					     Tix = Tit + Tiw;
					     TiQ = FNMS(KP980785280, TiC, TiB);
					     TiD = FMA(KP980785280, TiC, TiB);
					     TiN = FNMS(KP773010453, Tix, Tiq);
					     Tiy = FMA(KP773010453, Tix, Tiq);
					     TiS = FMA(KP773010453, TiR, TiQ);
					     Tj3 = FNMS(KP773010453, TiR, TiQ);
					     TiK = FNMS(KP773010453, TiG, TiD);
					     TiH = FMA(KP773010453, TiG, TiD);
					}
				   }
				   {
					E Tj2, Tj1, Tin, TiA, TiJ, TiM;
					Tin = W[12];
					TiA = W[13];
					{
					     E TiZ, TiI, Tiz, Tj4;
					     TiZ = W[44];
					     Tj2 = W[45];
					     TiI = Tin * TiH;
					     Tiz = Tin * Tiy;
					     Tj4 = TiZ * Tj3;
					     Tj1 = TiZ * Tj0;
					     iio[-WS(ios, 56)] = FMA(TiA, Tiy, TiI);
					     rio[WS(ios, 7)] = FNMS(TiA, TiH, Tiz);
					     iio[-WS(ios, 40)] = FMA(Tj2, Tj0, Tj4);
					}
					rio[WS(ios, 23)] = FNMS(Tj2, Tj3, Tj1);
					TiJ = W[76];
					TiM = W[77];
					{
					     E TiP, TiO, TiL, TiY;
					     TiP = W[108];
					     TiU = W[109];
					     TiO = TiJ * TiN;
					     TiL = TiJ * TiK;
					     TiY = TiP * TiX;
					     TiT = TiP * TiS;
					     rio[WS(ios, 39)] = FNMS(TiM, TiK, TiO);
					     iio[-WS(ios, 24)] = FMA(TiM, TiN, TiL);
					     rio[WS(ios, 55)] = FNMS(TiU, TiS, TiY);
					}
				   }
			      }
			 }
		    }
		    iio[-WS(ios, 8)] = FMA(TiU, TiX, TiT);
		    {
			 E T5z, T5n, T5m, T5A, Tep, Ted, Tec, Teq, Te3, Te0, TdZ;
			 {
			      E T5d, T5a, T55, T5e, T59;
			      {
				   E T5b, T4T, T4z, T5c, T57, T4W, T3a, T56, T4P, T4S;
				   T5z = FNMS(KP707106781, T4O, T4L);
				   T4P = FMA(KP707106781, T4O, T4L);
				   T4S = T4Q + T4R;
				   T5n = T4R - T4Q;
				   {
					E T4U, T4V, T2w, T39, T3R, T4y;
					T4U = FNMS(KP198912367, T3D, T3Q);
					T3R = FMA(KP198912367, T3Q, T3D);
					T4y = FNMS(KP198912367, T4x, T4k);
					T4V = FMA(KP198912367, T4k, T4x);
					T5b = FNMS(KP923879532, T4S, T4P);
					T4T = FMA(KP923879532, T4S, T4P);
					T4z = T3R + T4y;
					T5c = T3R - T4y;
					T2w = FMA(KP707106781, T2v, T2c);
					T5m = FNMS(KP707106781, T2v, T2c);
					T5A = T2P - T38;
					T39 = T2P + T38;
					T57 = T4V - T4U;
					T4W = T4U + T4V;
					T3a = FMA(KP923879532, T39, T2w);
					T56 = FNMS(KP923879532, T39, T2w);
				   }
				   {
					E T53, T58, T50, T5j, T5i, T5h;
					{
					     E T4X, T4C, T5g, T4A, T23;
					     T53 = FNMS(KP980785280, T4W, T4T);
					     T4X = FMA(KP980785280, T4W, T4T);
					     T4C = W[123];
					     T5g = FNMS(KP980785280, T57, T56);
					     T58 = FMA(KP980785280, T57, T56);
					     T4A = FMA(KP980785280, T4z, T3a);
					     T50 = FNMS(KP980785280, T4z, T3a);
					     T23 = W[122];
					     {
						  E T5f, T5k, T4Y, T4B;
						  T5j = FNMS(KP980785280, T5c, T5b);
						  T5d = FMA(KP980785280, T5c, T5b);
						  T5i = W[91];
						  T4Y = T4C * T4A;
						  T4B = T23 * T4A;
						  T5f = W[90];
						  T5k = T5i * T5g;
						  iio[-WS(ios, 1)] = FMA(T23, T4X, T4Y);
						  rio[WS(ios, 62)] = FNMS(T4C, T4X, T4B);
						  T5h = T5f * T5g;
						  iio[-WS(ios, 17)] = FMA(T5f, T5j, T5k);
					     }
					}
					{
					     E T52, T4Z, T54, T51;
					     T52 = W[59];
					     rio[WS(ios, 46)] = FNMS(T5i, T5j, T5h);
					     T4Z = W[58];
					     T54 = T52 * T50;
					     T5a = W[27];
					     T51 = T4Z * T50;
					     T55 = W[26];
					     iio[-WS(ios, 33)] = FMA(T4Z, T53, T54);
					     T5e = T5a * T58;
					     rio[WS(ios, 30)] = FNMS(T52, T53, T51);
					     T59 = T55 * T58;
					}
				   }
			      }
			      {
				   E Te6, TdT, Tds, TdY, Te9, TdQ, TdN;
				   {
					E TcN, Tdq, Tca, Te1, Te2, TdM, TdF, TdI;
					{
					     E TdK, TdL, Tbw, Tc9;
					     Tep = FNMS(KP923879532, Tbv, Tbg);
					     Tbw = FMA(KP923879532, Tbv, Tbg);
					     iio[-WS(ios, 49)] = FMA(T55, T5d, T5e);
					     Ted = Tc8 - TbP;
					     Tc9 = TbP + Tc8;
					     rio[WS(ios, 14)] = FNMS(T5a, T5d, T59);
					     TcN = FNMS(KP098491403, TcM, TcB);
					     TdK = FMA(KP098491403, TcB, TcM);
					     TdL = FNMS(KP098491403, Tde, Tdp);
					     Tdq = FMA(KP098491403, Tdp, Tde);
					     Tca = FMA(KP980785280, Tc9, Tbw);
					     Te1 = FNMS(KP980785280, Tc9, Tbw);
					     Te2 = TdK - TdL;
					     TdM = TdK + TdL;
					     Tec = FNMS(KP923879532, TdE, TdB);
					     TdF = FMA(KP923879532, TdE, TdB);
					     TdI = TdG + TdH;
					     Teq = TdG - TdH;
					}
					{
					     E TdX, Tdr, TdW, TdJ;
					     Te3 = FMA(KP995184726, Te2, Te1);
					     Te6 = FNMS(KP995184726, Te2, Te1);
					     TdX = Tdq - TcN;
					     Tdr = TcN + Tdq;
					     TdW = FNMS(KP980785280, TdI, TdF);
					     TdJ = FMA(KP980785280, TdI, TdF);
					     TdT = FNMS(KP995184726, Tdr, Tca);
					     Tds = FMA(KP995184726, Tdr, Tca);
					     TdY = FMA(KP995184726, TdX, TdW);
					     Te9 = FNMS(KP995184726, TdX, TdW);
					     TdQ = FNMS(KP995184726, TdM, TdJ);
					     TdN = FMA(KP995184726, TdM, TdJ);
					}
				   }
				   {
					E Te8, Te7, Tb5, Tdu, TdP, TdS;
					Tb5 = W[0];
					Tdu = W[1];
					{
					     E Te5, TdO, Tdt, Tea;
					     Te5 = W[32];
					     Te8 = W[33];
					     TdO = Tb5 * TdN;
					     Tdt = Tb5 * Tds;
					     Tea = Te5 * Te9;
					     Te7 = Te5 * Te6;
					     iio[-WS(ios, 62)] = FMA(Tdu, Tds, TdO);
					     rio[WS(ios, 1)] = FNMS(Tdu, TdN, Tdt);
					     iio[-WS(ios, 46)] = FMA(Te8, Te6, Tea);
					}
					rio[WS(ios, 17)] = FNMS(Te8, Te9, Te7);
					TdP = W[64];
					TdS = W[65];
					{
					     E TdV, TdU, TdR, Te4;
					     TdV = W[96];
					     Te0 = W[97];
					     TdU = TdP * TdT;
					     TdR = TdP * TdQ;
					     Te4 = TdV * Te3;
					     TdZ = TdV * TdY;
					     rio[WS(ios, 33)] = FNMS(TdS, TdQ, TdU);
					     iio[-WS(ios, 30)] = FMA(TdS, TdT, TdR);
					     rio[WS(ios, 49)] = FNMS(Te0, TdY, Te4);
					}
				   }
			      }
			 }
			 iio[-WS(ios, 14)] = FMA(Te0, Te3, TdZ);
			 {
			      E T5V, T5S, T5N, T5W, T5R;
			      {
				   E T5T, T5B, T5v, T5U, T5P, T5E, T5o, T5O;
				   {
					E T5C, T5D, T5r, T5u;
					T5C = FMA(KP668178637, T5p, T5q);
					T5r = FNMS(KP668178637, T5q, T5p);
					T5u = FMA(KP668178637, T5t, T5s);
					T5D = FNMS(KP668178637, T5s, T5t);
					T5T = FNMS(KP923879532, T5A, T5z);
					T5B = FMA(KP923879532, T5A, T5z);
					T5v = T5r + T5u;
					T5U = T5u - T5r;
					T5P = T5C - T5D;
					T5E = T5C + T5D;
					T5o = FMA(KP923879532, T5n, T5m);
					T5O = FNMS(KP923879532, T5n, T5m);
				   }
				   {
					E T5L, T5Q, T5I, T61, T60, T5Z;
					{
					     E T5F, T5y, T5Y, T5w, T5l;
					     T5L = FNMS(KP831469612, T5E, T5B);
					     T5F = FMA(KP831469612, T5E, T5B);
					     T5y = W[11];
					     T5Y = FNMS(KP831469612, T5P, T5O);
					     T5Q = FMA(KP831469612, T5P, T5O);
					     T5w = FMA(KP831469612, T5v, T5o);
					     T5I = FNMS(KP831469612, T5v, T5o);
					     T5l = W[10];
					     {
						  E T5X, T62, T5G, T5x;
						  T61 = FNMS(KP831469612, T5U, T5T);
						  T5V = FMA(KP831469612, T5U, T5T);
						  T60 = W[43];
						  T5G = T5y * T5w;
						  T5x = T5l * T5w;
						  T5X = W[42];
						  T62 = T60 * T5Y;
						  iio[-WS(ios, 57)] = FMA(T5l, T5F, T5G);
						  rio[WS(ios, 6)] = FNMS(T5y, T5F, T5x);
						  T5Z = T5X * T5Y;
						  iio[-WS(ios, 41)] = FMA(T5X, T61, T62);
					     }
					}
					{
					     E T5K, T5H, T5M, T5J;
					     T5K = W[75];
					     rio[WS(ios, 22)] = FNMS(T60, T61, T5Z);
					     T5H = W[74];
					     T5M = T5K * T5I;
					     T5S = W[107];
					     T5J = T5H * T5I;
					     T5N = W[106];
					     iio[-WS(ios, 25)] = FMA(T5H, T5L, T5M);
					     T5W = T5S * T5Q;
					     rio[WS(ios, 38)] = FNMS(T5K, T5L, T5J);
					     T5R = T5N * T5Q;
					}
				   }
			      }
			      {
				   E TeO, TeB, Tem, TeG, TeR, Tey, Tev;
				   {
					E Teh, Tek, Tee, TeJ, TeK, Teu, Tes, Tet;
					iio[-WS(ios, 9)] = FMA(T5N, T5V, T5W);
					rio[WS(ios, 54)] = FNMS(T5S, T5V, T5R);
					Teh = FNMS(KP820678790, Teg, Tef);
					Tes = FMA(KP820678790, Tef, Teg);
					Tet = FNMS(KP820678790, Tei, Tej);
					Tek = FMA(KP820678790, Tej, Tei);
					Tee = FMA(KP980785280, Ted, Tec);
					TeJ = FNMS(KP980785280, Ted, Tec);
					TeK = Tes - Tet;
					Teu = Tes + Tet;
					{
					     E TeF, Tel, TeE, Ter;
					     TeL = FMA(KP773010453, TeK, TeJ);
					     TeO = FNMS(KP773010453, TeK, TeJ);
					     TeF = Tek - Teh;
					     Tel = Teh + Tek;
					     TeE = FNMS(KP980785280, Teq, Tep);
					     Ter = FMA(KP980785280, Teq, Tep);
					     TeB = FNMS(KP773010453, Tel, Tee);
					     Tem = FMA(KP773010453, Tel, Tee);
					     TeG = FMA(KP773010453, TeF, TeE);
					     TeR = FNMS(KP773010453, TeF, TeE);
					     Tey = FNMS(KP773010453, Teu, Ter);
					     Tev = FMA(KP773010453, Teu, Ter);
					}
				   }
				   {
					E TeQ, TeP, Teb, Teo, Tex, TeA;
					Teb = W[112];
					Teo = W[113];
					{
					     E TeN, Tew, Ten, TeS;
					     TeN = W[80];
					     TeQ = W[81];
					     Tew = Teb * Tev;
					     Ten = Teb * Tem;
					     TeS = TeN * TeR;
					     TeP = TeN * TeO;
					     rio[WS(ios, 57)] = FNMS(Teo, Tem, Tew);
					     iio[-WS(ios, 6)] = FMA(Teo, Tev, Ten);
					     rio[WS(ios, 41)] = FNMS(TeQ, TeO, TeS);
					}
					iio[-WS(ios, 22)] = FMA(TeQ, TeR, TeP);
					Tex = W[48];
					TeA = W[49];
					{
					     E TeD, TeC, Tez, TeM;
					     TeD = W[16];
					     TeI = W[17];
					     TeC = Tex * TeB;
					     Tez = Tex * Tey;
					     TeM = TeD * TeL;
					     TeH = TeD * TeG;
					     iio[-WS(ios, 38)] = FMA(TeA, Tey, TeC);
					     rio[WS(ios, 25)] = FNMS(TeA, TeB, Tez);
					     iio[-WS(ios, 54)] = FMA(TeI, TeG, TeM);
					}
				   }
			      }
			 }
		    }
		    rio[WS(ios, 9)] = FNMS(TeI, TeL, TeH);
		    {
			 E T7j, T77, T76, T7k, Tg9, TfX, TfW, Tga, TfN, TfK, TfJ;
			 {
			      E T6X, T6U, T6P, T6Y, T6T;
			      {
				   E T6V, T6D, T6t, T6W, T6R, T6G, T6e, T6Q, T6z, T6C;
				   T7j = FNMS(KP707106781, T6y, T6x);
				   T6z = FMA(KP707106781, T6y, T6x);
				   T6C = T6A + T6B;
				   T77 = T6A - T6B;
				   {
					E T6E, T6F, T66, T6d, T6l, T6s;
					T6E = FMA(KP198912367, T6h, T6k);
					T6l = FNMS(KP198912367, T6k, T6h);
					T6s = FMA(KP198912367, T6r, T6o);
					T6F = FNMS(KP198912367, T6o, T6r);
					T6V = FNMS(KP923879532, T6C, T6z);
					T6D = FMA(KP923879532, T6C, T6z);
					T6t = T6l + T6s;
					T6W = T6s - T6l;
					T66 = FMA(KP707106781, T65, T64);
					T76 = FNMS(KP707106781, T65, T64);
					T7k = T6c - T69;
					T6d = T69 + T6c;
					T6R = T6E - T6F;
					T6G = T6E + T6F;
					T6e = FMA(KP923879532, T6d, T66);
					T6Q = FNMS(KP923879532, T6d, T66);
				   }
				   {
					E T6N, T6S, T6K, T73, T72, T71;
					{
					     E T6H, T6w, T70, T6u, T63;
					     T6N = FNMS(KP980785280, T6G, T6D);
					     T6H = FMA(KP980785280, T6G, T6D);
					     T6w = W[3];
					     T70 = FNMS(KP980785280, T6R, T6Q);
					     T6S = FMA(KP980785280, T6R, T6Q);
					     T6u = FMA(KP980785280, T6t, T6e);
					     T6K = FNMS(KP980785280, T6t, T6e);
					     T63 = W[2];
					     {
						  E T6Z, T74, T6I, T6v;
						  T73 = FNMS(KP980785280, T6W, T6V);
						  T6X = FMA(KP980785280, T6W, T6V);
						  T72 = W[35];
						  T6I = T6w * T6u;
						  T6v = T63 * T6u;
						  T6Z = W[34];
						  T74 = T72 * T70;
						  iio[-WS(ios, 61)] = FMA(T63, T6H, T6I);
						  rio[WS(ios, 2)] = FNMS(T6w, T6H, T6v);
						  T71 = T6Z * T70;
						  iio[-WS(ios, 45)] = FMA(T6Z, T73, T74);
					     }
					}
					{
					     E T6M, T6J, T6O, T6L;
					     T6M = W[67];
					     rio[WS(ios, 18)] = FNMS(T72, T73, T71);
					     T6J = W[66];
					     T6O = T6M * T6K;
					     T6U = W[99];
					     T6L = T6J * T6K;
					     T6P = W[98];
					     iio[-WS(ios, 29)] = FMA(T6J, T6N, T6O);
					     T6Y = T6U * T6S;
					     rio[WS(ios, 34)] = FNMS(T6M, T6N, T6L);
					     T6T = T6P * T6S;
					}
				   }
			      }
			      {
				   E TfQ, TfD, Tfk, TfI, TfT, TfA, Tfx;
				   {
					E Tfb, Tfi, Tf4, TfL, TfM, Tfw, Tfp, Tfs;
					{
					     E Tfu, Tfv, TeW, Tf3;
					     Tg9 = FNMS(KP923879532, TeV, TeU);
					     TeW = FMA(KP923879532, TeV, TeU);
					     iio[-WS(ios, 13)] = FMA(T6P, T6X, T6Y);
					     TfX = Tf2 - TeZ;
					     Tf3 = TeZ + Tf2;
					     rio[WS(ios, 50)] = FNMS(T6U, T6X, T6T);
					     Tfb = FNMS(KP303346683, Tfa, Tf7);
					     Tfu = FMA(KP303346683, Tf7, Tfa);
					     Tfv = FNMS(KP303346683, Tfe, Tfh);
					     Tfi = FMA(KP303346683, Tfh, Tfe);
					     Tf4 = FMA(KP831469612, Tf3, TeW);
					     TfL = FNMS(KP831469612, Tf3, TeW);
					     TfM = Tfu - Tfv;
					     Tfw = Tfu + Tfv;
					     TfW = FNMS(KP923879532, Tfo, Tfn);
					     Tfp = FMA(KP923879532, Tfo, Tfn);
					     Tfs = Tfq + Tfr;
					     Tga = Tfq - Tfr;
					}
					{
					     E TfH, Tfj, TfG, Tft;
					     TfN = FMA(KP956940335, TfM, TfL);
					     TfQ = FNMS(KP956940335, TfM, TfL);
					     TfH = Tfi - Tfb;
					     Tfj = Tfb + Tfi;
					     TfG = FNMS(KP831469612, Tfs, Tfp);
					     Tft = FMA(KP831469612, Tfs, Tfp);
					     TfD = FNMS(KP956940335, Tfj, Tf4);
					     Tfk = FMA(KP956940335, Tfj, Tf4);
					     TfI = FMA(KP956940335, TfH, TfG);
					     TfT = FNMS(KP956940335, TfH, TfG);
					     TfA = FNMS(KP956940335, Tfw, Tft);
					     Tfx = FMA(KP956940335, Tfw, Tft);
					}
				   }
				   {
					E TfS, TfR, TeT, Tfm, Tfz, TfC;
					TeT = W[120];
					Tfm = W[121];
					{
					     E TfP, Tfy, Tfl, TfU;
					     TfP = W[88];
					     TfS = W[89];
					     Tfy = TeT * Tfx;
					     Tfl = TeT * Tfk;
					     TfU = TfP * TfT;
					     TfR = TfP * TfQ;
					     rio[WS(ios, 61)] = FNMS(Tfm, Tfk, Tfy);
					     iio[-WS(ios, 2)] = FMA(Tfm, Tfx, Tfl);
					     rio[WS(ios, 45)] = FNMS(TfS, TfQ, TfU);
					}
					iio[-WS(ios, 18)] = FMA(TfS, TfT, TfR);
					Tfz = W[56];
					TfC = W[57];
					{
					     E TfF, TfE, TfB, TfO;
					     TfF = W[24];
					     TfK = W[25];
					     TfE = Tfz * TfD;
					     TfB = Tfz * TfA;
					     TfO = TfF * TfN;
					     TfJ = TfF * TfI;
					     iio[-WS(ios, 34)] = FMA(TfC, TfA, TfE);
					     rio[WS(ios, 29)] = FNMS(TfC, TfD, TfB);
					     iio[-WS(ios, 50)] = FMA(TfK, TfI, TfO);
					}
				   }
			      }
			 }
			 rio[WS(ios, 13)] = FNMS(TfK, TfN, TfJ);
			 {
			      E T7F, T7C, T7x, T7G, T7B;
			      {
				   E T7D, T7l, T7f, T7E, T7z, T7o, T78, T7y;
				   {
					E T7m, T7n, T7b, T7e;
					T7m = FNMS(KP668178637, T79, T7a);
					T7b = FMA(KP668178637, T7a, T79);
					T7e = FNMS(KP668178637, T7d, T7c);
					T7n = FMA(KP668178637, T7c, T7d);
					T7D = FNMS(KP923879532, T7k, T7j);
					T7l = FMA(KP923879532, T7k, T7j);
					T7f = T7b + T7e;
					T7E = T7b - T7e;
					T7z = T7n - T7m;
					T7o = T7m + T7n;
					T78 = FMA(KP923879532, T77, T76);
					T7y = FNMS(KP923879532, T77, T76);
				   }
				   {
					E T7v, T7A, T7s, T7L, T7K, T7J;
					{
					     E T7p, T7i, T7I, T7g, T75;
					     T7v = FNMS(KP831469612, T7o, T7l);
					     T7p = FMA(KP831469612, T7o, T7l);
					     T7i = W[115];
					     T7I = FNMS(KP831469612, T7z, T7y);
					     T7A = FMA(KP831469612, T7z, T7y);
					     T7g = FMA(KP831469612, T7f, T78);
					     T7s = FNMS(KP831469612, T7f, T78);
					     T75 = W[114];
					     {
						  E T7H, T7M, T7q, T7h;
						  T7L = FNMS(KP831469612, T7E, T7D);
						  T7F = FMA(KP831469612, T7E, T7D);
						  T7K = W[83];
						  T7q = T7i * T7g;
						  T7h = T75 * T7g;
						  T7H = W[82];
						  T7M = T7K * T7I;
						  iio[-WS(ios, 5)] = FMA(T75, T7p, T7q);
						  rio[WS(ios, 58)] = FNMS(T7i, T7p, T7h);
						  T7J = T7H * T7I;
						  iio[-WS(ios, 21)] = FMA(T7H, T7L, T7M);
					     }
					}
					{
					     E T7u, T7r, T7w, T7t;
					     T7u = W[51];
					     rio[WS(ios, 42)] = FNMS(T7K, T7L, T7J);
					     T7r = W[50];
					     T7w = T7u * T7s;
					     T7C = W[19];
					     T7t = T7r * T7s;
					     T7x = W[18];
					     iio[-WS(ios, 37)] = FMA(T7r, T7v, T7w);
					     T7G = T7C * T7A;
					     rio[WS(ios, 26)] = FNMS(T7u, T7v, T7t);
					     T7B = T7x * T7A;
					}
				   }
			      }
			      {
				   E Tgy, Tgl, Tg6, Tgq, TgB, Tgi, Tgf;
				   {
					E Tg1, Tg4, TfY, Tgt, Tgu, Tge, Tgc, Tgd;
					iio[-WS(ios, 53)] = FMA(T7x, T7F, T7G);
					rio[WS(ios, 10)] = FNMS(T7C, T7F, T7B);
					Tg1 = FNMS(KP534511135, Tg0, TfZ);
					Tgc = FMA(KP534511135, TfZ, Tg0);
					Tgd = FNMS(KP534511135, Tg2, Tg3);
					Tg4 = FMA(KP534511135, Tg3, Tg2);
					TfY = FMA(KP831469612, TfX, TfW);
					Tgt = FNMS(KP831469612, TfX, TfW);
					Tgu = Tgc - Tgd;
					Tge = Tgc + Tgd;
					{
					     E Tgp, Tg5, Tgo, Tgb;
					     Tgv = FMA(KP881921264, Tgu, Tgt);
					     Tgy = FNMS(KP881921264, Tgu, Tgt);
					     Tgp = Tg4 - Tg1;
					     Tg5 = Tg1 + Tg4;
					     Tgo = FNMS(KP831469612, Tga, Tg9);
					     Tgb = FMA(KP831469612, Tga, Tg9);
					     Tgl = FNMS(KP881921264, Tg5, TfY);
					     Tg6 = FMA(KP881921264, Tg5, TfY);
					     Tgq = FMA(KP881921264, Tgp, Tgo);
					     TgB = FNMS(KP881921264, Tgp, Tgo);
					     Tgi = FNMS(KP881921264, Tge, Tgb);
					     Tgf = FMA(KP881921264, Tge, Tgb);
					}
				   }
				   {
					E TgA, Tgz, TfV, Tg8, Tgh, Tgk;
					TfV = W[8];
					Tg8 = W[9];
					{
					     E Tgx, Tgg, Tg7, TgC;
					     Tgx = W[40];
					     TgA = W[41];
					     Tgg = TfV * Tgf;
					     Tg7 = TfV * Tg6;
					     TgC = Tgx * TgB;
					     Tgz = Tgx * Tgy;
					     iio[-WS(ios, 58)] = FMA(Tg8, Tg6, Tgg);
					     rio[WS(ios, 5)] = FNMS(Tg8, Tgf, Tg7);
					     iio[-WS(ios, 42)] = FMA(TgA, Tgy, TgC);
					}
					rio[WS(ios, 21)] = FNMS(TgA, TgB, Tgz);
					Tgh = W[72];
					Tgk = W[73];
					{
					     E Tgn, Tgm, Tgj, Tgw;
					     Tgn = W[104];
					     Tgs = W[105];
					     Tgm = Tgh * Tgl;
					     Tgj = Tgh * Tgi;
					     Tgw = Tgn * Tgv;
					     Tgr = Tgn * Tgq;
					     rio[WS(ios, 37)] = FNMS(Tgk, Tgi, Tgm);
					     iio[-WS(ios, 26)] = FMA(Tgk, Tgl, Tgj);
					     rio[WS(ios, 53)] = FNMS(Tgs, Tgq, Tgw);
					}
				   }
			      }
			 }
		    }
	       }
	  }
	  iio[-WS(ios, 10)] = FMA(Tgs, Tgv, Tgr);
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 64},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 64, "hb_64", twinstr, &GENUS, {520, 126, 518, 0}, 0, 0, 0 };

void X(codelet_hb_64) (planner *p) {
     X(khc2hc_register) (p, hb_64, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc -compact -variables 4 -pipeline-latency 4 -sign 1 -n 64 -dif -name hb_64 -include hb.h */

/*
 * This function contains 1038 FP additions, 500 FP multiplications,
 * (or, 808 additions, 270 multiplications, 230 fused multiply/add),
 * 196 stack variables, and 256 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hb.h"

static const R *hb_64(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 126, MAKE_VOLATILE_STRIDE(ios)) {
	  E Tf, T7i, Tfa, ThM, Tgp, ThH, T2c, T5O, T4T, T6n, Tcp, Ted, TcA, TdE, T87;
	  E T9o, TK, T93, T2P, T4F, Tfo, Thz, T5T, T6j, Tbx, TdI, Tfl, ThA, T7r, T81;
	  E TbE, TdH, TZ, T94, T38, T4G, Tfv, ThC, T5W, T6k, TbQ, TdK, Tfs, ThD, T7w;
	  E T82, TbX, TdL, Tu, T84, Tfh, ThG, Tgm, ThN, T2v, T6m, T4K, T5P, Tce, TdF;
	  E TcD, Tec, T7l, T9p, T1L, T20, T9c, T9d, T9e, T9f, T40, T66, Tg1, Thu, Tg8;
	  E Thv, Tg5, Thr, T4n, T67, T4j, T69, T4w, T6a, TaT, TdW, Tb8, TdZ, TfU, Ths;
	  E T7O, T8y, T7T, T8z, Tbc, TdX, Tbj, Te0, T1g, T1v, T97, T98, T99, T9a, T3j;
	  E T5Z, TfI, Thk, TfP, Thl, TfM, Tho, T3G, T60, T3C, T62, T3P, T63, Tak, TdQ;
	  E Tav, TdT, TfB, Thn, T7D, T8v, T7I, T8w, TaD, TdP, TaG, TdS;
	  {
	       E T3, Tcm, T4O, Tcv, T6, Tcu, T4R, Tcn, Td, Tcy, T2a, Tch, Ta, Tcx, T27;
	       E Tck;
	       {
		    E T1, T2, T4P, T4Q;
		    T1 = rio[0];
		    T2 = iio[-WS(ios, 32)];
		    T3 = T1 + T2;
		    Tcm = T1 - T2;
		    {
			 E T4M, T4N, T4, T5;
			 T4M = iio[0];
			 T4N = rio[WS(ios, 32)];
			 T4O = T4M - T4N;
			 Tcv = T4M + T4N;
			 T4 = rio[WS(ios, 16)];
			 T5 = iio[-WS(ios, 48)];
			 T6 = T4 + T5;
			 Tcu = T4 - T5;
		    }
		    T4P = iio[-WS(ios, 16)];
		    T4Q = rio[WS(ios, 48)];
		    T4R = T4P - T4Q;
		    Tcn = T4P + T4Q;
		    {
			 E Tb, Tc, Tcf, T28, T29, Tcg;
			 Tb = iio[-WS(ios, 56)];
			 Tc = rio[WS(ios, 24)];
			 Tcf = Tb - Tc;
			 T28 = iio[-WS(ios, 24)];
			 T29 = rio[WS(ios, 56)];
			 Tcg = T29 + T28;
			 Td = Tb + Tc;
			 Tcy = Tcf + Tcg;
			 T2a = T28 - T29;
			 Tch = Tcf - Tcg;
		    }
		    {
			 E T8, T9, Tcj, T25, T26, Tci;
			 T8 = rio[WS(ios, 8)];
			 T9 = iio[-WS(ios, 40)];
			 Tcj = T8 - T9;
			 T25 = iio[-WS(ios, 8)];
			 T26 = rio[WS(ios, 40)];
			 Tci = T25 + T26;
			 Ta = T8 + T9;
			 Tcx = Tcj + Tci;
			 T27 = T25 - T26;
			 Tck = Tci - Tcj;
		    }
	       }
	       {
		    E T7, Te, Tf8, Tf9;
		    T7 = T3 + T6;
		    Te = Ta + Td;
		    Tf = T7 + Te;
		    T7i = T7 - Te;
		    Tf8 = Tcv - Tcu;
		    Tf9 = KP707106781 * (Tck + Tch);
		    Tfa = Tf8 + Tf9;
		    ThM = Tf8 - Tf9;
	       }
	       {
		    E Tgn, Tgo, T24, T2b;
		    Tgn = KP707106781 * (Tcx + Tcy);
		    Tgo = Tcm + Tcn;
		    Tgp = Tgn + Tgo;
		    ThH = Tgo - Tgn;
		    T24 = T3 - T6;
		    T2b = T27 - T2a;
		    T2c = T24 + T2b;
		    T5O = T24 - T2b;
	       }
	       {
		    E T4L, T4S, Tcl, Tco;
		    T4L = Td - Ta;
		    T4S = T4O - T4R;
		    T4T = T4L + T4S;
		    T6n = T4S - T4L;
		    Tcl = KP707106781 * (Tch - Tck);
		    Tco = Tcm - Tcn;
		    Tcp = Tcl + Tco;
		    Ted = Tco - Tcl;
	       }
	       {
		    E Tcw, Tcz, T85, T86;
		    Tcw = Tcu + Tcv;
		    Tcz = KP707106781 * (Tcx - Tcy);
		    TcA = Tcw + Tcz;
		    TdE = Tcw - Tcz;
		    T85 = T4O + T4R;
		    T86 = T27 + T2a;
		    T87 = T85 - T86;
		    T9o = T86 + T85;
	       }
	  }
	  {
	       E TC, Tby, T2x, Tbu, T2N, Tbz, T7o, Tbv, TJ, TbB, TbC, T2E, T2G, Tbp, Tbs;
	       E T7p, Tfj, Tfk;
	       {
		    E Tw, Tx, Ty, Tz, TA, TB;
		    Tw = rio[WS(ios, 2)];
		    Tx = iio[-WS(ios, 34)];
		    Ty = Tw + Tx;
		    Tz = rio[WS(ios, 18)];
		    TA = iio[-WS(ios, 50)];
		    TB = Tz + TA;
		    TC = Ty + TB;
		    Tby = Tz - TA;
		    T2x = Ty - TB;
		    Tbu = Tw - Tx;
	       }
	       {
		    E T2H, T2I, T2J, T2K, T2L, T2M;
		    T2H = iio[-WS(ios, 2)];
		    T2I = rio[WS(ios, 34)];
		    T2J = T2H - T2I;
		    T2K = iio[-WS(ios, 18)];
		    T2L = rio[WS(ios, 50)];
		    T2M = T2K - T2L;
		    T2N = T2J - T2M;
		    Tbz = T2H + T2I;
		    T7o = T2J + T2M;
		    Tbv = T2K + T2L;
	       }
	       {
		    E TF, Tbr, T2A, Tbq, TI, Tbn, T2D, Tbo;
		    {
			 E TD, TE, T2y, T2z;
			 TD = rio[WS(ios, 10)];
			 TE = iio[-WS(ios, 42)];
			 TF = TD + TE;
			 Tbr = TD - TE;
			 T2y = iio[-WS(ios, 10)];
			 T2z = rio[WS(ios, 42)];
			 T2A = T2y - T2z;
			 Tbq = T2y + T2z;
		    }
		    {
			 E TG, TH, T2B, T2C;
			 TG = iio[-WS(ios, 58)];
			 TH = rio[WS(ios, 26)];
			 TI = TG + TH;
			 Tbn = TG - TH;
			 T2B = iio[-WS(ios, 26)];
			 T2C = rio[WS(ios, 58)];
			 T2D = T2B - T2C;
			 Tbo = T2C + T2B;
		    }
		    TJ = TF + TI;
		    TbB = Tbr + Tbq;
		    TbC = Tbn + Tbo;
		    T2E = T2A - T2D;
		    T2G = TI - TF;
		    Tbp = Tbn - Tbo;
		    Tbs = Tbq - Tbr;
		    T7p = T2A + T2D;
	       }
	       TK = TC + TJ;
	       T93 = T7p + T7o;
	       {
		    E T2F, T2O, Tfm, Tfn;
		    T2F = T2x + T2E;
		    T2O = T2G + T2N;
		    T2P = FMA(KP923879532, T2F, KP382683432 * T2O);
		    T4F = FNMS(KP382683432, T2F, KP923879532 * T2O);
		    Tfm = KP707106781 * (TbB + TbC);
		    Tfn = Tbu + Tbv;
		    Tfo = Tfm + Tfn;
		    Thz = Tfn - Tfm;
	       }
	       {
		    E T5R, T5S, Tbt, Tbw;
		    T5R = T2x - T2E;
		    T5S = T2N - T2G;
		    T5T = FNMS(KP382683432, T5S, KP923879532 * T5R);
		    T6j = FMA(KP382683432, T5R, KP923879532 * T5S);
		    Tbt = KP707106781 * (Tbp - Tbs);
		    Tbw = Tbu - Tbv;
		    Tbx = Tbt + Tbw;
		    TdI = Tbw - Tbt;
	       }
	       Tfj = Tbz - Tby;
	       Tfk = KP707106781 * (Tbs + Tbp);
	       Tfl = Tfj + Tfk;
	       ThA = Tfj - Tfk;
	       {
		    E T7n, T7q, TbA, TbD;
		    T7n = TC - TJ;
		    T7q = T7o - T7p;
		    T7r = T7n + T7q;
		    T81 = T7q - T7n;
		    TbA = Tby + Tbz;
		    TbD = KP707106781 * (TbB - TbC);
		    TbE = TbA + TbD;
		    TdH = TbA - TbD;
	       }
	  }
	  {
	       E TR, TbU, T2Q, TbN, T36, TbV, T7t, TbO, TY, TbR, TbS, T2X, T2Z, TbI, TbL;
	       E T7u, Tfq, Tfr;
	       {
		    E TL, TM, TN, TO, TP, TQ;
		    TL = iio[-WS(ios, 62)];
		    TM = rio[WS(ios, 30)];
		    TN = TL + TM;
		    TO = rio[WS(ios, 14)];
		    TP = iio[-WS(ios, 46)];
		    TQ = TO + TP;
		    TR = TN + TQ;
		    TbU = TL - TM;
		    T2Q = TN - TQ;
		    TbN = TO - TP;
	       }
	       {
		    E T30, T31, T32, T33, T34, T35;
		    T30 = iio[-WS(ios, 30)];
		    T31 = rio[WS(ios, 62)];
		    T32 = T30 - T31;
		    T33 = iio[-WS(ios, 14)];
		    T34 = rio[WS(ios, 46)];
		    T35 = T33 - T34;
		    T36 = T32 - T35;
		    TbV = T33 + T34;
		    T7t = T32 + T35;
		    TbO = T31 + T30;
	       }
	       {
		    E TU, TbG, T2T, TbH, TX, TbJ, T2W, TbK;
		    {
			 E TS, TT, T2R, T2S;
			 TS = rio[WS(ios, 6)];
			 TT = iio[-WS(ios, 38)];
			 TU = TS + TT;
			 TbG = TS - TT;
			 T2R = iio[-WS(ios, 6)];
			 T2S = rio[WS(ios, 38)];
			 T2T = T2R - T2S;
			 TbH = T2R + T2S;
		    }
		    {
			 E TV, TW, T2U, T2V;
			 TV = iio[-WS(ios, 54)];
			 TW = rio[WS(ios, 22)];
			 TX = TV + TW;
			 TbJ = TV - TW;
			 T2U = iio[-WS(ios, 22)];
			 T2V = rio[WS(ios, 54)];
			 T2W = T2U - T2V;
			 TbK = T2V + T2U;
		    }
		    TY = TU + TX;
		    TbR = TbJ - TbK;
		    TbS = TbH - TbG;
		    T2X = T2T - T2W;
		    T2Z = TX - TU;
		    TbI = TbG + TbH;
		    TbL = TbJ + TbK;
		    T7u = T2T + T2W;
	       }
	       TZ = TR + TY;
	       T94 = T7u + T7t;
	       {
		    E T2Y, T37, Tft, Tfu;
		    T2Y = T2Q + T2X;
		    T37 = T2Z + T36;
		    T38 = FNMS(KP382683432, T37, KP923879532 * T2Y);
		    T4G = FMA(KP382683432, T2Y, KP923879532 * T37);
		    Tft = KP707106781 * (TbI + TbL);
		    Tfu = TbU + TbV;
		    Tfv = Tft + Tfu;
		    ThC = Tfu - Tft;
	       }
	       {
		    E T5U, T5V, TbM, TbP;
		    T5U = T2Q - T2X;
		    T5V = T36 - T2Z;
		    T5W = FMA(KP923879532, T5U, KP382683432 * T5V);
		    T6k = FNMS(KP382683432, T5U, KP923879532 * T5V);
		    TbM = KP707106781 * (TbI - TbL);
		    TbP = TbN - TbO;
		    TbQ = TbM + TbP;
		    TdK = TbP - TbM;
	       }
	       Tfq = KP707106781 * (TbS + TbR);
	       Tfr = TbN + TbO;
	       Tfs = Tfq - Tfr;
	       ThD = Tfq + Tfr;
	       {
		    E T7s, T7v, TbT, TbW;
		    T7s = TR - TY;
		    T7v = T7t - T7u;
		    T7w = T7s - T7v;
		    T82 = T7s + T7v;
		    TbT = KP707106781 * (TbR - TbS);
		    TbW = TbU - TbV;
		    TbX = TbT + TbW;
		    TdL = TbW - TbT;
	       }
	  }
	  {
	       E Ti, T2g, Tl, T2j, T2d, T2k, Tfc, Tfb, Tc5, Tc2, Tp, T2p, Ts, T2s, T2m;
	       E T2t, Tff, Tfe, Tcc, Tc9;
	       {
		    E Tc0, Tc4, Tc3, Tc1;
		    {
			 E Tg, Th, T2e, T2f;
			 Tg = rio[WS(ios, 4)];
			 Th = iio[-WS(ios, 36)];
			 Ti = Tg + Th;
			 Tc0 = Tg - Th;
			 T2e = iio[-WS(ios, 4)];
			 T2f = rio[WS(ios, 36)];
			 T2g = T2e - T2f;
			 Tc4 = T2e + T2f;
		    }
		    {
			 E Tj, Tk, T2h, T2i;
			 Tj = rio[WS(ios, 20)];
			 Tk = iio[-WS(ios, 52)];
			 Tl = Tj + Tk;
			 Tc3 = Tj - Tk;
			 T2h = iio[-WS(ios, 20)];
			 T2i = rio[WS(ios, 52)];
			 T2j = T2h - T2i;
			 Tc1 = T2h + T2i;
		    }
		    T2d = Ti - Tl;
		    T2k = T2g - T2j;
		    Tfc = Tc0 + Tc1;
		    Tfb = Tc4 - Tc3;
		    Tc5 = Tc3 + Tc4;
		    Tc2 = Tc0 - Tc1;
	       }
	       {
		    E Tc7, Tcb, Tca, Tc8;
		    {
			 E Tn, To, T2n, T2o;
			 Tn = iio[-WS(ios, 60)];
			 To = rio[WS(ios, 28)];
			 Tp = Tn + To;
			 Tc7 = Tn - To;
			 T2n = iio[-WS(ios, 28)];
			 T2o = rio[WS(ios, 60)];
			 T2p = T2n - T2o;
			 Tcb = T2o + T2n;
		    }
		    {
			 E Tq, Tr, T2q, T2r;
			 Tq = rio[WS(ios, 12)];
			 Tr = iio[-WS(ios, 44)];
			 Ts = Tq + Tr;
			 Tca = Tq - Tr;
			 T2q = iio[-WS(ios, 12)];
			 T2r = rio[WS(ios, 44)];
			 T2s = T2q - T2r;
			 Tc8 = T2q + T2r;
		    }
		    T2m = Tp - Ts;
		    T2t = T2p - T2s;
		    Tff = Tca + Tcb;
		    Tfe = Tc7 + Tc8;
		    Tcc = Tca - Tcb;
		    Tc9 = Tc7 - Tc8;
	       }
	       {
		    E Tm, Tt, Tfd, Tfg;
		    Tm = Ti + Tl;
		    Tt = Tp + Ts;
		    Tu = Tm + Tt;
		    T84 = Tt - Tm;
		    Tfd = FNMS(KP382683432, Tfc, KP923879532 * Tfb);
		    Tfg = FNMS(KP923879532, Tff, KP382683432 * Tfe);
		    Tfh = Tfd + Tfg;
		    ThG = Tfg - Tfd;
	       }
	       {
		    E Tgk, Tgl, T2l, T2u;
		    Tgk = FMA(KP382683432, Tfb, KP923879532 * Tfc);
		    Tgl = FMA(KP923879532, Tfe, KP382683432 * Tff);
		    Tgm = Tgk + Tgl;
		    ThN = Tgk - Tgl;
		    T2l = T2d + T2k;
		    T2u = T2m - T2t;
		    T2v = KP707106781 * (T2l + T2u);
		    T6m = KP707106781 * (T2l - T2u);
	       }
	       {
		    E T4I, T4J, Tc6, Tcd;
		    T4I = T2k - T2d;
		    T4J = T2m + T2t;
		    T4K = KP707106781 * (T4I + T4J);
		    T5P = KP707106781 * (T4J - T4I);
		    Tc6 = FNMS(KP382683432, Tc5, KP923879532 * Tc2);
		    Tcd = FMA(KP923879532, Tc9, KP382683432 * Tcc);
		    Tce = Tc6 + Tcd;
		    TdF = Tcd - Tc6;
	       }
	       {
		    E TcB, TcC, T7j, T7k;
		    TcB = FMA(KP923879532, Tc5, KP382683432 * Tc2);
		    TcC = FNMS(KP382683432, Tc9, KP923879532 * Tcc);
		    TcD = TcB + TcC;
		    Tec = TcB - TcC;
		    T7j = T2g + T2j;
		    T7k = T2s + T2p;
		    T7l = T7j - T7k;
		    T9p = T7j + T7k;
	       }
	  }
	  {
	       E T1z, T1C, T1D, Tbg, TaQ, T4r, T4u, T7Q, Tbh, TaR, T1G, T3V, T1J, T3Y, T1K;
	       E T7R, Tbe, Tbd, TaO, TaL, T1S, TfV, TfW, T41, T48, TaW, TaZ, T7L, T1Z, TfY;
	       E TfZ, T4a, T4h, Tb3, Tb6, T7M;
	       {
		    E T1x, T1y, T1A, T1B;
		    T1x = iio[-WS(ios, 63)];
		    T1y = rio[WS(ios, 31)];
		    T1z = T1x + T1y;
		    T1A = rio[WS(ios, 15)];
		    T1B = iio[-WS(ios, 47)];
		    T1C = T1A + T1B;
		    T1D = T1z + T1C;
		    Tbg = T1x - T1y;
		    TaQ = T1A - T1B;
	       }
	       {
		    E T4p, T4q, T4s, T4t;
		    T4p = iio[-WS(ios, 31)];
		    T4q = rio[WS(ios, 63)];
		    T4r = T4p - T4q;
		    T4s = iio[-WS(ios, 15)];
		    T4t = rio[WS(ios, 47)];
		    T4u = T4s - T4t;
		    T7Q = T4r + T4u;
		    Tbh = T4s + T4t;
		    TaR = T4q + T4p;
	       }
	       {
		    E TaJ, TaK, TaM, TaN;
		    {
			 E T1E, T1F, T3T, T3U;
			 T1E = rio[WS(ios, 7)];
			 T1F = iio[-WS(ios, 39)];
			 T1G = T1E + T1F;
			 TaJ = T1E - T1F;
			 T3T = iio[-WS(ios, 7)];
			 T3U = rio[WS(ios, 39)];
			 T3V = T3T - T3U;
			 TaK = T3T + T3U;
		    }
		    {
			 E T1H, T1I, T3W, T3X;
			 T1H = iio[-WS(ios, 55)];
			 T1I = rio[WS(ios, 23)];
			 T1J = T1H + T1I;
			 TaM = T1H - T1I;
			 T3W = iio[-WS(ios, 23)];
			 T3X = rio[WS(ios, 55)];
			 T3Y = T3W - T3X;
			 TaN = T3X + T3W;
		    }
		    T1K = T1G + T1J;
		    T7R = T3V + T3Y;
		    Tbe = TaK - TaJ;
		    Tbd = TaM - TaN;
		    TaO = TaM + TaN;
		    TaL = TaJ + TaK;
	       }
	       {
		    E T1O, TaX, T44, TaV, T1R, TaU, T47, TaY;
		    {
			 E T1M, T1N, T42, T43;
			 T1M = rio[WS(ios, 3)];
			 T1N = iio[-WS(ios, 35)];
			 T1O = T1M + T1N;
			 TaX = T1M - T1N;
			 T42 = iio[-WS(ios, 3)];
			 T43 = rio[WS(ios, 35)];
			 T44 = T42 - T43;
			 TaV = T42 + T43;
		    }
		    {
			 E T1P, T1Q, T45, T46;
			 T1P = rio[WS(ios, 19)];
			 T1Q = iio[-WS(ios, 51)];
			 T1R = T1P + T1Q;
			 TaU = T1P - T1Q;
			 T45 = iio[-WS(ios, 19)];
			 T46 = rio[WS(ios, 51)];
			 T47 = T45 - T46;
			 TaY = T45 + T46;
		    }
		    T1S = T1O + T1R;
		    TfV = TaV - TaU;
		    TfW = TaX + TaY;
		    T41 = T1O - T1R;
		    T48 = T44 - T47;
		    TaW = TaU + TaV;
		    TaZ = TaX - TaY;
		    T7L = T44 + T47;
	       }
	       {
		    E T1V, Tb4, T4d, Tb2, T1Y, Tb1, T4g, Tb5;
		    {
			 E T1T, T1U, T4b, T4c;
			 T1T = iio[-WS(ios, 59)];
			 T1U = rio[WS(ios, 27)];
			 T1V = T1T + T1U;
			 Tb4 = T1T - T1U;
			 T4b = iio[-WS(ios, 27)];
			 T4c = rio[WS(ios, 59)];
			 T4d = T4b - T4c;
			 Tb2 = T4c + T4b;
		    }
		    {
			 E T1W, T1X, T4e, T4f;
			 T1W = rio[WS(ios, 11)];
			 T1X = iio[-WS(ios, 43)];
			 T1Y = T1W + T1X;
			 Tb1 = T1W - T1X;
			 T4e = iio[-WS(ios, 11)];
			 T4f = rio[WS(ios, 43)];
			 T4g = T4e - T4f;
			 Tb5 = T4e + T4f;
		    }
		    T1Z = T1V + T1Y;
		    TfY = Tb4 + Tb5;
		    TfZ = Tb1 + Tb2;
		    T4a = T1V - T1Y;
		    T4h = T4d - T4g;
		    Tb3 = Tb1 - Tb2;
		    Tb6 = Tb4 - Tb5;
		    T7M = T4g + T4d;
	       }
	       T1L = T1D + T1K;
	       T20 = T1S + T1Z;
	       T9c = T1L - T20;
	       T9d = T7R + T7Q;
	       T9e = T7L + T7M;
	       T9f = T9d - T9e;
	       {
		    E T3S, T3Z, TfX, Tg0;
		    T3S = T1z - T1C;
		    T3Z = T3V - T3Y;
		    T40 = T3S + T3Z;
		    T66 = T3S - T3Z;
		    TfX = FNMS(KP382683432, TfW, KP923879532 * TfV);
		    Tg0 = FNMS(KP923879532, TfZ, KP382683432 * TfY);
		    Tg1 = TfX + Tg0;
		    Thu = Tg0 - TfX;
	       }
	       {
		    E Tg6, Tg7, Tg3, Tg4;
		    Tg6 = KP707106781 * (TaL + TaO);
		    Tg7 = Tbg + Tbh;
		    Tg8 = Tg6 + Tg7;
		    Thv = Tg7 - Tg6;
		    Tg3 = FMA(KP382683432, TfV, KP923879532 * TfW);
		    Tg4 = FMA(KP923879532, TfY, KP382683432 * TfZ);
		    Tg5 = Tg3 + Tg4;
		    Thr = Tg3 - Tg4;
	       }
	       {
		    E T4l, T4m, T49, T4i;
		    T4l = T48 - T41;
		    T4m = T4a + T4h;
		    T4n = KP707106781 * (T4l + T4m);
		    T67 = KP707106781 * (T4m - T4l);
		    T49 = T41 + T48;
		    T4i = T4a - T4h;
		    T4j = KP707106781 * (T49 + T4i);
		    T69 = KP707106781 * (T49 - T4i);
	       }
	       {
		    E T4o, T4v, TaP, TaS;
		    T4o = T1J - T1G;
		    T4v = T4r - T4u;
		    T4w = T4o + T4v;
		    T6a = T4v - T4o;
		    TaP = KP707106781 * (TaL - TaO);
		    TaS = TaQ - TaR;
		    TaT = TaP + TaS;
		    TdW = TaS - TaP;
	       }
	       {
		    E Tb0, Tb7, TfS, TfT;
		    Tb0 = FMA(KP923879532, TaW, KP382683432 * TaZ);
		    Tb7 = FNMS(KP382683432, Tb6, KP923879532 * Tb3);
		    Tb8 = Tb0 + Tb7;
		    TdZ = Tb0 - Tb7;
		    TfS = KP707106781 * (Tbe + Tbd);
		    TfT = TaQ + TaR;
		    TfU = TfS - TfT;
		    Ths = TfS + TfT;
	       }
	       {
		    E T7K, T7N, T7P, T7S;
		    T7K = T1D - T1K;
		    T7N = T7L - T7M;
		    T7O = T7K + T7N;
		    T8y = T7K - T7N;
		    T7P = T1Z - T1S;
		    T7S = T7Q - T7R;
		    T7T = T7P + T7S;
		    T8z = T7S - T7P;
	       }
	       {
		    E Tba, Tbb, Tbf, Tbi;
		    Tba = FNMS(KP382683432, TaW, KP923879532 * TaZ);
		    Tbb = FMA(KP923879532, Tb6, KP382683432 * Tb3);
		    Tbc = Tba + Tbb;
		    TdX = Tbb - Tba;
		    Tbf = KP707106781 * (Tbd - Tbe);
		    Tbi = Tbg - Tbh;
		    Tbj = Tbf + Tbi;
		    Te0 = Tbi - Tbf;
	       }
	  }
	  {
	       E T14, T17, T18, Tax, Tas, T3K, T3N, T7F, Tay, Tat, T1b, T3e, T1e, T3h, T1f;
	       E T7G, TaB, TaA, Taq, Tan, T1n, TfC, TfD, T3k, T3r, Ta8, Tab, T7A, T1u, TfF;
	       E TfG, T3t, T3A, Taf, Tai, T7B;
	       {
		    E T12, T13, T15, T16;
		    T12 = rio[WS(ios, 1)];
		    T13 = iio[-WS(ios, 33)];
		    T14 = T12 + T13;
		    T15 = rio[WS(ios, 17)];
		    T16 = iio[-WS(ios, 49)];
		    T17 = T15 + T16;
		    T18 = T14 + T17;
		    Tax = T15 - T16;
		    Tas = T12 - T13;
	       }
	       {
		    E T3I, T3J, T3L, T3M;
		    T3I = iio[-WS(ios, 1)];
		    T3J = rio[WS(ios, 33)];
		    T3K = T3I - T3J;
		    T3L = iio[-WS(ios, 17)];
		    T3M = rio[WS(ios, 49)];
		    T3N = T3L - T3M;
		    T7F = T3K + T3N;
		    Tay = T3I + T3J;
		    Tat = T3L + T3M;
	       }
	       {
		    E Tap, Tao, Tal, Tam;
		    {
			 E T19, T1a, T3c, T3d;
			 T19 = rio[WS(ios, 9)];
			 T1a = iio[-WS(ios, 41)];
			 T1b = T19 + T1a;
			 Tap = T19 - T1a;
			 T3c = iio[-WS(ios, 9)];
			 T3d = rio[WS(ios, 41)];
			 T3e = T3c - T3d;
			 Tao = T3c + T3d;
		    }
		    {
			 E T1c, T1d, T3f, T3g;
			 T1c = iio[-WS(ios, 57)];
			 T1d = rio[WS(ios, 25)];
			 T1e = T1c + T1d;
			 Tal = T1c - T1d;
			 T3f = iio[-WS(ios, 25)];
			 T3g = rio[WS(ios, 57)];
			 T3h = T3f - T3g;
			 Tam = T3g + T3f;
		    }
		    T1f = T1b + T1e;
		    T7G = T3e + T3h;
		    TaB = Tal + Tam;
		    TaA = Tap + Tao;
		    Taq = Tao - Tap;
		    Tan = Tal - Tam;
	       }
	       {
		    E T1j, Ta6, T3n, Taa, T1m, Ta9, T3q, Ta7;
		    {
			 E T1h, T1i, T3l, T3m;
			 T1h = rio[WS(ios, 5)];
			 T1i = iio[-WS(ios, 37)];
			 T1j = T1h + T1i;
			 Ta6 = T1h - T1i;
			 T3l = iio[-WS(ios, 5)];
			 T3m = rio[WS(ios, 37)];
			 T3n = T3l - T3m;
			 Taa = T3l + T3m;
		    }
		    {
			 E T1k, T1l, T3o, T3p;
			 T1k = rio[WS(ios, 21)];
			 T1l = iio[-WS(ios, 53)];
			 T1m = T1k + T1l;
			 Ta9 = T1k - T1l;
			 T3o = iio[-WS(ios, 21)];
			 T3p = rio[WS(ios, 53)];
			 T3q = T3o - T3p;
			 Ta7 = T3o + T3p;
		    }
		    T1n = T1j + T1m;
		    TfC = Taa - Ta9;
		    TfD = Ta6 + Ta7;
		    T3k = T1j - T1m;
		    T3r = T3n - T3q;
		    Ta8 = Ta6 - Ta7;
		    Tab = Ta9 + Taa;
		    T7A = T3n + T3q;
	       }
	       {
		    E T1q, Tad, T3w, Tah, T1t, Tag, T3z, Tae;
		    {
			 E T1o, T1p, T3u, T3v;
			 T1o = iio[-WS(ios, 61)];
			 T1p = rio[WS(ios, 29)];
			 T1q = T1o + T1p;
			 Tad = T1o - T1p;
			 T3u = iio[-WS(ios, 29)];
			 T3v = rio[WS(ios, 61)];
			 T3w = T3u - T3v;
			 Tah = T3v + T3u;
		    }
		    {
			 E T1r, T1s, T3x, T3y;
			 T1r = rio[WS(ios, 13)];
			 T1s = iio[-WS(ios, 45)];
			 T1t = T1r + T1s;
			 Tag = T1r - T1s;
			 T3x = iio[-WS(ios, 13)];
			 T3y = rio[WS(ios, 45)];
			 T3z = T3x - T3y;
			 Tae = T3x + T3y;
		    }
		    T1u = T1q + T1t;
		    TfF = Tad + Tae;
		    TfG = Tag + Tah;
		    T3t = T1q - T1t;
		    T3A = T3w - T3z;
		    Taf = Tad - Tae;
		    Tai = Tag - Tah;
		    T7B = T3z + T3w;
	       }
	       T1g = T18 + T1f;
	       T1v = T1n + T1u;
	       T97 = T1g - T1v;
	       T98 = T7G + T7F;
	       T99 = T7A + T7B;
	       T9a = T98 - T99;
	       {
		    E T3b, T3i, TfE, TfH;
		    T3b = T14 - T17;
		    T3i = T3e - T3h;
		    T3j = T3b + T3i;
		    T5Z = T3b - T3i;
		    TfE = FNMS(KP382683432, TfD, KP923879532 * TfC);
		    TfH = FNMS(KP923879532, TfG, KP382683432 * TfF);
		    TfI = TfE + TfH;
		    Thk = TfH - TfE;
	       }
	       {
		    E TfN, TfO, TfK, TfL;
		    TfN = KP707106781 * (TaA + TaB);
		    TfO = Tas + Tat;
		    TfP = TfN + TfO;
		    Thl = TfO - TfN;
		    TfK = FMA(KP382683432, TfC, KP923879532 * TfD);
		    TfL = FMA(KP923879532, TfF, KP382683432 * TfG);
		    TfM = TfK + TfL;
		    Tho = TfK - TfL;
	       }
	       {
		    E T3E, T3F, T3s, T3B;
		    T3E = T3r - T3k;
		    T3F = T3t + T3A;
		    T3G = KP707106781 * (T3E + T3F);
		    T60 = KP707106781 * (T3F - T3E);
		    T3s = T3k + T3r;
		    T3B = T3t - T3A;
		    T3C = KP707106781 * (T3s + T3B);
		    T62 = KP707106781 * (T3s - T3B);
	       }
	       {
		    E T3H, T3O, Tac, Taj;
		    T3H = T1e - T1b;
		    T3O = T3K - T3N;
		    T3P = T3H + T3O;
		    T63 = T3O - T3H;
		    Tac = FNMS(KP382683432, Tab, KP923879532 * Ta8);
		    Taj = FMA(KP923879532, Taf, KP382683432 * Tai);
		    Tak = Tac + Taj;
		    TdQ = Taj - Tac;
	       }
	       {
		    E Tar, Tau, Tfz, TfA;
		    Tar = KP707106781 * (Tan - Taq);
		    Tau = Tas - Tat;
		    Tav = Tar + Tau;
		    TdT = Tau - Tar;
		    Tfz = Tay - Tax;
		    TfA = KP707106781 * (Taq + Tan);
		    TfB = Tfz + TfA;
		    Thn = Tfz - TfA;
	       }
	       {
		    E T7z, T7C, T7E, T7H;
		    T7z = T18 - T1f;
		    T7C = T7A - T7B;
		    T7D = T7z + T7C;
		    T8v = T7z - T7C;
		    T7E = T1u - T1n;
		    T7H = T7F - T7G;
		    T7I = T7E + T7H;
		    T8w = T7H - T7E;
	       }
	       {
		    E Taz, TaC, TaE, TaF;
		    Taz = Tax + Tay;
		    TaC = KP707106781 * (TaA - TaB);
		    TaD = Taz + TaC;
		    TdP = Taz - TaC;
		    TaE = FMA(KP923879532, Tab, KP382683432 * Ta8);
		    TaF = FNMS(KP382683432, Taf, KP923879532 * Tai);
		    TaG = TaE + TaF;
		    TdS = TaE - TaF;
	       }
	  }
	  {
	       E T11, T9K, T9T, Ta2, T22, T9Q, T9N, Ta3;
	       {
		    E Tv, T10, T9R, T9S;
		    Tv = Tf + Tu;
		    T10 = TK + TZ;
		    T11 = Tv + T10;
		    T9K = Tv - T10;
		    T9R = T9p + T9o;
		    T9S = T93 + T94;
		    T9T = T9R - T9S;
		    Ta2 = T9S + T9R;
	       }
	       {
		    E T1w, T21, T9L, T9M;
		    T1w = T1g + T1v;
		    T21 = T1L + T20;
		    T22 = T1w + T21;
		    T9Q = T21 - T1w;
		    T9L = T99 + T98;
		    T9M = T9e + T9d;
		    T9N = T9L - T9M;
		    Ta3 = T9L + T9M;
	       }
	       rio[0] = T11 + T22;
	       iio[-WS(ios, 63)] = Ta3 + Ta2;
	       {
		    E T9O, T9U, T9J, T9P;
		    T9O = T9K + T9N;
		    T9U = T9Q + T9T;
		    T9J = W[94];
		    T9P = W[95];
		    rio[WS(ios, 48)] = FNMS(T9P, T9U, T9J * T9O);
		    iio[-WS(ios, 15)] = FMA(T9P, T9O, T9J * T9U);
	       }
	       {
		    E T9W, T9Y, T9V, T9X;
		    T9W = T9K - T9N;
		    T9Y = T9T - T9Q;
		    T9V = W[30];
		    T9X = W[31];
		    rio[WS(ios, 16)] = FNMS(T9X, T9Y, T9V * T9W);
		    iio[-WS(ios, 47)] = FMA(T9X, T9W, T9V * T9Y);
	       }
	       {
		    E Ta0, Ta4, T9Z, Ta1;
		    Ta0 = T11 - T22;
		    Ta4 = Ta2 - Ta3;
		    T9Z = W[62];
		    Ta1 = W[63];
		    rio[WS(ios, 32)] = FNMS(Ta1, Ta4, T9Z * Ta0);
		    iio[-WS(ios, 31)] = FMA(Ta1, Ta0, T9Z * Ta4);
	       }
	  }
	  {
	       E T96, T9y, T9r, T9D, T9h, T9C, T9m, T9z;
	       {
		    E T92, T95, T9n, T9q;
		    T92 = Tf - Tu;
		    T95 = T93 - T94;
		    T96 = T92 + T95;
		    T9y = T92 - T95;
		    T9n = TZ - TK;
		    T9q = T9o - T9p;
		    T9r = T9n + T9q;
		    T9D = T9q - T9n;
	       }
	       {
		    E T9b, T9g, T9k, T9l;
		    T9b = T97 + T9a;
		    T9g = T9c - T9f;
		    T9h = KP707106781 * (T9b + T9g);
		    T9C = KP707106781 * (T9b - T9g);
		    T9k = T9a - T97;
		    T9l = T9c + T9f;
		    T9m = KP707106781 * (T9k + T9l);
		    T9z = KP707106781 * (T9l - T9k);
	       }
	       {
		    E T9i, T9s, T91, T9j;
		    T9i = T96 + T9h;
		    T9s = T9m + T9r;
		    T91 = W[110];
		    T9j = W[111];
		    rio[WS(ios, 56)] = FNMS(T9j, T9s, T91 * T9i);
		    iio[-WS(ios, 7)] = FMA(T9j, T9i, T91 * T9s);
	       }
	       {
		    E T9G, T9I, T9F, T9H;
		    T9G = T9y - T9z;
		    T9I = T9D - T9C;
		    T9F = W[78];
		    T9H = W[79];
		    rio[WS(ios, 40)] = FNMS(T9H, T9I, T9F * T9G);
		    iio[-WS(ios, 23)] = FMA(T9H, T9G, T9F * T9I);
	       }
	       {
		    E T9u, T9w, T9t, T9v;
		    T9u = T96 - T9h;
		    T9w = T9r - T9m;
		    T9t = W[46];
		    T9v = W[47];
		    rio[WS(ios, 24)] = FNMS(T9v, T9w, T9t * T9u);
		    iio[-WS(ios, 39)] = FMA(T9v, T9u, T9t * T9w);
	       }
	       {
		    E T9A, T9E, T9x, T9B;
		    T9A = T9y + T9z;
		    T9E = T9C + T9D;
		    T9x = W[14];
		    T9B = W[15];
		    rio[WS(ios, 8)] = FNMS(T9B, T9E, T9x * T9A);
		    iio[-WS(ios, 55)] = FMA(T9B, T9A, T9x * T9E);
	       }
	  }
	  {
	       E T8u, T8Q, T8J, T8V, T8B, T8U, T8G, T8R;
	       {
		    E T8s, T8t, T8H, T8I;
		    T8s = T7i - T7l;
		    T8t = KP707106781 * (T82 - T81);
		    T8u = T8s + T8t;
		    T8Q = T8s - T8t;
		    T8H = KP707106781 * (T7r - T7w);
		    T8I = T87 - T84;
		    T8J = T8H + T8I;
		    T8V = T8I - T8H;
	       }
	       {
		    E T8x, T8A, T8E, T8F;
		    T8x = FNMS(KP382683432, T8w, KP923879532 * T8v);
		    T8A = FMA(KP923879532, T8y, KP382683432 * T8z);
		    T8B = T8x + T8A;
		    T8U = T8A - T8x;
		    T8E = FMA(KP382683432, T8v, KP923879532 * T8w);
		    T8F = FNMS(KP382683432, T8y, KP923879532 * T8z);
		    T8G = T8E + T8F;
		    T8R = T8E - T8F;
	       }
	       {
		    E T8C, T8K, T8r, T8D;
		    T8C = T8u + T8B;
		    T8K = T8G + T8J;
		    T8r = W[6];
		    T8D = W[7];
		    rio[WS(ios, 4)] = FNMS(T8D, T8K, T8r * T8C);
		    iio[-WS(ios, 59)] = FMA(T8D, T8C, T8r * T8K);
	       }
	       {
		    E T8Y, T90, T8X, T8Z;
		    T8Y = T8Q - T8R;
		    T90 = T8V - T8U;
		    T8X = W[38];
		    T8Z = W[39];
		    rio[WS(ios, 20)] = FNMS(T8Z, T90, T8X * T8Y);
		    iio[-WS(ios, 43)] = FMA(T8Z, T8Y, T8X * T90);
	       }
	       {
		    E T8M, T8O, T8L, T8N;
		    T8M = T8u - T8B;
		    T8O = T8J - T8G;
		    T8L = W[70];
		    T8N = W[71];
		    rio[WS(ios, 36)] = FNMS(T8N, T8O, T8L * T8M);
		    iio[-WS(ios, 27)] = FMA(T8N, T8M, T8L * T8O);
	       }
	       {
		    E T8S, T8W, T8P, T8T;
		    T8S = T8Q + T8R;
		    T8W = T8U + T8V;
		    T8P = W[102];
		    T8T = W[103];
		    rio[WS(ios, 52)] = FNMS(T8T, T8W, T8P * T8S);
		    iio[-WS(ios, 11)] = FMA(T8T, T8S, T8P * T8W);
	       }
	  }
	  {
	       E T7y, T8g, T89, T8l, T7V, T8k, T80, T8h;
	       {
		    E T7m, T7x, T83, T88;
		    T7m = T7i + T7l;
		    T7x = KP707106781 * (T7r + T7w);
		    T7y = T7m + T7x;
		    T8g = T7m - T7x;
		    T83 = KP707106781 * (T81 + T82);
		    T88 = T84 + T87;
		    T89 = T83 + T88;
		    T8l = T88 - T83;
	       }
	       {
		    E T7J, T7U, T7Y, T7Z;
		    T7J = FMA(KP923879532, T7D, KP382683432 * T7I);
		    T7U = FNMS(KP382683432, T7T, KP923879532 * T7O);
		    T7V = T7J + T7U;
		    T8k = T7J - T7U;
		    T7Y = FNMS(KP382683432, T7D, KP923879532 * T7I);
		    T7Z = FMA(KP382683432, T7O, KP923879532 * T7T);
		    T80 = T7Y + T7Z;
		    T8h = T7Z - T7Y;
	       }
	       {
		    E T7W, T8a, T7h, T7X;
		    T7W = T7y + T7V;
		    T8a = T80 + T89;
		    T7h = W[118];
		    T7X = W[119];
		    rio[WS(ios, 60)] = FNMS(T7X, T8a, T7h * T7W);
		    iio[-WS(ios, 3)] = FMA(T7X, T7W, T7h * T8a);
	       }
	       {
		    E T8o, T8q, T8n, T8p;
		    T8o = T8g - T8h;
		    T8q = T8l - T8k;
		    T8n = W[86];
		    T8p = W[87];
		    rio[WS(ios, 44)] = FNMS(T8p, T8q, T8n * T8o);
		    iio[-WS(ios, 19)] = FMA(T8p, T8o, T8n * T8q);
	       }
	       {
		    E T8c, T8e, T8b, T8d;
		    T8c = T7y - T7V;
		    T8e = T89 - T80;
		    T8b = W[54];
		    T8d = W[55];
		    rio[WS(ios, 28)] = FNMS(T8d, T8e, T8b * T8c);
		    iio[-WS(ios, 35)] = FMA(T8d, T8c, T8b * T8e);
	       }
	       {
		    E T8i, T8m, T8f, T8j;
		    T8i = T8g + T8h;
		    T8m = T8k + T8l;
		    T8f = W[22];
		    T8j = W[23];
		    rio[WS(ios, 12)] = FNMS(T8j, T8m, T8f * T8i);
		    iio[-WS(ios, 51)] = FMA(T8j, T8i, T8f * T8m);
	       }
	  }
	  {
	       E T6K, T76, T6Z, T7b, T6R, T7a, T6W, T77;
	       {
		    E T6I, T6J, T6X, T6Y;
		    T6I = T5O - T5P;
		    T6J = T6j - T6k;
		    T6K = T6I + T6J;
		    T76 = T6I - T6J;
		    T6X = T5W - T5T;
		    T6Y = T6n - T6m;
		    T6Z = T6X + T6Y;
		    T7b = T6Y - T6X;
		    {
			 E T6N, T6U, T6Q, T6V;
			 {
			      E T6L, T6M, T6O, T6P;
			      T6L = T5Z - T60;
			      T6M = T63 - T62;
			      T6N = FMA(KP831469612, T6L, KP555570233 * T6M);
			      T6U = FNMS(KP555570233, T6L, KP831469612 * T6M);
			      T6O = T66 - T67;
			      T6P = T6a - T69;
			      T6Q = FNMS(KP555570233, T6P, KP831469612 * T6O);
			      T6V = FMA(KP555570233, T6O, KP831469612 * T6P);
			 }
			 T6R = T6N + T6Q;
			 T7a = T6N - T6Q;
			 T6W = T6U + T6V;
			 T77 = T6V - T6U;
		    }
	       }
	       {
		    E T6S, T70, T6H, T6T;
		    T6S = T6K + T6R;
		    T70 = T6W + T6Z;
		    T6H = W[114];
		    T6T = W[115];
		    rio[WS(ios, 58)] = FNMS(T6T, T70, T6H * T6S);
		    iio[-WS(ios, 5)] = FMA(T6T, T6S, T6H * T70);
	       }
	       {
		    E T7e, T7g, T7d, T7f;
		    T7e = T76 - T77;
		    T7g = T7b - T7a;
		    T7d = W[82];
		    T7f = W[83];
		    rio[WS(ios, 42)] = FNMS(T7f, T7g, T7d * T7e);
		    iio[-WS(ios, 21)] = FMA(T7f, T7e, T7d * T7g);
	       }
	       {
		    E T72, T74, T71, T73;
		    T72 = T6K - T6R;
		    T74 = T6Z - T6W;
		    T71 = W[50];
		    T73 = W[51];
		    rio[WS(ios, 26)] = FNMS(T73, T74, T71 * T72);
		    iio[-WS(ios, 37)] = FMA(T73, T72, T71 * T74);
	       }
	       {
		    E T78, T7c, T75, T79;
		    T78 = T76 + T77;
		    T7c = T7a + T7b;
		    T75 = W[18];
		    T79 = W[19];
		    rio[WS(ios, 10)] = FNMS(T79, T7c, T75 * T78);
		    iio[-WS(ios, 53)] = FMA(T79, T78, T75 * T7c);
	       }
	  }
	  {
	       E T3a, T52, T4V, T57, T4z, T56, T4E, T53;
	       {
		    E T2w, T39, T4H, T4U;
		    T2w = T2c + T2v;
		    T39 = T2P + T38;
		    T3a = T2w + T39;
		    T52 = T2w - T39;
		    T4H = T4F + T4G;
		    T4U = T4K + T4T;
		    T4V = T4H + T4U;
		    T57 = T4U - T4H;
		    {
			 E T3R, T4C, T4y, T4D;
			 {
			      E T3D, T3Q, T4k, T4x;
			      T3D = T3j + T3C;
			      T3Q = T3G + T3P;
			      T3R = FMA(KP980785280, T3D, KP195090322 * T3Q);
			      T4C = FNMS(KP195090322, T3D, KP980785280 * T3Q);
			      T4k = T40 + T4j;
			      T4x = T4n + T4w;
			      T4y = FNMS(KP195090322, T4x, KP980785280 * T4k);
			      T4D = FMA(KP195090322, T4k, KP980785280 * T4x);
			 }
			 T4z = T3R + T4y;
			 T56 = T3R - T4y;
			 T4E = T4C + T4D;
			 T53 = T4D - T4C;
		    }
	       }
	       {
		    E T4A, T4W, T23, T4B;
		    T4A = T3a + T4z;
		    T4W = T4E + T4V;
		    T23 = W[122];
		    T4B = W[123];
		    rio[WS(ios, 62)] = FNMS(T4B, T4W, T23 * T4A);
		    iio[-WS(ios, 1)] = FMA(T4B, T4A, T23 * T4W);
	       }
	       {
		    E T5a, T5c, T59, T5b;
		    T5a = T52 - T53;
		    T5c = T57 - T56;
		    T59 = W[90];
		    T5b = W[91];
		    rio[WS(ios, 46)] = FNMS(T5b, T5c, T59 * T5a);
		    iio[-WS(ios, 17)] = FMA(T5b, T5a, T59 * T5c);
	       }
	       {
		    E T4Y, T50, T4X, T4Z;
		    T4Y = T3a - T4z;
		    T50 = T4V - T4E;
		    T4X = W[58];
		    T4Z = W[59];
		    rio[WS(ios, 30)] = FNMS(T4Z, T50, T4X * T4Y);
		    iio[-WS(ios, 33)] = FMA(T4Z, T4Y, T4X * T50);
	       }
	       {
		    E T54, T58, T51, T55;
		    T54 = T52 + T53;
		    T58 = T56 + T57;
		    T51 = W[26];
		    T55 = W[27];
		    rio[WS(ios, 14)] = FNMS(T55, T58, T51 * T54);
		    iio[-WS(ios, 49)] = FMA(T55, T54, T51 * T58);
	       }
	  }
	  {
	       E T5g, T5C, T5v, T5H, T5n, T5G, T5s, T5D;
	       {
		    E T5e, T5f, T5t, T5u;
		    T5e = T2c - T2v;
		    T5f = T4G - T4F;
		    T5g = T5e + T5f;
		    T5C = T5e - T5f;
		    T5t = T2P - T38;
		    T5u = T4T - T4K;
		    T5v = T5t + T5u;
		    T5H = T5u - T5t;
		    {
			 E T5j, T5q, T5m, T5r;
			 {
			      E T5h, T5i, T5k, T5l;
			      T5h = T3j - T3C;
			      T5i = T3P - T3G;
			      T5j = FNMS(KP555570233, T5i, KP831469612 * T5h);
			      T5q = FMA(KP555570233, T5h, KP831469612 * T5i);
			      T5k = T40 - T4j;
			      T5l = T4w - T4n;
			      T5m = FMA(KP831469612, T5k, KP555570233 * T5l);
			      T5r = FNMS(KP555570233, T5k, KP831469612 * T5l);
			 }
			 T5n = T5j + T5m;
			 T5G = T5m - T5j;
			 T5s = T5q + T5r;
			 T5D = T5q - T5r;
		    }
	       }
	       {
		    E T5o, T5w, T5d, T5p;
		    T5o = T5g + T5n;
		    T5w = T5s + T5v;
		    T5d = W[10];
		    T5p = W[11];
		    rio[WS(ios, 6)] = FNMS(T5p, T5w, T5d * T5o);
		    iio[-WS(ios, 57)] = FMA(T5p, T5o, T5d * T5w);
	       }
	       {
		    E T5K, T5M, T5J, T5L;
		    T5K = T5C - T5D;
		    T5M = T5H - T5G;
		    T5J = W[42];
		    T5L = W[43];
		    rio[WS(ios, 22)] = FNMS(T5L, T5M, T5J * T5K);
		    iio[-WS(ios, 41)] = FMA(T5L, T5K, T5J * T5M);
	       }
	       {
		    E T5y, T5A, T5x, T5z;
		    T5y = T5g - T5n;
		    T5A = T5v - T5s;
		    T5x = W[74];
		    T5z = W[75];
		    rio[WS(ios, 38)] = FNMS(T5z, T5A, T5x * T5y);
		    iio[-WS(ios, 25)] = FMA(T5z, T5y, T5x * T5A);
	       }
	       {
		    E T5E, T5I, T5B, T5F;
		    T5E = T5C + T5D;
		    T5I = T5G + T5H;
		    T5B = W[106];
		    T5F = W[107];
		    rio[WS(ios, 54)] = FNMS(T5F, T5I, T5B * T5E);
		    iio[-WS(ios, 9)] = FMA(T5F, T5E, T5B * T5I);
	       }
	  }
	  {
	       E T5Y, T6w, T6p, T6B, T6d, T6A, T6i, T6x;
	       {
		    E T5Q, T5X, T6l, T6o;
		    T5Q = T5O + T5P;
		    T5X = T5T + T5W;
		    T5Y = T5Q + T5X;
		    T6w = T5Q - T5X;
		    T6l = T6j + T6k;
		    T6o = T6m + T6n;
		    T6p = T6l + T6o;
		    T6B = T6o - T6l;
		    {
			 E T65, T6g, T6c, T6h;
			 {
			      E T61, T64, T68, T6b;
			      T61 = T5Z + T60;
			      T64 = T62 + T63;
			      T65 = FNMS(KP195090322, T64, KP980785280 * T61);
			      T6g = FMA(KP195090322, T61, KP980785280 * T64);
			      T68 = T66 + T67;
			      T6b = T69 + T6a;
			      T6c = FMA(KP980785280, T68, KP195090322 * T6b);
			      T6h = FNMS(KP195090322, T68, KP980785280 * T6b);
			 }
			 T6d = T65 + T6c;
			 T6A = T6c - T65;
			 T6i = T6g + T6h;
			 T6x = T6g - T6h;
		    }
	       }
	       {
		    E T6e, T6q, T5N, T6f;
		    T6e = T5Y + T6d;
		    T6q = T6i + T6p;
		    T5N = W[2];
		    T6f = W[3];
		    rio[WS(ios, 2)] = FNMS(T6f, T6q, T5N * T6e);
		    iio[-WS(ios, 61)] = FMA(T6f, T6e, T5N * T6q);
	       }
	       {
		    E T6E, T6G, T6D, T6F;
		    T6E = T6w - T6x;
		    T6G = T6B - T6A;
		    T6D = W[34];
		    T6F = W[35];
		    rio[WS(ios, 18)] = FNMS(T6F, T6G, T6D * T6E);
		    iio[-WS(ios, 45)] = FMA(T6F, T6E, T6D * T6G);
	       }
	       {
		    E T6s, T6u, T6r, T6t;
		    T6s = T5Y - T6d;
		    T6u = T6p - T6i;
		    T6r = W[66];
		    T6t = W[67];
		    rio[WS(ios, 34)] = FNMS(T6t, T6u, T6r * T6s);
		    iio[-WS(ios, 29)] = FMA(T6t, T6s, T6r * T6u);
	       }
	       {
		    E T6y, T6C, T6v, T6z;
		    T6y = T6w + T6x;
		    T6C = T6A + T6B;
		    T6v = W[98];
		    T6z = W[99];
		    rio[WS(ios, 50)] = FNMS(T6z, T6C, T6v * T6y);
		    iio[-WS(ios, 13)] = FMA(T6z, T6y, T6v * T6C);
	       }
	  }
	  {
	       E TdO, Tf1, Teq, TeH, Tef, TeW, Ten, TeM, Te3, Ter, Te8, Tem, TeE, Tf0, TeP;
	       E TeX;
	       {
		    E TdG, TeG, TdN, TeF, TdJ, TdM;
		    TdG = TdE + TdF;
		    TeG = Ted - Tec;
		    TdJ = FNMS(KP555570233, TdI, KP831469612 * TdH);
		    TdM = FMA(KP831469612, TdK, KP555570233 * TdL);
		    TdN = TdJ + TdM;
		    TeF = TdM - TdJ;
		    TdO = TdG + TdN;
		    Tf1 = TeG - TeF;
		    Teq = TdG - TdN;
		    TeH = TeF + TeG;
	       }
	       {
		    E Tee, TeK, Teb, TeL, Te9, Tea;
		    Tee = Tec + Ted;
		    TeK = TdE - TdF;
		    Te9 = FMA(KP555570233, TdH, KP831469612 * TdI);
		    Tea = FNMS(KP555570233, TdK, KP831469612 * TdL);
		    Teb = Te9 + Tea;
		    TeL = Te9 - Tea;
		    Tef = Teb + Tee;
		    TeW = TeK - TeL;
		    Ten = Tee - Teb;
		    TeM = TeK + TeL;
	       }
	       {
		    E TdV, Te6, Te2, Te7;
		    {
			 E TdR, TdU, TdY, Te1;
			 TdR = TdP + TdQ;
			 TdU = TdS + TdT;
			 TdV = FNMS(KP290284677, TdU, KP956940335 * TdR);
			 Te6 = FMA(KP290284677, TdR, KP956940335 * TdU);
			 TdY = TdW + TdX;
			 Te1 = TdZ + Te0;
			 Te2 = FMA(KP956940335, TdY, KP290284677 * Te1);
			 Te7 = FNMS(KP290284677, TdY, KP956940335 * Te1);
		    }
		    Te3 = TdV + Te2;
		    Ter = Te6 - Te7;
		    Te8 = Te6 + Te7;
		    Tem = Te2 - TdV;
	       }
	       {
		    E TeA, TeN, TeD, TeO;
		    {
			 E Tey, Tez, TeB, TeC;
			 Tey = TdT - TdS;
			 Tez = TdP - TdQ;
			 TeA = FNMS(KP471396736, Tez, KP881921264 * Tey);
			 TeN = FMA(KP881921264, Tez, KP471396736 * Tey);
			 TeB = TdW - TdX;
			 TeC = Te0 - TdZ;
			 TeD = FMA(KP471396736, TeB, KP881921264 * TeC);
			 TeO = FNMS(KP471396736, TeC, KP881921264 * TeB);
		    }
		    TeE = TeA + TeD;
		    Tf0 = TeN - TeO;
		    TeP = TeN + TeO;
		    TeX = TeD - TeA;
	       }
	       {
		    E Te4, Teg, TdD, Te5;
		    Te4 = TdO + Te3;
		    Teg = Te8 + Tef;
		    TdD = W[120];
		    Te5 = W[121];
		    iio[-WS(ios, 2)] = FMA(TdD, Te4, Te5 * Teg);
		    rio[WS(ios, 61)] = FNMS(Te5, Te4, TdD * Teg);
	       }
	       {
		    E TeY, Tf2, TeV, TeZ;
		    TeY = TeW + TeX;
		    Tf2 = Tf0 + Tf1;
		    TeV = W[104];
		    TeZ = W[105];
		    iio[-WS(ios, 10)] = FMA(TeV, TeY, TeZ * Tf2);
		    rio[WS(ios, 53)] = FNMS(TeZ, TeY, TeV * Tf2);
	       }
	       {
		    E Tf4, Tf6, Tf3, Tf5;
		    Tf4 = Tf1 - Tf0;
		    Tf6 = TeW - TeX;
		    Tf3 = W[40];
		    Tf5 = W[41];
		    rio[WS(ios, 21)] = FNMS(Tf5, Tf6, Tf3 * Tf4);
		    iio[-WS(ios, 42)] = FMA(Tf3, Tf6, Tf5 * Tf4);
	       }
	       {
		    E Tei, Tek, Teh, Tej;
		    Tei = Tef - Te8;
		    Tek = TdO - Te3;
		    Teh = W[56];
		    Tej = W[57];
		    rio[WS(ios, 29)] = FNMS(Tej, Tek, Teh * Tei);
		    iio[-WS(ios, 34)] = FMA(Teh, Tek, Tej * Tei);
	       }
	       {
		    E Teo, Tes, Tel, Tep;
		    Teo = Tem + Ten;
		    Tes = Teq + Ter;
		    Tel = W[24];
		    Tep = W[25];
		    rio[WS(ios, 13)] = FNMS(Tep, Tes, Tel * Teo);
		    iio[-WS(ios, 50)] = FMA(Tel, Tes, Tep * Teo);
	       }
	       {
		    E TeI, TeQ, Tex, TeJ;
		    TeI = TeE + TeH;
		    TeQ = TeM + TeP;
		    Tex = W[8];
		    TeJ = W[9];
		    rio[WS(ios, 5)] = FNMS(TeJ, TeQ, Tex * TeI);
		    iio[-WS(ios, 58)] = FMA(Tex, TeQ, TeJ * TeI);
	       }
	       {
		    E TeS, TeU, TeR, TeT;
		    TeS = TeM - TeP;
		    TeU = TeH - TeE;
		    TeR = W[72];
		    TeT = W[73];
		    iio[-WS(ios, 26)] = FMA(TeR, TeS, TeT * TeU);
		    rio[WS(ios, 37)] = FNMS(TeT, TeS, TeR * TeU);
	       }
	       {
		    E Teu, Tew, Tet, Tev;
		    Teu = Teq - Ter;
		    Tew = Ten - Tem;
		    Tet = W[88];
		    Tev = W[89];
		    iio[-WS(ios, 18)] = FMA(Tet, Teu, Tev * Tew);
		    rio[WS(ios, 45)] = FNMS(Tev, Teu, Tet * Tew);
	       }
	  }
	  {
	       E Tcr, Tdw, TcX, Td6, TcI, Tdt, TcS, Tdl, Tbm, TcW, TcL, TcT, Tdd, Tdx, Tdi;
	       E Tds;
	       {
		    E Tcq, Td4, TbZ, Td5, TbF, TbY;
		    Tcq = Tce + Tcp;
		    Td4 = TcA - TcD;
		    TbF = FNMS(KP195090322, TbE, KP980785280 * Tbx);
		    TbY = FMA(KP195090322, TbQ, KP980785280 * TbX);
		    TbZ = TbF + TbY;
		    Td5 = TbY - TbF;
		    Tcr = TbZ + Tcq;
		    Tdw = Td4 - Td5;
		    TcX = Tcq - TbZ;
		    Td6 = Td4 + Td5;
	       }
	       {
		    E TcE, Tdk, TcH, Tdj, TcF, TcG;
		    TcE = TcA + TcD;
		    Tdk = Tcp - Tce;
		    TcF = FMA(KP980785280, TbE, KP195090322 * Tbx);
		    TcG = FNMS(KP195090322, TbX, KP980785280 * TbQ);
		    TcH = TcF + TcG;
		    Tdj = TcF - TcG;
		    TcI = TcE + TcH;
		    Tdt = Tdk - Tdj;
		    TcS = TcE - TcH;
		    Tdl = Tdj + Tdk;
	       }
	       {
		    E TaI, TcJ, Tbl, TcK;
		    {
			 E Taw, TaH, Tb9, Tbk;
			 Taw = Tak + Tav;
			 TaH = TaD + TaG;
			 TaI = FNMS(KP098017140, TaH, KP995184726 * Taw);
			 TcJ = FMA(KP995184726, TaH, KP098017140 * Taw);
			 Tb9 = TaT + Tb8;
			 Tbk = Tbc + Tbj;
			 Tbl = FMA(KP098017140, Tb9, KP995184726 * Tbk);
			 TcK = FNMS(KP098017140, Tbk, KP995184726 * Tb9);
		    }
		    Tbm = TaI + Tbl;
		    TcW = TcJ - TcK;
		    TcL = TcJ + TcK;
		    TcT = Tbl - TaI;
	       }
	       {
		    E Td9, Tdg, Tdc, Tdh;
		    {
			 E Td7, Td8, Tda, Tdb;
			 Td7 = TaD - TaG;
			 Td8 = Tav - Tak;
			 Td9 = FNMS(KP634393284, Td8, KP773010453 * Td7);
			 Tdg = FMA(KP634393284, Td7, KP773010453 * Td8);
			 Tda = TaT - Tb8;
			 Tdb = Tbj - Tbc;
			 Tdc = FMA(KP773010453, Tda, KP634393284 * Tdb);
			 Tdh = FNMS(KP634393284, Tda, KP773010453 * Tdb);
		    }
		    Tdd = Td9 + Tdc;
		    Tdx = Tdg - Tdh;
		    Tdi = Tdg + Tdh;
		    Tds = Tdc - Td9;
	       }
	       {
		    E Tcs, TcM, Ta5, Tct;
		    Tcs = Tbm + Tcr;
		    TcM = TcI + TcL;
		    Ta5 = W[0];
		    Tct = W[1];
		    rio[WS(ios, 1)] = FNMS(Tct, TcM, Ta5 * Tcs);
		    iio[-WS(ios, 62)] = FMA(Ta5, TcM, Tct * Tcs);
	       }
	       {
		    E Tdu, Tdy, Tdr, Tdv;
		    Tdu = Tds + Tdt;
		    Tdy = Tdw + Tdx;
		    Tdr = W[16];
		    Tdv = W[17];
		    rio[WS(ios, 9)] = FNMS(Tdv, Tdy, Tdr * Tdu);
		    iio[-WS(ios, 54)] = FMA(Tdr, Tdy, Tdv * Tdu);
	       }
	       {
		    E TdA, TdC, Tdz, TdB;
		    TdA = Tdw - Tdx;
		    TdC = Tdt - Tds;
		    Tdz = W[80];
		    TdB = W[81];
		    iio[-WS(ios, 22)] = FMA(Tdz, TdA, TdB * TdC);
		    rio[WS(ios, 41)] = FNMS(TdB, TdA, Tdz * TdC);
	       }
	       {
		    E TcO, TcQ, TcN, TcP;
		    TcO = TcI - TcL;
		    TcQ = Tcr - Tbm;
		    TcN = W[64];
		    TcP = W[65];
		    iio[-WS(ios, 30)] = FMA(TcN, TcO, TcP * TcQ);
		    rio[WS(ios, 33)] = FNMS(TcP, TcO, TcN * TcQ);
	       }
	       {
		    E TcU, TcY, TcR, TcV;
		    TcU = TcS + TcT;
		    TcY = TcW + TcX;
		    TcR = W[96];
		    TcV = W[97];
		    iio[-WS(ios, 14)] = FMA(TcR, TcU, TcV * TcY);
		    rio[WS(ios, 49)] = FNMS(TcV, TcU, TcR * TcY);
	       }
	       {
		    E Tde, Tdm, Td3, Tdf;
		    Tde = Td6 + Tdd;
		    Tdm = Tdi + Tdl;
		    Td3 = W[112];
		    Tdf = W[113];
		    iio[-WS(ios, 6)] = FMA(Td3, Tde, Tdf * Tdm);
		    rio[WS(ios, 57)] = FNMS(Tdf, Tde, Td3 * Tdm);
	       }
	       {
		    E Tdo, Tdq, Tdn, Tdp;
		    Tdo = Tdl - Tdi;
		    Tdq = Td6 - Tdd;
		    Tdn = W[48];
		    Tdp = W[49];
		    rio[WS(ios, 25)] = FNMS(Tdp, Tdq, Tdn * Tdo);
		    iio[-WS(ios, 38)] = FMA(Tdn, Tdq, Tdp * Tdo);
	       }
	       {
		    E Td0, Td2, TcZ, Td1;
		    Td0 = TcX - TcW;
		    Td2 = TcS - TcT;
		    TcZ = W[32];
		    Td1 = W[33];
		    rio[WS(ios, 17)] = FNMS(Td1, Td2, TcZ * Td0);
		    iio[-WS(ios, 46)] = FMA(TcZ, Td2, Td1 * Td0);
	       }
	  }
	  {
	       E Tfy, Thd, TgC, TgT, Tgr, Th8, Tgz, TgY, Tgb, TgD, Tgg, Tgy, TgQ, Thc, Th1;
	       E Th9;
	       {
		    E Tfi, TgS, Tfx, TgR, Tfp, Tfw;
		    Tfi = Tfa + Tfh;
		    TgS = Tgp - Tgm;
		    Tfp = FNMS(KP195090322, Tfo, KP980785280 * Tfl);
		    Tfw = FMA(KP980785280, Tfs, KP195090322 * Tfv);
		    Tfx = Tfp + Tfw;
		    TgR = Tfw - Tfp;
		    Tfy = Tfi + Tfx;
		    Thd = TgS - TgR;
		    TgC = Tfi - Tfx;
		    TgT = TgR + TgS;
	       }
	       {
		    E Tgq, TgW, Tgj, TgX, Tgh, Tgi;
		    Tgq = Tgm + Tgp;
		    TgW = Tfa - Tfh;
		    Tgh = FMA(KP195090322, Tfl, KP980785280 * Tfo);
		    Tgi = FNMS(KP195090322, Tfs, KP980785280 * Tfv);
		    Tgj = Tgh + Tgi;
		    TgX = Tgh - Tgi;
		    Tgr = Tgj + Tgq;
		    Th8 = TgW - TgX;
		    Tgz = Tgq - Tgj;
		    TgY = TgW + TgX;
	       }
	       {
		    E TfR, Tge, Tga, Tgf;
		    {
			 E TfJ, TfQ, Tg2, Tg9;
			 TfJ = TfB + TfI;
			 TfQ = TfM + TfP;
			 TfR = FNMS(KP098017140, TfQ, KP995184726 * TfJ);
			 Tge = FMA(KP098017140, TfJ, KP995184726 * TfQ);
			 Tg2 = TfU + Tg1;
			 Tg9 = Tg5 + Tg8;
			 Tga = FMA(KP995184726, Tg2, KP098017140 * Tg9);
			 Tgf = FNMS(KP098017140, Tg2, KP995184726 * Tg9);
		    }
		    Tgb = TfR + Tga;
		    TgD = Tge - Tgf;
		    Tgg = Tge + Tgf;
		    Tgy = Tga - TfR;
	       }
	       {
		    E TgM, TgZ, TgP, Th0;
		    {
			 E TgK, TgL, TgN, TgO;
			 TgK = TfP - TfM;
			 TgL = TfB - TfI;
			 TgM = FNMS(KP634393284, TgL, KP773010453 * TgK);
			 TgZ = FMA(KP773010453, TgL, KP634393284 * TgK);
			 TgN = TfU - Tg1;
			 TgO = Tg8 - Tg5;
			 TgP = FMA(KP634393284, TgN, KP773010453 * TgO);
			 Th0 = FNMS(KP634393284, TgO, KP773010453 * TgN);
		    }
		    TgQ = TgM + TgP;
		    Thc = TgZ - Th0;
		    Th1 = TgZ + Th0;
		    Th9 = TgP - TgM;
	       }
	       {
		    E Tgc, Tgs, Tf7, Tgd;
		    Tgc = Tfy + Tgb;
		    Tgs = Tgg + Tgr;
		    Tf7 = W[124];
		    Tgd = W[125];
		    iio[0] = FMA(Tf7, Tgc, Tgd * Tgs);
		    rio[WS(ios, 63)] = FNMS(Tgd, Tgc, Tf7 * Tgs);
	       }
	       {
		    E Tha, The, Th7, Thb;
		    Tha = Th8 + Th9;
		    The = Thc + Thd;
		    Th7 = W[108];
		    Thb = W[109];
		    iio[-WS(ios, 8)] = FMA(Th7, Tha, Thb * The);
		    rio[WS(ios, 55)] = FNMS(Thb, Tha, Th7 * The);
	       }
	       {
		    E Thg, Thi, Thf, Thh;
		    Thg = Thd - Thc;
		    Thi = Th8 - Th9;
		    Thf = W[44];
		    Thh = W[45];
		    rio[WS(ios, 23)] = FNMS(Thh, Thi, Thf * Thg);
		    iio[-WS(ios, 40)] = FMA(Thf, Thi, Thh * Thg);
	       }
	       {
		    E Tgu, Tgw, Tgt, Tgv;
		    Tgu = Tgr - Tgg;
		    Tgw = Tfy - Tgb;
		    Tgt = W[60];
		    Tgv = W[61];
		    rio[WS(ios, 31)] = FNMS(Tgv, Tgw, Tgt * Tgu);
		    iio[-WS(ios, 32)] = FMA(Tgt, Tgw, Tgv * Tgu);
	       }
	       {
		    E TgA, TgE, Tgx, TgB;
		    TgA = Tgy + Tgz;
		    TgE = TgC + TgD;
		    Tgx = W[28];
		    TgB = W[29];
		    rio[WS(ios, 15)] = FNMS(TgB, TgE, Tgx * TgA);
		    iio[-WS(ios, 48)] = FMA(Tgx, TgE, TgB * TgA);
	       }
	       {
		    E TgU, Th2, TgJ, TgV;
		    TgU = TgQ + TgT;
		    Th2 = TgY + Th1;
		    TgJ = W[12];
		    TgV = W[13];
		    rio[WS(ios, 7)] = FNMS(TgV, Th2, TgJ * TgU);
		    iio[-WS(ios, 56)] = FMA(TgJ, Th2, TgV * TgU);
	       }
	       {
		    E Th4, Th6, Th3, Th5;
		    Th4 = TgY - Th1;
		    Th6 = TgT - TgQ;
		    Th3 = W[76];
		    Th5 = W[77];
		    iio[-WS(ios, 24)] = FMA(Th3, Th4, Th5 * Th6);
		    rio[WS(ios, 39)] = FNMS(Th5, Th4, Th3 * Th6);
	       }
	       {
		    E TgG, TgI, TgF, TgH;
		    TgG = TgC - TgD;
		    TgI = Tgz - Tgy;
		    TgF = W[92];
		    TgH = W[93];
		    iio[-WS(ios, 16)] = FMA(TgF, TgG, TgH * TgI);
		    rio[WS(ios, 47)] = FNMS(TgH, TgG, TgF * TgI);
	       }
	  }
	  {
	       E ThJ, TiG, Ti7, Tig, ThS, TiD, Ti2, Tiv, Thy, Ti6, ThV, Ti3, Tin, TiH, Tis;
	       E TiC;
	       {
		    E ThI, Tie, ThF, Tif, ThB, ThE;
		    ThI = ThG + ThH;
		    Tie = ThM - ThN;
		    ThB = FNMS(KP555570233, ThA, KP831469612 * Thz);
		    ThE = FNMS(KP555570233, ThD, KP831469612 * ThC);
		    ThF = ThB + ThE;
		    Tif = ThE - ThB;
		    ThJ = ThF + ThI;
		    TiG = Tie - Tif;
		    Ti7 = ThI - ThF;
		    Tig = Tie + Tif;
	       }
	       {
		    E ThO, Tiu, ThR, Tit, ThP, ThQ;
		    ThO = ThM + ThN;
		    Tiu = ThH - ThG;
		    ThP = FMA(KP831469612, ThA, KP555570233 * Thz);
		    ThQ = FMA(KP831469612, ThD, KP555570233 * ThC);
		    ThR = ThP - ThQ;
		    Tit = ThP + ThQ;
		    ThS = ThO + ThR;
		    TiD = Tiu - Tit;
		    Ti2 = ThO - ThR;
		    Tiv = Tit + Tiu;
	       }
	       {
		    E Thq, ThT, Thx, ThU;
		    {
			 E Thm, Thp, Tht, Thw;
			 Thm = Thk + Thl;
			 Thp = Thn + Tho;
			 Thq = FNMS(KP290284677, Thp, KP956940335 * Thm);
			 ThT = FMA(KP956940335, Thp, KP290284677 * Thm);
			 Tht = Thr - Ths;
			 Thw = Thu + Thv;
			 Thx = FMA(KP290284677, Tht, KP956940335 * Thw);
			 ThU = FNMS(KP290284677, Thw, KP956940335 * Tht);
		    }
		    Thy = Thq + Thx;
		    Ti6 = ThT - ThU;
		    ThV = ThT + ThU;
		    Ti3 = Thx - Thq;
	       }
	       {
		    E Tij, Tiq, Tim, Tir;
		    {
			 E Tih, Tii, Tik, Til;
			 Tih = Thn - Tho;
			 Tii = Thl - Thk;
			 Tij = FNMS(KP471396736, Tii, KP881921264 * Tih);
			 Tiq = FMA(KP471396736, Tih, KP881921264 * Tii);
			 Tik = Thv - Thu;
			 Til = Ths + Thr;
			 Tim = FNMS(KP881921264, Til, KP471396736 * Tik);
			 Tir = FMA(KP471396736, Til, KP881921264 * Tik);
		    }
		    Tin = Tij + Tim;
		    TiH = Tiq - Tir;
		    Tis = Tiq + Tir;
		    TiC = Tim - Tij;
	       }
	       {
		    E ThK, ThW, Thj, ThL;
		    ThK = Thy + ThJ;
		    ThW = ThS + ThV;
		    Thj = W[4];
		    ThL = W[5];
		    rio[WS(ios, 3)] = FNMS(ThL, ThW, Thj * ThK);
		    iio[-WS(ios, 60)] = FMA(Thj, ThW, ThL * ThK);
	       }
	       {
		    E TiE, TiI, TiB, TiF;
		    TiE = TiC + TiD;
		    TiI = TiG + TiH;
		    TiB = W[20];
		    TiF = W[21];
		    rio[WS(ios, 11)] = FNMS(TiF, TiI, TiB * TiE);
		    iio[-WS(ios, 52)] = FMA(TiB, TiI, TiF * TiE);
	       }
	       {
		    E TiK, TiM, TiJ, TiL;
		    TiK = TiG - TiH;
		    TiM = TiD - TiC;
		    TiJ = W[84];
		    TiL = W[85];
		    iio[-WS(ios, 20)] = FMA(TiJ, TiK, TiL * TiM);
		    rio[WS(ios, 43)] = FNMS(TiL, TiK, TiJ * TiM);
	       }
	       {
		    E ThY, Ti0, ThX, ThZ;
		    ThY = ThS - ThV;
		    Ti0 = ThJ - Thy;
		    ThX = W[68];
		    ThZ = W[69];
		    iio[-WS(ios, 28)] = FMA(ThX, ThY, ThZ * Ti0);
		    rio[WS(ios, 35)] = FNMS(ThZ, ThY, ThX * Ti0);
	       }
	       {
		    E Ti4, Ti8, Ti1, Ti5;
		    Ti4 = Ti2 + Ti3;
		    Ti8 = Ti6 + Ti7;
		    Ti1 = W[100];
		    Ti5 = W[101];
		    iio[-WS(ios, 12)] = FMA(Ti1, Ti4, Ti5 * Ti8);
		    rio[WS(ios, 51)] = FNMS(Ti5, Ti4, Ti1 * Ti8);
	       }
	       {
		    E Tio, Tiw, Tid, Tip;
		    Tio = Tig + Tin;
		    Tiw = Tis + Tiv;
		    Tid = W[116];
		    Tip = W[117];
		    iio[-WS(ios, 4)] = FMA(Tid, Tio, Tip * Tiw);
		    rio[WS(ios, 59)] = FNMS(Tip, Tio, Tid * Tiw);
	       }
	       {
		    E Tiy, TiA, Tix, Tiz;
		    Tiy = Tiv - Tis;
		    TiA = Tig - Tin;
		    Tix = W[52];
		    Tiz = W[53];
		    rio[WS(ios, 27)] = FNMS(Tiz, TiA, Tix * Tiy);
		    iio[-WS(ios, 36)] = FMA(Tix, TiA, Tiz * Tiy);
	       }
	       {
		    E Tia, Tic, Ti9, Tib;
		    Tia = Ti7 - Ti6;
		    Tic = Ti2 - Ti3;
		    Ti9 = W[36];
		    Tib = W[37];
		    rio[WS(ios, 19)] = FNMS(Tib, Tic, Ti9 * Tia);
		    iio[-WS(ios, 44)] = FMA(Ti9, Tic, Tib * Tia);
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 64},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 64, "hb_64", twinstr, &GENUS, {808, 270, 230, 0}, 0, 0, 0 };

void X(codelet_hb_64) (planner *p) {
     X(khc2hc_register) (p, hb_64, &desc);
}
#endif				/* HAVE_FMA */
