/*
 * ffproxy (c) 2002, 2003 Niklas Olmes <niklas@noxa.de>
 *                                     <niklas.olmes@web.de>
 * http://faith.eu.org
 * 
 * $Id: signals.c,v 1.6 2003/08/08 14:10:28 niklas Exp $
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675
 * Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>
#include <sys/wait.h>

#include <signal.h>

#include "cfg.h"
#include "print.h"
#include "db.h"
#include "signals.h"

static void     sigchld(int);
static void     sighup(int);
static void     sigterm(int);
static void     sigint(int);

extern struct cfg config;

static void
sigchld(int dummy)
{
	int             status;
	pid_t           pid;

	(void) dummy;
	while ((pid = waitpid(-1, &status, WNOHANG)) > 0)
		config.ccount--;
}

static void
sighup(int dummy)
{
	(void) dummy;
	info("SIGHUP received, reloading databases");
	reload_databases();
}

static void
sigterm(int dummy)
{
	(void) dummy;
	fatal_n("SIGTERM received");
}

static void
sigint(int dummy)
{
	(void) dummy;
	fatal_n("SIGINT received");
}

void
init_sighandlers(void)
{
	signal(SIGCHLD, sigchld);
	signal(SIGHUP, sighup);
	signal(SIGTERM, sigterm);
	signal(SIGINT, sigint);
}
