#$Id: ezmlmrc.cs,v 1.8 1999/05/11 03:28:11 lindberg Exp $
#$Name: ezmlm-idx-040 $
#
# ezmlmrc 
# #######
# Controls the actions of ezmlm-make as patched with ezmlm-idx-0.31 or later.
#
# The base directory 'DIR' is always created by ezmlm-make, as is DIR/key.
# Everything else is done from here.
#
# ezmlm-make looks for this file, first as .ezmlmrc in the directory that the
# lists .qmail files will be placed in (if you've used the -c command line
# switch), then /etc/ezmlmrc, then ezmlmrc in the ezmlm-make binary directory.
# Thus, you can customize ezmlm-make on a global level by placing a customized
# copy of ezmlmrc in /etc and on a user level by copying it to .ezmlmrc in
# the user's home directory AND use the ezmlm-make -c switch.
#
# Tags are:
#	</filename/>       : put succeeding text lines in DIR/filename
#	</-filename/>      : erase DIR/filename.
#	</+dirname/>       : create directory DIR/dirname
#	</:lname/dirname>  : symlink DIR/.qmail-list-lname -> DIR/dirname
#
# The name in the tag can be suffixed with '#' and any number of flags,
# corresponding to command line switches. The item will be created/extended
# only if all the flags listed are set. Files can be extended as long as they
# were the last one created, but not if another file has been started since
# then. Flags that are not recognized are silently ignored.
# 
# Thus, </filename#aP/> creates the file if and only if the list is archived
# (-a) and not public (-P). If the next tag is </filename#m/>, the file is
# extended with the lines up to the next tag if the list is message moderated
# (-m). If the next tag is </another/>, 'filename' is closed. Any further
# tags leading to the reopenining of 'filename' will overwrite the file, not
# extend it.
#
# A set of user-defined command line switches (xX, yY, zZ) are available for
# customization.
#
# Within the text, certain tags are substituted. Other tags are copied as
# is. <#A#> and <#R#> are substituted by ezmlm-manage and -store (see man pages)
# and <#l#> (lower case L) is replaced dynamically by the list name for
# programs handling both 'list' and 'list-digest'.
#
# Substitutions are:
# <#B#> ezmlm binaries path   <#C#> digest code         <#D#> dir
# <#H#> host                  <#L#> local               <#F#> flags
# <#T#> dot                   <#0#> arg for -0. <#3#>...<#9#> arg for -3..9
# <#1#> ext1                  <#2#> ext2 [if dot is /path/.qmail-ext1-ext2-name]
# The latter useful when a single user is controlling several virtual domains.
#
# -0 is used for the main list address when setting up sublists
# -4 for specifying the ezmlm-tstdig switches used in dir/editor. Default
#    -k64 -m30 -t24. Only used if -g is used.
# -5 for list-owner address. Mail to list-owner will be forwarded to this addr.
# -6 for sql connection info
# -7 for contents of DIR/modpost
# -8 for contents of DIR/modsub
# -9 for contents of DIR/remote
#
# For demonstration purposes, the '-x' switch results in the following
# non-standard actions:
# - Removal of many non-text MIME parts from messages.
# - Limit posts to 2 bytes <= msg body size <= 40000
#
# Attempts to create links or directories that already exist, will result
# in a FATAL error. Attempts to open files that have already been closed
# or already exits, will cause the old file to be overwritten.
#
# One of the major problems with ezmlm-lists is DIR/inlocal. For normal
# users, it is set up to the list name (user-list or so), which is correct.
# However, for user 'ezmlm' in control of virtual domain 'host.dom.com'
# the list name is 'list@host.dom.com', but inlocal should be 'ezmlm-list',
# not 'list'. Similarly, if ezmlm-domain1 is in control of 'host.dom.com,
# list@host.dom.com, should yield an inlocal of 'ezmlm-domain1-list'. To
# always get the lists correct, place this file as '.ezmlmrc' in the 
# users home directory (~ezmlm/.ezmlmrc) and change the inlocal text below
# to 'ezmlm-<#L#>' or 'ezmlm-<#1#>-<#L#>, respectively.
# config to support future editing without giving ezmlm-make command line
# arguments other than dir. Useful for GUI/WWW editing tools
</config/>
F:<#F#>
D:<#D#>
T:<#T#>
L:<#L#>
H:<#H#>
C:<#C#>
0:<#0#>
3:<#3#>
4:<#4#>
5:<#5#>
6:<#6#>
7:<#7#>
8:<#8#>
9:<#9#>
</charset/>
# Explicitly specify character-set, when this ezmlmrc was used.
# Use Quoted-Printable to make averyone happy.
iso-8859-2:Q
</inlocal/>
<#L#>
</sublist#0/>
<#0#>
</+archive/>
</+subscribers/>
</+bounce/>
</+text/>
# dirs for digests
</+digest#d/>
</+digest/subscribers#d/>
</+digest/bounce#d/>
# for extra address db
</+allow/>
</+allow/subscribers/>
# for blacklist
</+deny#k/>
</+deny/subscribers#k/>
# moderator db & mod queue dirs. Needed for -m, -r -s, so we just
# make them by default.
</+mod/>
</+mod/subscribers/>
</+mod/pending/>
</+mod/accepted/>
</+mod/rejected/>
# links: dot -> dir/editor
</:/editor/>
</:-owner/owner/>
</:-digest-owner/owner#d/>
</:-return-default/bouncer/>
</:-digest-return-default/digest/bouncer#d/>
</:-default/manager/>
# for message moderation only
</:-accept-default/moderator#m/>
</:-reject-default/moderator#m/>
# Get rid of configuration flags for editing mode so we can start with a
# clean slate.
</-modpost#eM/>
</-modsub#eS/>
</-remote#eR/>
</-public#eP/>
</-indexed#eI/>
</-archived#eA/>
</-prefix#eF/>
</-text/trailer#eT/>
</-sublist#e^0/>
</-mimeremove#eX/>
# Not needed, except for message moderation.
</-moderator#eM/>
# We don't clean out text files to make it easier for users
# doing manual config by e.g. touching dir/remote.
# subscription moderation
</modsub#s/>
<#8#>
# remote admin
</remote#r/>
<#9#>
# message moderation
</modpost#m/>
<#7#>
# List owner mail
</owner#5/>
<#5#>
</owner#^5/>
<#D#>/Mailbox
</#W/>
|<#B#>/ezmlm-warn '<#D#>' || exit 0
# Handles subscription. Add flags if you want a non-default digest format.
# Service subject commands to the # request address if the -q switch is given.
# Also -l and -d enable subscriber listing/text file editing, for remote adms.
# -u gives subscriber only archive access
</manager#iG/>
|<#B#>/ezmlm-get '<#D#>' <#C#>
</manager#ig/>
|<#B#>/ezmlm-get -s '<#D#>' <#C#>
</manager#q/>
|<#B#>/ezmlm-request '<#D#>'
# Ok to add -l/-d even for non-mod lists, since ezmlm-manage
# won't allow it unless there are remote admins.
</manager#LN/>
|<#B#>/ezmlm-manage '<#D#>'
</manager#lN/>
|<#B#>/ezmlm-manage -l '<#D#>'
</manager#Ln/>
|<#B#>/ezmlm-manage -e '<#D#>'
</manager#ln/>
|<#B#>/ezmlm-manage -le '<#D#>'
</manager#W/>
|<#B#>/ezmlm-warn '<#D#>' || exit 0
</#dW/>
|<#B#>/ezmlm-warn -d '<#D#>' || exit 0
</editor/>
# reject shouldn't be configured for sublist.
</#^0/>
# full reject is now default, to get To/Cc: listaddress requirement
|<#B#>/ezmlm-reject '<#D#>'
# -k => reject posts from blacklisted addresses. Done for moderated
# lists as well - allows removal of unwanted noise.
</#k^0/>
|<#B#>/ezmlm-issubn -n '<#D#>/deny' || { echo "Omlovm se, ale mm pkaz odmtnout pspvky od vs. Kontaktujte <#L#>-owner@<#H#>, mte-li dotazy k tomuto faktu (#5.7.2)"; exit 100 ; }
# switch -u=> restrict to subs of list & digest. If not m
# do it with ezmlm-issubn, if 'm' do it with ezmlm-gate
</#uM/>
|<#B#>/ezmlm-issubn '<#D#>' '<#D#>/digest' '<#D#>/allow' '<#D#>/mod' || { echo "Omlouvm se, ale do tohoto listu smj pispvat pouze pihlen uivatel. Jste-li pihlenm uivatelem, pepolete tuto zprvu na adresu <#L#>-owner@<#H#>, aby akceptoval vai novou adresu (#5.7.2)"; exit 100 ; }
</#um/>
|<#B#>/ezmlm-gate '<#D#>' '<#D#>' '<#D#>/digest' '<#D#>/allow' '<#D#>/mod'
# For message moderation, editor has store/clean
</#mU/>
|<#B#>/ezmlm-store '<#D#>'
|<#B#>/ezmlm-clean '<#D#>' || exit 0
</#mu/>
|<#B#>/ezmlm-clean -R '<#D#>' || exit 0
# for non-message moderated lists, it has send
</#M/>
|<#B#>/ezmlm-send '<#D#>'
# all lists have warn unless -w.
</#W/>
|<#B#>/ezmlm-warn '<#D#>' || exit 0
# for digest bounces
</#dW/>
|<#B#>/ezmlm-warn -d '<#D#>' || exit 0
</#d^4/>
|<#B#>/ezmlm-tstdig -m30 -k64 -t48 '<#D#>' || exit 99
</#d4/>
|<#B#>/ezmlm-tstdig <#4#> '<#D#>' || exit 99
</#d/>
|<#B#>/ezmlm-get '<#D#>' || exit 0
# bouncer is complicated. We use ezmlm-receipt if -6 AND -w, but ezmlm-return
# if (-6 and -W) OR (not -6 and -w). Since there is no or, we need 2 lines.
</bouncer/>
|<#B#>/ezmlm-weed
</#^6/>
|<#B#>/ezmlm-return -D '<#D#>'
</#6W/>
|<#B#>/ezmlm-return -D '<#D#>'
</#6w/>
|<#B#>/ezmlm-receipt -D '<#D#>'
</digest/bouncer#d/>
|<#B#>/ezmlm-weed
</#^6d/>
|<#B#>/ezmlm-return -d '<#D#>'
</#6Wd/>
|<#B#>/ezmlm-return -d '<#D#>'
</#6wd/>
|<#B#>/ezmlm-receipt -d '<#D#>'
# moderator is set up only for message moderated lists. However, '-e' does
# not remove it since we can't remove the symlinks to it (they're outside
# of the list dir.
</moderator#m/>
|<#B#>/ezmlm-moderate '<#D#>'
</#mU/>
|<#B#>/ezmlm-clean '<#D#>' || exit 0
</#mu/>
|<#B#>/ezmlm-clean -R '<#D#>' || exit 0
</headerremove#E/>
return-path
return-receipt-to
content-length
precedence
x-confirm-reading-to
x-pmrqc
# Only one allowed
list-help
list-unsubscribe
list-post
</lock/>
</lockbounce/>
</digest/lockbounce#d/>
</digest/lock#d/>
</public#p/>
</archived#a/>
</indexed#i/>
</inhost/>
<#H#>
</outhost/>
<#H#>
</outlocal/>
<#L#>
</mailinglist/>
contact <#L#>-help@<#H#>; run by ezmlm
# Headeradd needs to always exist
</headeradd#E/>
# Good for mailing list stuff (and vacation program)
Precedence: bulk
# To prevent indexing by findmail.com
X-No-Archive: yes
# rfc2369
List-Help: <mailto:<#l#>-help@<#h#>>
List-Unsubscribe: <mailto:<#l#>-unsubscribe@<#h#>>
List-Subscribe: <mailto:<#l#>-subscribe@<#h#>>
List-Post: <mailto:<#L#>@<#H#>>
# max & min message size
</msgsize#x/>
40000:2
# remove mime parts if -x
</mimeremove#x/>
application/excel
application/rtf
application/msword
application/ms-tnef
text/html
text/rtf
text/enriched
text/x-vcard
application/activemessage
application/andrew-inset
application/applefile
application/atomicmail
application/dca-rft
application/dec-dx
application/mac-binhex40
application/mac-compactpro
application/macwriteii
application/news-message-id
application/news-transmission
application/octet-stream
application/oda
application/pdf
application/postscript
application/powerpoint
application/remote-printing
application/slate
application/wita
application/wordperfect5.1
application/x-bcpio
application/x-cdlink
application/x-compress
application/x-cpio
application/x-csh
application/x-director
application/x-dvi
application/x-hdf
application/x-httpd-cgi
application/x-koan
application/x-latex
application/x-mif
application/x-netcdf
application/x-stuffit
application/x-sv4cpio
application/x-sv4crc
application/x-tar
application/x-tcl
application/x-tex
application/x-texinfo
application/x-troff
application/x-troff-man
application/x-troff-me
application/x-troff-ms
application/x-ustar
application/x-wais-source
audio/basic
audio/mpeg
audio/x-aiff
audio/x-pn-realaudio
audio/x-pn-realaudio
audio/x-pn-realaudio-plugin
audio/x-realaudio
audio/x-wav
image/gif
image/ief
image/jpeg
image/png
image/tiff
image/x-cmu-raster
image/x-portable-anymap
image/x-portable-bitmap
image/x-portable-graymap
image/x-portable-pixmap
image/x-rgb
image/x-xbitmap
image/x-xpixmap
image/x-xwindowdump
text/x-sgml
video/mpeg
video/quicktime
video/x-msvideo
video/x-sgi-movie
x-conference/x-cooltalk
x-world/x-vrml
# These can also be excluded, but for many lists it is desirable
# to allow them. Uncomment to add to mimeremove.
# application/zip
# application/x-gtar
# application/x-gzip
# application/x-sh
# application/x-shar
# chemical/x-pdb
# --------------------- Handle SQL connect info
</-sql#^6e/>
</-digest/sql#^6e/>
</-allow/sql#^6e/>
</sql#6W/>
<#6#>
</sql#6w/>
<#6#>:<#L#>@<#H#>
</digest/sql#6dW/>
<#6#>_digest
</digest/sql#6dw/>
<#6#>_digest:<#L#>_digest@<#H#>
</allow/sql#6/>
<#6#>_allow
# -------------------- End sql stuff
</prefix#f/>
[<#L#>]
</text/trailer#t/>
---------------------------------------------------------------------
Pro odhlen, polete mail na <#L#>-unsubscribe@<#H#>
Dal pkazy vype e-mail: <#L#>-help@<#H#>
</text/bottom/>

--- Administrativn pkazy pro list <#l#> ---

Umm automaticky obsluhovat administrativn pkazy. Neposlejte
je prosm do listu! Polete zprvu na adresu pslunho pkazu:

Pro pihlen do listu, polete e-mail na adresu:
   <<#L#>-subscribe@<#H#>>

Pro odhlen se z listu pouijte adresu
   <<#L#>-unsubscribe@<#H#>>

Informace o listu a FAQ (asto kladen dotazy) zskte zaslnm dopisu
na nsledujc adresy:
   <<#L#>-info@<#H#>>
   <<#L#>-faq@<#H#>>

</#d/>
Podobn adresy existuj i pro list digest:
   <<#L#>-digest-subscribe@<#H#>>
   <<#L#>-digest-unsubscribe@<#H#>>

# ezmlm-make -i needed to add ezmlm-get line. If not, we can't do
# multi-get!
</text/bottom#ai/>
Zprvy slo 123 a 145 z archvu (maximln 100 zprv na jeden mail)
zskte zaslnm zprvy na nsledujc adresu:
   <<#L#>-get.123_145@<#H#>>

</text/bottom#aI/>
Zprvu slo 12 zskte pomoc nsledujc adresy:
   <<#L#>-get.12@<#H#>>

</text/bottom#i/>
Seznam zprv se subjectem a autorem zprv 123-456 - e-mail:
   <<#L#>-index.123_456@<#H#>>

Tyto adresy vdy vrac seznam 100 zprv, maximln 2000 na jeden poadavek.
Take ve ve uvedenm pklad ve skutenosti dostanete seznam zprv 100-499.

# Lists need to be both archived and indexed for -thread to work
</text/bottom#ai/>
Pro zskn zprv se stejnm subjectem jako zprva 12345 polete
przdn mail na adresu:
   <<#L#>-thread.12345@<#H#>>

# The '#' in the tag below is optional, since no flags follow.
# The name is optional as well, since the file will always be open
# at this point.
</text/bottom#/>
Zprvy ve skutenosti nemus bt przdn - budu jejich obsah ignorovat.
Jedin dleit vc je ADRESA na kterou mail poslte.

Mete se tak do listu pihlsit pod jinou adresou - napklad
"pepa@domena.cz". Sta pidat pomlku a novou adresu s rovntkem (=)
namsto zavine:
<<#L#>-subscribe-pepa=domena.cz@<#H#>>

Odhlsit tuto adresu lze pomoc mailu na adresu
<<#L#>-unsubscribe-pepa=domena.cz@<#H#>>

V obou ppadech polu dost o souhlas na tuto adresu. Kdy ji dostanete,
jednodue na ni odpovzte a vae pihlen/odhlen se dokon.

</text/bottom/>
Pokud nedoshnete poadovanch vsledk, kontaktujte mho sprvce
na adrese <#L#>-owner@<#H#>. Prosm o trplivost, mj sprvce je
podstatn pomalej ne j ;-)
</text/bottom/>

--- Pipojuji kopii poadavku, kter jsem dostal.

</text/bounce-bottom/>

--- Pipojuji kopii zprvy, kter se mi vrtila.

</text/bounce-num/>

Uschoval jsem si seznam zprv z listu <#L#>, kter se z va adresy
vrtily.

</#a/>
Kopie tchto zprv mete zskat v archvu.
</#aI/>
Pro zskn zprvy 12345 z archvu, polete przdn mail na adresu
   <<#L#>-get.12345@<#H#>>

</#ia/>
Zprvy slo 123 a 145 zskte z archvu (maximln 100 zprv na jeden mail)
zskte zaslnm zprvy na nsledujc adresu:
   <<#L#>-get.123_145@<#H#>>

Seznam zprv se subjectem a autorem zprv 123-456 - e-mail:
   <<#L#>-index@<#H#>>

<//>
Nsleduj sla zprv:

</text/dig-bounce-num/>

Uschoval jsem sla digest z listu <#L#>-digest, kter se vrtily
z va adresy. Pro kad takov digest jsem si zapamatoval slo
prvn zprvy v digestu. Nearchivuji si digesty samotn, ale
mete si vydat jednotliv zprvy z archvu hlavnho listu.

</#aI/>

Pro zskn zprvy 12345 z archvu, polete przdn mail na adresu
   <<#L#>-get.12345@<#H#>>

</#ia/>
Zprvy slo 123 a 145 zskte z archvu (maximln 100 zprv na jeden mail)
zskte zaslnm zprvy na nsledujc adresu:
   <<#L#>-get.123_145@<#H#>>

Seznam zprv se subjectem a autorem zprv 123-456 - e-mail:
   <<#L#>-index@<#H#>>

<//>
Nsleduj sla prvnch zprv v digestech:

</text/bounce-probe/>

Vracej se mi zprvy pro vs z listu <#l#>.
Poslal jsem vm varovnou zprvu, ale ta se tak vrtila.
Pipojuji kopii varovn zprvy.

Toto je testovac zprva pro oven, jestli je vae adresa dosaiteln.
Pokud se tato zprva vrt, zrum vai adresu z listu <#l#>@<#H#>
bez dalho upozornn. Mete se pihlsit znovu poslnm przdn zprvy
na adresu
   <<#l#>-subscribe@<#H#>>

</text/bounce-warn/>

Vracej se mi zprvy pro vs z listu <#l#>.
Pipojuji kopii prvn vrcen zprvy, kterou jsem dostal.

Pokud se tato zprva tak vrt, polu testovac zprvu.
Pokud se vrt i testovac zprva, zrum vai adresu z listu <#l#>
bez dalho upozornn.

</text/digest#d/>
Pro pihlen do digestu polete mail na adresu
	<#L#>-digest-subscribe@<#H#>

Pro odhlen z digestu pouijte adresu
	<#L#>-digest-unsubscribe@<#H#>

Chcete-li poslat zprvu do listu, pite na adresu
	<#L#>@<#H#>

</text/get-bad/>
Promite, ale tato zprva v archvu nen.

</text/help/>
Toto je zprva se veobecnou npovdou. Zprva, kterou jsem dostal,
nebyla poslna na dnou z adres platnch pro zasln pkaz.

</text/mod-help/>
Dkuji, e jste se uvoli moderovat nebo spravovat list <#L#>@<#H#>.

Moje pkazy jsou ponkud odlinj od jinch list, ale myslm,
e je seznte intuitivnmi a pjemnmi k pouit.

Tady jsou instrukce pro innosti, kter ppadn mete vykonvat
jako sprvce listu nebo modertor.

Vzdlen pihlen
-------------------

Jako modertor mete pihlaovat a odhlaovat libovolnou adresu
do svho listu. Pro pihlen uivatele "pepa@domena.cz" jednodue
doplte pomlku za nzev pkazu a pak tuto adres s rovntkem
msto zavine. Napklad pro pihlen ve uveden adresy
polete mail na adresu
   <<#L#>-subscribe-pepa=domena.cz@<#H#>>

Podobn mete odhlaovat uivatele pomoc mailu na adresu
   <<#L#>-unsubscribe-pepa=domena.cz@<#H#>>

</#d/>
Pro digestov list:
   <<#L#>-digest-subscribe-pepa=domena.cz@<#H#>>
   <<#L#>-digest-unsubscribe-pepa=domena.cz@<#H#>>

<//>
To je vechno. dn speciln subject ani obsah zprvy nen poteba!

</#r/>
Polu vm dost o potvrzen, abych se ujistil, e poadavek
opravdu pochz od vs. Jednodue odpovzte na mail,
kter obdrte a v pkaz se vykon.
</#R/>
Polu dost o potvrzen, v tomto ppad na adresu <pepa@domena.cz>.
Vechno co bude muset udlat uivatel je odpovdt na tuto
dost.
<//>

Potvrzen jsou nezbytn, aby se tetm stranm co nejvce
ztila monost pidvat a ruit ciz adresu do/z listu.

Uvdomuji uivatele, kdy se stav jeho pihlen zmn.

Pihlen
----------

Libovoln uivatel se sm pihlaovat a odhlaovat do/z listu
zaslnm zprvy na adresu

<#L#>-subscribe@<#H#>
<#L#>-unsubscribe@<#H#>

</#d/>
Pro digestov list:

<#L#>-digest-subscribe@<#H#>
<#L#>-digest-unsubscribe@<#H#>

Uivatel obdr dost o potvrzen, abych se ujistil,
e mu skuten dan adresa pat. Jakmile se toto ov,
uivatel je odhlen.

</#s/>
Protoe toto je list s moderovanm pihlenm, polu dal
dost o potvrzen modertorovi. Protoe uivatel ji potvrdil
pn bt na listu, mete si jako modertor bt dostaten jist,
e adresa pihlaovanho je skuten. Pokud chcete pijmout
uivatelovu dost, jednodue polete odpov na tuto zprvu.
Pokud ne, smate tuto zprvu a ppadn kontaktujte uivatele
pro dal informace.
</#S/>
Pihlen funguje stejn.
<//>

Uivatel tak me pout adresu

   <<#L#>-subscribe-jana=domena.cz@<#H#>>
   <<#L#>-unsubscribe-jana=domena.cz@<#H#>>

pro zasln mailu pro "jana@domena.cz". Pokud tato skuten m
ve uvedenou adresu, obdr dost o potvrzen a me ji
potvrdit.

Vae adresa a identita nen otevena pihlenmu, pokud mu sm
nepolete mail.

</#rl/>
Pro zskn seznamu pihlench pro list <#L#>@<#H#>, polete
zprvu na adresu
   <<#L#>-list@<#H#>>

Seznam provedench transakc listu <#L#>@<#H#> zskte z adresy
   <<#L#>-list@<#H#>>

</#rld/>
Pro pihlen do digestu:
   <<#L#>-digest-list@<#H#>>
a
   <<#L#>-digest-log@<#H#>>

</#rn/>
Mete vzdlen editovat textov soubory, ze kterch se sestavuj
odpovdi, kter poslm. Chcete-li zskat seznam editovatelnch soubor
a pokyny pro editaci, napite na adresu
   <<#L#>-edit@<#H#>>

</#m/>
Moderovan pspvky
--------------------

Pokud je list moderovan, ulom si zprvy, kter obdrm a polu vm
kopii a instrukce. Zprva pro vs bude mt subject "MODERATE for ...".

Chcete-li zprvu pijmout, sta poslat odpov (na adresu v "Reply-To:"),
kterou nastavm na pkaz pro pijet zprvy do listu. Nemuste 
poslat obsah pvodn zprvy. Ve skutenosti ignoruji cokoli, co mi
polete, pokud bude adresa, na kterou to polete, korektn.

Pokud chcete zprvu odmtnout, polete odpov na adresu ve "From:",
kterou nastavm na pkaz pro odmtnut zprvy. Toto se obvykle udl
pkazem "Odpovz vem" ve vaem potovnm klientovi, piem
smaete vechny ostatn adresy krom adresy pro odmtnut (reject).
Mete pidat koment odeslateli - napite jej mezi dva dky,
zanajc tema znaky "%". Polu autorovi pouze tento koment,
co neprozrad vai identitu.

Se zprvou nalom podle prvn odpovdi, kterou dostanu.
Uvdomm vs, pokud mi polete poadavek na potvrzen ji
odmtnut zprvy a naopak,

Pokud nedostanu odpov od modertora do urit doby (implicitn 5 dn),
vrtm zprvu odeslateli s vysvtlenm, e byla odmtnuta.
Jako administrtor mete tak list nastavit tak, e ignorovan
zprvy jsou jednodue smazny bez upozornn odeslateli.
<//>

Dovolen
--------
Pokud jste doasn na jin adrese, sta si peposlat vechny zprvy,
kter maj sprvnou hlaviku "Mailing-List:" (nebo vechny se subjectem
"MODERATE for <#L#>@<#H#>" (nebo "CONFIRM subscribe to <#L#>@<#H#>")
na novou adresu. Mete tak peposlat tyto zprvy pteli, kter
bude moderovat za vs. Prosm uvdomte o tomto tak sprvce listserveru.

Pokud chcete automaticky potvrdit vechny poadavky bhem sv neptomnosti,
nastavte si potovnho klienta na posln automatickch odpovd na zprvy,
kter spluj ve uveden kritria.

</#r/>
Pokud zkuste dlat vzdlenou administraci z adresy, kter nen
vae vlastn, bude o potvrzen podn uivatel, nikoli vy.
Po schvlen uivatelem polu dost o potvrzen vem modertorm.
Toto dlm proto, e nemm zpsob, jak zjistit, e jste to skuten vy,
kdo poslal pvodn poadavek.

Berte tak na vdom, e v tomto ppad je v pvodn poadavek
(vetn va adresy!) zasln uivateli s dost o potvrzen.
<//>

Mnoho tst!

PS: Prosm kontaktujte sprvce listu (<#L#>-owner@<#H#>),
budete-li mt dotazy nebo problmy.

</text/mod-reject/>
Je mi lto, ale vae ne citovan zprva nebyla potvrzena modertorem.
Pokud modertor pipojil njak koment, uvdm jej ne.
</text/mod-request/>
Ne citovan zprva byla zaslna na adresu listu <#L#>@<#H#>.
Pokud souhlaste s distribuc tto zprvy vem pihlenm, polete
mail na adresu

!A

Toho obvykle doshnete pomoc tlatka "Odpov/Reply". Mete zkontrolovat
adresu, zan-li etzcem "<#L#>-accept". Pokud toto nefunguje, sta
zkoprovat adresu a uloit ji do polka "To:" nov zprvy.
</#x/>

Mete tak zkusit kliknout zde:
	mailto:<#A#>
<//>

Chcete-li zprvu odmtnout a zpsobit jej vrcen odeslateli,
polete zprvu na adresu

!R

Toto se bvykle nejsnze udl pomoc tlatka "Odpovz vem/Reply to all"
a nslednho vymazn vech adres krom t, kter zan "<#L#>-reject".
</#x/>

Mete tak zkusit kliknout zde:
	mailto:<#R#>
<//>

Nen teba koprovat zprvu ve svm potvrzen nebo odmtnut tto zprvy.
Chcete-li poslat koment odeslateli odmtnut zprvy, doplte jej
mezi nsledujc dky zanajc temi znaky "%":

%%% Zatek komente
%%% Konec komente

Dkuji za spoluprci.

--- Dle uvdm zaslanou zprvu.

</text/mod-sub#E/>
--- Pihlsil nebo odhlsil jsem vs na dost modertora
listu <#l#>@<#H#>.

Pokud to nen akce, se kterou souhlaste, polete co nejdve
stnost nebo dal komente sprvci listu (<#l#>-owner@<#H#>).

Chcete-li zskat podrobnj nvod pro prci s listem <#L#>, polete
przdnou zprvu na adresu
<#L#>-help@<#H#>.

</text/mod-timeout/>
Je mi lto, ale modertor listu <#L#> nezareagoval na v pspvek.
Tento tedy povauji za odmtnut a vracm vm jej. Pokud mte pocit,
e dolo k chyb, obrate se pmo na modertora listu.

--- Dle uvdm vmi zaslanou zprvu.

</text/mod-sub-confirm/>
dm zdvoile oprvnn pidat adresu

!A

do seznamu ten listu <#l#>. Poadavek vzeel buto od vs,
nebo ji byl oven u potencilnho tene.

Souhlaste-li, polete przdn mail na adresu

!R

Toho obvykle doshnete pomoc tlatka "Odpov/Reply". Mete zkontrolovat
adresu, zan-li etzcem "<#L#>-sc". Pokud toto nefunguje, sta
zkoprovat adresu a uloit ji do polka "To:" nov zprvy.
</#x/>

Mete tak zkusit kliknout zde:
	mailto:<#R#>
<//>

Nesouhlaste-li, ignorujte tuto zprvu.

Dky za spoluprci!

</text/mod-unsub-confirm/>
Obdrel jsem poadavek na zruen adresy

!A

z listu <#l#>. Souhlaste-li, polete przdnou odpov
na tuto adresu:

!R

Toho obvykle doshnete pomoc tlatka "Odpov/Reply". Mete zkontrolovat
adresu, zan-li etzcem "<#L#>-sc". Pokud toto nefunguje, sta
zkoprovat adresu a uloit ji do polka "To:" nov zprvy.
</#x/>

Mete tak zkusit kliknout zde:
	mailto:<#R#>
<//>

Nesouhlaste-li, ignorujte tuto zprvu.

Dkuji za spoluprci!

</text/sub-bad/>
Hmmm, tohle slo potvrzen nevypad platn.

Nejastjm dvodem vskytu neplatnch sel je vypren asu.
Musm dostat odpov na kad poadavek nejpozdji do deseti dn.
Ujistte se tak, e v odpovdi, kterou jsem obdrel, bylo _cel_
slo potvrzen. Nkter e-mailov programy mohou oznout st
adresy pro odpov, kter me bt i dosti dlouh.

Poslm novou dost o potvrzen. Pro potvrzen, e chcete pidat adresu

!A

do listu <#l#>, polete przdnou odpov na adresu

!R
</#x/>

Mete tak zkusit kliknout zde:
	mailto:<#R#>
<//>

Jet jednou: ujistte se, e adresa pro odpov je skuten v podku
pedtm, ne potvrdte tuto dost.

Omlouvm se za pote.

	<#L#>-Owner <<#l#>-owner@<#H#>>

</text/sub-confirm/>
Chcete-li opravdu pidat adresu

!A

do listu <#l#>, polete przdnou zprvu na adresu

!R

Toho obvykle doshnete pomoc tlatka "Odpov/Reply". Mete zkontrolovat
adresu, zan-li etzcem "<#L#>-sc". Pokud toto nefunguje, sta
zkoprovat adresu a uloit ji do polka "To:" nov zprvy.

</#x/>

Mete tak zkusit kliknout zde:
	mailto:<#R#>
<//>

Vyadovn tohoto potvrzen m dva dvody. Za prv ovuje, e jsem
schopen zaslat mail na vai adresu. A za druh, chrn vs v ppad,
e nkdo zfaluje dost o pihlen s vam jmnem.

</#q/>
Nkter potovn programy jsou chybn a nemohou zpracovvat dlouh
adresy. Pokud nemete odpovdt na tuto adresu, polete
zprvu na adresu <<#L#>-request@<#H#>>
a vlote celou ve uvedenou adresu do subjectu.

</text/sub-confirm#s/>
Tento list je moderovan. Jakmile polete potvrzen, poadavek
bude posln modertorovi tohoto listu. Uvdomm vs, jakmile
bude pihlen hotovo.

</text/sub-nop/>
Potvrzen: Adresa

!A

byla v ji v listu <#l#>, kdy jsem obdrel vai dost,
a zstv pihlena.

</text/sub-ok#E/>
Potvrzen: Pidal jsem adresu

!A

do listu <#l#>.

Vtejte v listu <#l#>@<#H#>!

Prosm uschovejte si tuto zprvu pro informaci, z jak adresy
bylo pihlen do listu provedeno. Budete ji potebovat v ppad,
e se budete chtt odhlsit nebo zmnit svoji adresu.

</text/top/>
Zdravm, tady je program ezmlm. Spravuji diskusn list
<#l#>@<#H#>.

</#x/>
Pracuji pro svho sprvce, kter me bt zastien na adrese
at <#l#>-owner@<#H#>.

</text/unsub-bad/>
Hmmm, tohle slo potvrzen nevypad platn.

Nejastjm dvodem vskytu neplatnch sel je vypren asu.
Musm dostat odpov na kad poadavek nejpozdji do deseti dn.
Ujistte se tak, e v odpovdi, kterou jsem obdrel, bylo _cel_
slo potvrzen. Nkter e-mailov programy mohou oznout st
adresy pro odpov, kter me bt i dosti dlouh.

Poslm novou dost o potvrzen. Pro potvrzen, e chcete zruit adresu

!A

do listu <#l#>, polete przdnou odpov na adresu

!R
</#x/>

Mete tak zkusit kliknout zde:
        mailto:<#R#>
<//>

Jet jednou: ujistte se, e adresa pro odpov je skuten v podku
pedtm, ne potvrdte tuto dost.

Omlouvm se za pote.

        <#L#>-Owner <<#l#>-owner@<#H#>>

</text/unsub-confirm/>
Potvrzujete-li, e chcete adresu

!A

zruit z listu <#l#>, polete przdnou odpov na adresu

!R

Toho obvykle doshnete pomoc tlatka "Odpov/Reply". Mete zkontrolovat
adresu, zan-li etzcem "<#L#>-sc". Pokud toto nefunguje, sta
zkoprovat adresu a uloit ji do polka "To:" nov zprvy.
</#x/>

Mete tak zkusit kliknout zde:
	mailto:<#R#>
<//>

Nekontroloval jsem, je-li vae adresa v souasn dob na listu.
Chcete-li zjistit, ze kter adresy bylo provedeno pihlen,
podvejte se do zprv, kter dostvte z listu. Kad zprva
m adresu v nvratov cest:
<<#l#>-return-<number>-jana=domena.cz@<#H#>.

</#q/>
Nkter potovn programy jsou chybn a nemohou zpracovvat dlouh
adresy. Pokud nemete odpovdt na tuto adresu, polete
zprvu na adresu <<#L#>-request@<#H#>>
a vlote celou ve uvedenou adresu do subjectu.

</text/unsub-nop/>
Potvrzen: Adresa

!A

nebyla na listu <#l#> v dob, kdy jsem obdrel
v poadavek a nen na nm ani te.

Pokud se odhlste, ale stle vm budou chodit dopisy, je pihlen
provedeno pod jinou adresou, ne kterou v souasn dob pouvte.
Podvejte se prosm do hlaviek zprv na text

"Return-Path: <<#l#>-return-1234-pepa=domena.cz@<#H#>>'

Odhlaovac adresa pro tohoto uivatele pak bude
"<#l#>-unsubscribe-pepa=domena.cz@<#H#>".
Sta poslat mail na tuto adresu s tm, e pepa=domena.cz nahradte
skutenmi hodnotami. Pak odpovte na dost o potvrzen a mla
by vm dojt zprva o odhlen z listu.

V nkterch potovnch programech si muste zprvu zobrazit vetn
hlaviek, jinak nen hlavika "Return-Path" viditeln.

Pokud toto stle nefunguje, pak je mi lto, ale nemohu vm pomoci.
Prosm PREPOLETE (forward) zprvu z listu spolu s poznmkou o tom,
eho se snate doshnout a seznamem adres, ze kterch potenciln
mete bt pihlen[a] mmu sprvci:

    <#l#>-owner@<#H#>

Tento se bude snait v problm eit. Mj sprvce je troku pomalej
ne j, take prosm o trochu trplivosti.

</text/unsub-ok/>
Potvrzen: Zruil jsem adresu

!A

z listu <#l#>. Tato adresa ji dle nen v seznamu
pihlench.

</text/edit-do#n/>
Prosm editujte nsledujc soubor a polete jej na adresu

!R

V potovn program by ml mt tlatko "Odpov/Reply",
kter tuto adresu pouije automaticky.

Umm dokonce sm smazat citovac znaky, kter v potovn program
pid ped text, pokud ovem ponechte znakovac dky samotn.

Tyto dky zanaj temi znaky procento. Nesm bt modifikovny
(s vjimkou ppadnch znak ped nimi, pidanch pipadn vam
potovnm klientem).

</text/edit-list#n/>
Pkaz <#L#>-edit.soubor me bt pouit vzdlenm sprvcem k editaci
textovch soubor, ze kterch se skldaj odpovdi pro list <#L#>@<#H#>.

Nsleduje seznam pslunch soubor a krtk popis toho, kdy je
jejich obsah vyuvn. Chcete-li editovat soubor, sta poslat
mail na adresu <#L#>-edit.soubor, piem je nutno "soubor"
nahradit skutenm jmnem souboru. Obdrte soubor spolu s instrukcemi,
jak tento soubor editovat.

Soubor              Pouit

bottom              pidv se za kadou odpov. Veobecn informace.
digest              "administrativn" st digest.
faq                 asto kladen dotazy, specifick pro tento list.
get_bad             neni-li zprva nalezena v archvu.
help                veobecn npovda (mezi "top" a "bottom").
info                informace o listu. Prvn dek by ml dvat smysl sm o sob.
mod_help            npovda pro modertory.
mod_reject          odeslateli odmtnut zprvy.
mod_request         modertorovi spolu s pspvkem.
mod_sub             pihlaovanmu, jakmile jeho pihlen potvrd modertor.
mod_sub_confirm     modertorovi s dost o potvrzen pihlen.
mod_timeout         odeslateli, nestihne-li modertor potvrdit zprvu.
mod_unsub_confirm   administrtorovi s dost o potvrzen odhlen.
sub_bad             odeslateli, bylo-li pihlen neplatn.
sub_confirm         odeslateli - dost potvrzen pihlen.
sub_nop             odeslateli - pi pokusu o optovn pihlen
sub_ok              odeslateli - oznamuje pihlen.
top                 zatek vech odpovd.
</#tn/>
trailer             pid se za kad pspvek do listu.
</#n/>
unsub_bad           odeslateli, byla li dost o odhlen neplatn.
unsub_confirm       odeslateli - dost o potvrzen odhlen.
unsub_nop           odeslateli - nebyl-li pihlen a snail-li se odhlsit.
unsub_ok            odeslateli po spnm odhlen.

</text/edit-done#n/>
Textov soubor byl spn upraven.
</text/info#E/>
dn informace nebyla k tomuto listu poskytnuta.
</text/faq#E/>
FAQ - asto kladen dotazy v listu <#l#>@<#H#>.

[ dn zatm nejsou dostupn ]


