/* $Id: messages.c,v 1.12 2005/10/15 16:24:20 gsson Exp $ */

/*
 * Copyright (c) 2005 Henrik Gustafsson <henrik.gustafsson@fnord.se>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <err.h>
#include <syslog.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

void
error(int log, int retval, const char *fmt, ...) {
	char message[128];
	va_list p;
	
	va_start(p, fmt);
	
	if (log) {
		vsnprintf(message, 128, fmt, p);
		syslog(LOG_ERR, "%s: %m", message);
		exit(retval);
	}
	else {
		verr(retval, fmt, p);
	}
	va_end(p);
}

void
warning(int log, const char *fmt, ...) {
	char message[128];
	va_list p;
	
	va_start(p, fmt);
	
	if (log) {
		vsnprintf(message, 128, fmt, p);
		syslog(LOG_WARNING, "%s: %m", message);
	}
	else {
		vwarn(fmt, p);
	}
	va_end(p);
}

void
info(int log, const char *fmt, ...) {
	char message[128];
	va_list p;
	
	va_start(p, fmt);
	
	if (log) {
		vsnprintf(message, 128, fmt, p);
		syslog(LOG_INFO, "%s: %m", message);
	}
	else {
		vprintf(fmt, p);
		putchar('\n');
	}
	va_end(p);
}

void
errorx(int log, int retval, const char *fmt, ...) {
	va_list p;
	
	va_start(p, fmt);
	
	if (log) {
		vsyslog(LOG_ERR, fmt, p);
		exit(retval);
	}
	else {
		verr(retval, fmt, p);
	}
	va_end(p);
}

void
warningx(int log, const char *fmt, ...) {
	va_list p;
	
	va_start(p, fmt);
	
	if (log) {
		vsyslog(LOG_WARNING, fmt, p);
	}
	else {
		vwarn(fmt, p);
	}
	va_end(p);
}

void
infox(int log, const char *fmt, ...) {
	va_list p;
	
	va_start(p, fmt);
	
	if (log) {
		vsyslog(LOG_INFO, fmt, p);
	}
	else {
		vprintf(fmt, p);
		putchar('\n');
	}
	va_end(p);
}
