/* evilwm - Minimalist Window Manager for X
 * Copyright (C) 1999-2002 Ciaran Anscomb <evilwm@6809.org.uk>
 * see README for license and other details. */

#include "evilwm.h"
#include <X11/Xproto.h>
#include <stdlib.h>
#include <stdarg.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdio.h>

/* Now do this by fork()ing twice so we don't have to worry about SIGCHLDs */
void spawn(char *cmd) {
	pid_t pid;
	if (!(pid = fork())) {
		switch (fork()) {
			case 0: execlp(cmd, cmd, NULL);
			default: _exit(0);
		}
	}
	if (pid > 0)
		wait(NULL);
}

void handle_signal(int signo) {
	/* SIGCHLD check no longer necessary */
	/* Quit Nicely */
	quitting = 1;
	while(head_client) remove_client(head_client);
	XSetInputFocus(dpy, PointerRoot, RevertToPointerRoot, CurrentTime);
	XInstallColormap(dpy, DefaultColormap(dpy, screen));
	XFreeGC(dpy, invert_gc);
	if (font) XFreeFont(dpy, font);
	XCloseDisplay(dpy);
	exit(0);
}

int handle_xerror(Display *dpy, XErrorEvent *e) {
	Client *c = find_client(e->resourceid);

	/* if (e->error_code == BadAccess && e->resourceid == root) { */
	if (e->error_code == BadAccess && e->request_code == X_ChangeWindowAttributes) {
#ifdef STDIO
		fprintf(stderr, "root window unavailable (maybe another wm is running?)\n");
#endif
		exit(1);
	}
#ifdef XDEBUG
	fprintf(stderr, "XError %x ", e->error_code);
#endif
	if (c) {
#ifdef XDEBUG
		fprintf(stderr, "(removing client)\n");
#endif
		remove_client(c);
	}
	return 0;
}

int ignore_xerror(Display *dpy, XErrorEvent *e) {
	return 0;
}

#ifdef DEBUG
void dump_clients() {
	Client *c;

	for (c = head_client; c; c = c->next)
		fprintf(stderr, "MISC: (%d, %d) @ %d,%d\n", wm_state(c),
			c->ignore_unmap, c->x, c->y);
}
#endif /* DEBUG */

#ifdef SANITY
void sanity_check() {
	Client *c;
	int count = 0;

	for (c = head_client; c; c = c->next)
		count++;
	if (count != tracked_count) {
		fprintf(stderr, "misc:sanity_check() failed - should be %d clients, I count %d\n", tracked_count, count);
		exit(1);
	}
}
#endif /* SANITY */
