/* evilwm - Minimalist Window Manager for X
 * Copyright (C) 1999-2002 Ciaran Anscomb <evilwm@6809.org.uk>
 * see README for license and other details. */

#include "evilwm.h"
#include <stdlib.h>
#include <X11/Xatom.h>
#include <stdio.h>
#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif

void handle_key_event(XKeyEvent *e) {
	Client *c = find_client(e->window);
	KeySym key = XKeycodeToKeysym(dpy,e->keycode,0);

	if (!c)
		c = current;
	if (c) {
		switch (key) {
		case KEY_LEFT:
			c->x -= 16; if (0)
		case KEY_DOWN:
			c->y += 16; if (0)
		case KEY_UP:
			c->y -= 16; if (0)
		case KEY_RIGHT:
			c->x += 16; if (0)
		case KEY_TOPLEFT:
			{ c->x = c->border; c->y = c->border; } if (0)
		case KEY_TOPRIGHT:
			{ c->x = DisplayWidth(dpy, screen)-c->width-c->border; c->y = c->border; } if (0)
		case KEY_BOTTOMLEFT:
			{ c->x = c->border; c->y = DisplayHeight(dpy, screen)-c->height-c->border; } if (0)
		case KEY_BOTTOMRIGHT:
			{ c->x = DisplayWidth(dpy, screen)-c->width-c->border; c->y = DisplayHeight(dpy, screen)-c->height-c->border; }
			move(c, 1);
			setmouse(c->window, c->width + c->border - 1,
					c->height + c->border - 1);
			break;
		case KEY_KILL:
			send_wm_delete(c); break;
		case KEY_LOWER: case KEY_ALTLOWER:
			XLowerWindow(dpy, c->parent);
			break;
		case KEY_INFO:
			show_info(c, key);
			break;
		case KEY_MAX:
			maximise_horiz(c);
		case KEY_MAXVERT:
			maximise_vert(c);
			resize(c, 1);
			setmouse(c->window, c->width + c->border - 1,
					c->height + c->border - 1);
			break;
#ifdef VWM
		case KEY_FIX:
			XSetWindowBackground(dpy, c->parent,
					RD_DESK(c) == STICKY ? fg.pixel : fc.pixel);
			XClearWindow(dpy, c->parent);
			WR_DESK(c, ( RD_DESK(c) == STICKY ? GET_VDESK : STICKY ) );
			break;
#endif
		}
	}
	switch(key) {
		case KEY_NEW:
			spawn(opt_term ? opt_term : DEF_TERM); break;
		case KEY_NEXT:
			next(c);
			break;
#ifdef VWM
		case XK_1: case XK_2: case XK_3: case XK_4:
		case XK_5: case XK_6: case XK_7: case XK_8:
			switch_vdesk(KEY_TO_VDESK(key));
			break;
		case KEY_PREVDESK:
			if (GET_VDESK > KEY_TO_VDESK(XK_1))
				switch_vdesk(GET_VDESK - 1);
			break;
		case KEY_NEXTDESK:
			if (GET_VDESK < KEY_TO_VDESK(XK_8))
				switch_vdesk(GET_VDESK + 1);
			break;
#endif
	}
}

#ifdef MOUSE
void handle_button_event(XButtonEvent *e) {
	Client *c = find_client(e->window);

	if (c && e->window != root) {
		switch (e->button) {
			case Button1:
				move(c, 0); break;
			case Button2:
				resize(c, 0); break;
			case Button3:
				XLowerWindow(dpy, c->parent); break;
		}
	}
}
#endif

void handle_configure_request(XConfigureRequestEvent *e) {
	Client *c = find_client(e->window);
	XWindowChanges wc;

	wc.sibling = e->above;
	wc.stack_mode = e->detail;
	if (c) {
		ungravitate(c);
		if (e->value_mask & CWWidth) c->width = e->width;
		if (e->value_mask & CWHeight) c->height = e->height;
		if (e->value_mask & CWX) {
			c->x = e->x;
			if (c->x == 0 && c->width >= DisplayWidth(dpy, screen))
				c->x -= c->border;
		}
		if (e->value_mask & CWY) {
			c->y = e->y;
			if (c->y == 0 && c->height >= DisplayHeight(dpy, screen))
				c->y -= c->border;
		}
		gravitate(c);

		wc.x = c->x - c->border;
		wc.y = c->y - c->border;
		wc.width = c->width + (c->border*2);
		wc.height = c->height + (c->border*2);
		wc.border_width = 0;
		XConfigureWindow(dpy, c->parent, e->value_mask, &wc);
		send_config(c);
	}

	wc.x = c ? c->border : e->x;
	wc.y = c ? c->border : e->y;
	wc.width = e->width;
	wc.height = e->height;
	XConfigureWindow(dpy, e->window, e->value_mask, &wc);
}

void handle_map_request(XMapRequestEvent *e) {
	Client *c = find_client(e->window);

	if (c) {
#ifdef VWM
		if (RD_DESK(c) != GET_VDESK)
			switch_vdesk(RD_DESK(c));
#endif
		unhide(c, RAISE);
	} else {
#ifdef DEBUG
		fprintf(stderr, "event:map->make_new_client(); ");
#endif
		make_new_client(e->window);
	}
}

void handle_unmap_event(XUnmapEvent *e) {
	Client *c = find_client(e->window);

	if (c) {
#ifdef DEBUG
		fprintf(stderr, "EVENT: unmap, ignore_unmap = %d\n", c->ignore_unmap);
#endif
		if (c->ignore_unmap) c->ignore_unmap--;
		else remove_client(c);
	}
}

#ifdef VDESK
void handle_client_message(XClientMessageEvent *e) {
	Client *c = find_client(e->window);

	if (c && e->message_type == xa_wm_change_state &&
		e->format == 32 && e->data.l[0] == IconicState) hide(c);
}
#endif

#ifdef COLOURMAP
void handle_colormap_change(XColormapEvent *e) {
	Client *c = find_client(e->window);

	if (c && e->new) {
		c->cmap = e->colormap;
		XInstallColormap(dpy, c->cmap);
	}
}
#endif

void handle_property_change(XPropertyEvent *e) {
	Client *c = find_client(e->window);
	long dummy;

	if (c) {
		if (e->atom == XA_WM_NORMAL_HINTS)
				XGetWMNormalHints(dpy, c->window, c->size, &dummy);
#ifdef VDESK_BOTH
		/* Vdesk-hack. Evilwm does not use iconifying, so whenever
		* vdesk tries to set it's "iconifyed" flag we remove it again.
		* Vdesk assumes that if a window is not visible, but marked
		* as belonging to the current window, it sets a flag to
		* permanently mark that window as invisible. It works nicely
		* when vdesk does all the magic itself.
		*/
		if (e->atom == vdesk_desktop) fix_visibility_hack(c->window);
#endif
	}
}

void handle_enter_event(XCrossingEvent *e) {
#ifdef VWM
	int wdesk;
#endif
	Client *c = find_client(e->window);
	if (c) {
#ifdef VWM
		wdesk = RD_DESK(c);
		if (wdesk != GET_VDESK && wdesk != STICKY)
			return;
#endif
#ifdef COLOURMAP
		XInstallColormap(dpy, c->cmap);
#endif
		if (current && c!=current) {
			XSetWindowBackground(dpy, current->parent, bg.pixel);
			XClearWindow(dpy, current->parent);
		}
#ifdef VWM
		XSetWindowBackground(dpy, c->parent, (wdesk==STICKY)?fc.pixel:fg.pixel);
#else
		XSetWindowBackground(dpy, c->parent, fg.pixel);
#endif
		XClearWindow(dpy, c->parent);
		current = c;
		XSetInputFocus(dpy, c->window, RevertToPointerRoot, CurrentTime);
#ifdef MOUSE
		XGrabButton(dpy, AnyButton, Mod1Mask, c->parent, False,
			ButtonMask, GrabModeAsync, GrabModeSync, None, None);
		XGrabButton(dpy, AnyButton, Mod3Mask|Mod1Mask, c->parent, False,
			ButtonMask, GrabModeAsync, GrabModeSync, None, None);
#endif
	}
}

#ifdef SHAPE
void handle_shape_event(XShapeEvent *e) {
	Client *c = find_client(e->window);
	if (c)
		set_shape(c);
}
#endif
