#include <gtk/gtk.h>
#include "account.h"
#include "service.h"

#ifndef __CHAT_ROOM_H__
#define __CHAT_ROOM_H__

typedef struct _eb_chat_room_buddy
{
	gchar alias[255];
	gchar handle[255];
} eb_chat_room_buddy;

typedef struct _eb_chat_room
{
	gboolean connected; //are we currently in this chat room
	gchar id[255];      //who are we?
	gchar room_name[1024];  //what is this chat room called
	GtkWidget * window;
	GtkWidget * conversation;
	GtkWidget * entry;
	GtkWidget * online;  // CList of online folks

	GList * fellows;   //who is in the chat room
	eb_local_account * chat_room_account; //who are we talking as?
	void *protocol_local_chat_room_data; // For protocol-specific storage

	/*
	 * the folloing data members is for the invite window gui
	 * since each chat room may spawn an invite window 
	 */

	gboolean invite_window_is_open;
	GtkWidget * invite_window;
	GtkWidget * invite_buddy;
	GtkWidget * invite_message;


} eb_chat_room;

void eb_join_chat_room( eb_chat_room * chat_room );
void eb_chat_room_show_message( eb_chat_room * chat_room, gchar * user, gchar * message );
void eb_start_chat_room( gint service, gchar * name );
void eb_chat_room_buddy_arrive( eb_chat_room * room, gchar * alias, gchar * handle );
void eb_chat_room_buddy_leave( eb_chat_room * room, gchar * handle );
void open_join_chat_window();



#endif

