
#if !defined(EC_INTERFACE_H)
#define EC_INTERFACE_H

#ifdef HAVE_NCURSES
   
   #ifdef HAVE_NCURSES_H
      #include <ncurses.h>
   #else
      #include <curses.h>
   #endif
   
   #include <ec_interface_sniff.h>
   #include <ec_interface_sniff_data.h>
   #include <ec_interface_plugins.h>

   #define BOTTOM_COLOR 1        // color schemes
   #define HELP_COLOR   6

   extern WINDOW *data_source_win;
   extern WINDOW *plugin_window, *main_window;
   extern short scroll_yp;
   extern int W_MAINX1, W_MAINY1, W_MAINX2, W_MAINY2;
      

extern void Interface_InitTitle(char *ip, char *mac, char *subnet);
extern void Interface_InitScreen(void);
extern void Interface_CloseScreen(void);
extern void Interface_Run(void);
extern void Interface_Winch(void);
extern void Interface_WExit(char *buffer);
extern void Interface_Redraw(void);
extern char Interface_PopUp(char *question, ...);
extern void Interface_HelpWindow(char *help[]);


#ifdef CYGWIN
   #define MIN_DO_UPDATE_DELAY 50
#endif

#endif   // HAVE_NCURSES

#endif

/* EOF */

// vim:ts=3:expandtab

