
#if !defined(EC_PACKET_H)
#define EC_PACKET_H

struct packet_object {
	struct L2 {
		u_char * header;
		int len;
	} L2;
	struct L3 {
      u_short proto;
         #define L3PROTO_IP   ETH_P_IP
         #define L3PROTO_ARP  ETH_P_ARP
		u_char * header;
		u_char * options;
		int len;
	} L3;
	struct L4 {
      u_char proto;
         #define L4PROTO_ICMP IPPROTO_ICMP
         #define L4PROTO_TCP  IPPROTO_TCP
         #define L4PROTO_UDP  IPPROTO_UDP
		u_char * header;
		u_char * options;
      u_short * sport;
      u_short * dport;
		int len;
	} L4;
	struct data {
		u_char * data;
		int len;
	} data;

	int * len;

	int (*decode)(struct packet_object *, void *);
   char decode_mode;

	int (*filter)(struct packet_object *, void *);
};

extern int packet_create_object(struct packet_object **po, u_char * buf, int * len);

extern int packet_destroy_object(struct packet_object **po);

extern int packet_duplicate(struct packet_object *po, char level, u_char **buf);
#define LEVEL_2		0           /* 00000000 */
#define LEVEL_3		1           /* 00000001 */ 
#define LEVEL_4		(1 << 2)    /* 00000010 */ 
#define LEVEL_DATA	(1 << 3)    /* 00000100 */ 
#define LEVEL_MASK   0x7         /* 00000111 */
#define DUP_COPY     (1 << 4)    /* 00001000 */ 
#define DUP_ALLOC    (1 << 5)    /* 00010000 */



#endif

/* EOF */

// vim:ts=3:expandtab

