/*
    ettercap -- dissector NNTP -- TCP 119

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "include/ec_main.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "include/ec_dissector.h"
#include "include/ec_inet_structures.h"
#include "include/ec_error.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif

// protos

FUNC_DISSECTOR(Dissector_nntp);

// --------------------


FUNC_DISSECTOR(Dissector_nntp)
{

   TCP_header *tcp;
   u_char *payload;
   ONLY_CONNECTION;

   tcp = (TCP_header *) data;

   if (ntohs(tcp->source) == SERV_PORT) return 0;            // skip server messages...

   payload = (char *)((int)tcp + tcp->doff * 4);

   if ( !strncasecmp(payload, "AUTHINFO USER", 13) )
   {
      char user[25];
      #ifdef DEBUG
         Debug_msg("\tDissector_NNTP USER");
      #endif
      strncpy(user, payload + 14 , 25 );
      strcat(data_to_ettercap->user, user);
   }

   if ( !strncasecmp(payload, "AUTHINFO PASS", 13) )
   {
      char pass[25];
      #ifdef DEBUG
         Debug_msg("\tDissector_NNTP PASS");
      #endif
      strncpy(pass, payload + 14 , 25 );
      strcat(data_to_ettercap->pass, pass);
   }

   return 0;
}


/* EOF */
