/*
    ettercap -- dissector HTTP Authorization: Basic -- TCP 80 8080

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "include/ec_main.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "include/ec_dissector.h"
#include "include/ec_inet_structures.h"
#include "include/ec_error.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif

// protos

FUNC_DISSECTOR(Dissector_http);

// --------------------------------------

FUNC_DISSECTOR(Dissector_http)
{

   TCP_header *tcp;
   u_char *payload;
   char *fromhere;
   u_char collector[MAX_DATA];
   ONLY_CONNECTION;

   tcp = (TCP_header *) data;

   if (ntohs(tcp->source) == SERV_PORT) return 0;            // skip server messages...
   if (data_to_ettercap->datalen == 0) return 0;      // no data...

   payload = (char *)((int)tcp + tcp->doff * 4);

   memset(collector, 0, MAX_DATA);
   memcpy(collector, payload, data_to_ettercap->datalen);

   if ( (fromhere = strstr(collector, "Authorization: Basic")) || (fromhere = strstr(collector, "Proxy-authorization: Basic")) )
   {
      char user[25];
      char pass[25];
      char decoded[50];
      char to_be_decoded[50];
      char page[100] = "";
      char host[100] = "";

      #ifdef DEBUG
         Debug_msg("\tDissector_HTTP");
      #endif

      memset(page, 0, sizeof(page));
      memset(host, 0, sizeof(host));

      if (strstr(collector, "GET"))
      {

         strncpy(page, strstr(collector, "GET") + strlen("GET "), 99);
         page[99]=0;
         strtok(page, " HTTP");
      }
      else if (strstr(collector, "POST"))
      {
         strncpy(page, strstr(collector, "POST") + strlen("POST "), 99);
         page[99]=0;
         strtok(page, " HTTP");
      }
      else if (strstr(collector, "PUT"))
      {
         strncpy(page, strstr(collector, "PUT") + strlen("PUT "), 99);
         page[99]=0;
         strtok(page, " HTTP");
      }

      if (strstr(collector, "Host:"))
      {
         strncpy(host, strstr(collector, "Host:") + strlen("Host: "), 99);
         host[99]=0;
         strtok(host, "\r");
      }

      strtok(fromhere, "\r");
      if (!strncmp(fromhere, "Authorization: Basic", 20))
         strncpy(to_be_decoded, fromhere+strlen("Authorization: Basic")+1 , 50 );
      else
         strncpy(to_be_decoded, fromhere+strlen("Proxy-authorization: Basic")+1 , 50 );

      to_be_decoded[50]=0;

      Dissector_base64decode(decoded, to_be_decoded);
      strncpy(user, strtok(decoded, ":"), 25);  strcat(user, "\n");
      strncpy(pass, strtok(NULL, ":"), 25);     strcat(pass, "\n");

      strcat(data_to_ettercap->user, user);
      strcat(data_to_ettercap->pass, pass);
      snprintf(data_to_ettercap->info, 150, "http://%s%s\n", host, page);

      #ifdef DEBUG
         Debug_msg("\tDissector_HTTP -- [%s][%s]", host, page);
         Debug_msg("\tDissector_HTTP -- [%s]", to_be_decoded);
      #endif
   }
   return 0;
}


/* EOF */
