/*
    ettercap -- dissector MySQL -- TCP 3306

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "include/ec_main.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "include/ec_dissector.h"
#include "include/ec_decodedata.h"
#include "include/ec_inet_structures.h"
#include "include/ec_error.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif

// protos

FUNC_DISSECTOR(Dissector_mysql);

// --------------------

FUNC_DISSECTOR(Dissector_mysql)
{

   TCP_header *tcp;
   u_char *payload;
   u_char collector[MAX_DATA];
   char seed[8];
   ONLY_CONNECTION;

   tcp = (TCP_header *) data;

   if (data_to_ettercap->datalen == 0) return 0;      // no data...

   payload = (char *)((int)tcp + tcp->doff * 4);

   memset(collector, 0, MAX_DATA);
   memcpy(collector, payload, data_to_ettercap->datalen);

   if ( (Dissector_StateMachine_GetStatus(data_to_ettercap) == 0) && ntohs(tcp->source) == 3306)            // server messages... collect the random seed
   {
      int i = 5;  // skip first five byte

      if (memcmp(collector, "\x28\x00\x00\x00\x0a", 2)) return 0;    // magic number... ;)

      #ifdef DEBUG
         Debug_msg("\tDissector_MySQL server");
      #endif

      while(collector[i] != collector[i-1] != collector[i-2] != 0)   // search for 000 padding
         i++;

      strncpy(seed, collector + i + 1, 8);
      sprintf(data_to_ettercap->info, "Encrypted (one way) seed: %s  pass: ", seed);

      Dissector_StateMachine_SetStatus(data_to_ettercap, 1);
      return 0;
   }

   if ( (Dissector_StateMachine_GetStatus(data_to_ettercap) == 1) && ntohs(tcp->source) != 3306)  // client response crypt pass with seed
   {
      char user[25];
      char pass[25];

      snprintf(user, 25, "%s", collector+9);
      snprintf(pass, 25, "%s", collector+9+strlen(user)+1);

      strcat(data_to_ettercap->user, user);
      strcat(data_to_ettercap->user, "\n");

      if (strlen(pass) != 0)
         strcat(data_to_ettercap->pass, "\n");
      else  // NULL password oh yeah !!
         strcat(data_to_ettercap->pass, "NO PASS yeah ! ;)\n");

      strcat(data_to_ettercap->info, pass);
      strcat(data_to_ettercap->info, "\n");
      sprintf(data_to_ettercap->type, "MySQL");

      Dissector_StateMachine_SetStatus(data_to_ettercap, 0);
    }

    return 0;
}

/* EOF */
