/*
    ettercap -- dissector X11 -- TCP 6000 6001 6002 6003

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "include/ec_main.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "include/ec_dissector.h"
#include "include/ec_inet_structures.h"
#include "include/ec_error.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif

// protos

FUNC_DISSECTOR(Dissector_x11);

// --------------------


FUNC_DISSECTOR(Dissector_x11)
{

   TCP_header *tcp;
   u_char *payload;
   ONLY_CONNECTION;

   tcp = (TCP_header *) data;

   payload = (char *)((int)tcp + tcp->doff * 4);

   payload = strstr(payload+12, "MIT-MAGIC-COOKIE-1");

   if (payload)
   {
      int i;

      #ifdef DEBUG
         Debug_msg("\tDissector_X11");
      #endif
      if (ntohs(tcp->dest) >= 6000 && ntohs(tcp->dest) <= 6004)
         sprintf(data_to_ettercap->user, "On display :%d\n", ntohs(tcp->dest)-6000);
      else
         sprintf(data_to_ettercap->user, "\n");
      strcat(data_to_ettercap->pass, "\n");
      sprintf(data_to_ettercap->info, "MIT-MAGIC-COOKIE-1 ");
      strcat(data_to_ettercap->type, "X11");

      for (i = 0; i < 16; i++)
         sprintf(data_to_ettercap->info + (i * 2) + 19, "%.2x", payload[i+20]);

      strcat(data_to_ettercap->info, "\n");
   }

   return 0;
}

/* EOF */
