
extern void Dissector_Connections( char mode, short proto, u_char *data, void *data_to_ettercap, int Conn_Mode );
extern int Dissector_base64decode(char *bufplain, const char *bufcoded);

#define FUNC_DISSECTOR(func) int func( u_char *data, void *vdata_to_ettercap, int Conn_Mode )

#define ONLY_CONNECTION    CONNECTION *data_to_ettercap; \
                           if (!Conn_Mode) return 0; \
                           data_to_ettercap = (CONNECTION *)vdata_to_ettercap

#define DATA_DISSECTOR     CONNECTION *data_to_ettercap; \
                           SNIFFED_DATA *sniff_data_to_ettercap; \
                           data_to_ettercap = (CONNECTION *)vdata_to_ettercap; \
   								sniff_data_to_ettercap = (SNIFFED_DATA *)vdata_to_ettercap


extern FUNC_DISSECTOR(Dissector_ftp);      // 21
#ifdef HAVE_OPENSSL
extern FUNC_DISSECTOR(Dissector_ssh);      // 22
#endif
extern FUNC_DISSECTOR(Dissector_telnet);   // 23
extern FUNC_DISSECTOR(Dissector_http);     // 80 8080
extern FUNC_DISSECTOR(Dissector_pop);      // 110
extern FUNC_DISSECTOR(Dissector_nntp);     // 119
extern FUNC_DISSECTOR(Dissector_smb);      // 139
extern FUNC_DISSECTOR(Dissector_imap);     // 143 220
extern FUNC_DISSECTOR(Dissector_bgp);      // 179
extern FUNC_DISSECTOR(Dissector_rlogin);   // 512 513 514
extern FUNC_DISSECTOR(Dissector_rip);      // 520					UDP
extern FUNC_DISSECTOR(Dissector_socks);    // 1080
extern FUNC_DISSECTOR(Dissector_mysql);    // 3306
extern FUNC_DISSECTOR(Dissector_icq);      // 4000	ALL_P			UDP
extern FUNC_DISSECTOR(Dissector_vnc);      // 5900-5905
extern FUNC_DISSECTOR(Dissector_x11);      // 6000-6005
extern FUNC_DISSECTOR(Dissector_napster);  // 6666 7777 8888
extern FUNC_DISSECTOR(Dissector_irc); 		 // 6667-6669

/* EOF */
