/*
    ettercap -- module for logging into different files

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>

#include "include/ec_main.h"
#include "include/ec_error.h"
#include "include/ec_inet_structures.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif

typedef struct {
   char ip_source[16];
   char ip_dest[16];
   int source_port;
   int dest_port;
   char proto;
   FILE *flog;
   struct LOGGED_DATA *next;
} LOGGED_DATA;

LOGGED_DATA *head;

// protos

void LogToFile(SNIFFED_DATA *data);
FILE * LogToFile_open_collect();
void LogToFile_freelist(LOGGED_DATA *head);
void LogToFile_close();

// -------------------------------

FILE * LogToFile_open_collect()
{
   FILE *fto;
   time_t tt;
   struct tm *dd;
   char filename[50];

   tt = time(NULL);
   dd = localtime(&tt);

   sprintf(filename, "%04d%02d%02d-collected-pass.log", dd->tm_year+1900, dd->tm_mon+1, dd->tm_mday);
   fto = fopen(filename, "a");

   return fto;
}


void LogToFile(SNIFFED_DATA *data)
{
   time_t tt;
   struct tm *dd;
   char filter[45];
   char cur_conn[45];
   char found = 0;
   LOGGED_DATA *index = head;
   LOGGED_DATA *ptr = index;
   LOGGED_DATA *current;

   tt = time(NULL);
   dd = localtime(&tt);

   sprintf(filter, "%c%s%d%s%d", data->proto, data->ip_source, data->source_port, data->ip_dest, data->dest_port);

   if (head != NULL)
   {
      for(ptr = head; ptr != NULL; ptr = (LOGGED_DATA *)ptr->next)
      {
         index = ptr;
         sprintf(cur_conn, "%c%s%d%s%d", index->proto, index->ip_source, index->source_port, index->ip_dest, index->dest_port);

         if (!strcmp(filter, cur_conn))
         {
            found = 1;

            write(fileno(index->flog), data->data, data->datasize);

            if ( (data->flags & TH_RST) || (data->flags & TH_FIN) )
            	fprintf(index->flog, "\n\n| CONNECTION CLOSED ON %02d:%02d:%02d |\n\n",  dd->tm_hour, dd->tm_min, dd->tm_sec);

            fflush(index->flog);
            return;
         }
      }
   }

   if (!found)
   {
      char logname[100];

      #ifdef DEBUG
         Debug_msg("LogToFile - new log ! %c %s:%d - %s:%d ",  data->proto, data->ip_source, data->source_port, data->ip_dest, data->dest_port);
      #endif

      current = (LOGGED_DATA *)calloc(1, sizeof(LOGGED_DATA));
      if (current == NULL)
         Error_msg("ec_logtofile:%d calloc() | ERRNO : %d | %s", __LINE__, errno, strerror(errno));

      memcpy(current->ip_source, &data->ip_source, sizeof(data->ip_source));
      memcpy(current->ip_dest, &data->ip_dest, sizeof(data->ip_dest));

      current->source_port = data->source_port;
      current->dest_port = data->dest_port;
      current->proto = data->proto;

      sprintf(logname, "%04d%02d%02d-%c-%s:%d-%s:%d.log", dd->tm_year+1900, dd->tm_mon+1, dd->tm_mday,
                        data->proto,
                        data->ip_source,
                        data->source_port,
                        data->ip_dest,
                        data->dest_port
      );

      current->flog = fopen(logname, "a");

      write(fileno(current->flog), data->data, data->datasize);
      fflush(current->flog);

      if (head == NULL) head = current;
      if (index != NULL) index->next = (struct LOGGED_DATA *)current;
   }
}


void LogToFile_close()
{

#ifdef DEBUG
   Debug_msg("LogToFile_close");
#endif

   LogToFile_freelist(head);
   head = NULL;

}

void LogToFile_freelist(LOGGED_DATA *cur)
{
   if (!cur)   return;

   LogToFile_freelist((LOGGED_DATA *) cur->next);
   fclose(cur->flog);
   free(cur);

}

/* EOF */
