/*
    ettercap -- illithid -- the sniffer module

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>

#include "include/ec_main.h"
#include "include/ec_inet.h"
#include "include/ec_inet_forge.h"
#include "include/ec_inet_structures.h"
#include "include/ec_buffer.h"
#include "include/ec_error.h"
#include "include/ec_dissector.h"
#include "include/ec_filterdrop.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif

// global data
short IPIDD=0, IPIDS=0;
int SeqS=0, AckS=0, SeqD=0, AckD=0,
    ByteSentS=0, ByteSentD=0, PacketSentS=0,
    PacketSentD=0, datalenS=0, datalenD=0;
int sock, G_PortSource, G_PortDest, IP1, IP2;
int Connection_Mode=1;
unsigned char MAC1[6];
unsigned char MAC2[6];
unsigned char MyMAC[6];

// protos...

int Illithid_ARPBased_GetData(char *iface, char proto, char *IPsource, int PortSource, char *IPdest, int PortDest, char *MAC1, char *MAC2);
int Illithid_ARPBased_GetConnections(char *iface, char *IP1p, char *IP2p, char *MAC1, char *MAC2);
int Illithid_PublicARP_GetConnections(char *iface, char *IP1p, char *IP2p, char *MAC1, char *MAC2);
int Illithid_IPBased_GetConnections(char *iface, char *IP1p, char *IP2p);
int Illithid_MACBased_GetConnections(char *iface, char *MAC1p, char *MAC2p);
int Illithid_ToBeSniffed(char *source, int psource, char *dest, int pdest, SNIFFED_DATA *data);
int Illithid_ToBeSniffed_ip(char *source, char *dest, CONNECTION *data);
void Illithid_GetConnections(short mode, char *iface, char *IP1p, char *IP2p, char *MAC1p, char *MAC2p);
void Illithid_Reset_Conn(void);

//---------------------------

void Illithid_Reset_Conn(void)
{
   int i;
   char *buf1, *buf2, *pck_to_send;

   if (ByteSentS || ByteSentD)
   {

#ifdef DEBUG
   Debug_msg("Illithid_Reset_Conn");
#endif

      buf1 = Inet_Forge_packet( ETH_HEADER + IP_HEADER + TCP_HEADER );
      pck_to_send = buf1;
      pck_to_send += Inet_Forge_ethernet( pck_to_send, MyMAC, MAC2, ETH_P_IP );
      pck_to_send += Inet_Forge_ip( pck_to_send, IP1, IP2, TCP_HEADER, IPIDD+PacketSentD+1, 0, IPPROTO_TCP);
      pck_to_send += Inet_Forge_tcp( pck_to_send, G_PortSource, G_PortDest, SeqD+datalenD+ByteSentD, AckD-ByteSentS, TH_RST | TH_ACK, 0, 0);

      buf2 = Inet_Forge_packet( ETH_HEADER + IP_HEADER + TCP_HEADER );
      pck_to_send = buf2;
      pck_to_send += Inet_Forge_ethernet( pck_to_send, MyMAC, MAC1, ETH_P_IP );
      pck_to_send += Inet_Forge_ip( pck_to_send, IP2, IP1, TCP_HEADER, IPIDS+PacketSentS+1, 0, IPPROTO_TCP);
      pck_to_send += Inet_Forge_tcp( pck_to_send, G_PortDest, G_PortSource, SeqS+datalenS+ByteSentS, AckS-ByteSentD, TH_RST | TH_ACK, 0, 0);

      for(i=0; i<5; i++)
      {
         Inet_SendRawPacket(sock, buf1, ETH_HEADER + IP_HEADER + TCP_HEADER );
         Inet_SendRawPacket(sock, buf2, ETH_HEADER + IP_HEADER + TCP_HEADER );
         usleep(1000);
      }
   }
#ifdef DEBUG
   Debug_msg("Illithid_Reset_Conn_END");
#endif
}

int Illithid_ARPBased_GetData(char *iface, char proto, char *IPsource, int PortSource, char *IPdest, int PortDest, char *MAC1p, char *MAC2p)
{
   int MTU, Illithid_pid, delta, datalen;
   short pkttype;
   struct in_addr addr;
   ETH_header *eth;
   IP_header *ip;
   TCP_header *tcp;
   UDP_header *udp;
   unsigned char *data;
   int nchars;
   char tosendchar[MAX_INJECT];
   char *ins_pck;
   u_char *buffer;
   SNIFFED_DATA data_to_test;
   DROP_FILTER filter;

#ifdef DEBUG
   Debug_msg("Illithid_ARPBased_GetData -- %c [%s:%d] [%s:%d] -- [%s] [%s]", proto, IPsource, PortSource, IPdest, PortDest, MAC1, MAC2);
#endif

   if ((Illithid_pid = fork()))
      return Illithid_pid;

   strcpy(program_argv0, "illidata");

   if (proto == 'T') exit_func(Illithid_Reset_Conn);

   sock = Inet_OpenRawSock(iface);
   Inet_GetIfaceInfo( iface, &MTU, MyMAC, NULL, NULL);

   G_PortSource = PortSource;
   G_PortDest = PortDest;

   inet_aton(IPsource,&addr);
   IP1 = addr.s_addr;
   inet_aton(IPdest,&addr);
   IP2 = addr.s_addr;

   Inet_GetMACfromString(MAC1p, MAC1);
   Inet_GetMACfromString(MAC2p, MAC2);

   fcntl(sock,F_SETFL,O_NONBLOCK);
   fcntl(pipe_inject_stod[0], F_SETFL, O_NONBLOCK);
   fcntl(pipe_inject_dtos[0], F_SETFL, O_NONBLOCK);
   fcntl(pipe_filter_stod[0], F_SETFL, O_NONBLOCK);
   fcntl(pipe_filter_dtos[0], F_SETFL, O_NONBLOCK);

   ins_pck = Inet_Forge_packet(MTU);
   buffer = Inet_Forge_packet(MTU);

   loop
   {
      int len;
      char ok;

      if (getppid() == 1) exit(0);
      //memset(buffer, 0, MTU);

      len = Inet_GetRawPacket(sock, buffer, MTU, &pkttype);

      if (len > 0 && pkttype == PACKET_HOST)
      {
         eth = (ETH_header *)buffer;

         if ( ntohs(eth->type) == ETH_P_IP )
         {
            ip = (IP_header *)(eth+1);
            ok = 0;

            if (ip->dest_ip==IP1 && ip->source_ip==IP2)
            {
               memcpy(eth->dest_mac, MAC1, 6);
               memcpy(eth->source_mac, MyMAC, 6);
               ok = 1;
            }

            if (ip->dest_ip==IP2 && ip->source_ip==IP1)
            {
               memcpy(eth->dest_mac, MAC2, 6);
               memcpy(eth->source_mac, MyMAC, 6);
               ok = 2;
            }


            if ( ok && ip->proto == IPPROTO_UDP && proto == 'U')
            {
               udp = (UDP_header *) ((int)ip + ip->h_len * 4);

               if (ntohs(ip->frag_and_flags) & IP_OFFMASK) goto send;

               strcpy(data_to_test.ip_source, int_ntoa(ip->source_ip) );
               strcpy(data_to_test.ip_dest, int_ntoa(ip->dest_ip) );
               data_to_test.source_port = ntohs(udp->source);
               data_to_test.dest_port = ntohs(udp->dest);
               data = (char *)((int)udp + UDP_HEADER);

               if ( Illithid_ToBeSniffed(IPsource,PortSource, IPdest, PortDest, &data_to_test) )
               {
                  datalen = ntohs(udp->len) - UDP_HEADER;

                  if (ok == 1)
                  {
                     len -= ETH_HEADER;
                     delta = FilterDrop_MakefilterUDP((u_char *)ip, &len, MTU-40, &ARP_Filter_Source);
                     len += ETH_HEADER;
                  }
                  else // ok == 2
                  {
                     len -= ETH_HEADER;
                     delta = FilterDrop_MakefilterUDP((u_char *)ip, &len, MTU-40, &ARP_Filter_Dest);
                     len += ETH_HEADER;
                  }
                  if (delta == -datalen) ok = 0;  // drop the packet (forwarding is done only if(ok) )
               }

            }

            if (ok && ip->proto == IPPROTO_TCP && proto == 'T')
            {
               tcp = (TCP_header *) ((int)ip + ip->h_len * 4);

               if (ntohs(ip->frag_and_flags) & IP_OFFMASK) goto send;

               strcpy(data_to_test.ip_source, int_ntoa(ip->source_ip) );
               strcpy(data_to_test.ip_dest, int_ntoa(ip->dest_ip) );
               data_to_test.source_port = ntohs(tcp->source);
               data_to_test.dest_port = ntohs(tcp->dest);

               data = (char *)((int)tcp + tcp->doff * 4);

               if ( Illithid_ToBeSniffed(IPsource, PortSource, IPdest, PortDest, &data_to_test) )
               {

                  if (ok == 1)   // from source
                  {
                     datalenS = (int)ip + ntohs(ip->t_len) - (int)data; // I need it before modifications....

                     len -= ETH_HEADER;
                     delta = FilterDrop_MakefilterTCP((u_char *)ip, &len, MTU-40, &ARP_Filter_Source);
                     len += ETH_HEADER;

                     SeqS = ntohl(tcp->seq);
                     AckS = ntohl(tcp->ack_seq);
                     tcp->seq = htonl(SeqS+ByteSentS);
                     tcp->ack_seq = htonl(AckS-ByteSentD);
                     IPIDS = ntohs(ip->ident);
                     ip->ident = htons(IPIDS+PacketSentS);

                     if (delta == -datalenS && datalenS != 0)     // the packet must be dropped, so we send an ACK
                     {
                        char *pck_to_send;
                        #ifdef DEBUG
                           Debug_msg("Illithid_ARPBased_GetData -- drop TCP ");
                        #endif
                        pck_to_send = ins_pck;
                        pck_to_send += Inet_Forge_ethernet( pck_to_send, MyMAC, MAC2, ETH_P_IP );
                        pck_to_send += Inet_Forge_ip( pck_to_send, IP1, IP2, TCP_HEADER, IPIDD+PacketSentD, 0, IPPROTO_TCP);
                        pck_to_send += Inet_Forge_tcp( pck_to_send, PortSource, PortDest, ntohl(tcp->ack_seq), SeqS+datalenS, TH_ACK, 0, 0);

                        Inet_SendRawPacket(sock, ins_pck, pck_to_send-ins_pck);
                        PacketSentD++;
                        ok = 0;  // drop the packet (forwarding is done only if(ok) )
                     }
                     ByteSentS += delta;

                     datalenS = (int)ip + ntohs(ip->t_len) - (int)data; // now i store the modified datalen

                     ip->checksum = 0;
                     tcp->checksum = 0;
                     ip->checksum = Inet_Forge_ChecksumIP( (unsigned short *) ip, sizeof(IP_header));

                     if (tcp->doff*4 > sizeof(TCP_header))
                     {
                         char *pointer;
                         pointer=(char *)(tcp + 1);
                         Inet_Forge_RemoveTimeStamp(pointer,tcp->doff*4-sizeof(TCP_header));
                     }
                     tcp->checksum = Inet_Forge_Checksum((unsigned short *)tcp, IPPROTO_TCP, ntohs(ip->t_len)-ip->h_len*4, IP2, IP1);
                  }
                  else  // ok == 2  //from dest
                  {
                     datalenD = (int)ip + ntohs(ip->t_len) - (int)data; // I need it before modifications....

                     len -= ETH_HEADER;
                     delta = FilterDrop_MakefilterTCP((u_char *)ip, &len, MTU-40, &ARP_Filter_Dest);
                     len += ETH_HEADER;

                     SeqD = ntohl(tcp->seq);
                     AckD = ntohl(tcp->ack_seq);
                     tcp->seq = htonl(SeqD+ByteSentD);
                     tcp->ack_seq = htonl(AckD-ByteSentS);
                     IPIDD = ntohs(ip->ident);
                     ip->ident = htons(IPIDD+PacketSentD);

                     if (delta == -datalenD && datalenD != 0)     // the packet must be dropped, so we send an ACK
                     {
                        char *pck_to_send;
                        #ifdef DEBUG
                           Debug_msg("Illithid_ARPBased_GetData -- drop TCP ");
                        #endif
                        pck_to_send = ins_pck;
                        pck_to_send += Inet_Forge_ethernet( pck_to_send, MyMAC, MAC1, ETH_P_IP );
                        pck_to_send += Inet_Forge_ip( pck_to_send, IP2, IP1, TCP_HEADER, IPIDS+PacketSentS, 0, IPPROTO_TCP);
                        pck_to_send += Inet_Forge_tcp( pck_to_send, PortDest, PortSource, ntohl(tcp->ack_seq), SeqD+datalenD, TH_ACK, 0, 0);

                        Inet_SendRawPacket(sock, ins_pck, pck_to_send-ins_pck);
                        PacketSentS++;
                        ok = 0;  // drop the packet (forwarding is done only if(ok) )
                     }
                     ByteSentD += delta;

                     datalenD = (int)ip + ntohs(ip->t_len) - (int)data; // now i store the modified datalen

                     ip->checksum = 0;
                     tcp->checksum = 0;
                     ip->checksum = Inet_Forge_ChecksumIP( (unsigned short *) ip, sizeof(IP_header));

                     if (tcp->doff*4 > sizeof(TCP_header))
                     {
                         char *pointer;
                         pointer=(char *)(tcp + 1);
                         Inet_Forge_RemoveTimeStamp(pointer,tcp->doff*4-sizeof(TCP_header));
                     }
                     tcp->checksum = Inet_Forge_Checksum((unsigned short *)tcp, IPPROTO_TCP, ntohs(ip->t_len)-ip->h_len*4, IP2, IP1);
                  }
               }
            }
send:       if (ok) Inet_SendRawPacket(sock, buffer, len);
         }
      }
      else
         usleep(1000);

      nchars = read(pipe_filter_stod[0], &filter, sizeof(DROP_FILTER));
      if (nchars  == sizeof(DROP_FILTER))
      {
         #ifdef DEBUG
            Debug_msg("Illithid_ARPBased_GetData -- set filter on source [%s][%s]", filter.search, filter.replace);
         #endif
         memcpy(&ARP_Filter_Source, &filter, sizeof(DROP_FILTER));
      }

      nchars = read(pipe_filter_dtos[0], &filter, sizeof(DROP_FILTER));
      if (nchars == sizeof(DROP_FILTER))
      {
         #ifdef DEBUG
            Debug_msg("Illithid_ARPBased_GetData -- set filter on dest [%s][%s]", filter.search, filter.replace);
         #endif
         memcpy(&ARP_Filter_Dest, &filter, sizeof(DROP_FILTER));
      }

      nchars = read(pipe_inject_stod[0], tosendchar, MAX_INJECT);
      if (nchars > 0)
      {
         char *pck_to_send;

         pck_to_send = ins_pck;
         pck_to_send += Inet_Forge_ethernet( pck_to_send, MyMAC, MAC2, ETH_P_IP );
         if (proto == 'T')
         {
            pck_to_send += Inet_Forge_ip( pck_to_send, IP1, IP2, TCP_HEADER+nchars, IPIDD+PacketSentD+1, 0, IPPROTO_TCP);
            pck_to_send += Inet_Forge_tcp( pck_to_send, PortSource, PortDest, SeqD+datalenD+ByteSentD, AckD-ByteSentS, TH_PSH | TH_ACK, tosendchar, nchars);
         }
         else if (proto == 'U')
         {
            pck_to_send += Inet_Forge_ip( pck_to_send, IP1, IP2, UDP_HEADER+nchars, IPIDD+PacketSentD+1, 0, IPPROTO_UDP);
            pck_to_send += Inet_Forge_udp( pck_to_send, PortSource, PortDest, tosendchar, nchars);
         }

         Inet_SendRawPacket(sock, ins_pck, pck_to_send-ins_pck);
         ByteSentD+=nchars;
         PacketSentD++;
      }

      nchars = read(pipe_inject_dtos[0], tosendchar, MAX_INJECT);
      if (nchars > 0)
      {
         char *pck_to_send;

         pck_to_send = ins_pck;
         pck_to_send += Inet_Forge_ethernet( pck_to_send, MyMAC, MAC1, ETH_P_IP );
         if (proto == 'T')
         {
            pck_to_send += Inet_Forge_ip( pck_to_send, IP2, IP1, TCP_HEADER+nchars, IPIDS+PacketSentS+1, 0, IPPROTO_TCP);
            pck_to_send += Inet_Forge_tcp( pck_to_send, PortDest, PortSource, SeqS+datalenS+ByteSentS, AckS-ByteSentD, TH_PSH | TH_ACK, tosendchar, nchars);
         }
         else if (proto == 'U')
         {
            pck_to_send += Inet_Forge_ip( pck_to_send, IP2, IP1, UDP_HEADER+nchars, IPIDS+PacketSentS+1, 0, IPPROTO_UDP);
            pck_to_send += Inet_Forge_udp( pck_to_send, PortDest, PortSource, tosendchar, nchars);
         }
         Inet_SendRawPacket(sock, ins_pck, pck_to_send-ins_pck);
         ByteSentS+=nchars;
         PacketSentS++;
      }
   }  // end loop
}


int Illithid_ARPBased_GetConnections(char *iface, char *IP1p, char *IP2p, char *MAC1p, char *MAC2p)
{
   int Illithid_pid;

#ifdef DEBUG
   Debug_msg("Illithid_ARPBased_GetConnections -- [%s] [%s] [%s] [%s]", IP1p, IP2p, MAC1p, MAC2p);
#endif

   if (!(Illithid_pid = fork()))
      Illithid_GetConnections(ARPBASED, iface, IP1p, IP2p, MAC1p, MAC2p);
   else
      return Illithid_pid;

   return 0;
}

int Illithid_PublicARP_GetConnections(char *iface, char *IP1p, char *IP2p, char *MAC1p, char *MAC2p)
{
   int Illithid_pid;

#ifdef DEBUG
   Debug_msg("Illithid_PublicARP_GetConnections -- [%s] [%s] [%s] [%s]", IP1p, IP2p, MAC1p, MAC2p);
#endif

   if (!(Illithid_pid = fork()))
      Illithid_GetConnections(PUBLICARP, iface, IP1p, IP2p, MAC1p, MAC2p);
   else
      return Illithid_pid;

   return 0;
}



int Illithid_IPBased_GetConnections(char *iface, char *IP1p, char *IP2p)
{
      int Illithid_pid;

#ifdef DEBUG
   Debug_msg("Illithid_IPBased_GetConnections -- [%s] [%s]", IP1p, IP2p);
#endif

   if (!(Illithid_pid = fork()))
           Illithid_GetConnections(IPBASED, iface, IP1p, IP2p, "", "");
   else
      return Illithid_pid;

   return 0;
}


int Illithid_MACBased_GetConnections(char *iface, char *MAC1p, char *MAC2p)
{
      int Illithid_pid;

#ifdef DEBUG
   Debug_msg("Illithid_MACBased_GetConnections -- [%s] [%s]", MAC1p, MAC2p);
#endif

   if (!(Illithid_pid = fork()))
      Illithid_GetConnections(MACBASED, iface, "", "", MAC1p, MAC2p);
   else
      return Illithid_pid;

   return 0;
}


void Illithid_GetConnections(short mode, char *iface, char *IP1p, char *IP2p, char *MAC1p, char *MAC2p)
{
   int len, MTU;
   short pkttype;
   struct in_addr addr;
   ETH_header *eth;
   IP_header *ip;
   TCP_header *tcp;
   UDP_header *udp;
   CONNECTION data_to_ettercap;
   SNIFFED_DATA sniff_data_to_ettercap;
   u_char *buffer;
   u_long IP_Test, NetMask;
   int Act_Connection_Mode;

   strcpy(program_argv0, "illithid");

   inet_aton(IP1p,&addr);
   IP1 = addr.s_addr;
   inet_aton(IP2p,&addr);
   IP2 = addr.s_addr;

   Inet_GetMACfromString(MAC1p, MAC1);
   Inet_GetMACfromString(MAC2p, MAC2);

   sock = Inet_OpenRawSock(iface);
   Inet_GetIfaceInfo( iface, &MTU, MyMAC, &IP_Test, &NetMask);

   if (mode > PUBLICARP)
       Inet_SetPromisc(iface);
   else
      IP_Test=IP_Test&NetMask;

   buffer = Inet_Forge_packet(MTU);

   for (;;)
   {
      if (getppid() == 1) exit(0);

      memset(&data_to_ettercap, 0, sizeof(CONNECTION));
      memset(&sniff_data_to_ettercap, 0, sizeof(SNIFFED_DATA));
      memset(buffer, 0, MTU);

      len = Inet_GetRawPacket(sock, buffer, MTU, &pkttype);
      Act_Connection_Mode = Connection_Mode;

      if (len > 0 && ( mode > PUBLICARP || pkttype == PACKET_HOST))
      {
         char ok1 = 0;

         eth = (ETH_header *)buffer;
         memcpy(data_to_ettercap.mac_source,eth->source_mac,6);

         if (mode == MACBASED)
         {
            if ( memcmp(eth->source_mac, MAC1, 6) != 0 && memcmp(eth->source_mac, MAC2, 6) != 0 ) continue;
            if ( memcmp(eth->dest_mac, MAC1, 6) != 0 && memcmp(eth->dest_mac, MAC2, 6) != 0 ) continue;
            ok1 = 1;
         }

         if ( ntohs(eth->type) == ETH_P_IP )
         {
            ip = (IP_header *)(eth+1);

            strcpy(data_to_ettercap.ip_source, int_ntoa(ip->source_ip) );
            strcpy(data_to_ettercap.ip_dest, int_ntoa(ip->dest_ip) );
            strcpy(sniff_data_to_ettercap.ip_source, int_ntoa(ip->source_ip) );
            strcpy(sniff_data_to_ettercap.ip_dest, int_ntoa(ip->dest_ip) );

            if ( mode == IPBASED && Illithid_ToBeSniffed_ip(IP1p, IP2p, &data_to_ettercap) ) ok1 = 1;

            if ( mode == ARPBASED && (ip->dest_ip==IP1 || ip->source_ip==IP2) && (((ip->dest_ip&NetMask)!=IP_Test || (ip->source_ip&NetMask)!=IP_Test)
                 || (ip->dest_ip==IP1 && ip->source_ip==IP2)))
            {
               memcpy(eth->dest_mac, MAC1, 6);
               memcpy(eth->source_mac, MyMAC, 6);
               ok1 = 1;
            }

            if ( mode == ARPBASED && (ip->dest_ip==IP2 || ip->source_ip==IP1) && (((ip->dest_ip&NetMask)!=IP_Test || (ip->source_ip&NetMask)!=IP_Test)
                 || (ip->dest_ip==IP2 && ip->source_ip==IP1)))
            {
               memcpy(eth->dest_mac, MAC2, 6);
               memcpy(eth->source_mac, MyMAC, 6);
               ok1 = 1;
            }

            if (mode == PUBLICARP && !Act_Connection_Mode) ok1 = 1;

            if ( mode == PUBLICARP && !strcmp(data_to_ettercap.ip_dest,IP1p))
            {
               memcpy(eth->dest_mac, MAC1, 6);
               memcpy(eth->source_mac, MyMAC, 6);
               ok1 = 1;
            }
            else
            if ( mode == PUBLICARP && !strcmp(data_to_ettercap.ip_dest,IP2p))
            {
               memcpy(eth->dest_mac, MAC2, 6);
               memcpy(eth->source_mac, MyMAC, 6);
               ok1 = 1;
            }
            else
            if ( mode == PUBLICARP && (ip->dest_ip&NetMask)!=IP_Test)
            {
               if (!strcmp(IP1p,""))
                  memcpy(eth->dest_mac, MAC2, 6);
               else
                  memcpy(eth->dest_mac, MAC1, 6);

               memcpy(eth->source_mac, MyMAC, 6);
               ok1 = 1;
            }

            memcpy(data_to_ettercap.mac_dest,eth->dest_mac,6);

            if ( ok1 && ip->proto == IPPROTO_TCP)
            {
               unsigned char *data;
               int datalen;
               tcp = (TCP_header *) ((int)ip + ip->h_len * 4);

               if (!( ntohs(ip->frag_and_flags) & IP_OFFMASK))
               {
                  data = (char *)((int)tcp + tcp->doff * 4);
                  datalen = (int)ip + ntohs(ip->t_len) - (int)data;

                  if (Act_Connection_Mode)
                  {
                      data_to_ettercap.source_port = ntohs(tcp->source);
                      data_to_ettercap.dest_port = ntohs(tcp->dest);
                      data_to_ettercap.source_seq = ntohl(tcp->seq) + datalen;
                      data_to_ettercap.dest_seq = ntohl(tcp->seq) + datalen;
                      data_to_ettercap.flags = tcp->flags;
                      data_to_ettercap.proto = 'T';
                      data_to_ettercap.datalen = datalen;
                      Dissector_Connections( mode, IPPROTO_TCP, (u_char *)tcp, &data_to_ettercap, Act_Connection_Mode);
                      Buffer_Put(pipe_with_illithid, &data_to_ettercap, sizeof(CONNECTION));
                  }
                  else
                  {
                      sniff_data_to_ettercap.source_port = ntohs(tcp->source);
                      sniff_data_to_ettercap.dest_port = ntohs(tcp->dest);
                      sniff_data_to_ettercap.seq = ntohl(tcp->seq);
                      sniff_data_to_ettercap.ack_seq = ntohl(tcp->ack_seq);
                      sniff_data_to_ettercap.flags = tcp->flags;
                      sniff_data_to_ettercap.proto = 'T';
                      datalen = (datalen > MAX_DATA) ? MAX_DATA : datalen;
                      sniff_data_to_ettercap.datasize = datalen;
                      memset(&sniff_data_to_ettercap.data, 0, sizeof(sniff_data_to_ettercap.data));
                      memcpy(&sniff_data_to_ettercap.data, data, datalen);
                      Dissector_Connections( mode, IPPROTO_TCP, (u_char *)tcp, &sniff_data_to_ettercap, Act_Connection_Mode);
                      Buffer_Put(pipe_with_illithid_data, &sniff_data_to_ettercap, sizeof(SNIFFED_DATA));
                  }
               }
            }

            if ( ok1 && ip->proto == IPPROTO_UDP)
            {
               unsigned char *data;
               int datalen;
               udp = (UDP_header *) ((int)ip + ip->h_len * 4);

               if (!( ntohs(ip->frag_and_flags) & IP_OFFMASK))
               {
                  data = (char *)((int)udp + UDP_HEADER);
                  datalen = ntohs(udp->len) - UDP_HEADER;

                  if (Act_Connection_Mode)
                  {
                     data_to_ettercap.source_port = ntohs(udp->source);
                     data_to_ettercap.dest_port = ntohs(udp->dest);
                     data_to_ettercap.proto = 'U';
                     data_to_ettercap.datalen = datalen;
                     Dissector_Connections( mode, IPPROTO_UDP, (u_char *)udp, &data_to_ettercap, Act_Connection_Mode);
                     Buffer_Put(pipe_with_illithid, &data_to_ettercap, sizeof(CONNECTION));
                  }
                  else
                  {
                     sniff_data_to_ettercap.source_port = ntohs(udp->source);
                     sniff_data_to_ettercap.dest_port = ntohs(udp->dest);
                     sniff_data_to_ettercap.proto = 'U';
                     datalen = (datalen > MAX_DATA) ? MAX_DATA : datalen;
                     sniff_data_to_ettercap.datasize = datalen;
                     memset(&sniff_data_to_ettercap.data, 0, sizeof(sniff_data_to_ettercap.data));
                     memcpy(&sniff_data_to_ettercap.data, data, datalen);
                     Dissector_Connections( mode, IPPROTO_UDP, (u_char *)udp, &sniff_data_to_ettercap, Act_Connection_Mode);
                     Buffer_Put(pipe_with_illithid_data, &sniff_data_to_ettercap, sizeof(SNIFFED_DATA));
                  }
               }
            }
            if (mode <= PUBLICARP && ok1 && Act_Connection_Mode) Inet_SendRawPacket(sock, buffer, len);
         }
      }
   }
}


int Illithid_ToBeSniffed(char *source, int psource, char *dest, int pdest, SNIFFED_DATA *data)
{
   char s=0, ps=0, d=0, pd=0;

   if (psource == 0) ps = 1;
   if (pdest == 0) pd = 1;
   if (!strcmp(source, "") || !strcmp(source, "0.0.0.0") ) s = 1;
   if (!strcmp(dest, "") || !strcmp(dest, "0.0.0.0")) d = 1;

   if (s || !strcmp(source, data->ip_source))
      if (ps || psource == data->source_port)
      {  s = 1;   ps = 1;  }

   if (s || !strcmp(source, data->ip_dest))
      if (ps || psource == data->dest_port)
      {  s = 1;   ps = 1;  }

   if (d || !strcmp(dest, data->ip_source))
      if (pd || pdest == data->source_port)
      {  d = 1;   pd = 1;  }

   if (d || !strcmp(dest, data->ip_dest))
      if (pd || pdest == data->dest_port)
      {  d = 1;   pd = 1;  }

   return ( s && ps && d && pd );
}


int Illithid_ToBeSniffed_ip(char *source, char *dest, CONNECTION *data)
{
   char s=0, d=0;

   if (!strcmp(source, "")) s = 1;
   if (!strcmp(dest, "")) d = 1;

   if (s || !strcmp(source, data->ip_source)) s = 1;

   if (s || !strcmp(source, data->ip_dest)) s = 1;

   if (d || !strcmp(dest, data->ip_source)) d = 1;

   if (d || !strcmp(dest, data->ip_dest)) d = 1;

   return ( s && d );

}


/* EOF */

